/// <reference types="../CTAutocomplete" />
/// <reference lib="es2016" />
// Generated by CT-Pack
import { perks } from "./src/perks";
import config from "./src/config";
import Changelog from "../ChangelogLib/index";
const changelog = new Changelog("CalcPowder", "0.2.0", "&aAdded Calculations for HOTM 8-10");
changelog.writeChangelog({ changelog: "&b", name: "&e", version: "&e" });
const prefix = "&f[&5CalcPowder&f] ";
function getPowderColor(powder) {
    switch (powder) {
        case "Mithril":
            return "&2";
        case "Gemstone":
            return "&d";
        case "Glacite":
            return "&b";
    }
}
function formatNumber(num, seperator) {
    return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, seperator);
}
register("command", (...args) => {
    const [perk, start, end] = args;
    if (perk === "config")
        return config.openGUI();
    if (perk === "discord")
        return ChatLib.chat(new TextComponent(`${prefix}&3Click here join the Discord for support, to suggest features, or to report bugs`).setClick("open_url", "https://discord.gg/9RJKbCtEUz").setHoverValue("&eClick to join the Discord"));
    if (perk === undefined || start === undefined || end === undefined) {
        ChatLib.chat(`${prefix}&cUsage: /calcpowder <perk_name> <start> <end>`);
        ChatLib.chat(new TextComponent(`${prefix}&cTo open the configuration GUI, click here or run /calcpowder config`).setClick("run_command", "/calcpowder config").setHoverValue("&eClick to open the configuration GUI"));
        return;
    }
    const perkObj = perks[perk.toLowerCase()];
    if (!perkObj)
        return ChatLib.chat(`${prefix}&cPerk &e${perk} &cnot found`);
    if (perkObj === "MISSING_DATA")
        ChatLib.chat(`${prefix}&cPerk &e${perk} &chas no formula data on the wiki yet, and so cannot be calculated`);
    let iStart = parseInt(start);
    let iEnd = parseInt(end);
    if (iStart === 0)
        iStart = 1;
    if (iEnd === 0)
        iEnd = 1;
    if (isNaN(iStart) || isNaN(iEnd))
        return ChatLib.chat(`${prefix}&cInvalid level`);
    if (iStart < 1 || iEnd < 1)
        return ChatLib.chat(`${prefix}&cLevels must be greater than 0`);
    if (iStart > perkObj.max || iEnd > perkObj.max)
        return ChatLib.chat(`${prefix}&cLevel exceeds max of &e${perkObj.max}`);
    if (iStart > iEnd)
        return ChatLib.chat(`${prefix}&cStart level must be less than end level`);
    const powder = { type: perkObj.powder, color: getPowderColor(perkObj.powder) };
    const cost = Math.round(perkObj.costBetween(iStart, iEnd));
    ChatLib.chat(`${prefix}&aUpgrading ${perk} from &e${start} &ato &e${end} &awill cost approximately ${powder.color}${formatNumber(cost, config.seperator)} ${powder.type} Powder`);
}).setTabCompletions(Object.keys(perks)).setName("calcpowder");
