/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.renderer.html;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.commonmark.renderer.html.UrlSanitizer;

public class DefaultUrlSanitizer
implements UrlSanitizer {
    private Set<String> protocols;

    public DefaultUrlSanitizer() {
        this(Arrays.asList("http", "https", "mailto"));
    }

    public DefaultUrlSanitizer(Collection<String> protocols) {
        this.protocols = new HashSet<String>(protocols);
    }

    @Override
    public String sanitizeLinkUrl(String url2) {
        url2 = this.stripHtmlSpaces(url2);
        int n = url2.length();
        block4: for (int i2 = 0; i2 < n; ++i2) {
            switch (url2.charAt(i2)) {
                case '#': 
                case '/': 
                case '?': {
                    break block4;
                }
                case ':': {
                    String protocol = url2.substring(0, i2).toLowerCase();
                    if (this.protocols.contains(protocol)) break block4;
                    return "";
                }
                default: {
                    continue block4;
                }
            }
        }
        return url2;
    }

    @Override
    public String sanitizeImageUrl(String url2) {
        return this.sanitizeLinkUrl(url2);
    }

    private String stripHtmlSpaces(String s2) {
        int n;
        int i2 = 0;
        for (n = s2.length(); n > i2 && this.isHtmlSpace(s2.charAt(n - 1)); --n) {
        }
        while (i2 < n && this.isHtmlSpace(s2.charAt(i2))) {
            ++i2;
        }
        if (i2 == 0 && n == s2.length()) {
            return s2;
        }
        return s2.substring(i2, n);
    }

    private boolean isHtmlSpace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

