/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.features.impl.misc.damagesplash;

import gg.essential.universal.UChat;
import gg.skytils.skytilsmod.Skytils;
import gg.skytils.skytilsmod.features.impl.misc.damagesplash.Damage;
import gg.skytils.skytilsmod.features.impl.misc.damagesplash.DamageSplashEntityKt;
import gg.skytils.skytilsmod.features.impl.misc.damagesplash.FakeEntity;
import gg.skytils.skytilsmod.features.impl.misc.damagesplash.Location;
import gg.skytils.skytilsmod.utils.NumberUtil;
import gg.skytils.skytilsmod.utils.Utils;
import gg.skytils.skytilsmod.utils.graphics.ScreenRenderer;
import gg.skytils.skytilsmod.utils.graphics.SmartFontRenderer;
import gg.skytils.skytilsmod.utils.graphics.colors.CustomColor;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityArmorStand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J)\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u000f\u0010\n\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0018R\u0016\u0010\u001e\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lgg/skytils/skytilsmod/features/impl/misc/damagesplash/DamageSplashEntity;", "Lgg/skytils/skytilsmod/features/impl/misc/damagesplash/FakeEntity;", "", "partialTicks", "Lnet/minecraft/client/renderer/RenderGlobal;", "context", "Lnet/minecraft/client/renderer/entity/RenderManager;", "render", "", "(FLnet/minecraft/client/renderer/RenderGlobal;Lnet/minecraft/client/renderer/entity/RenderManager;)V", "tick", "()V", "Lnet/minecraft/entity/item/EntityArmorStand;", "boundEntity", "Lnet/minecraft/entity/item/EntityArmorStand;", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "color", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "damage", "Ljava/lang/String;", "displayText", "", "extremeFocus", "Z", "love", "getName", "()Ljava/lang/String;", "name", "octodexterity", "scale", "F", "Lgg/skytils/skytilsmod/features/impl/misc/damagesplash/Location;", "currentLocation", "<init>", "(Lnet/minecraft/entity/item/EntityArmorStand;Ljava/lang/String;Lgg/skytils/skytilsmod/features/impl/misc/damagesplash/Location;)V", "Companion", "SkytilsMod"})
public final class DamageSplashEntity
extends FakeEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityArmorStand boundEntity;
    @NotNull
    private String damage;
    @NotNull
    private String displayText;
    private float scale;
    @Nullable
    private CustomColor color;
    private boolean love;
    private boolean extremeFocus;
    private boolean octodexterity;
    @NotNull
    private static final ScreenRenderer renderer = new ScreenRenderer();
    @NotNull
    private static final WeakHashMap<String, UUID> added = new WeakHashMap();
    @NotNull
    private static final Regex SYMBOL_PATTERN = new Regex("(\\d{1,3}(?:,\\d{3})*)(.*)");

    public DamageSplashEntity(@NotNull EntityArmorStand boundEntity, @NotNull String damage, @NotNull Location currentLocation) {
        Intrinsics.checkNotNullParameter((Object)boundEntity, (String)"boundEntity");
        Intrinsics.checkNotNullParameter((Object)damage, (String)"damage");
        Intrinsics.checkNotNullParameter((Object)((Object)currentLocation), (String)"currentLocation");
        super(currentLocation);
        this.boundEntity = boundEntity;
        this.damage = damage;
        this.scale = 1.0f;
        MatchResult symbolMatcher = SYMBOL_PATTERN.matchEntire((CharSequence)this.damage);
        if (symbolMatcher != null) {
            MatchGroup matchGroup = symbolMatcher.getGroups().get(2);
            Intrinsics.checkNotNull((Object)matchGroup);
            String symbol = matchGroup.getValue();
            MatchGroup matchGroup2 = symbolMatcher.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup2);
            this.damage = StringsKt.replace$default((String)matchGroup2.getValue(), (String)",", (String)"", (boolean)false, (int)4, null);
            if (StringsKt.contains$default((CharSequence)symbol, (CharSequence)"\u2764", (boolean)false, (int)2, null)) {
                this.love = true;
                symbol = StringsKt.replace$default((String)symbol, (String)"\u2764", (String)"", (boolean)false, (int)4, null);
            }
            if (StringsKt.contains$default((CharSequence)symbol, (CharSequence)"\u2694", (boolean)false, (int)2, null)) {
                this.extremeFocus = true;
                symbol = StringsKt.replace$default((String)symbol, (String)"\u2694", (String)"", (boolean)false, (int)4, null);
            }
            if (StringsKt.contains$default((CharSequence)symbol, (CharSequence)"+", (boolean)false, (int)2, null)) {
                this.octodexterity = true;
                symbol = StringsKt.replace$default((String)symbol, (String)"+", (String)"", (boolean)false, (int)4, null);
            }
            Damage damage2 = Damage.Companion.fromSymbol(symbol);
            this.color = damage2 != null ? damage2.getColor() : null;
        }
        this.displayText = (Skytils.Companion.getConfig().getCustomDamageSplash() == 1 ? NumberUtil.nf.format(Long.parseLong(this.damage)) : NumberUtil.format(Long.parseLong(this.damage))) + DamageSplashEntityKt.access$exportStringIfTrue(this.love, "\u2764") + DamageSplashEntityKt.access$exportStringIfTrue(this.extremeFocus, "\u2694") + DamageSplashEntityKt.access$exportStringIfTrue(this.octodexterity, "+");
        UUID uuid2 = new UUID(Utils.getRandom().nextLong(), Utils.getRandom().nextLong());
        if (added.containsValue(uuid2)) {
            this.remove();
        } else {
            ((Map)added).put(this.displayText, uuid2);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "EntityDamageSplash";
    }

    @Override
    public void tick() {
        if (this.color == null) {
            System.out.println((Object)("Failed to parse color for DamageSplashEntity, bound entity '" + this.boundEntity.func_95999_t() + "' | parse string '" + this.damage + '\''));
            UChat.chat((Object)"\u00a7c\u00a7lSkytils (1.12.0-pre1) \u00a78\u00bb \u00a7cSkytils ran into a problem while rendering damage, please report this on our Discord with your log file attached.");
            this.remove();
            return;
        }
        int maxLiving = 150;
        if (this.getLivingTicks() > (long)maxLiving) {
            this.remove();
            return;
        }
        float initialScale = 2.5f;
        this.getCurrentLocation().subtract(0.0, (double)2 / (double)maxLiving, 0.0);
        this.scale = initialScale - (float)this.getLivingTicks() * initialScale / (float)maxLiving;
    }

    @Override
    public void render(float partialTicks, @Nullable RenderGlobal context, @NotNull RenderManager render2) {
        Intrinsics.checkNotNullParameter((Object)render2, (String)"render");
        if (this.color == null) {
            return;
        }
        boolean thirdPerson = render2.field_78733_k.field_74320_O == 2;
        ScreenRenderer.Companion.setRendering(true);
        DamageSplashEntity $this$render_u24lambda_u241 = this;
        boolean bl = false;
        DamageSplashEntity $this$render_u24lambda_u241_u24lambda_u240 = $this$render_u24lambda_u241;
        boolean bl2 = false;
        GlStateManager.func_179114_b((float)(-render2.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(thirdPerson ? -1 : 1) * render2.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179152_a((float)$this$render_u24lambda_u241_u24lambda_u240.scale, (float)$this$render_u24lambda_u241_u24lambda_u240.scale, (float)$this$render_u24lambda_u241_u24lambda_u240.scale);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String string = $this$render_u24lambda_u241.displayText;
        CustomColor customColor = $this$render_u24lambda_u241.color;
        Intrinsics.checkNotNull((Object)customColor);
        renderer.drawString(string, 0.0f, 0.0f, customColor, SmartFontRenderer.TextAlignment.MIDDLE, SmartFontRenderer.TextShadow.NONE);
        ScreenRenderer.Companion.setRendering(false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lgg/skytils/skytilsmod/features/impl/misc/damagesplash/DamageSplashEntity$Companion;", "", "Lkotlin/text/Regex;", "SYMBOL_PATTERN", "Lkotlin/text/Regex;", "Ljava/util/WeakHashMap;", "", "Ljava/util/UUID;", "added", "Ljava/util/WeakHashMap;", "Lgg/skytils/skytilsmod/utils/graphics/ScreenRenderer;", "renderer", "Lgg/skytils/skytilsmod/utils/graphics/ScreenRenderer;", "<init>", "()V", "SkytilsMod"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

