/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.features.impl.dungeons.catlas.dev;

import gg.essential.universal.UChat;
import gg.essential.universal.wrappers.message.UTextComponent;
import gg.skytils.skytilsmod.Skytils;
import gg.skytils.skytilsmod.commands.SkytilsCommands;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Commands;
import org.jetbrains.annotations.NotNull;

@Commands(value={})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b'\u0010(J7\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJK\u0010\"\u001a\u00020\n2\b\b\u0001\u0010\u001c\u001a\u00020\u00062\b\b\u0001\u0010\u001d\u001a\u00020\u00062\b\b\u0001\u0010\u001e\u001a\u00020\u00062\b\b\u0001\u0010\u001f\u001a\u00020\u00062\b\b\u0001\u0010 \u001a\u00020\u00062\b\b\u0001\u0010!\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\"\u0010#R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lgg/skytils/skytilsmod/features/impl/dungeons/catlas/dev/TopographyGenerator;", "", "Ljava/awt/Graphics2D;", "graphics", "Lnet/minecraft/block/state/IBlockState;", "blockState", "", "x", "y", "size", "", "drawBlockTexture", "(Ljava/awt/Graphics2D;Lnet/minecraft/block/state/IBlockState;III)V", "Ljava/awt/image/BufferedImage;", "getBlockTexture", "(Lnet/minecraft/block/state/IBlockState;)Ljava/awt/image/BufferedImage;", "Lnet/minecraft/client/renderer/texture/TextureMap;", "textureMap", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getTextureSprite", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/client/renderer/texture/TextureMap;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "Lnet/minecraft/world/World;", "worldIn", "Lnet/minecraft/util/BlockPos;", "pos", "", "hasRoomForPlayer", "(Lnet/minecraft/world/World;Lnet/minecraft/util/BlockPos;)Z", "x1", "y1", "z1", "x2", "y2", "z2", "stitch", "(IIIIII)V", "", "textureCache", "Ljava/util/Map;", "<init>", "()V", "SkytilsMod"})
public final class TopographyGenerator {
    @NotNull
    public static final TopographyGenerator INSTANCE = new TopographyGenerator();
    @NotNull
    private static final Map<IBlockState, BufferedImage> textureCache;

    private TopographyGenerator() {
    }

    @Command(value="skytils|st dungeonmap stitch <x1> <y1> <z1> <x2> <y2> <z2>")
    public final void stitch(@Argument(value="x1") int x1, @Argument(value="y1") int y1, @Argument(value="z1") int z1, @Argument(value="x2") int x2, @Argument(value="y2") int y2, @Argument(value="z2") int z2) {
        AxisAlignedBB region = new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        int width = (int)(region.field_72336_d - region.field_72340_a + 1.0);
        int height = (int)(region.field_72334_f - region.field_72339_c + 1.0);
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid region dimensions: " + width + " x " + height);
        }
        int texturePx = 16;
        BufferedImage outputImage = new BufferedImage(width * texturePx, height * texturePx, 2);
        Graphics2D graphics = outputImage.createGraphics();
        for (int imgXIndex = 0; imgXIndex < width; ++imgXIndex) {
            for (int imgZIndex = 0; imgZIndex < height; ++imgZIndex) {
                int currentWorldX = (int)(region.field_72340_a + (double)imgXIndex);
                int currentWorldZ = (int)(region.field_72339_c + (double)imgZIndex);
                IBlockState highestBlock = null;
                int n = (int)region.field_72338_b;
                int currentWorldY = (int)region.field_72337_e;
                if (n <= currentWorldY) {
                    while (true) {
                        BlockPos currentBlockPos = new BlockPos(currentWorldX, currentWorldY, currentWorldZ);
                        WorldClient worldClient = Skytils.Companion.getMc().field_71441_e;
                        Intrinsics.checkNotNull((Object)worldClient);
                        IBlockState blockState = worldClient.func_180495_p(currentBlockPos);
                        Block block2 = blockState.func_177230_c();
                        if (!Intrinsics.areEqual((Object)block2, (Object)Blocks.field_150350_a)) {
                            WorldClient worldClient2 = Skytils.Companion.getMc().field_71441_e;
                            Intrinsics.checkNotNull((Object)worldClient2);
                            World world = (World)worldClient2;
                            BlockPos blockPos2 = currentBlockPos.func_177984_a();
                            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"up(...)");
                            if (this.hasRoomForPlayer(world, blockPos2)) {
                                highestBlock = blockState;
                                break;
                            }
                        }
                        if (currentWorldY == n) break;
                        --currentWorldY;
                    }
                }
                int imagePixelX = imgXIndex * texturePx;
                int imagePixelY = imgZIndex * texturePx;
                if (highestBlock == null) continue;
                Intrinsics.checkNotNull((Object)graphics);
                this.drawBlockTexture(graphics, highestBlock, imagePixelX, imagePixelY, texturePx);
            }
        }
        graphics.dispose();
        File outputFile = new File("dungeon_topography_map.png");
        ImageIO.write((RenderedImage)outputImage, "PNG", outputFile);
        UTextComponent uTextComponent = new UTextComponent("\u00a7aTopography map successfully generated and saved to: " + outputFile.getAbsolutePath());
        String string = outputFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        UChat.chat((Object)uTextComponent.setClick(ClickEvent.Action.OPEN_FILE, string));
    }

    private final boolean hasRoomForPlayer(World worldIn, BlockPos pos) {
        return !worldIn.func_180495_p(pos).func_177230_c().func_149688_o().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o().func_76220_a();
    }

    private final void drawBlockTexture(Graphics2D graphics, IBlockState blockState, int x, int y, int size2) {
        BufferedImage blockTexture = this.getBlockTexture(blockState);
        if (blockTexture != null) {
            graphics.drawImage(blockTexture, x, y, size2, size2, null);
        } else {
            graphics.setColor(new Color(blockState.func_177230_c().func_180659_g((IBlockState)blockState).field_76291_p));
            graphics.fillRect(x, y, size2, size2);
        }
    }

    private final BufferedImage getBlockTexture(IBlockState blockState) {
        if (textureCache.containsKey(blockState)) {
            return textureCache.get(blockState);
        }
        try {
            TextureMap textureMap = Skytils.Companion.getMc().func_147117_R();
            Intrinsics.checkNotNull((Object)textureMap);
            TextureAtlasSprite sprite = this.getTextureSprite(blockState, textureMap);
            if (sprite != null) {
                BufferedImage image = new BufferedImage(sprite.func_94211_a(), sprite.func_94216_b(), 2);
                int[] frameData = sprite.func_147965_a(0)[0];
                int n = sprite.func_94216_b();
                for (int pixelY = 0; pixelY < n; ++pixelY) {
                    int n2 = sprite.func_94211_a();
                    for (int pixelX = 0; pixelX < n2; ++pixelX) {
                        int index = sprite.func_94211_a() * pixelY + pixelX;
                        int color = frameData[index];
                        image.setRGB(pixelX, pixelY, color);
                    }
                }
                BufferedImage finalImage = new BufferedImage(16, 16, 2);
                Graphics2D g2 = finalImage.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g2.drawImage(image, 0, 0, 16, 16, null);
                g2.dispose();
                textureCache.put(blockState, finalImage);
                return finalImage;
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Error getting texture for " + blockState.func_177230_c().getRegistryName() + ": " + e.getMessage()));
            e.printStackTrace();
        }
        return null;
    }

    private final TextureAtlasSprite getTextureSprite(IBlockState blockState, TextureMap textureMap) {
        try {
            IBakedModel bakedModel = Skytils.Companion.getMc().func_175602_ab().func_175023_a().func_178125_b(blockState);
            TextureAtlasSprite particleSprite = bakedModel.func_177554_e();
            if (particleSprite != null && !Intrinsics.areEqual((Object)particleSprite.func_94215_i(), (Object)"missingno") && particleSprite.func_94215_i() != null && particleSprite.func_94211_a() > 0 && particleSprite.func_94216_b() > 0 && particleSprite.func_110970_k() > 0) {
                return particleSprite;
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Error getting texture for " + blockState.func_177230_c().getRegistryName() + " via BakedModel: " + e.getMessage()));
            e.printStackTrace();
        }
        String registryName = blockState.func_177230_c().getRegistryName();
        if (registryName != null) {
            String[] stringArray = new String[]{":"};
            StringBuilder stringBuilder = new StringBuilder().append((String)StringsKt.split$default((CharSequence)registryName, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)).append(":blocks/");
            stringArray = new String[]{":"};
            String textureName = stringBuilder.append((String)StringsKt.split$default((CharSequence)registryName, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)).append(blockState.func_177230_c() instanceof BlockStaticLiquid ? "_still" : (blockState.func_177230_c() instanceof BlockDynamicLiquid ? "flow" : "")).toString();
            try {
                TextureAtlasSprite sprite = textureMap.func_110572_b(textureName);
                if (sprite != null && !Intrinsics.areEqual((Object)sprite.func_94215_i(), (Object)"missingno") && sprite.func_94215_i() != null && sprite.func_94211_a() > 0 && sprite.func_94216_b() > 0 && sprite.func_110970_k() > 0) {
                    return sprite;
                }
            }
            catch (Exception e) {
                System.out.println((Object)("Error getting texture via registry name for " + blockState.func_177230_c().getRegistryName() + " (tried " + textureName + "): " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        Object[] objectArray = new Object[]{INSTANCE};
        SkytilsCommands.INSTANCE.getAnnotationParser().parse(objectArray);
        textureCache = new LinkedHashMap();
    }
}

