/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json.internal;

import gg.skytils.ktx-serialization.json.internal.AbstractJsonLexer;
import gg.skytils.ktx-serialization.json.internal.AbstractJsonLexerKt;
import gg.skytils.ktx-serialization.json.internal.ArrayAsSequence;
import gg.skytils.ktx-serialization.json.internal.CharArrayPoolBatchSize;
import gg.skytils.ktx-serialization.json.internal.InternalJsonReader;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0013\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010+\u001a\u00020*\u0012\b\b\u0002\u0010(\u001a\u00020'\u00a2\u0006\u0004\b4\u00105J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u0005\u00a2\u0006\u0004\b\"\u0010\u0012J\u001f\u0010$\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b&\u0010\nR\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001a\u0010.\u001a\u00020-8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00066"}, d2={"Lgg/skytils/ktx-serialization/json/internal/ReaderJsonLexer;", "Lgg/skytils/ktx-serialization/json/internal/AbstractJsonLexer;", "", "fromIndex", "toIndex", "", "appendRange", "(II)V", "", "canConsumeValue", "()Z", "", "consumeKeyString", "()Ljava/lang/String;", "", "consumeNextToken", "()B", "ensureHaveChars", "()V", "", "char", "startPos", "indexOf", "(CI)I", "keyToMatch", "isLenient", "peekLeadingMatchingValue", "(Ljava/lang/String;Z)Ljava/lang/String;", "position", "prefetchOrEof", "(I)I", "unprocessedCount", "preload", "(I)V", "release", "endPos", "substring", "(II)Ljava/lang/String;", "tryConsumeComma", "", "buffer", "[C", "Lgg/skytils/ktx-serialization/json/internal/InternalJsonReader;", "reader", "Lgg/skytils/ktx-serialization/json/internal/InternalJsonReader;", "Lgg/skytils/ktx-serialization/json/internal/ArrayAsSequence;", "source", "Lgg/skytils/ktx-serialization/json/internal/ArrayAsSequence;", "getSource", "()Lkotlinx/serialization/json/internal/ArrayAsSequence;", "threshold", "I", "<init>", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "kotlinx-serialization-json"})
public final class ReaderJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final InternalJsonReader reader;
    @NotNull
    private final char[] buffer;
    private int threshold;
    @NotNull
    private final ArrayAsSequence source;

    public ReaderJsonLexer(@NotNull InternalJsonReader reader, @NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.reader = reader;
        this.buffer = buffer;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this.buffer);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = CharArrayPoolBatchSize.INSTANCE.take();
        }
        this(internalJsonReader, cArray);
    }

    @Override
    @NotNull
    protected ArrayAsSequence getSource() {
        return this.source;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    private final void preload(int unprocessedCount) {
        int actual;
        char[] buffer = this.getSource().getBuffer$kotlinx_serialization_json();
        if (unprocessedCount != 0) {
            ArraysKt.copyInto((char[])buffer, (char[])buffer, (int)0, (int)this.currentPosition, (int)(this.currentPosition + unprocessedCount));
        }
        int sizeTotal = this.getSource().length();
        for (int filledCount = unprocessedCount; filledCount != sizeTotal; filledCount += actual) {
            actual = this.reader.read(buffer, filledCount, sizeTotal - filledCount);
            if (actual != -1) continue;
            this.getSource().trim(filledCount);
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int position) {
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch;
            byte tc;
            if ((tc = AbstractJsonLexerKt.charToTokenClass(ch = source.charAt(cpos++))) == 3) continue;
            this.currentPosition = cpos;
            return tc;
        }
        this.currentPosition = cpos;
        return 10;
    }

    @Override
    public void ensureHaveChars() {
        int cur = this.currentPosition;
        int oldSize = this.getSource().length();
        int spaceLeft = oldSize - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload(spaceLeft);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = this.indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = this.prefetchOrEof(current)) == -1) {
                AbstractJsonLexer.fail$kotlinx_serialization_json$default(this, (byte)1, false, 2, null);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, current);
        }
        for (int i2 = current; i2 < closingQuote; ++i2) {
            if (this.getSource().charAt(i2) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i2);
        }
        this.currentPosition = closingQuote + 1;
        return this.substring(current, closingQuote);
    }

    @Override
    public int indexOf(char c, int startPos) {
        ArrayAsSequence src = this.getSource();
        int n = src.length();
        for (int i2 = startPos; i2 < n; ++i2) {
            if (src.charAt(i2) != c) continue;
            return i2;
        }
        return -1;
    }

    @Override
    @NotNull
    public String substring(int startPos, int endPos) {
        return this.getSource().substring(startPos, endPos);
    }

    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(this.getSource().getBuffer$kotlinx_serialization_json(), fromIndex, toIndex - fromIndex), (String)"append(...)");
    }

    @Override
    @Nullable
    public String peekLeadingMatchingValue(@NotNull String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter((Object)keyToMatch, (String)"keyToMatch");
        return null;
    }

    public final void release() {
        CharArrayPoolBatchSize.INSTANCE.release(this.buffer);
    }
}

