/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json;

import gg.skytils.ktx-serialization.KSerializer;
import gg.skytils.ktx-serialization.descriptors.ClassSerialDescriptorBuilder;
import gg.skytils.ktx-serialization.descriptors.PolymorphicKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptorsKt;
import gg.skytils.ktx-serialization.encoding.Decoder;
import gg.skytils.ktx-serialization.encoding.Encoder;
import gg.skytils.ktx-serialization.json.JsonArray;
import gg.skytils.ktx-serialization.json.JsonArraySerializer;
import gg.skytils.ktx-serialization.json.JsonDecoder;
import gg.skytils.ktx-serialization.json.JsonElement;
import gg.skytils.ktx-serialization.json.JsonElementSerializer;
import gg.skytils.ktx-serialization.json.JsonElementSerializersKt;
import gg.skytils.ktx-serialization.json.JsonObject;
import gg.skytils.ktx-serialization.json.JsonObjectSerializer;
import gg.skytils.ktx-serialization.json.JsonPrimitive;
import gg.skytils.ktx-serialization.json.JsonPrimitiveSerializer;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c1\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lgg/skytils/ktx-serialization/json/JsonElementSerializer;", "Lgg/skytils/ktx-serialization/KSerializer;", "Lgg/skytils/ktx-serialization/json/JsonElement;", "Lgg/skytils/ktx-serialization/encoding/Decoder;", "decoder", "deserialize", "(Lgg/skytils/ktx-serialization/encoding/Decoder;)Lgg/skytils/ktx-serialization/json/JsonElement;", "Lgg/skytils/ktx-serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lgg/skytils/ktx-serialization/encoding/Encoder;Lgg/skytils/ktx-serialization/json/JsonElement;)V", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "descriptor", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "()V", "kotlinx-serialization-json"})
@PublishedApi
public final class JsonElementSerializer
implements KSerializer<JsonElement> {
    @NotNull
    public static final JsonElementSerializer INSTANCE = new JsonElementSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.buildSerialDescriptor("gg.skytils.ktx-serialization.json.JsonElement", PolymorphicKind.SEALED.INSTANCE, new SerialDescriptor[0], (Function1<? super ClassSerialDescriptorBuilder, Unit>)((Function1)descriptor.1.INSTANCE));

    private JsonElementSerializer() {
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonElementSerializersKt.access$verify(encoder2);
        JsonElement jsonElement = value;
        if (jsonElement instanceof JsonPrimitive) {
            encoder2.encodeSerializableValue(JsonPrimitiveSerializer.INSTANCE, value);
        } else if (jsonElement instanceof JsonObject) {
            encoder2.encodeSerializableValue(JsonObjectSerializer.INSTANCE, value);
        } else if (jsonElement instanceof JsonArray) {
            encoder2.encodeSerializableValue(JsonArraySerializer.INSTANCE, value);
        }
    }

    @Override
    @NotNull
    public JsonElement deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonDecoder input2 = JsonElementSerializersKt.asJsonDecoder(decoder);
        return input2.decodeJsonElement();
    }
}

