/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.utils.io.internal;

import gg.skytils.ktor.utils.io.internal.ReadWriteBufferStateKt;
import gg.skytils.ktor.utils.io.internal.RingBufferCapacity;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0007\u001c\u001d\u001e\u001f !\"B\u0019\b\u0004\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u0004\u001a\u00020\u0000H\u0010\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0000H\u0010\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0000H\u0010\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0000H\u0010\u00a2\u0006\u0004\b\t\u0010\u0003R\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u0082\u0001\u0007#$%&'()\u00a8\u0006*"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "", "startReading$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "startReading", "startWriting$ktor_io", "startWriting", "stopReading$ktor_io", "stopReading", "stopWriting$ktor_io", "stopWriting", "Ljava/nio/ByteBuffer;", "backingBuffer", "Ljava/nio/ByteBuffer;", "Lgg/skytils/ktor/utils/io/internal/RingBufferCapacity;", "capacity", "Lgg/skytils/ktor/utils/io/internal/RingBufferCapacity;", "", "getIdle", "()Z", "idle", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "readBuffer", "getWriteBuffer", "writeBuffer", "<init>", "(Ljava/nio/ByteBuffer;Lio/ktor/utils/io/internal/RingBufferCapacity;)V", "IdleEmpty", "IdleNonEmpty", "Initial", "Reading", "ReadingWriting", "Terminated", "Writing", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleEmpty;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Terminated;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "ktor-io"})
public abstract class ReadWriteBufferState {
    @JvmField
    @NotNull
    public final ByteBuffer backingBuffer;
    @JvmField
    @NotNull
    public final RingBufferCapacity capacity;

    private ReadWriteBufferState(ByteBuffer backingBuffer, RingBufferCapacity capacity) {
        this.backingBuffer = backingBuffer;
        this.capacity = capacity;
    }

    public boolean getIdle() {
        return false;
    }

    @NotNull
    public ByteBuffer getReadBuffer() {
        throw new IllegalStateException(("read buffer is not available in state " + this).toString());
    }

    @NotNull
    public ByteBuffer getWriteBuffer() {
        throw new IllegalStateException(("write buffer is not available in state " + this).toString());
    }

    @NotNull
    public ReadWriteBufferState startReading$ktor_io() {
        throw new IllegalStateException(("ByteChannel[state: " + this + "] Concurrent reading is not supported").toString());
    }

    @NotNull
    public ReadWriteBufferState startWriting$ktor_io() {
        throw new IllegalStateException(("ByteChannel[state: " + this + "] Concurrent writing is not supported").toString());
    }

    @NotNull
    public ReadWriteBufferState stopReading$ktor_io() {
        throw new IllegalStateException(("Unable to stop reading in state " + this).toString());
    }

    @NotNull
    public ReadWriteBufferState stopWriting$ktor_io() {
        throw new IllegalStateException(("Unable to stop writing in state " + this).toString());
    }

    public /* synthetic */ ReadWriteBufferState(ByteBuffer backingBuffer, RingBufferCapacity capacity, DefaultConstructorMarker $constructor_marker) {
        this(backingBuffer, capacity);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleEmpty;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "", "toString", "()Ljava/lang/String;", "", "getIdle", "()Z", "idle", "<init>", "()V", "ktor-io"})
    public static final class IdleEmpty
    extends ReadWriteBufferState {
        @NotNull
        public static final IdleEmpty INSTANCE = new IdleEmpty();

        private IdleEmpty() {
            super(ReadWriteBufferStateKt.getEmptyByteBuffer(), ReadWriteBufferStateKt.getEmptyCapacity(), null);
        }

        @Override
        public boolean getIdle() {
            return true;
        }

        @NotNull
        public String toString() {
            return "IDLE(empty)";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0005\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\t\u001a\u00020\u0006H\u0010\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "startReading$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "startReading", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "startWriting$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "startWriting", "", "toString", "()Ljava/lang/String;", "", "getIdle", "()Z", "idle", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "initial", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "getInitial", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "<init>", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "ktor-io"})
    public static final class IdleNonEmpty
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public IdleNonEmpty(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @NotNull
        public final Initial getInitial() {
            return this.initial;
        }

        @Override
        @NotNull
        public Reading startReading$ktor_io() {
            return this.initial.getReadingState$ktor_io();
        }

        @Override
        @NotNull
        public Writing startWriting$ktor_io() {
            return this.initial.getWritingState$ktor_io();
        }

        @Override
        public boolean getIdle() {
            return true;
        }

        @NotNull
        public String toString() {
            return "IDLE(with buffer)";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010*\u001a\u00020\u0016\u0012\b\b\u0002\u0010,\u001a\u00020+\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010\u0005\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\t\u001a\u00020\u0006H\u0010\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u00118\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\u00020\u001f8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010\u0018\u001a\u0004\b%\u0010\u001aR\u001a\u0010&\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006/"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "startReading$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "startReading", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "startWriting$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "startWriting", "", "toString", "()Ljava/lang/String;", "", "getIdle", "()Z", "idle", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "idleState", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "getIdleState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "Ljava/nio/ByteBuffer;", "readBuffer", "Ljava/nio/ByteBuffer;", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "readingState", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "getReadingState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "readingWritingState", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "getReadingWritingState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "writeBuffer", "getWriteBuffer", "writingState", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "getWritingState$ktor_io", "()Lio/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "backingBuffer", "", "reservedSize", "<init>", "(Ljava/nio/ByteBuffer;I)V", "ktor-io"})
    public static final class Initial
    extends ReadWriteBufferState {
        @NotNull
        private final ByteBuffer writeBuffer;
        @NotNull
        private final ByteBuffer readBuffer;
        @NotNull
        private final IdleNonEmpty idleState;
        @NotNull
        private final Reading readingState;
        @NotNull
        private final Writing writingState;
        @NotNull
        private final ReadingWriting readingWritingState;

        public Initial(@NotNull ByteBuffer backingBuffer, int reservedSize) {
            Intrinsics.checkNotNullParameter((Object)backingBuffer, (String)"backingBuffer");
            super(backingBuffer, new RingBufferCapacity(backingBuffer.capacity() - reservedSize), null);
            if (!(backingBuffer.position() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(backingBuffer.limit() == backingBuffer.capacity())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ByteBuffer byteBuffer = backingBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"backingBuffer.duplicate()");
            this.writeBuffer = byteBuffer;
            ByteBuffer byteBuffer2 = backingBuffer.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"backingBuffer.duplicate()");
            this.readBuffer = byteBuffer2;
            this.idleState = new IdleNonEmpty(this);
            this.readingState = new Reading(this);
            this.writingState = new Writing(this);
            this.readingWritingState = new ReadingWriting(this);
        }

        public /* synthetic */ Initial(ByteBuffer byteBuffer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 8;
            }
            this(byteBuffer, n);
        }

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.writeBuffer;
        }

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        @NotNull
        public final IdleNonEmpty getIdleState$ktor_io() {
            return this.idleState;
        }

        @NotNull
        public final Reading getReadingState$ktor_io() {
            return this.readingState;
        }

        @NotNull
        public final Writing getWritingState$ktor_io() {
            return this.writingState;
        }

        @NotNull
        public final ReadingWriting getReadingWritingState$ktor_io() {
            return this.readingWritingState;
        }

        @Override
        @NotNull
        public Reading startReading$ktor_io() {
            return this.readingState;
        }

        @Override
        @NotNull
        public Writing startWriting$ktor_io() {
            return this.writingState;
        }

        @Override
        public boolean getIdle() {
            throw new IllegalStateException("Not available for initial state".toString());
        }

        @NotNull
        public String toString() {
            return "Initial";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0005\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\t\u001a\u00020\u0006H\u0010\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "startWriting$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "startWriting", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopReading$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopReading", "", "toString", "()Ljava/lang/String;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "initial", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "Ljava/nio/ByteBuffer;", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "readBuffer", "<init>", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "ktor-io"})
    public static final class Reading
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public Reading(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.initial.getReadBuffer();
        }

        @Override
        @NotNull
        public ReadingWriting startWriting$ktor_io() {
            return this.initial.getReadingWritingState$ktor_io();
        }

        @Override
        @NotNull
        public IdleNonEmpty stopReading$ktor_io() {
            return this.initial.getIdleState$ktor_io();
        }

        @NotNull
        public String toString() {
            return "Reading";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0005\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\t\u001a\u00020\u0006H\u0010\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "stopReading$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "stopReading", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "stopWriting$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Reading;", "stopWriting", "", "toString", "()Ljava/lang/String;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "initial", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "Ljava/nio/ByteBuffer;", "getReadBuffer", "()Ljava/nio/ByteBuffer;", "readBuffer", "getWriteBuffer", "writeBuffer", "<init>", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "ktor-io"})
    public static final class ReadingWriting
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public ReadingWriting(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @Override
        @NotNull
        public ByteBuffer getReadBuffer() {
            return this.initial.getReadBuffer();
        }

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.initial.getWriteBuffer();
        }

        @Override
        @NotNull
        public Writing stopReading$ktor_io() {
            return this.initial.getWritingState$ktor_io();
        }

        @Override
        @NotNull
        public Reading stopWriting$ktor_io() {
            return this.initial.getReadingState$ktor_io();
        }

        @NotNull
        public String toString() {
            return "Reading+Writing";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Terminated;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "", "toString", "()Ljava/lang/String;", "<init>", "()V", "ktor-io"})
    public static final class Terminated
    extends ReadWriteBufferState {
        @NotNull
        public static final Terminated INSTANCE = new Terminated();

        private Terminated() {
            super(ReadWriteBufferStateKt.getEmptyByteBuffer(), ReadWriteBufferStateKt.getEmptyCapacity(), null);
        }

        @NotNull
        public String toString() {
            return "Terminated";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0005\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\t\u001a\u00020\u0006H\u0010\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Writing;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "startReading$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$ReadingWriting;", "startReading", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopWriting$ktor_io", "()Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$IdleNonEmpty;", "stopWriting", "", "toString", "()Ljava/lang/String;", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "initial", "Lgg/skytils/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "Ljava/nio/ByteBuffer;", "getWriteBuffer", "()Ljava/nio/ByteBuffer;", "writeBuffer", "<init>", "(Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;)V", "ktor-io"})
    public static final class Writing
    extends ReadWriteBufferState {
        @NotNull
        private final Initial initial;

        public Writing(@NotNull Initial initial) {
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            super(initial.backingBuffer, initial.capacity, null);
            this.initial = initial;
        }

        @Override
        @NotNull
        public ByteBuffer getWriteBuffer() {
            return this.initial.getWriteBuffer();
        }

        @Override
        @NotNull
        public ReadingWriting startReading$ktor_io() {
            return this.initial.getReadingWritingState$ktor_io();
        }

        @Override
        @NotNull
        public IdleNonEmpty stopWriting$ktor_io() {
            return this.initial.getIdleState$ktor_io();
        }

        @NotNull
        public String toString() {
            return "Writing";
        }
    }
}

