/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.server.sessions.BaseTimeoutCache;
import gg.skytils.ktor.server.sessions.KeyState;
import gg.skytils.ktor.server.sessions.ListElement;
import gg.skytils.ktor.server.sessions.PullableLinkedList;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00060\u0003j\u0002`\u0004B=\u0012\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u001b\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0010\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R6\u0010\u001d\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003 \u001c*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\u001b0\u001b0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lgg/skytils/ktor/server/sessions/TimeoutWorker;", "", "K", "Ljava/lang/Runnable;", "Lgg/skytils/ktx-coroutines/Runnable;", "Lgg/skytils/ktor/server/sessions/KeyState;", "head", "()Lgg/skytils/ktor/server/sessions/KeyState;", "", "run", "()V", "Ljava/util/concurrent/locks/Condition;", "cond", "Ljava/util/concurrent/locks/Condition;", "getCond", "()Ljava/util/concurrent/locks/Condition;", "Lgg/skytils/ktor/server/sessions/PullableLinkedList;", "items", "Lgg/skytils/ktor/server/sessions/PullableLinkedList;", "getItems", "()Lio/ktor/server/sessions/PullableLinkedList;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "Ljava/lang/ref/WeakReference;", "Lgg/skytils/ktor/server/sessions/BaseTimeoutCache;", "kotlin.jvm.PlatformType", "owner", "Ljava/lang/ref/WeakReference;", "<init>", "(Lio/ktor/server/sessions/BaseTimeoutCache;Ljava/util/concurrent/locks/ReentrantLock;Ljava/util/concurrent/locks/Condition;Lio/ktor/server/sessions/PullableLinkedList;)V", "ktor-server-sessions"})
final class TimeoutWorker<K>
implements Runnable {
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final Condition cond;
    @NotNull
    private final PullableLinkedList<KeyState<K>> items;
    @NotNull
    private final WeakReference<BaseTimeoutCache<K, ?>> owner;

    public TimeoutWorker(@NotNull BaseTimeoutCache<? super K, ?> owner, @NotNull ReentrantLock lock, @NotNull Condition cond, @NotNull PullableLinkedList<KeyState<K>> items2) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.lock = lock;
        this.cond = cond;
        this.items = items2;
        this.owner = new WeakReference(owner);
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    @NotNull
    public final Condition getCond() {
        return this.cond;
    }

    @NotNull
    public final PullableLinkedList<KeyState<K>> getItems() {
        return this.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                KeyState<K> item = this.head();
                if (item != null) {
                    long time = item.timeToWait();
                    if (time == 0L) {
                        this.items.remove((KeyState<K>)((ListElement)item));
                        Object k = item.getKey().get();
                        if (k != null) {
                            BaseTimeoutCache baseTimeoutCache = (BaseTimeoutCache)this.owner.get();
                            if (baseTimeoutCache != null) {
                                baseTimeoutCache.invalidate(k);
                            }
                        }
                    } else {
                        this.cond.await(time, TimeUnit.MILLISECONDS);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        } while (!Thread.interrupted() && this.owner.get() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyState<K> head() {
        KeyState<K> keyState;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            while (this.items.isEmpty() && this.owner.get() != null) {
                this.cond.await(60L, TimeUnit.SECONDS);
            }
            keyState = this.owner.get() == null ? null : this.items.head();
        }
        finally {
            lock.unlock();
        }
        return keyState;
    }
}

