/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.routing;

import gg.skytils.ktor.http.CodecsKt;
import gg.skytils.ktor.http.HttpStatusCode;
import gg.skytils.ktor.http.ParametersBuilder;
import gg.skytils.ktor.http.ParametersKt;
import gg.skytils.ktor.http.URLDecodeException;
import gg.skytils.ktor.server.application.ApplicationCall;
import gg.skytils.ktor.server.plugins.BadRequestException;
import gg.skytils.ktor.server.request.ApplicationRequestPropertiesKt;
import gg.skytils.ktor.server.routing.IgnoreTrailingSlashKt;
import gg.skytils.ktor.server.routing.Route;
import gg.skytils.ktor.server.routing.RouteSelectorEvaluation;
import gg.skytils.ktor.server.routing.RoutingResolveResult;
import gg.skytils.ktor.server.routing.RoutingResolveTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010.\u001a\u00020\u0005\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0018\u0010:\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u001c090\u0011\u00a2\u0006\u0004\b;\u0010<J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J?\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0004J/\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u001b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0017\u0010(\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R$\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0017\u0010.\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u001d\u00102\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0016\u00107\u001a\u0004\u0018\u0001068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R&\u0010:\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u001c090\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00103\u00a8\u0006="}, d2={"Lgg/skytils/ktor/server/routing/RoutingResolveContext;", "", "Lgg/skytils/ktor/server/routing/RoutingResolveResult;", "findBestRoute", "()Lgg/skytils/ktor/server/routing/RoutingResolveResult;", "Lgg/skytils/ktor/server/routing/Route;", "entry", "", "segmentIndex", "Ljava/util/ArrayList;", "Lgg/skytils/ktor/server/routing/RoutingResolveResult$Success;", "Lkotlin/collections/ArrayList;", "trait", "", "matchedQuality", "handleRoute", "(Lgg/skytils/ktor/server/routing/Route;ILjava/util/ArrayList;D)D", "", "new", "", "isBetterResolve", "(Ljava/util/List;)Z", "", "path", "parse", "(Ljava/lang/String;)Ljava/util/List;", "resolve", "Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation$Failure;", "", "updateFailedEvaluation", "(Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation$Failure;Ljava/util/ArrayList;)V", "Lgg/skytils/ktor/server/application/ApplicationCall;", "call", "Lgg/skytils/ktor/server/application/ApplicationCall;", "getCall", "()Lio/ktor/server/application/ApplicationCall;", "failedEvaluation", "Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation$Failure;", "failedEvaluationDepth", "I", "hasTrailingSlash", "Z", "getHasTrailingSlash", "()Z", "resolveResult", "Ljava/util/ArrayList;", "routing", "Lgg/skytils/ktor/server/routing/Route;", "getRouting", "()Lio/ktor/server/routing/Route;", "segments", "Ljava/util/List;", "getSegments", "()Ljava/util/List;", "Lgg/skytils/ktor/server/routing/RoutingResolveTrace;", "trace", "Lgg/skytils/ktor/server/routing/RoutingResolveTrace;", "Lkotlin/Function1;", "tracers", "<init>", "(Lio/ktor/server/routing/Route;Lio/ktor/server/application/ApplicationCall;Ljava/util/List;)V", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRoutingResolveContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingResolveContext.kt\nio/ktor/server/routing/RoutingResolveContext\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1099#2,3:246\n1#3:249\n1855#4,2:250\n1774#4,4:252\n1774#4,4:256\n1726#4,3:260\n*S KotlinDebug\n*F\n+ 1 RoutingResolveContext.kt\nio/ktor/server/routing/RoutingResolveContext\n*L\n57#1:246,3\n88#1:250,2\n224#1:252,4\n225#1:256,4\n235#1:260,3\n*E\n"})
public final class RoutingResolveContext {
    @NotNull
    private final Route routing;
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private final List<Function1<RoutingResolveTrace, Unit>> tracers;
    @NotNull
    private final List<String> segments;
    private final boolean hasTrailingSlash;
    @Nullable
    private final RoutingResolveTrace trace;
    @NotNull
    private final ArrayList<RoutingResolveResult.Success> resolveResult;
    @Nullable
    private RouteSelectorEvaluation.Failure failedEvaluation;
    private int failedEvaluationDepth;

    public RoutingResolveContext(@NotNull Route routing, @NotNull ApplicationCall call, @NotNull List<? extends Function1<? super RoutingResolveTrace, Unit>> tracers) {
        Intrinsics.checkNotNullParameter((Object)routing, (String)"routing");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(tracers, (String)"tracers");
        this.routing = routing;
        this.call = call;
        this.tracers = tracers;
        this.hasTrailingSlash = StringsKt.endsWith$default((CharSequence)ApplicationRequestPropertiesKt.path(this.call.getRequest()), (char)'/', (boolean)false, (int)2, null);
        this.resolveResult = new ArrayList(16);
        this.failedEvaluation = RouteSelectorEvaluation.Companion.getFailedPath();
        try {
            this.segments = this.parse(ApplicationRequestPropertiesKt.path(this.call.getRequest()));
            this.trace = this.tracers.isEmpty() ? null : new RoutingResolveTrace(this.call, this.segments);
        }
        catch (URLDecodeException cause) {
            throw new BadRequestException("Url decode failed for " + ApplicationRequestPropertiesKt.getUri(this.call.getRequest()), cause);
        }
    }

    @NotNull
    public final Route getRouting() {
        return this.routing;
    }

    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    public final boolean getHasTrailingSlash() {
        return this.hasTrailingSlash;
    }

    private final List<String> parse(String path) {
        if (((CharSequence)path).length() == 0 || Intrinsics.areEqual((Object)path, (Object)"/")) {
            return CollectionsKt.emptyList();
        }
        int length = path.length();
        int beginSegment = 0;
        int nextSegment = 0;
        CharSequence $this$count$iv = path;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int segmentCount = count$iv;
        ArrayList<String> segments2 = new ArrayList<String>(segmentCount);
        while (nextSegment < length) {
            nextSegment = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)beginSegment, (boolean)false, (int)4, null);
            if (nextSegment == -1) {
                nextSegment = length;
            }
            if (nextSegment == beginSegment) {
                beginSegment = nextSegment + 1;
                continue;
            }
            String segment = CodecsKt.decodeURLPart$default(path, beginSegment, nextSegment, null, 4, null);
            segments2.add(segment);
            beginSegment = nextSegment + 1;
        }
        if (!IgnoreTrailingSlashKt.getIgnoreTrailingSlash(this.call) && StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            segments2.add("");
        }
        return segments2;
    }

    @NotNull
    public final RoutingResolveResult resolve() {
        RoutingResolveResult resolveResult;
        block2: {
            RoutingResolveTrace routingResolveTrace;
            this.handleRoute(this.routing, 0, new ArrayList<RoutingResolveResult.Success>(), -1.7976931348623157E308);
            resolveResult = this.findBestRoute();
            RoutingResolveTrace routingResolveTrace2 = this.trace;
            if (routingResolveTrace2 != null) {
                routingResolveTrace2.registerFinalResult(resolveResult);
            }
            RoutingResolveTrace routingResolveTrace3 = this.trace;
            if (routingResolveTrace3 == null) break block2;
            RoutingResolveTrace $this$resolve_u24lambda_u242 = routingResolveTrace = routingResolveTrace3;
            boolean bl = false;
            Iterable $this$forEach$iv = this.tracers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl2 = false;
                it.invoke((Object)$this$resolve_u24lambda_u242);
            }
        }
        return resolveResult;
    }

    private final double handleRoute(Route entry, int segmentIndex, ArrayList<RoutingResolveResult.Success> trait, double matchedQuality) {
        double bestSucceedChildQuality;
        RouteSelectorEvaluation evaluation;
        block15: {
            int n;
            int childIndex;
            evaluation = entry.getSelector().evaluate(this, segmentIndex);
            if (evaluation instanceof RouteSelectorEvaluation.Failure) {
                RoutingResolveTrace routingResolveTrace = this.trace;
                if (routingResolveTrace != null) {
                    routingResolveTrace.skip(entry, segmentIndex, new RoutingResolveResult.Failure(entry, "Selector didn't match", ((RouteSelectorEvaluation.Failure)evaluation).getFailureStatusCode()));
                }
                if (segmentIndex == this.segments.size()) {
                    this.updateFailedEvaluation((RouteSelectorEvaluation.Failure)evaluation, trait);
                }
                return -1.7976931348623157E308;
            }
            if (!(evaluation instanceof RouteSelectorEvaluation.Success)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(((RouteSelectorEvaluation.Success)evaluation).getQuality() == -1.0) && ((RouteSelectorEvaluation.Success)evaluation).getQuality() < matchedQuality) {
                RoutingResolveTrace routingResolveTrace = this.trace;
                if (routingResolveTrace != null) {
                    routingResolveTrace.skip(entry, segmentIndex, new RoutingResolveResult.Failure(entry, "Better match was already found", HttpStatusCode.Companion.getNotFound()));
                }
                return -1.7976931348623157E308;
            }
            RoutingResolveResult.Success result2 = new RoutingResolveResult.Success(entry, ((RouteSelectorEvaluation.Success)evaluation).getParameters(), ((RouteSelectorEvaluation.Success)evaluation).getQuality());
            int newIndex = segmentIndex + ((RouteSelectorEvaluation.Success)evaluation).getSegmentIncrement();
            if (entry.getChildren().isEmpty() && newIndex != this.segments.size()) {
                RoutingResolveTrace routingResolveTrace = this.trace;
                if (routingResolveTrace != null) {
                    routingResolveTrace.skip(entry, newIndex, new RoutingResolveResult.Failure(entry, "Not all segments matched", HttpStatusCode.Companion.getNotFound()));
                }
                return -1.7976931348623157E308;
            }
            RoutingResolveTrace routingResolveTrace = this.trace;
            if (routingResolveTrace != null) {
                routingResolveTrace.begin(entry, newIndex);
            }
            trait.add(result2);
            boolean hasHandlers = !((Collection)entry.getHandlers$ktor_server_core()).isEmpty();
            bestSucceedChildQuality = -1.7976931348623157E308;
            if (hasHandlers && newIndex == this.segments.size()) {
                if (this.resolveResult.isEmpty() || this.isBetterResolve((List<RoutingResolveResult.Success>)trait)) {
                    bestSucceedChildQuality = ((RouteSelectorEvaluation.Success)evaluation).getQuality();
                    this.resolveResult.clear();
                    this.resolveResult.addAll((Collection<RoutingResolveResult.Success>)trait);
                    this.failedEvaluation = null;
                }
                RoutingResolveTrace routingResolveTrace2 = this.trace;
                if (routingResolveTrace2 != null) {
                    routingResolveTrace2.addCandidate((List<RoutingResolveResult.Success>)trait);
                }
            }
            if ((childIndex = 0) <= (n = CollectionsKt.getLastIndex(entry.getChildren()))) {
                while (true) {
                    Route child2;
                    double childQuality;
                    if ((childQuality = this.handleRoute(child2 = entry.getChildren().get(childIndex), newIndex, trait, bestSucceedChildQuality)) > 0.0) {
                        bestSucceedChildQuality = Math.max(bestSucceedChildQuality, childQuality);
                    }
                    if (childIndex == n) break;
                    ++childIndex;
                }
            }
            CollectionsKt.removeLast((List)trait);
            RoutingResolveTrace routingResolveTrace3 = this.trace;
            if (routingResolveTrace3 == null) break block15;
            routingResolveTrace3.finish(entry, newIndex, result2);
        }
        return bestSucceedChildQuality > 0.0 ? ((RouteSelectorEvaluation.Success)evaluation).getQuality() : -1.7976931348623157E308;
    }

    private final RoutingResolveResult findBestRoute() {
        ArrayList<RoutingResolveResult.Success> finalResolve = this.resolveResult;
        if (finalResolve.isEmpty()) {
            Object object = this.failedEvaluation;
            if (object == null || (object = ((RouteSelectorEvaluation.Failure)object).getFailureStatusCode()) == null) {
                object = HttpStatusCode.Companion.getNotFound();
            }
            return new RoutingResolveResult.Failure(this.routing, "No matched subtrees found", (HttpStatusCode)object);
        }
        ParametersBuilder parameters2 = ParametersKt.ParametersBuilder$default(0, 1, null);
        double quality = Double.MAX_VALUE;
        int index = 0;
        int n = CollectionsKt.getLastIndex((List)finalResolve);
        if (index <= n) {
            while (true) {
                RoutingResolveResult.Success part2;
                Intrinsics.checkNotNullExpressionValue((Object)finalResolve.get(index), (String)"finalResolve[index]");
                parameters2.appendAll(part2.getParameters());
                double partQuality = part2.getQuality$ktor_server_core() == -1.0 ? 1.0 : part2.getQuality$ktor_server_core();
                quality = Math.min(quality, partQuality);
                if (index == n) break;
                ++index;
            }
        }
        return new RoutingResolveResult.Success(((RoutingResolveResult.Success)CollectionsKt.last((List)finalResolve)).getRoute(), parameters2.build(), quality);
    }

    private final boolean isBetterResolve(List<RoutingResolveResult.Success> list) {
        int n;
        int n2;
        int index1 = 0;
        int index2 = 0;
        ArrayList<RoutingResolveResult.Success> currentResolve = this.resolveResult;
        while (index1 < currentResolve.size() && index2 < list.size()) {
            double quality1 = currentResolve.get(index1).getQuality$ktor_server_core();
            double quality2 = list.get(index2).getQuality$ktor_server_core();
            if (quality1 == -1.0) {
                ++index1;
                continue;
            }
            if (quality2 == -1.0) {
                ++index2;
                continue;
            }
            if (!(quality1 == quality2)) {
                return quality2 > quality1;
            }
            ++index1;
            ++index2;
        }
        Iterable $this$count$iv = currentResolve;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int firstQuality = n2;
        Iterable $this$count$iv2 = list;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int secondQuality = n;
        return secondQuality > firstQuality;
    }

    private final void updateFailedEvaluation(RouteSelectorEvaluation.Failure failure, ArrayList<RoutingResolveResult.Success> trait) {
        RouteSelectorEvaluation.Failure failure2 = this.failedEvaluation;
        if (failure2 == null) {
            return;
        }
        RouteSelectorEvaluation.Failure current = failure2;
        if (current.getQuality() < failure.getQuality() || this.failedEvaluationDepth < trait.size()) {
            boolean bl;
            block6: {
                Iterable $this$all$iv = trait;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                        boolean bl2 = false;
                        if (it.getQuality$ktor_server_core() == -1.0 || it.getQuality$ktor_server_core() == 1.0) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.failedEvaluation = failure;
                this.failedEvaluationDepth = trait.size();
            }
        }
    }
}

