/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlWhiteSpaceUtil {
    public static final HtmlWhiteSpaceUtil INSTANCE = new HtmlWhiteSpaceUtil();
    private final Pattern PREFORMATTED_ELEMENT = Pattern.compile("<pre>(?:(?!</?pre>).)*?</pre>", 32);
    private final Pattern BEFORE_AFTER_LINEBREAK = Pattern.compile("\\s+$|^\\s+", 8);
    private final Pattern HORIZONTAL_WHITESPACE = Pattern.compile("\\h");
    private final Pattern SUBSEQUENT_SPACE = Pattern.compile(" {2,}");
    private final Pattern SPACES_ACROSS_TAGS = Pattern.compile(" +((</?[^<>]+>)+) +");
    private final Pattern SPACES_START = Pattern.compile("^((</?[^<>]+>)+) +");
    private final Pattern SPACES_END = Pattern.compile(" +((</?[^<>]+>)+)$");

    private HtmlWhiteSpaceUtil() {
    }

    public String removeUnnecessaryWhiteSpace(String html) {
        html = html.trim();
        LinkedHashMap<String, String> preformattedElements = null;
        Matcher preformattedElementsMatcher = this.PREFORMATTED_ELEMENT.matcher(html);
        int num = 0;
        boolean found = false;
        while (true) {
            if (preformattedElementsMatcher.find()) {
                if (preformattedElements == null) {
                    preformattedElements = new LinkedHashMap<String, String>();
                }
                String key2 = "%%%preformattedElement-" + num + "%%%%";
                while (html.contains(key2)) {
                    key2 = "%%%preformattedElement-" + ++num + "%%%%";
                }
                ++num;
                String element = preformattedElementsMatcher.group();
                preformattedElements.put(key2, element);
                html = html.replace(element, key2);
                found = true;
                continue;
            }
            if (!found) break;
            preformattedElementsMatcher = this.PREFORMATTED_ELEMENT.matcher(html);
            found = false;
        }
        html = this.BEFORE_AFTER_LINEBREAK.matcher(html).replaceAll("");
        html = this.HORIZONTAL_WHITESPACE.matcher(html).replaceAll(" ");
        html = this.SUBSEQUENT_SPACE.matcher(html).replaceAll(" ");
        html = this.SPACES_ACROSS_TAGS.matcher(html).replaceAll(" $1");
        html = this.SPACES_START.matcher(html).replaceAll("$1");
        html = this.SPACES_END.matcher(html).replaceAll("$1");
        if (preformattedElements != null) {
            ArrayList keys2 = new ArrayList(preformattedElements.keySet());
            Collections.reverse(keys2);
            for (String key3 : keys2) {
                html = html.replace(key3, (CharSequence)preformattedElements.get(key3));
            }
        }
        return html;
    }
}

