/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark.elements.impl.table;

import dev.dediamondpro.minemark.LayoutData;
import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.style.Style;
import dev.dediamondpro.minemark.utils.MouseButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class TableRowElement<S extends Style, R>
extends Element<S, R> {
    protected LayoutData.MarkDownElementPosition position;
    protected float cellWidth;
    protected float cellHeight;

    public TableRowElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes2) {
        super(style, layoutStyle, parent, qName, attributes2);
    }

    @Override
    public void drawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            float x = this.cellWidth * (float)i2;
            float y = this.position.getY();
            ((Element)this.children.get(i2)).drawInternal(xOffset + x, yOffset + y, mouseX - x, mouseY - y, renderData);
        }
    }

    @Override
    public void beforeDrawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            float x = this.cellWidth * (float)i2;
            float y = this.position.getY();
            ((Element)this.children.get(i2)).beforeDrawInternal(xOffset + x, yOffset + y, mouseX - x, mouseY - y, renderData);
        }
    }

    @Override
    public void onMouseClickedInternal(MouseButton button, float mouseX, float mouseY) {
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            float x = this.cellWidth * (float)i2;
            float y = this.position.getY();
            ((Element)this.children.get(i2)).onMouseClickedInternal(button, mouseX - x, mouseY - y);
        }
    }

    @Override
    public void generateLayout(LayoutData layoutData, R renderData) {
        if (this.children.isEmpty()) {
            return;
        }
        this.cellWidth = layoutData.getMaxWidth() / (float)(this.children.isEmpty() ? 1 : this.children.size());
        this.cellHeight = 0.0f;
        for (Element child2 : this.children) {
            LayoutData newLayoutData = new LayoutData(this.cellWidth);
            child2.generateLayoutInternal(newLayoutData, renderData);
            this.cellHeight = Math.max(this.cellHeight, newLayoutData.getY() + newLayoutData.getCurrentLine().getHeight());
        }
        this.position = layoutData.addElement(LayoutStyle.Alignment.LEFT, layoutData.getMaxWidth(), this.cellHeight);
    }
}

