/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark;

import dev.dediamondpro.minemark.LayoutStyle;
import dev.dediamondpro.minemark.elements.Element;
import dev.dediamondpro.minemark.elements.EmptyElement;
import dev.dediamondpro.minemark.elements.MineMarkElement;
import dev.dediamondpro.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.minemark.elements.creators.TextElementCreator;
import dev.dediamondpro.minemark.elements.formatting.FormattingElement;
import dev.dediamondpro.minemark.style.Style;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MineMarkHtmlParser<S extends Style, R>
extends DefaultHandler {
    private final List<ElementCreator<S, R>> elements;
    private final List<FormattingElement<S, R>> formattingElements;
    private final TextElementCreator<S, R> textElementCreator;
    private MineMarkElement<S, R> markDown;
    private Element<S, R> currentElement;
    private LayoutStyle layoutStyle;
    private String wrapper = "minemark";
    private S style;
    private StringBuilder textBuilder = new StringBuilder();
    private boolean isPreFormatted = false;

    protected MineMarkHtmlParser(TextElementCreator<S, R> textElementCreator, List<ElementCreator<S, R>> elements, List<FormattingElement<S, R>> formattingElements) {
        this.textElementCreator = textElementCreator;
        this.elements = elements;
        this.formattingElements = formattingElements;
    }

    @Override
    public void startElement(String uri2, String localName, String qName, Attributes attributes2) {
        LayoutStyle originalLayoutStyle;
        switch (qName) {
            case "br": {
                this.textBuilder.append("\n");
                return;
            }
            case "pre": {
                this.isPreFormatted = true;
            }
        }
        if (qName.equals(this.wrapper)) {
            this.markDown = new MineMarkElement(this.style, this.layoutStyle, attributes2);
            this.currentElement = this.markDown;
            return;
        }
        this.addText();
        LayoutStyle layoutStyle = originalLayoutStyle = this.currentElement.getLayoutStyle();
        boolean canBeInline = true;
        for (FormattingElement<S, R> element : this.formattingElements) {
            if (!element.appliesTo(this.style, layoutStyle, this.currentElement, qName, attributes2)) continue;
            if (layoutStyle == originalLayoutStyle) {
                layoutStyle = layoutStyle.clone();
            }
            element.applyStyle(this.style, layoutStyle, this.currentElement, qName, attributes2);
            canBeInline = canBeInline && element.canBeInline(this.style, layoutStyle, this.currentElement, qName, attributes2);
        }
        EmptyElement<S, R> newElement = this.createElement(this.style, layoutStyle, this.currentElement, qName, attributes2);
        EmptyElement<S, R> emptyElement = this.currentElement = newElement != null ? newElement : new EmptyElement<S, R>(this.style, layoutStyle, this.currentElement, qName, attributes2);
        if (!canBeInline) {
            this.currentElement.setInline(false);
        }
    }

    @Override
    public void endElement(String uri2, String localName, String qName) {
        switch (qName) {
            case "br": {
                return;
            }
            case "pre": {
                this.isPreFormatted = false;
            }
        }
        this.addText();
        this.currentElement.complete();
        if (qName.equals(this.wrapper)) {
            return;
        }
        this.currentElement = this.currentElement.getParent();
    }

    @Override
    public void characters(char[] ch, int start2, int length) {
        if (length > 0 && ch[start2] == '\n') {
            ++start2;
            --length;
        }
        if (length > 0 && ch[start2 + length - 1] == '\n') {
            --length;
        }
        if (!this.isPreFormatted) {
            for (int i2 = start2; i2 < start2 + length; ++i2) {
                if (ch[i2] != '\n') continue;
                ch[i2] = 32;
            }
        }
        if (length > 0) {
            this.textBuilder.append(ch, start2, length);
        }
    }

    private void addText() {
        String text2 = this.textBuilder.toString();
        if (text2.isEmpty()) {
            return;
        }
        this.textElementCreator.createElement(this.textBuilder.toString(), this.style, this.currentElement.getLayoutStyle(), this.currentElement, "text", null);
        this.textBuilder = new StringBuilder();
    }

    private Element<S, R> createElement(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes2) {
        for (ElementCreator<S, R> element : this.elements) {
            if (!element.appliesTo(style, layoutStyle, parent, qName, attributes2)) continue;
            return element.createElement(style, layoutStyle, parent, qName, attributes2);
        }
        return null;
    }

    protected void setStyle(S style, LayoutStyle layoutStyle) {
        this.style = style;
        this.layoutStyle = layoutStyle;
    }

    protected void setWrapper(String wrapper) {
        this.wrapper = wrapper;
    }

    protected MineMarkElement<S, R> getParsedResult() {
        return this.markDown;
    }

    protected void cleanUp() {
        this.markDown = null;
        this.currentElement = null;
        this.layoutStyle = null;
        this.style = null;
        this.textBuilder = new StringBuilder();
        this.isPreFormatted = false;
    }
}

