/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigInt;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigNumber;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SerializedConfigValue
extends AbstractConfigValue
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ConfigValue value;
    private boolean wasConfig;

    public SerializedConfigValue() {
        super(null);
    }

    SerializedConfigValue(ConfigValue value) {
        this();
        this.value = value;
        this.wasConfig = false;
    }

    SerializedConfigValue(Config conf) {
        this(conf.root());
        this.wasConfig = true;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.wasConfig) {
            return ((ConfigObject)this.value).toConfig();
        }
        return this.value;
    }

    private static void writeOriginField(DataOutput out2, SerializedField code, Object v) throws IOException {
        switch (code) {
            case ORIGIN_DESCRIPTION: {
                out2.writeUTF((String)v);
                break;
            }
            case ORIGIN_LINE_NUMBER: {
                out2.writeInt((Integer)v);
                break;
            }
            case ORIGIN_END_LINE_NUMBER: {
                out2.writeInt((Integer)v);
                break;
            }
            case ORIGIN_TYPE: {
                out2.writeByte((Integer)v);
                break;
            }
            case ORIGIN_URL: {
                out2.writeUTF((String)v);
                break;
            }
            case ORIGIN_RESOURCE: {
                out2.writeUTF((String)v);
                break;
            }
            case ORIGIN_COMMENTS: {
                List list = (List)v;
                int size2 = list.size();
                out2.writeInt(size2);
                for (String s2 : list) {
                    out2.writeUTF(s2);
                }
                break;
            }
            case ORIGIN_NULL_URL: 
            case ORIGIN_NULL_RESOURCE: 
            case ORIGIN_NULL_COMMENTS: {
                break;
            }
            default: {
                throw new IOException("Unhandled field from origin: " + (Object)((Object)code));
            }
        }
    }

    static void writeOrigin(DataOutput out2, SimpleConfigOrigin origin2, SimpleConfigOrigin baseOrigin) throws IOException {
        Map<Object, Object> m4 = origin2 != null ? origin2.toFieldsDelta(baseOrigin) : Collections.emptyMap();
        for (Map.Entry e : m4.entrySet()) {
            FieldOut field2 = new FieldOut((SerializedField)((Object)e.getKey()));
            Object v = e.getValue();
            SerializedConfigValue.writeOriginField(field2.data, field2.code, v);
            SerializedConfigValue.writeField(out2, field2);
        }
        SerializedConfigValue.writeEndMarker(out2);
    }

    static SimpleConfigOrigin readOrigin(DataInput in, SimpleConfigOrigin baseOrigin) throws IOException {
        EnumMap<SerializedField, Object> m4 = new EnumMap<SerializedField, Object>(SerializedField.class);
        while (true) {
            ArrayList<String> v = null;
            SerializedField field2 = SerializedConfigValue.readCode(in);
            switch (field2) {
                case END_MARKER: {
                    return SimpleConfigOrigin.fromBase(baseOrigin, m4);
                }
                case ORIGIN_DESCRIPTION: {
                    in.readInt();
                    v = in.readUTF();
                    break;
                }
                case ORIGIN_LINE_NUMBER: {
                    in.readInt();
                    v = in.readInt();
                    break;
                }
                case ORIGIN_END_LINE_NUMBER: {
                    in.readInt();
                    v = in.readInt();
                    break;
                }
                case ORIGIN_TYPE: {
                    in.readInt();
                    v = in.readUnsignedByte();
                    break;
                }
                case ORIGIN_URL: {
                    in.readInt();
                    v = in.readUTF();
                    break;
                }
                case ORIGIN_RESOURCE: {
                    in.readInt();
                    v = in.readUTF();
                    break;
                }
                case ORIGIN_COMMENTS: {
                    in.readInt();
                    int size2 = in.readInt();
                    ArrayList<String> list = new ArrayList<String>(size2);
                    for (int i2 = 0; i2 < size2; ++i2) {
                        list.add(in.readUTF());
                    }
                    v = list;
                    break;
                }
                case ORIGIN_NULL_URL: 
                case ORIGIN_NULL_RESOURCE: 
                case ORIGIN_NULL_COMMENTS: {
                    in.readInt();
                    v = "";
                    break;
                }
                case ROOT_VALUE: 
                case ROOT_WAS_CONFIG: 
                case VALUE_DATA: 
                case VALUE_ORIGIN: {
                    throw new IOException("Not expecting this field here: " + (Object)((Object)field2));
                }
                case UNKNOWN: {
                    SerializedConfigValue.skipField(in);
                }
            }
            if (v == null) continue;
            m4.put(field2, (Object)v);
        }
    }

    private static void writeValueData(DataOutput out2, ConfigValue value) throws IOException {
        SerializedValueType st2 = SerializedValueType.forValue(value);
        out2.writeByte(st2.ordinal());
        switch (st2) {
            case BOOLEAN: {
                out2.writeBoolean(((ConfigBoolean)value).unwrapped());
                break;
            }
            case NULL: {
                break;
            }
            case INT: {
                out2.writeInt(((ConfigInt)value).unwrapped());
                out2.writeUTF(((ConfigNumber)value).transformToString());
                break;
            }
            case LONG: {
                out2.writeLong(((ConfigLong)value).unwrapped());
                out2.writeUTF(((ConfigNumber)value).transformToString());
                break;
            }
            case DOUBLE: {
                out2.writeDouble(((ConfigDouble)value).unwrapped());
                out2.writeUTF(((ConfigNumber)value).transformToString());
                break;
            }
            case STRING: {
                out2.writeUTF(((ConfigString)value).unwrapped());
                break;
            }
            case LIST: {
                ConfigList list = (ConfigList)value;
                out2.writeInt(list.size());
                for (ConfigValue v : list) {
                    SerializedConfigValue.writeValue(out2, v, (SimpleConfigOrigin)list.origin());
                }
                break;
            }
            case OBJECT: {
                ConfigObject obj = (ConfigObject)value;
                out2.writeInt(obj.size());
                for (Map.Entry e : obj.entrySet()) {
                    out2.writeUTF((String)e.getKey());
                    SerializedConfigValue.writeValue(out2, (ConfigValue)e.getValue(), (SimpleConfigOrigin)obj.origin());
                }
                break;
            }
        }
    }

    private static AbstractConfigValue readValueData(DataInput in, SimpleConfigOrigin origin2) throws IOException {
        int stb = in.readUnsignedByte();
        SerializedValueType st2 = SerializedValueType.forInt(stb);
        if (st2 == null) {
            throw new IOException("Unknown serialized value type: " + stb);
        }
        switch (st2) {
            case BOOLEAN: {
                return new ConfigBoolean(origin2, in.readBoolean());
            }
            case NULL: {
                return new ConfigNull(origin2);
            }
            case INT: {
                int vi = in.readInt();
                String si = in.readUTF();
                return new ConfigInt(origin2, vi, si);
            }
            case LONG: {
                long vl = in.readLong();
                String sl = in.readUTF();
                return new ConfigLong(origin2, vl, sl);
            }
            case DOUBLE: {
                double vd = in.readDouble();
                String sd = in.readUTF();
                return new ConfigDouble(origin2, vd, sd);
            }
            case STRING: {
                return new ConfigString.Quoted(origin2, in.readUTF());
            }
            case LIST: {
                int listSize = in.readInt();
                ArrayList<AbstractConfigValue> list = new ArrayList<AbstractConfigValue>(listSize);
                for (int i2 = 0; i2 < listSize; ++i2) {
                    AbstractConfigValue v = SerializedConfigValue.readValue(in, origin2);
                    list.add(v);
                }
                return new SimpleConfigList(origin2, list);
            }
            case OBJECT: {
                int mapSize = in.readInt();
                HashMap<String, AbstractConfigValue> map2 = new HashMap<String, AbstractConfigValue>(mapSize);
                for (int i3 = 0; i3 < mapSize; ++i3) {
                    String key2 = in.readUTF();
                    AbstractConfigValue v = SerializedConfigValue.readValue(in, origin2);
                    map2.put(key2, v);
                }
                return new SimpleConfigObject(origin2, map2);
            }
        }
        throw new IOException("Unhandled serialized value type: " + (Object)((Object)st2));
    }

    private static void writeValue(DataOutput out2, ConfigValue value, SimpleConfigOrigin baseOrigin) throws IOException {
        FieldOut origin2 = new FieldOut(SerializedField.VALUE_ORIGIN);
        SerializedConfigValue.writeOrigin(origin2.data, (SimpleConfigOrigin)value.origin(), baseOrigin);
        SerializedConfigValue.writeField(out2, origin2);
        FieldOut data2 = new FieldOut(SerializedField.VALUE_DATA);
        SerializedConfigValue.writeValueData(data2.data, value);
        SerializedConfigValue.writeField(out2, data2);
        SerializedConfigValue.writeEndMarker(out2);
    }

    private static AbstractConfigValue readValue(DataInput in, SimpleConfigOrigin baseOrigin) throws IOException {
        AbstractConfigValue value = null;
        SimpleConfigOrigin origin2 = null;
        while (true) {
            SerializedField code;
            if ((code = SerializedConfigValue.readCode(in)) == SerializedField.END_MARKER) {
                if (value == null) {
                    throw new IOException("No value data found in serialization of value");
                }
                return value;
            }
            if (code == SerializedField.VALUE_DATA) {
                if (origin2 == null) {
                    throw new IOException("Origin must be stored before value data");
                }
                in.readInt();
                value = SerializedConfigValue.readValueData(in, origin2);
                continue;
            }
            if (code == SerializedField.VALUE_ORIGIN) {
                in.readInt();
                origin2 = SerializedConfigValue.readOrigin(in, baseOrigin);
                continue;
            }
            SerializedConfigValue.skipField(in);
        }
    }

    private static void writeField(DataOutput out2, FieldOut field2) throws IOException {
        byte[] bytes = field2.bytes.toByteArray();
        out2.writeByte(field2.code.ordinal());
        out2.writeInt(bytes.length);
        out2.write(bytes);
    }

    private static void writeEndMarker(DataOutput out2) throws IOException {
        out2.writeByte(SerializedField.END_MARKER.ordinal());
    }

    private static SerializedField readCode(DataInput in) throws IOException {
        int c = in.readUnsignedByte();
        if (c == SerializedField.UNKNOWN.ordinal()) {
            throw new IOException("field code " + c + " is not supposed to be on the wire");
        }
        return SerializedField.forInt(c);
    }

    private static void skipField(DataInput in) throws IOException {
        int len = in.readInt();
        int skipped = in.skipBytes(len);
        if (skipped < len) {
            byte[] bytes = new byte[len - skipped];
            in.readFully(bytes);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out2) throws IOException {
        if (((AbstractConfigValue)this.value).resolveStatus() != ResolveStatus.RESOLVED) {
            throw new NotSerializableException("tried to serialize a value with unresolved substitutions, need to Config#resolve() first, see API docs");
        }
        FieldOut field2 = new FieldOut(SerializedField.ROOT_VALUE);
        SerializedConfigValue.writeValue(field2.data, this.value, null);
        SerializedConfigValue.writeField(out2, field2);
        field2 = new FieldOut(SerializedField.ROOT_WAS_CONFIG);
        field2.data.writeBoolean(this.wasConfig);
        SerializedConfigValue.writeField(out2, field2);
        SerializedConfigValue.writeEndMarker(out2);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SerializedField code;
        while ((code = SerializedConfigValue.readCode(in)) != SerializedField.END_MARKER) {
            DataInput input2 = this.fieldIn(in);
            if (code == SerializedField.ROOT_VALUE) {
                this.value = SerializedConfigValue.readValue(input2, null);
                continue;
            }
            if (code != SerializedField.ROOT_WAS_CONFIG) continue;
            this.wasConfig = input2.readBoolean();
        }
        return;
    }

    private DataInput fieldIn(ObjectInput in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        return new DataInputStream(new ByteArrayInputStream(bytes));
    }

    private static ConfigException shouldNotBeUsed() {
        return new ConfigException.BugOrBroken(SerializedConfigValue.class.getName() + " should not exist outside of serialization");
    }

    @Override
    public ConfigValueType valueType() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    public Object unwrapped() {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    protected SerializedConfigValue newCopy(ConfigOrigin origin2) {
        throw SerializedConfigValue.shouldNotBeUsed();
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + "(value=" + this.value + ",wasConfig=" + this.wasConfig + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SerializedConfigValue) {
            return this.canEqual(other) && this.wasConfig == ((SerializedConfigValue)other).wasConfig && this.value.equals(((SerializedConfigValue)other).value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h2 = 41 * (41 + this.value.hashCode());
        h2 = 41 * (h2 + (this.wasConfig ? 1 : 0));
        return h2;
    }

    private static class FieldOut {
        final SerializedField code;
        final ByteArrayOutputStream bytes;
        final DataOutput data;

        FieldOut(SerializedField code) {
            this.code = code;
            this.bytes = new ByteArrayOutputStream();
            this.data = new DataOutputStream(this.bytes);
        }
    }

    private static enum SerializedValueType {
        NULL(ConfigValueType.NULL),
        BOOLEAN(ConfigValueType.BOOLEAN),
        INT(ConfigValueType.NUMBER),
        LONG(ConfigValueType.NUMBER),
        DOUBLE(ConfigValueType.NUMBER),
        STRING(ConfigValueType.STRING),
        LIST(ConfigValueType.LIST),
        OBJECT(ConfigValueType.OBJECT);

        ConfigValueType configType;

        private SerializedValueType(ConfigValueType configType) {
            this.configType = configType;
        }

        static SerializedValueType forInt(int b) {
            if (b < SerializedValueType.values().length) {
                return SerializedValueType.values()[b];
            }
            return null;
        }

        static SerializedValueType forValue(ConfigValue value) {
            ConfigValueType t2 = value.valueType();
            if (t2 == ConfigValueType.NUMBER) {
                if (value instanceof ConfigInt) {
                    return INT;
                }
                if (value instanceof ConfigLong) {
                    return LONG;
                }
                if (value instanceof ConfigDouble) {
                    return DOUBLE;
                }
            } else {
                for (SerializedValueType st2 : SerializedValueType.values()) {
                    if (st2.configType != t2) continue;
                    return st2;
                }
            }
            throw new ConfigException.BugOrBroken("don't know how to serialize " + value);
        }
    }

    static enum SerializedField {
        UNKNOWN,
        END_MARKER,
        ROOT_VALUE,
        ROOT_WAS_CONFIG,
        VALUE_DATA,
        VALUE_ORIGIN,
        ORIGIN_DESCRIPTION,
        ORIGIN_LINE_NUMBER,
        ORIGIN_END_LINE_NUMBER,
        ORIGIN_TYPE,
        ORIGIN_URL,
        ORIGIN_COMMENTS,
        ORIGIN_NULL_URL,
        ORIGIN_NULL_COMMENTS,
        ORIGIN_RESOURCE,
        ORIGIN_NULL_RESOURCE;


        static SerializedField forInt(int b) {
            if (b < SerializedField.values().length) {
                return SerializedField.values()[b];
            }
            return UNKNOWN;
        }
    }
}

