/*
 * Decompiled with CFR 0.152.
 */
package com.github.scherso.notsoessential.asm;

import com.github.scherso.notsoessential.asm.ITransformer;
import com.github.scherso.notsoessential.asm.transformer.CommandConfigTransformer;
import com.github.scherso.notsoessential.asm.transformer.ConnectionManagerTransformer;
import com.github.scherso.notsoessential.asm.transformer.ConnectionTransformer;
import com.github.scherso.notsoessential.asm.transformer.EssentialConfigTransformer;
import com.github.scherso.notsoessential.asm.transformer.EssentialModelRendererTransformer;
import com.github.scherso.notsoessential.asm.transformer.EssentialMultiplayerGuiTransformer;
import com.github.scherso.notsoessential.asm.transformer.ExtensionsKtTransformer;
import com.github.scherso.notsoessential.asm.transformer.MenuButtonTransformer;
import com.github.scherso.notsoessential.asm.transformer.MixinLogExceptionsTransformer;
import com.github.scherso.notsoessential.asm.transformer.Mixin_AddPerServerPrivacyButtonTransformer;
import com.github.scherso.notsoessential.asm.transformer.OnboardingDataTransformer;
import com.github.scherso.notsoessential.asm.transformer.OnlineIndicatorTransformer;
import com.github.scherso.notsoessential.asm.transformer.PauseMenuDisplayTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassTransformer
implements IClassTransformer {
    public static final boolean DUMP_BYTECODE = Boolean.parseBoolean(System.getProperty("NSE.debugBytecode", "false"));
    static final int EOL = -1;
    private final HashMap<String, List<ITransformer>> TRANSFORMER_HASHMAP = new HashMap();

    public ClassTransformer() {
        this.registerTransformer(new CommandConfigTransformer());
        this.registerTransformer(new ConnectionManagerTransformer());
        this.registerTransformer(new ConnectionTransformer());
        this.registerTransformer(new EssentialConfigTransformer());
        this.registerTransformer(new EssentialModelRendererTransformer());
        this.registerTransformer(new EssentialMultiplayerGuiTransformer());
        this.registerTransformer(new MenuButtonTransformer());
        this.registerTransformer(new Mixin_AddPerServerPrivacyButtonTransformer());
        this.registerTransformer(new OnboardingDataTransformer());
        this.registerTransformer(new OnlineIndicatorTransformer());
        this.registerTransformer(new PauseMenuDisplayTransformer());
        this.registerTransformer(new MixinLogExceptionsTransformer());
        this.registerTransformer(new ExtensionsKtTransformer());
    }

    private void registerTransformer(@NotNull ITransformer transformer) {
        List<ITransformer> transformer_list = this.TRANSFORMER_HASHMAP.get(transformer.getClassName());
        if (transformer_list == null) {
            ArrayList<ITransformer> new_list = new ArrayList<ITransformer>();
            new_list.add(transformer);
            this.TRANSFORMER_HASHMAP.put(transformer.getClassName(), new_list);
        } else {
            transformer_list.add(transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        List<ITransformer> transformer_list = this.TRANSFORMER_HASHMAP.get(transformedName);
        if (transformer_list == null) {
            return bytes;
        }
        for (int i = transformer_list.size() - 1; i > -1; --i) {
            ITransformer transformer = transformer_list.get(i);
            ClassNode cn = new ClassNode();
            ClassReader cr = new ClassReader(bytes);
            cr.accept((ClassVisitor)cn, 0);
            transformer.transform(cn, transformedName);
            ClassWriter cw = new ClassWriter(cr, 2);
            cn.accept((ClassVisitor)cw);
            if (DUMP_BYTECODE) {
                this.dumpBytes(transformedName, cw);
            }
            bytes = cw.toByteArray();
        }
        return bytes;
    }

    private void dumpBytes(String name, ClassWriter writer) {
        try {
            File bytecode_out;
            name = name.contains("$") ? name.replace('$', '.') + ".class" : name + ".class";
            File bytecode_dir = new File(".bytecode.out");
            if (!bytecode_dir.exists()) {
                bytecode_dir.mkdirs();
            }
            if (!(bytecode_out = new File(bytecode_dir, name)).exists()) {
                bytecode_out.createNewFile();
            }
            FileOutputStream stream = new FileOutputStream(bytecode_out);
            stream.write(writer.toByteArray());
            stream.close();
        }
        catch (Exception ex) {
            System.out.println("Failed to dump bytecode for " + name);
            throw new RuntimeException(ex);
        }
    }
}

