/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.resourceloaders;

import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import com.google.gson.Gson;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ReportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ResourceLoader {
    protected static final Gson gson = new Gson();
    protected static final Logger logger = LogManager.getLogger();

    protected static void handleResourceLoadException(IResource resource, boolean fatal, RuntimeException e) {
        String resourcePackDescription;
        String resourcePackName;
        ResourcePackRepository.Entry resourcePackEntry = Minecraft.func_71410_x().func_110438_M().func_110613_c().stream().filter(entry -> entry.func_110515_d().equals(resource.func_177240_d())).findFirst().orElse(null);
        if (resourcePackEntry != null) {
            resourcePackName = resource.func_177240_d();
            resourcePackDescription = resourcePackEntry.func_110519_e();
        } else {
            resourcePackName = FancyWarpMenu.getInstance().getModContainer().getName() + " " + FancyWarpMenu.getInstance().getModContainer().getVersion();
            resourcePackDescription = "Built-in resource pack";
        }
        if (!fatal) {
            StringBuilder stringBuilder = new StringBuilder("Your Fancy Warp Menu resource pack may be outdated.");
            stringBuilder.append("\n").append(String.format("Resource loading failed: %s", e.getMessage()));
            stringBuilder.append("\n").append(String.format("Resource Path: %s", resource.func_177241_a().toString()));
            stringBuilder.append("\n").append("Resource Pack Details:");
            stringBuilder.append("\n").append("Name: ").append(resourcePackName);
            stringBuilder.append("\n").append("Description: ").append(resourcePackDescription);
            if (resourcePackEntry != null) {
                stringBuilder.append("\n").append("File: ").append(resourcePackEntry);
            }
            logger.error((Object)stringBuilder, (Throwable)e);
            if (Minecraft.func_71410_x().field_71456_v != null) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + stringBuilder.toString()));
            }
        } else {
            CrashReport crashReport = new CrashReport("Your Fancy Warp Menu resource pack may be outdated", (Throwable)e);
            CrashReportCategory resourceDetails = crashReport.func_85058_a("Resource");
            CrashReportCategory resourcePackDetails = crashReport.func_85058_a("Resource Pack");
            resourceDetails.func_71507_a("Path", (Object)resource.func_177241_a().toString());
            resourcePackDetails.func_71507_a("Name", (Object)resourcePackName);
            resourcePackDetails.func_71507_a("Description", (Object)resourcePackDescription);
            if (resourcePackEntry != null) {
                resourcePackDetails.func_71507_a("File", (Object)resourcePackEntry.toString());
            }
            throw new ReportedException(crashReport);
        }
    }

    protected static void handleGetResourceException(String resourcePath, boolean fatal, IOException e) {
        if (!fatal) {
            StringBuilder stringBuilder = new StringBuilder("Your Fancy Warp Menu resource pack may be outdated.");
            stringBuilder.append("\n").append(String.format("Resource loading failed: %s", e.getMessage()));
            stringBuilder.append("\n").append(String.format("Resource Path: %s", resourcePath));
            logger.error((Object)stringBuilder, (Throwable)e);
            if (Minecraft.func_71410_x().field_71456_v != null) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + stringBuilder.toString()));
            }
        } else {
            CrashReport crashReport = new CrashReport("Your Fancy Warp Menu resource pack may be outdated", (Throwable)e);
            CrashReportCategory resourceDetails = crashReport.func_85058_a("Resource");
            resourceDetails.func_71507_a("Path", (Object)resourcePath);
            throw new ReportedException(crashReport);
        }
    }
}

