/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.listeners;

import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.GameState;
import ca.tirelesstraveler.fancywarpmenu.data.Settings;
import ca.tirelesstraveler.fancywarpmenu.data.skyblockconstants.WarpCommandVariant;
import ca.tirelesstraveler.fancywarpmenu.data.skyblockconstants.WarpMessages;
import ca.tirelesstraveler.fancywarpmenu.gui.FancyWarpMenuConfigScreen;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonConfig;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiFancyWarp;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;

@ChannelHandler.Sharable
public class WarpMenuListener
extends ChannelOutboundHandlerAdapter
implements IResourceManagerReloadListener {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final FancyWarpMenu modInstance = FancyWarpMenu.getInstance();
    private static final Logger logger = LogManager.getLogger();
    private static GuiFancyWarp warpScreen;
    private static boolean openMenuRequested;
    private static boolean openConfigMenuRequested;

    @SubscribeEvent
    public void onChatMessageReceived(ClientChatReceivedEvent event) {
        if (event.type == 0 && warpScreen != null && WarpMenuListener.mc.field_71462_r == warpScreen) {
            String unformattedText = event.message.func_150260_c();
            if (FancyWarpMenu.getSkyBlockConstants().getWarpMessages().getWarpSuccessMessages().contains(unformattedText)) {
                mc.func_147108_a(null);
            } else if (FancyWarpMenu.getSkyBlockConstants().getWarpMessages().getWarpFailMessages().containsKey(unformattedText)) {
                WarpMessages warpMessages = FancyWarpMenu.getSkyBlockConstants().getWarpMessages();
                Map<String, String> warpFailMessages = warpMessages.getWarpFailMessages();
                String failMessageKey = warpFailMessages.get(unformattedText);
                warpScreen.onWarpFail(failMessageKey);
            }
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui == null) {
            if (openMenuRequested) {
                event.gui = warpScreen;
                openMenuRequested = false;
            } else if (openConfigMenuRequested) {
                event.gui = new FancyWarpMenuConfigScreen(null);
                openConfigMenuRequested = false;
            }
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post e) {
        if (e.gui instanceof GuiChest) {
            GuiChest guiChest = (GuiChest)e.gui;
            ContainerChest containerChest = (ContainerChest)guiChest.field_147002_h;
            if (containerChest.func_85151_d().func_70005_c_().equals("Fast Travel")) {
                e.buttonList.add(new GuiButtonConfig(e.buttonList.size(), new ScaledResolution(mc)));
            }
        }
    }

    @SubscribeEvent
    public void onKeyboardInput(InputEvent.KeyInputEvent event) {
        if (Settings.isWarpMenuEnabled() && modInstance.isPlayerOnSkyBlock() && FancyWarpMenu.getKeyBindingOpenWarpMenu().func_151468_f()) {
            this.displayFancyWarpMenu();
        }
    }

    @SubscribeEvent
    public void onGuiMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (Settings.isWarpMenuEnabled() && modInstance.isPlayerOnSkyBlock() && Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && event.gui instanceof GuiChest) {
            ContainerChest container;
            GuiChest guiChest = (GuiChest)event.gui;
            if (guiChest.field_147002_h instanceof ContainerChest && (container = (ContainerChest)guiChest.field_147002_h).func_85151_d() != null && container.func_85151_d().func_145818_k_() && container.func_85151_d().func_70005_c_().equals("SkyBlock Menu") && guiChest.getSlotUnderMouse() != null && guiChest.getSlotUnderMouse().getSlotIndex() == 47 && StringUtils.func_76338_a((String)guiChest.getSlotUnderMouse().func_75211_c().func_82833_r()).equals("Fast Travel")) {
                this.displayFancyWarpMenu();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(modInstance.getModId())) {
            Settings.syncConfig(false);
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        FancyWarpMenu.getInstance().reloadLayout();
    }

    public void onWarpCommand() {
        warpScreen = new GuiFancyWarp();
        if (Settings.shouldAddWarpCommandToChatHistory()) {
            WarpMenuListener.mc.field_71456_v.func_146158_b().func_146239_a("/warp");
        }
        if (WarpMenuListener.mc.field_71462_r instanceof GuiChat) {
            openMenuRequested = true;
        } else {
            this.displayFancyWarpMenu();
        }
    }

    public void onOpenConfigMenuCommand() {
        openConfigMenuRequested = true;
    }

    public void displayFancyWarpMenu() {
        this.checkLateWinter();
        warpScreen = new GuiFancyWarp();
        mc.func_147108_a((GuiScreen)warpScreen);
    }

    private void checkLateWinter() {
        if (!Settings.shouldSkipSkyBlockCheck()) {
            try {
                Scoreboard sb = WarpMenuListener.mc.field_71441_e.func_96441_U();
                ArrayList scores = (ArrayList)sb.func_96534_i(sb.func_96518_b("SBScoreboard"));
                for (int i = scores.size(); i > 0; --i) {
                    Score score = (Score)scores.get(i - 1);
                    String playerNameDisplayFormat = sb.func_96509_i(score.func_96653_e()).func_142053_d("");
                    if (!playerNameDisplayFormat.trim().startsWith("Late Winter")) continue;
                    GameState.setLateWinter(true);
                    return;
                }
                GameState.setLateWinter(false);
            }
            catch (RuntimeException e) {
                logger.warn("Failed to check scoreboard season for late winter", (Throwable)e);
            }
        }
    }

    public static WarpCommandVariant getWarpCommandVariant(String command) {
        String baseCommand = command.toLowerCase(Locale.US).substring(1).split(" ")[0];
        for (WarpCommandVariant commandVariant : FancyWarpMenu.getSkyBlockConstants().getWarpCommandVariants()) {
            if (!commandVariant.getCommand().equals(baseCommand)) continue;
            return commandVariant;
        }
        return null;
    }

    public static void sendReminderToUseWarpScreen() {
        WarpMenuListener.mc.field_71439_g.func_145747_a(new ChatComponentTranslation(FancyWarpMenu.getFullLanguageKey("messages.useWarpMenuInsteadOfCommand"), new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
    }
}

