/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.listeners;

import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.GameState;
import ca.tirelesstraveler.fancywarpmenu.data.Settings;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.network.play.server.S3DPacketDisplayScoreboard;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class SkyBlockJoinListener
extends SimpleChannelInboundHandler<S3DPacketDisplayScoreboard> {
    private static final String SERVER_BRAND_START = "Hypixel BungeeCord";
    private static final String PACKET_LISTENER_NAME = String.format("%s:skyblock_join_listener", FancyWarpMenu.getInstance().getModId());
    private static final Logger logger = LogManager.getLogger();
    private boolean serverBrandChecked;
    private boolean onHypixel;

    public SkyBlockJoinListener() {
        super(false);
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        if (e.manager.channel().pipeline().get(PACKET_LISTENER_NAME) == null) {
            e.manager.channel().pipeline().addBefore("packet_handler", PACKET_LISTENER_NAME, (ChannelHandler)this);
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        if (this.onHypixel) {
            this.serverBrandChecked = false;
            this.onHypixel = false;
            GameState.setOnSkyBlock(false);
            logger.info("Disconnected from Hypixel.");
        }
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, S3DPacketDisplayScoreboard packet) {
        if (channelHandlerContext.channel().isOpen()) {
            EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
            try {
                logger.debug("Received S3DPacketDisplayScoreboard packet with title \"{}\"", new Object[]{packet.func_149370_d()});
                if (thePlayer != null && thePlayer.func_142021_k() != null) {
                    if (!this.serverBrandChecked) {
                        this.onHypixel = thePlayer.func_142021_k().startsWith(SERVER_BRAND_START);
                        this.serverBrandChecked = true;
                        if (this.onHypixel) {
                            logger.info("Player joined Hypixel.");
                        }
                    }
                    if (this.onHypixel && packet.func_149371_c() == 1) {
                        String objectiveName = packet.func_149370_d();
                        boolean newSkyBlockState = objectiveName.equals("SBScoreboard");
                        if (newSkyBlockState && !GameState.isOnSkyBlock()) {
                            logger.info("Player joined SkyBlock.");
                        } else if (!newSkyBlockState && GameState.isOnSkyBlock()) {
                            logger.info("Player left SkyBlock.");
                        }
                        GameState.setOnSkyBlock(newSkyBlockState);
                    }
                }
            }
            catch (RuntimeException e) {
                logger.error(String.format("SkyBlock Join Check Failed: %s\nBrand: %s\nPacket contents:\n  Position: %s\n  Score Name: %s", e.getMessage(), thePlayer.func_142021_k(), packet.func_149371_c(), packet.func_149370_d()), (Throwable)e);
            }
        }
        channelHandlerContext.fireChannelRead((Object)packet);
    }

    public boolean isOnSkyBlock() {
        return Settings.isDebugModeEnabled() && Settings.shouldSkipSkyBlockCheck() || GameState.isOnSkyBlock();
    }
}

