/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.gui.grid;

import ca.tirelesstraveler.fancywarpmenu.gui.grid.GridRectangle;
import java.util.HashMap;

public class ScaledGrid {
    public final HashMap<String, GridRectangle> rectangleMap = new HashMap();
    public final float ORIGINAL_X_POSITION;
    public final float ORIGINAL_Y_POSITION;
    public final float ORIGINAL_GRID_WIDTH;
    public final float ORIGINAL_GRID_HEIGHT;
    public final float ORIGINAL_GRID_UNIT_WIDTH;
    public final float ORIGINAL_GRID_UNIT_HEIGHT;
    private float gridStartX;
    private float gridStartY;
    private float gridWidth;
    private float gridHeight;
    private float gridUnitWidth;
    private float gridUnitHeight;
    private float scaleFactor;
    private boolean scaled;
    protected boolean scaleStartPosition;
    protected boolean centerStartPositionWhenScaled;

    public ScaledGrid(float gridStartX, float gridStartY, float gridWidth, float gridHeight, int numberOfRowsAndColumns, boolean centerStartPositionWhenScaled) {
        this(gridStartX, gridStartY, gridWidth, gridHeight, numberOfRowsAndColumns, numberOfRowsAndColumns, centerStartPositionWhenScaled);
    }

    public ScaledGrid(float gridStartX, float gridStartY, float gridWidth, float gridHeight, int numberOfRows, int numberOfColumns, boolean centerStartPositionWhenScaled) {
        this(gridStartX, gridStartY, gridWidth, gridHeight, gridWidth / (float)numberOfColumns, gridHeight / (float)numberOfRows, centerStartPositionWhenScaled);
    }

    public ScaledGrid(float gridStartX, float gridStartY, float gridWidth, float gridHeight, float gridUnitSize, boolean centerStartPositionWhenScaled) {
        this(gridStartX, gridStartY, gridWidth, gridHeight, gridUnitSize, gridUnitSize, centerStartPositionWhenScaled);
    }

    public ScaledGrid(float gridStartX, float gridStartY, float gridWidth, float gridHeight, float gridUnitWidth, float gridUnitHeight, boolean centerStartPositionWhenScaled) {
        this.ORIGINAL_X_POSITION = gridStartX;
        this.ORIGINAL_Y_POSITION = gridStartY;
        this.ORIGINAL_GRID_WIDTH = gridWidth;
        this.ORIGINAL_GRID_HEIGHT = gridHeight;
        this.ORIGINAL_GRID_UNIT_WIDTH = gridUnitWidth;
        this.ORIGINAL_GRID_UNIT_HEIGHT = gridUnitHeight;
        this.gridStartX = gridStartX;
        this.gridStartY = gridStartY;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.gridUnitWidth = gridUnitWidth;
        this.gridUnitHeight = gridUnitHeight;
        this.scaleFactor = 1.0f;
        this.scaled = false;
        this.centerStartPositionWhenScaled = centerStartPositionWhenScaled;
    }

    public int findNearestGridX(int mouseX) {
        float offset = (float)mouseX - this.gridStartX;
        float quotient = offset / this.gridUnitWidth;
        float remainder = offset / this.gridUnitWidth;
        return (int)(remainder > this.gridUnitWidth / 2.0f ? quotient + 1.0f : quotient);
    }

    public void addRectangle(String name, GridRectangle rectangle) {
        if (rectangle != null) {
            if (this.scaled) {
                rectangle.scale(this.scaleFactor);
            }
        } else {
            throw new NullPointerException("Cannot add a null GridRectangle to ScaledGrid");
        }
        this.rectangleMap.put(name, rectangle);
    }

    public void removeRectangle(String name) {
        this.rectangleMap.remove(name);
    }

    public int findNearestGridY(int mouseY) {
        float offset = (float)mouseY - this.gridStartY;
        float quotient = offset / this.gridUnitHeight;
        float remainder = offset % this.gridUnitHeight;
        return (int)(remainder > this.gridUnitHeight / 2.0f ? quotient + 1.0f : quotient);
    }

    public float getActualX(int gridX) {
        return this.gridStartX + this.getOffsetX(gridX);
    }

    public float getActualY(int gridY) {
        return this.gridStartY + this.getOffsetY(gridY);
    }

    public float getOffsetX(float gridX) {
        return this.gridUnitWidth * gridX;
    }

    public float getOffsetY(int gridY) {
        return this.gridUnitHeight * (float)gridY;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.scaled = scaleFactor != 1.0f;
        this.gridWidth = this.getScaledDimension(this.ORIGINAL_GRID_WIDTH);
        this.gridHeight = this.getScaledDimension(this.ORIGINAL_GRID_HEIGHT);
        this.gridUnitWidth = this.getScaledDimension(this.ORIGINAL_GRID_UNIT_WIDTH);
        this.gridUnitHeight = this.getScaledDimension(this.ORIGINAL_GRID_UNIT_HEIGHT);
        if (this.scaleStartPosition) {
            this.gridStartX = this.getScaledDimension(this.ORIGINAL_X_POSITION);
            this.gridStartY = this.getScaledDimension(this.ORIGINAL_Y_POSITION);
        } else if (this.centerStartPositionWhenScaled) {
            this.gridStartX = this.ORIGINAL_X_POSITION - Math.abs(this.gridWidth - this.ORIGINAL_GRID_WIDTH) / 2.0f;
            this.gridStartY = this.ORIGINAL_Y_POSITION - Math.abs(this.gridHeight - this.ORIGINAL_GRID_HEIGHT) / 2.0f;
        }
        for (GridRectangle rectangle : this.rectangleMap.values()) {
            rectangle.scale(scaleFactor);
        }
    }

    public float getGridStartX() {
        return this.gridStartX;
    }

    public void setGridStartX(float gridStartX) {
        this.gridStartX = gridStartX;
    }

    public float getGridStartY() {
        return this.gridStartY;
    }

    public void setGridStartY(float gridStartY) {
        this.gridStartY = gridStartY;
    }

    public float getGridWidth() {
        return this.gridWidth;
    }

    public float getGridHeight() {
        return this.gridHeight;
    }

    public float getScaledDimension(float originalDimension) {
        if (this.scaled) {
            return originalDimension * this.scaleFactor;
        }
        return originalDimension;
    }

    public boolean isScaled() {
        return this.scaled;
    }

    public String toString() {
        return "ScaledGrid{rectangleMap=" + this.rectangleMap + ", ORIGINAL_X_POSITION=" + this.ORIGINAL_X_POSITION + ", ORIGINAL_Y_POSITION=" + this.ORIGINAL_Y_POSITION + ", ORIGINAL_GRID_WIDTH=" + this.ORIGINAL_GRID_WIDTH + ", ORIGINAL_GRID_HEIGHT=" + this.ORIGINAL_GRID_HEIGHT + ", ORIGINAL_GRID_UNIT_WIDTH=" + this.ORIGINAL_GRID_UNIT_WIDTH + ", ORIGINAL_GRID_UNIT_HEIGHT=" + this.ORIGINAL_GRID_UNIT_HEIGHT + ", gridStartX=" + this.gridStartX + ", gridStartY=" + this.gridStartY + ", gridWidth=" + this.gridWidth + ", gridHeight=" + this.gridHeight + ", gridUnitWidth=" + this.gridUnitWidth + ", gridUnitHeight=" + this.gridUnitHeight + ", scaleFactor=" + this.scaleFactor + ", scaled=" + this.scaled + '}';
    }
}

