/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.gui.grid;

import ca.tirelesstraveler.fancywarpmenu.gui.grid.ScaledGrid;

public class GridRectangle {
    protected final transient ScaledGrid scaledGrid;
    protected int gridX;
    protected int gridY;
    protected float xPosition;
    protected float yPosition;
    protected float scaledXPosition;
    protected float scaledYPosition;
    protected float width;
    protected float height;
    protected float scaledWidth;
    protected float scaledHeight;
    protected boolean scalePosition;
    protected boolean centerPositionWhenScaled;

    public GridRectangle(ScaledGrid scaledGrid, int gridX, int gridY, float width, float height, boolean scalePosition, boolean centerPositionWhenScaled) {
        this.scaledGrid = scaledGrid;
        this.gridX = gridX;
        this.gridY = gridY;
        this.xPosition = scaledGrid.getActualX(gridX);
        this.yPosition = scaledGrid.getActualY(gridY);
        this.width = width;
        this.height = height;
        this.scalePosition = scalePosition;
        this.centerPositionWhenScaled = centerPositionWhenScaled;
    }

    public void scale(float scaleFactor) {
        this.scaledWidth = this.width * scaleFactor;
        this.scaledHeight = this.height * scaleFactor;
        if (this.scalePosition) {
            this.scaledXPosition = this.scaledGrid.getActualX(this.gridX);
            this.scaledYPosition = this.scaledGrid.getActualY(this.gridY);
        } else if (this.centerPositionWhenScaled) {
            this.scaledXPosition = this.xPosition - (this.scaledWidth - this.width) / 2.0f;
            this.scaledYPosition = this.yPosition - (this.scaledHeight - this.height) / 2.0f;
        }
    }

    public float getXPosition() {
        if (this.scalePosition || this.centerPositionWhenScaled) {
            return this.scaledXPosition;
        }
        return this.xPosition;
    }

    public float getYPosition() {
        if (this.scalePosition || this.centerPositionWhenScaled) {
            return this.scaledYPosition;
        }
        return this.yPosition;
    }

    public float getWidth() {
        return this.scaledWidth;
    }

    public float getHeight() {
        return this.scaledHeight;
    }

    public String toString() {
        return "GridRectangle{gridX=" + this.gridX + ", gridY=" + this.gridY + ", xPosition=" + this.xPosition + ", yPosition=" + this.yPosition + ", scaledXPosition=" + this.scaledXPosition + ", scaledYPosition=" + this.scaledYPosition + ", width=" + this.width + ", height=" + this.height + ", scaledWidth=" + this.scaledWidth + ", scaledHeight=" + this.scaledHeight + ", scalePosition=" + this.scalePosition + ", centerPositionWhenScaled=" + this.centerPositionWhenScaled + '}';
    }
}

