/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.gui;

import ca.tirelesstraveler.fancywarpmenu.EnvironmentDetails;
import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.GameState;
import ca.tirelesstraveler.fancywarpmenu.data.Settings;
import ca.tirelesstraveler.fancywarpmenu.data.layout.Island;
import ca.tirelesstraveler.fancywarpmenu.data.layout.Warp;
import ca.tirelesstraveler.fancywarpmenu.gui.FancyWarpMenuConfigScreen;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonConfig;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonExt;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonIsland;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonRegularWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonWarp;
import ca.tirelesstraveler.fancywarpmenu.gui.grid.ScaledGrid;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C01PacketChatMessage;
import net.minecraft.util.EnumChatFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiFancyWarp
extends GuiScreen {
    private static final long WARP_FAIL_COOL_DOWN = 500L;
    private static final long WARP_FAIL_TOOLTIP_DISPLAY_TIME = 2000L;
    private static final Logger logger = LogManager.getLogger();
    private ScaledResolution res;
    private ScaledGrid scaledGrid;
    private boolean screenDrawn;
    private long warpFailCoolDownExpiryTime;
    private long warpFailTooltipExpiryTime;
    private String warpFailMessage;

    public void func_73866_w_() {
        if (!this.screenDrawn && EnvironmentDetails.isPatcherInstalled()) {
            return;
        }
        this.res = new ScaledResolution(this.field_146297_k);
        this.scaledGrid = new ScaledGrid(0.0f, 0.0f, (float)this.res.func_78326_a(), (float)this.res.func_78328_b(), 36, 64, false);
        Warp.initDefaults(this.res);
        for (Island island : FancyWarpMenu.getLayout().getIslandList()) {
            if (!(Settings.isDebugModeEnabled() && Settings.shouldAlwaysShowJerryIsland() || Settings.shouldShowJerryIsland() && GameState.isLateWinter() || !island.getWarps().get(0).getWarpCommand().equals("/savethejerrys"))) continue;
            GuiButtonIsland islandButton = new GuiButtonIsland(this, this.field_146292_n.size(), this.res, island);
            this.field_146292_n.add(islandButton);
            for (Warp warp : island.getWarps()) {
                if (Settings.shouldHideWarpLabelForIslandsWithOneWarp() && island.getWarpCount() == 1) {
                    warp.setHideDisplayName(true);
                }
                if (Settings.shouldHideUnobtainableWarps() && warp.requiresSpecialGameMode()) continue;
                this.field_146292_n.add(new GuiButtonWarp(this.field_146292_n.size(), islandButton, warp));
            }
        }
        this.field_146292_n.add(new GuiButtonConfig(this.field_146292_n.size(), this.res));
        if (Settings.shouldShowRegularWarpMenuButton()) {
            this.field_146292_n.add(new GuiButtonRegularWarpMenu(this.field_146292_n.size(), this.res, this.scaledGrid));
        }
        this.field_146292_n.sort(null);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.screenDrawn && EnvironmentDetails.isPatcherInstalled()) {
            this.screenDrawn = true;
            this.func_73866_w_();
            this.field_146294_l = this.res.func_78326_a();
            this.field_146295_m = this.res.func_78328_b();
        }
        this.func_146276_q_();
        ArrayList<GuiButtonExt> hoveredButtons = new ArrayList<GuiButtonExt>();
        for (GuiButton button : this.field_146292_n) {
            GuiButtonIsland islandButton;
            if (!(button instanceof GuiButtonIsland)) continue;
            islandButton.setHovered((float)mouseX >= (islandButton = (GuiButtonIsland)button).getScaledXPosition() && (float)mouseY >= islandButton.getScaledYPosition() && (float)mouseX <= islandButton.getScaledXPosition() + islandButton.getScaledWidth() && (float)mouseY <= ((GuiButtonIsland)button).getScaledYPosition() + islandButton.getScaledHeight());
            if (!button.func_146115_a()) continue;
            hoveredButtons.add((GuiButtonExt)button);
        }
        for (int i = 0; i < hoveredButtons.size() - 1; ++i) {
            ((GuiButtonExt)hoveredButtons.get(i)).setHovered(false);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (Minecraft.func_71386_F() <= this.warpFailTooltipExpiryTime && this.warpFailMessage != null) {
            this.func_146283_a(Collections.singletonList(this.warpFailMessage), mouseX, mouseY);
        }
        if (Settings.isDebugModeEnabled() && Settings.shouldShowDebugOverlay()) {
            int nearestY;
            int nearestX;
            ArrayList<String> debugStrings = new ArrayList<String>();
            boolean tooltipDrawn = false;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)20.0f);
            this.func_73732_a(this.field_146297_k.field_71466_p, String.format("%d x %d (%d)", this.res.func_78326_a(), this.res.func_78328_b(), this.res.func_78325_e()), this.field_146294_l / 2, this.field_146295_m - 20, 0xE0E0E0);
            String modName = FancyWarpMenu.getInstance().getModContainer().getName();
            String modVersion = FancyWarpMenu.getInstance().getModContainer().getVersion();
            this.func_73732_a(this.field_146297_k.field_71466_p, modName + " " + modVersion, this.field_146294_l / 2, this.field_146295_m - 10, 0xE0E0E0);
            if (!GuiFancyWarp.func_146272_n()) {
                for (GuiButton button : this.field_146292_n) {
                    if (!(button instanceof GuiButtonIsland) || !button.func_146115_a()) continue;
                    GuiButtonIsland islandButton = (GuiButtonIsland)button;
                    debugStrings.add(EnumChatFormatting.GREEN + button.field_146126_j);
                    nearestX = islandButton.scaledGrid.findNearestGridX(mouseX);
                    nearestY = islandButton.scaledGrid.findNearestGridY(mouseY);
                    int drawX = (int)islandButton.scaledGrid.getActualX(nearestX);
                    int drawY = (int)islandButton.scaledGrid.getActualY(nearestY);
                    this.drawDebugStrings(debugStrings, drawX, drawY, nearestX, nearestY, islandButton.getZLevel());
                    tooltipDrawn = true;
                    break;
                }
            }
            if (!tooltipDrawn) {
                nearestX = this.scaledGrid.findNearestGridX(mouseX);
                nearestY = this.scaledGrid.findNearestGridY(mouseY);
                int drawX = (int)this.scaledGrid.getActualX(nearestX);
                int drawY = (int)this.scaledGrid.getActualY(nearestY);
                this.drawDebugStrings(debugStrings, drawX, drawY, nearestX, nearestY, -1);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void onWarpFail(String failMessageKey) {
        long currentTime = Minecraft.func_71386_F();
        this.warpFailCoolDownExpiryTime = currentTime + 500L;
        this.warpFailTooltipExpiryTime = currentTime + 2000L;
        this.warpFailMessage = EnumChatFormatting.RED + I18n.func_135052_a((String)failMessageKey, (Object[])new Object[0]);
    }

    protected void func_146284_a(GuiButton button) {
        if (Minecraft.func_71386_F() > this.warpFailCoolDownExpiryTime) {
            if (button instanceof GuiButtonWarp) {
                GuiButtonWarp warpButton = (GuiButtonWarp)button;
                if (warpButton.getIsland().getWarpCount() > 1) {
                    String warpCommand = warpButton.getWarpCommand();
                    this.sendCommand(warpCommand);
                }
            } else if (button instanceof GuiButtonIsland) {
                Island island = ((GuiButtonIsland)button).island;
                if (island.getWarpCount() == 1) {
                    String warpCommand = island.getWarps().get(0).getWarpCommand();
                    this.sendCommand(warpCommand);
                }
            } else if (button instanceof GuiButtonConfig) {
                this.field_146297_k.func_147108_a((GuiScreen)new FancyWarpMenuConfigScreen(this));
            } else if (button instanceof GuiButtonRegularWarpMenu) {
                this.sendCommand("/warp");
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        FancyWarpMenu mod = FancyWarpMenu.getInstance();
        if (Settings.isDebugModeEnabled()) {
            if (keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                this.field_146297_k.func_147108_a(null);
            } else if (keyCode == 19) {
                if (GuiFancyWarp.func_146272_n()) {
                    mod.reloadResources();
                } else {
                    mod.reloadLayout();
                }
                this.field_146292_n.clear();
                this.func_73866_w_();
            } else if (keyCode == 15) {
                Settings.setShowDebugOverlay(!Settings.shouldShowDebugOverlay());
            } else if (keyCode == 48) {
                Settings.setDrawBorders(!Settings.shouldDrawBorders());
            }
        }
    }

    ScaledGrid getScaledGrid() {
        return this.scaledGrid;
    }

    private void drawDebugStrings(ArrayList<String> debugStrings, int drawX, int drawY, int nearestGridX, int nearestGridY, int zLevel) {
        debugStrings.add("gridX: " + nearestGridX);
        debugStrings.add("gridY: " + nearestGridY);
        if (zLevel > -1) {
            debugStrings.add("zLevel: " + zLevel);
        }
        this.func_146283_a(debugStrings, drawX, drawY);
        GuiFancyWarp.func_73734_a((int)(drawX - 2), (int)(drawY - 2), (int)(drawX + 2), (int)(drawY + 2), (int)Color.RED.getRGB());
    }

    private void sendCommand(String command) {
        try {
            this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)new C01PacketChatMessage(command));
            if (Settings.shouldAddWarpCommandToChatHistory()) {
                this.field_146297_k.field_71456_v.func_146158_b().func_146239_a(command);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Failed to send command \"%s\": %s", command, e.getMessage()), (Throwable)e);
        }
    }
}

