/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.gui;

import ca.tirelesstraveler.fancywarpmenu.data.Settings;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonExt;
import ca.tirelesstraveler.fancywarpmenu.gui.grid.GridRectangle;
import ca.tirelesstraveler.fancywarpmenu.gui.transitions.ScaleTransition;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class GuiButtonScaleTransition
extends GuiButtonExt {
    private static final float HOVERED_BRIGHTNESS = 1.0f;
    private static final float UN_HOVERED_BRIGHTNESS = 0.9f;
    protected GridRectangle buttonRectangle;
    protected ScaleTransition transition;
    protected float scaledXPosition;
    protected float scaledYPosition;
    protected float scaledWidth;
    protected float scaledHeight;

    public GuiButtonScaleTransition(int buttonId, String buttonText) {
        super(buttonId, buttonText);
    }

    public void calculateHoverState(int mouseX, int mouseY) {
        this.field_146123_n = (float)mouseX >= this.scaledXPosition && (float)mouseY >= this.scaledYPosition && (float)mouseX <= this.scaledXPosition + this.scaledWidth && (float)mouseY <= this.scaledYPosition + this.scaledHeight;
    }

    public void drawBorder(Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.field_73735_i);
        this.func_73730_a((int)this.scaledXPosition, (int)(this.scaledXPosition + this.scaledWidth), (int)this.scaledYPosition, color.getRGB());
        this.func_73728_b((int)this.scaledXPosition, (int)this.scaledYPosition, (int)(this.scaledYPosition + this.scaledHeight), color.getRGB());
        this.func_73730_a((int)this.scaledXPosition, (int)(this.scaledXPosition + this.scaledWidth), (int)(this.scaledYPosition + this.scaledHeight), color.getRGB());
        this.func_73728_b((int)(this.scaledXPosition + this.scaledWidth), (int)this.scaledYPosition, (int)(this.scaledYPosition + this.scaledHeight), color.getRGB());
        GlStateManager.func_179121_F();
    }

    @Override
    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            this.buttonRectangle.scale(this.transition.getCurrentScale());
            this.scaledXPosition = this.buttonRectangle.getXPosition();
            this.scaledYPosition = this.buttonRectangle.getYPosition();
            this.scaledWidth = this.buttonRectangle.getWidth();
            this.scaledHeight = this.buttonRectangle.getHeight();
            this.drawButtonTexture(this.backgroundTextureLocation);
            if (Settings.isDebugModeEnabled() && Settings.shouldDrawBorders()) {
                this.drawBorder(Color.WHITE);
            }
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return this.field_146124_l && this.field_146125_m && (float)mouseX >= this.scaledXPosition && (float)mouseY >= this.scaledYPosition && (float)mouseX <= this.scaledXPosition + this.scaledWidth && (float)mouseY <= this.scaledYPosition + this.scaledHeight;
    }

    public void drawButtonForegroundLayer(ResourceLocation foregroundTextureLocation) {
        if (foregroundTextureLocation != null) {
            this.drawButtonTexture(foregroundTextureLocation);
        }
    }

    protected void drawButtonTexture(ResourceLocation textureLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        if (this.field_146123_n) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179124_c((float)0.9f, (float)0.9f, (float)0.9f);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)this.scaledXPosition, (double)(this.scaledYPosition + this.scaledHeight), (double)this.field_73735_i).func_181673_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(this.scaledXPosition + this.scaledWidth), (double)(this.scaledYPosition + this.scaledHeight), (double)this.field_73735_i).func_181673_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(this.scaledXPosition + this.scaledWidth), (double)this.scaledYPosition, (double)this.field_73735_i).func_181673_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)this.scaledXPosition, (double)this.scaledYPosition, (double)this.field_73735_i).func_181673_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawDisplayString(Minecraft mc, float xOffset, float yOffset) {
        String[] lines = this.field_146126_j.split("\n");
        if (this.field_146123_n) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179124_c((float)0.9f, (float)0.9f, (float)0.9f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.scaledXPosition + xOffset), (float)(this.scaledYPosition + yOffset), (float)(this.field_73735_i + 1.0f));
        GlStateManager.func_179152_a((float)this.transition.getCurrentScale(), (float)this.transition.getCurrentScale(), (float)1.0f);
        for (int i = 0; i < lines.length; ++i) {
            this.func_73732_a(mc.field_71466_p, lines[i], 0, mc.field_71466_p.field_78288_b * i, Color.WHITE.getRGB());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void transitionStep(long scaleTransitionDuration, float hoveredScale) {
        this.transition.step();
        if (this.field_146123_n) {
            if (this.transition.getEndScale() == 1.0f) {
                this.transition = new ScaleTransition((long)(this.transition.getProgress() * (float)scaleTransitionDuration), this.transition.getCurrentScale(), hoveredScale);
            }
        } else if (this.transition.getEndScale() == hoveredScale) {
            this.transition = new ScaleTransition((long)(this.transition.getProgress() * (float)scaleTransitionDuration), this.transition.getCurrentScale(), 1.0f);
        }
    }
}

