/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.gui;

import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.data.Settings;
import ca.tirelesstraveler.fancywarpmenu.data.layout.ConfigButton;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiButtonScaleTransition;
import ca.tirelesstraveler.fancywarpmenu.gui.GuiFancyWarp;
import ca.tirelesstraveler.fancywarpmenu.gui.grid.GridRectangle;
import ca.tirelesstraveler.fancywarpmenu.gui.grid.ScaledGrid;
import ca.tirelesstraveler.fancywarpmenu.gui.transitions.ScaleTransition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.ForgeVersion;

public class GuiButtonConfig
extends GuiButtonScaleTransition {
    private static final float HOVERED_SCALE = 1.2f;
    private static final long SCALE_TRANSITION_DURATION = 500L;
    private final ScaledGrid scaledGrid;
    private final int GRID_X;
    private final int GRID_Y;

    public GuiButtonConfig(int buttonId, ScaledResolution res) {
        super(buttonId, EnumChatFormatting.GREEN + I18n.func_135052_a((String)FancyWarpMenu.getFullLanguageKey("gui.buttons.config"), (Object[])new Object[0]));
        this.scaledGrid = new ScaledGrid(0.0f, 0.0f, (float)res.func_78326_a(), (float)res.func_78328_b(), 36, 64, false);
        ConfigButton configButtonSettings = FancyWarpMenu.getLayout().getConfigButton();
        configButtonSettings.init(res);
        this.GRID_X = configButtonSettings.getGridX();
        this.GRID_Y = configButtonSettings.getGridY();
        this.field_146120_f = configButtonSettings.getWidth();
        this.field_146121_g = configButtonSettings.getHeight();
        this.field_73735_i = 20.0f;
        this.buttonRectangle = new GridRectangle(this.scaledGrid, this.GRID_X, this.GRID_Y, this.field_146120_f, this.field_146121_g, false, true);
        this.scaledGrid.addRectangle("configButton", this.buttonRectangle);
        this.backgroundTextureLocation = configButtonSettings.getTextureLocation();
        this.transition = new ScaleTransition(0L, 1.0f, 1.0f);
    }

    @Override
    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            this.calculateHoverState(mouseX, mouseY);
            this.transitionStep(500L, 1.2f);
            super.func_146112_a(mc, mouseX, mouseY);
            if (Settings.isUpdateNotificationEnabled() && FancyWarpMenu.getUpdateCheckResult() != null && FancyWarpMenu.getUpdateCheckResult().status == ForgeVersion.Status.OUTDATED) {
                this.drawButtonForegroundLayer(ConfigButton.NOTIFICATION_TEXTURE_LOCATION);
            }
        }
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean clicked = super.func_146116_c(mc, mouseX, mouseY);
        if (clicked && !(mc.field_71462_r instanceof GuiFancyWarp)) {
            if (!Settings.isWarpMenuEnabled()) {
                Settings.setWarpMenuEnabled(true);
                mc.field_71439_g.func_145747_a(new ChatComponentTranslation("fancywarpmenu.messages.fancyWarpMenuEnabled", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
            }
            FancyWarpMenu.getInstance().getWarpMenuListener().displayFancyWarpMenu();
        }
        return clicked;
    }
}

