/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.data.skyblockconstants;

import ca.tirelesstraveler.fancywarpmenu.data.DataCommon;
import ca.tirelesstraveler.fancywarpmenu.data.skyblockconstants.WarpCommandVariant;
import ca.tirelesstraveler.fancywarpmenu.data.skyblockconstants.WarpMessages;
import java.util.List;

public class SkyBlockConstants {
    private WarpMessages warpMessages;
    private List<WarpCommandVariant> warpCommandVariants;

    private SkyBlockConstants() {
    }

    public WarpMessages getWarpMessages() {
        return this.warpMessages;
    }

    public List<WarpCommandVariant> getWarpCommandVariants() {
        return this.warpCommandVariants;
    }

    public String toString() {
        return DataCommon.gson.toJson((Object)this);
    }

    public static void validateSkyBlockConstants(SkyBlockConstants skyBlockConstants) {
        if (skyBlockConstants == null) {
            throw new NullPointerException("SkyBlock constants cannot be null");
        }
        WarpMessages.validateWarpMessages(skyBlockConstants.getWarpMessages());
        if (skyBlockConstants.warpCommandVariants == null || skyBlockConstants.warpCommandVariants.isEmpty()) {
            throw new NullPointerException("Warp command variant list cannot be empty");
        }
        for (WarpCommandVariant warpCommandVariant : skyBlockConstants.warpCommandVariants) {
            WarpCommandVariant.validateWarpCommandVariant(warpCommandVariant);
        }
    }
}

