/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.data.layout;

import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.data.DataCommon;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class WarpIcon {
    private String texturePath;
    private String hoverEffectTexturePath;
    private float widthPercentage;
    private transient ResourceLocation textureLocation;
    private transient ResourceLocation hoverEffectTextureLocation;
    private transient int textureWidth;
    private transient int textureHeight;
    private transient int heightPercentage;

    private WarpIcon() {
    }

    public void init() {
        this.textureLocation = new ResourceLocation(FancyWarpMenu.getInstance().getModId(), this.texturePath);
        if (this.hoverEffectTexturePath != null) {
            this.hoverEffectTextureLocation = new ResourceLocation(FancyWarpMenu.getInstance().getModId(), this.hoverEffectTexturePath);
        }
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public ResourceLocation getHoverEffectTextureLocation() {
        return this.hoverEffectTextureLocation;
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public float getHeightPercentage() {
        return this.heightPercentage;
    }

    public void setTextureDimensions(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.heightPercentage = textureHeight / textureWidth;
    }

    public String toString() {
        return DataCommon.gson.toJson((Object)this);
    }

    public static void validateWarpIcon(WarpIcon warpIcon) throws IllegalArgumentException, NullPointerException {
        if (warpIcon == null) {
            throw new NullPointerException("Warp icon cannot be null");
        }
        if (warpIcon.texturePath == null) {
            throw new NullPointerException("Warp icon texture path cannot be null");
        }
        ResourceLocation textureLocation = new ResourceLocation(FancyWarpMenu.getInstance().getModId(), warpIcon.texturePath);
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(textureLocation);
            IOUtils.closeQuietly((InputStream)resource.func_110527_b());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Warp icon texture not found at %s", textureLocation));
        }
        if (warpIcon.widthPercentage < 0.0f || warpIcon.widthPercentage > 1.0f) {
            throw new IllegalArgumentException("Warp icon widthPercentage must be between 0 and 1");
        }
    }
}

