/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.data.layout;

import ca.tirelesstraveler.fancywarpmenu.data.DataCommon;
import ca.tirelesstraveler.fancywarpmenu.data.layout.WarpIcon;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;

public class Warp {
    public static int GRID_UNIT_WIDTH_FACTOR = 40;
    public static WarpIcon warpIcon;
    private static int width;
    private static int height;
    private int gridX;
    private int gridY;
    private String displayName;
    private String commandName;
    private boolean hideDisplayName;
    private boolean requiresSpecialGameMode;
    private boolean hideButton;

    private Warp() {
    }

    public String getDisplayName() {
        return this.hideDisplayName ? "" : this.displayName;
    }

    public ResourceLocation getWarpTextureLocation() {
        return warpIcon.getTextureLocation();
    }

    public ResourceLocation getWarpHoverEffectTextureLocation() {
        return warpIcon.getHoverEffectTextureLocation();
    }

    public String getWarpCommand() {
        return this.commandName.equals("/savethejerrys") ? this.commandName : "/warp " + this.commandName;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public boolean requiresSpecialGameMode() {
        return this.requiresSpecialGameMode;
    }

    public boolean shouldHideButton() {
        return this.hideButton;
    }

    public String toString() {
        return DataCommon.gson.toJson((Object)this);
    }

    public static void initDefaults(ScaledResolution res) {
        width = (int)((float)res.func_78326_a() * warpIcon.getWidthPercentage());
        float scaleFactor = (float)width / (float)warpIcon.getTextureWidth();
        height = (int)((float)warpIcon.getTextureHeight() * scaleFactor);
    }

    public void setHideDisplayName(boolean hideDisplayName) {
        this.hideDisplayName = hideDisplayName;
    }

    public static void setWarpIcon(WarpIcon warpIcon) {
        Warp.warpIcon = warpIcon;
    }

    public static void validateWarp(Warp warp) throws IllegalArgumentException, NullPointerException {
        if (warp == null) {
            throw new NullPointerException("Warp cannot be null");
        }
        String name = warp.displayName;
        if (name == null) {
            throw new IllegalArgumentException(String.format("The following warp lacks a name: %s", warp));
        }
        if (warp.commandName == null || warp.commandName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Warp %s is missing a command name", warp.displayName));
        }
        if (warp.gridX < 0 || warp.gridX > GRID_UNIT_WIDTH_FACTOR) {
            throw new IllegalArgumentException(String.format("Warp %s gridX is outside island", name));
        }
        if (warp.gridY < 0 || warp.gridY > GRID_UNIT_WIDTH_FACTOR) {
            throw new IllegalArgumentException(String.format("Warp %s gridY is outside island", name));
        }
    }
}

