/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.data.layout;

import ca.tirelesstraveler.fancywarpmenu.data.DataCommon;
import ca.tirelesstraveler.fancywarpmenu.data.layout.ConfigButton;
import ca.tirelesstraveler.fancywarpmenu.data.layout.Island;
import ca.tirelesstraveler.fancywarpmenu.data.layout.RegularWarpMenuButton;
import ca.tirelesstraveler.fancywarpmenu.data.layout.WarpIcon;
import java.util.List;

public class Layout {
    private List<Island> islandList;
    private WarpIcon warpIcon;
    private ConfigButton configButton;
    private RegularWarpMenuButton regularWarpMenuButton;

    private Layout() {
    }

    public List<Island> getIslandList() {
        return this.islandList;
    }

    public WarpIcon getWarpIcon() {
        return this.warpIcon;
    }

    public ConfigButton getConfigButton() {
        return this.configButton;
    }

    public RegularWarpMenuButton getRegularWarpMenuButton() {
        return this.regularWarpMenuButton;
    }

    public static void validateLayout(Layout layout) throws IllegalArgumentException, NullPointerException {
        if (layout == null) {
            throw new NullPointerException("Warp configuration cannot be null");
        }
        if (layout.islandList == null || layout.islandList.isEmpty()) {
            throw new IllegalArgumentException("Island list cannot be empty");
        }
        for (Island island : layout.getIslandList()) {
            Island.validateIsland(island);
        }
        WarpIcon.validateWarpIcon(layout.getWarpIcon());
        ConfigButton.validateConfigButtonIcon(layout.getConfigButton());
        RegularWarpMenuButton.validateRegularMenuButtonIcon(layout.getRegularWarpMenuButton());
    }

    public String toString() {
        return DataCommon.gson.toJson((Object)this);
    }
}

