/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.data.layout;

import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.data.DataCommon;
import ca.tirelesstraveler.fancywarpmenu.data.layout.Warp;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class Island {
    public static final int GRID_UNIT_WIDTH_FACTOR = 64;
    public static final int GRID_UNIT_HEIGHT_FACTOR = 36;
    private String name;
    private String texturePath;
    private String hoverEffectTexturePath;
    private int gridX;
    private int gridY;
    private int zLevel;
    private float widthPercentage;
    private List<Warp> warpList;
    private transient ResourceLocation textureLocation;
    private transient ResourceLocation hoverEffectTextureLocation;
    private transient int textureWidth;
    private transient int textureHeight;
    private transient int width;
    private transient int height;

    private Island() {
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public ResourceLocation getHoverEffectTextureLocation() {
        return this.hoverEffectTextureLocation;
    }

    public String getHoverEffectTexturePath() {
        return this.hoverEffectTexturePath;
    }

    public List<Warp> getWarps() {
        return this.warpList;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public int getzLevel() {
        return this.zLevel;
    }

    public int getWarpCount() {
        return this.warpList.size();
    }

    public void init(ScaledResolution res) {
        this.width = (int)((float)res.func_78326_a() * this.widthPercentage);
        float scaleFactor = (float)this.width / (float)this.textureWidth;
        this.height = (int)((float)this.textureHeight * scaleFactor);
    }

    public void setTextureDimensions(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public void setTextureLocation() {
        this.textureLocation = new ResourceLocation(FancyWarpMenu.getInstance().getModId(), this.texturePath);
    }

    public void setHoverEffectTextureLocation() {
        this.hoverEffectTextureLocation = new ResourceLocation(FancyWarpMenu.getInstance().getModId(), this.hoverEffectTexturePath);
    }

    public String toString() {
        return DataCommon.gson.toJson((Object)this);
    }

    public static void validateIsland(Island island) throws IllegalArgumentException, NullPointerException {
        IResource resource;
        if (island == null) {
            throw new NullPointerException("Island cannot be null");
        }
        String name = island.name;
        if (name == null) {
            throw new IllegalArgumentException(String.format("The following island lacks a name: %s", island));
        }
        if (island.texturePath == null) {
            throw new NullPointerException("Island texture path cannot be null");
        }
        ResourceLocation textureLocation = new ResourceLocation(FancyWarpMenu.getInstance().getModId(), island.texturePath);
        try {
            resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(textureLocation);
            IOUtils.closeQuietly((InputStream)resource.func_110527_b());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Island %s texture not found at %s", name, textureLocation));
        }
        if (island.hoverEffectTextureLocation != null) {
            textureLocation = new ResourceLocation(FancyWarpMenu.getInstance().getModId(), island.hoverEffectTexturePath);
            try {
                resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(textureLocation);
                IOUtils.closeQuietly((InputStream)resource.func_110527_b());
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Island %s hover effect texture not found at %s", name, textureLocation));
            }
        }
        if (island.gridX < 0 || island.gridX > 64) {
            throw new IllegalArgumentException(String.format("Island %s gridX is outside screen", name));
        }
        if (island.gridY < 0 || island.gridY > 36) {
            throw new IllegalArgumentException(String.format("Island %s gridY is outside screen", name));
        }
        if (island.zLevel < 0) {
            throw new IllegalArgumentException(String.format("Island %s zLevel is outside screen", name));
        }
        if (island.zLevel >= 10) {
            throw new IllegalArgumentException(String.format("Island %s zLevel is too high. Z levels 10+ are reserved for warp buttons.", name));
        }
        if (island.widthPercentage < 0.0f || island.widthPercentage > 1.0f) {
            throw new IllegalArgumentException(String.format("Island %s widthPercentage must be between 0 and 1", name));
        }
        if (island.warpList == null || island.warpList.isEmpty()) {
            throw new IllegalArgumentException(String.format("Island %s has no warps", name));
        }
        for (Warp warp : island.warpList) {
            Warp.validateWarp(warp);
        }
    }
}

