/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.data.layout;

import ca.tirelesstraveler.fancywarpmenu.data.DataCommon;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;

public abstract class Button {
    private int gridX;
    private int gridY;
    private float widthPercentage;
    private transient int textureWidth;
    private transient int textureHeight;
    private transient int width;
    private transient int height;

    Button() {
    }

    public abstract ResourceLocation getTextureLocation();

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void init(ScaledResolution res) {
        this.width = (int)((float)res.func_78326_a() * this.widthPercentage);
        float scaleFactor = (float)this.width / (float)this.textureWidth;
        this.height = (int)((float)this.textureHeight * scaleFactor);
    }

    public void setTextureDimensions(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public String toString() {
        return DataCommon.gson.toJson((Object)this);
    }

    public static void validateButtonIcon(Button button) throws IllegalArgumentException, NullPointerException {
        if (button.gridX < 0 || button.gridX > 64) {
            throw new IllegalArgumentException("Button gridX must be between 0 and 64 inclusive");
        }
        if (button.gridY < 0 || button.gridY > 36) {
            throw new IllegalArgumentException("Button gridX must be between 0 and 36 inclusive");
        }
        if (button.widthPercentage < 0.0f || button.widthPercentage > 1.0f) {
            throw new IllegalArgumentException("Button icon widthPercentage must be between 0 and 1");
        }
    }
}

