/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu.data;

import ca.tirelesstraveler.fancywarpmenu.EnvironmentDetails;
import ca.tirelesstraveler.fancywarpmenu.FancyWarpMenu;
import ca.tirelesstraveler.fancywarpmenu.gui.FancyWarpMenuConfigScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.IConfigElement;

public class Settings {
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_DEBUG = "debug";
    private static Configuration config;
    private static boolean warpMenuEnabled;
    private static boolean showIslandLabels;
    private static boolean hideWarpLabelsUntilIslandHovered;
    private static boolean hideWarpLabelForIslandsWithOneWarp;
    private static boolean suggestWarpMenuOnWarpCommand;
    private static boolean addWarpCommandToChatHistory;
    private static boolean showJerryIsland;
    private static boolean hideUnobtainableWarps;
    private static boolean enableUpdateNotification;
    private static boolean showRegularWarpMenuButton;
    private static boolean debugModeEnabled;
    private static boolean showDebugOverlay;
    private static boolean drawBorders;
    private static boolean skipSkyBlockCheck;
    private static boolean alwaysShowJerryIsland;

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> topLevelElements = new ArrayList<IConfigElement>();
        List generalElements = new ConfigElement(config.getCategory(CATEGORY_GENERAL)).getChildElements();
        List debugElements = new ConfigElement(config.getCategory(CATEGORY_DEBUG)).getChildElements();
        DummyConfigElement supportLinkElement = new DummyConfigElement("supportLink", (Object)EnvironmentDetails.SUPPORT_LINK, ConfigGuiType.CONFIG_CATEGORY, "fancywarpmenu.config.categories.support");
        supportLinkElement.setConfigEntryClass(FancyWarpMenuConfigScreen.OpenLinkEntry.class);
        topLevelElements.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(CATEGORY_GENERAL, "fancywarpmenu.config.categories.general", generalElements));
        topLevelElements.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(CATEGORY_DEBUG, "fancywarpmenu.config.categories.developerSettings", debugElements));
        topLevelElements.add((IConfigElement)supportLinkElement);
        ForgeVersion.CheckResult updateCheckResult = FancyWarpMenu.getUpdateCheckResult();
        if (Settings.isUpdateNotificationEnabled() && updateCheckResult != null && (updateCheckResult.status == ForgeVersion.Status.OUTDATED || updateCheckResult.status == ForgeVersion.Status.BETA_OUTDATED)) {
            DummyConfigElement updateAvailableCategory = new DummyConfigElement("updateAvailable", null, ConfigGuiType.CONFIG_CATEGORY, "fancywarpmenu.config.categories.updateAvailable");
            Object[] options = new Object[]{updateCheckResult.url, EnumChatFormatting.GREEN};
            updateAvailableCategory.set(options);
            updateAvailableCategory.setConfigEntryClass(FancyWarpMenuConfigScreen.ColoredOpenLinkEntry.class);
            topLevelElements.add((IConfigElement)updateAvailableCategory);
        }
        return topLevelElements;
    }

    public static void setConfig(Configuration config) {
        Settings.config = config;
    }

    public static void setConfigPropertyOrder() {
        ArrayList generalPropertyOrder = new ArrayList();
        Collections.addAll(generalPropertyOrder, "warpMenuEnabled", "showIslandLabels", "hideWarpLabelsUntilIslandHovered", "hideWarpLabelForIslandsWithOneWarp", "suggestWarpMenuOnWarpCommand", "addWarpCommandToChatHistory", "showJerryIsland", "hideUnobtainableWarps", "enableUpdateNotification", "showRegularWarpMenuButton");
        ArrayList debugPropertyOrder = new ArrayList();
        Collections.addAll(debugPropertyOrder, "debugModeEnabled", "showDebugOverlay", "drawBorders", "skipSkyBlockCheck", "alwaysShowJerryIsland");
        config.setCategoryPropertyOrder(CATEGORY_GENERAL, generalPropertyOrder);
        config.setCategoryPropertyOrder(CATEGORY_DEBUG, debugPropertyOrder);
    }

    public static void syncConfig(boolean load) {
        if (load) {
            config.load();
        }
        Property prop = config.get(CATEGORY_GENERAL, "warpMenuEnabled", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.warpMenuEnabled"));
        warpMenuEnabled = prop.getBoolean(true);
        prop = config.get(CATEGORY_GENERAL, "showIslandLabels", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.showIslandLabels"));
        showIslandLabels = prop.getBoolean(true);
        prop = config.get(CATEGORY_GENERAL, "hideWarpLabelsUntilIslandHovered", false);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.hideWarpLabelsUntilIslandHovered"));
        hideWarpLabelsUntilIslandHovered = prop.getBoolean(false);
        prop = config.get(CATEGORY_GENERAL, "hideWarpLabelForIslandsWithOneWarp", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.hideWarpLabelForIslandsWithOneWarp"));
        hideWarpLabelForIslandsWithOneWarp = prop.getBoolean(true);
        prop = config.get(CATEGORY_GENERAL, "suggestWarpMenuOnWarpCommand", false);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.suggestWarpMenuOnWarpCommand"));
        suggestWarpMenuOnWarpCommand = prop.getBoolean(false);
        prop = config.get(CATEGORY_GENERAL, "addWarpCommandToChatHistory", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.addWarpCommandToChatHistory"));
        addWarpCommandToChatHistory = prop.getBoolean(true);
        prop = config.get(CATEGORY_GENERAL, "showJerryIsland", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.showJerryIsland"));
        showJerryIsland = prop.getBoolean(true);
        prop = config.get(CATEGORY_GENERAL, "hideUnobtainableWarps", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.hideUnobtainableWarps"));
        hideUnobtainableWarps = prop.getBoolean(true);
        prop = config.get(CATEGORY_GENERAL, "enableUpdateNotification", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.enableUpdateNotification"));
        enableUpdateNotification = prop.getBoolean(true);
        prop = config.get(CATEGORY_GENERAL, "showRegularWarpMenuButton", false);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.showRegularWarpMenuButton"));
        showRegularWarpMenuButton = prop.getBoolean(true);
        config.setCategoryRequiresWorldRestart(CATEGORY_GENERAL, false);
        prop = config.get(CATEGORY_DEBUG, "debugModeEnabled", false);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.developerModeEnabled"));
        debugModeEnabled = prop.getBoolean(false);
        if (!debugModeEnabled && EnvironmentDetails.isDeobfuscatedEnvironment()) {
            prop.set(true);
        }
        prop = config.get(CATEGORY_DEBUG, "showDebugOverlay", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.showDebugOverlay"));
        showDebugOverlay = prop.getBoolean(true);
        prop = config.get(CATEGORY_DEBUG, "drawBorders", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.drawBorders"));
        drawBorders = prop.getBoolean(true);
        prop = config.get(CATEGORY_DEBUG, "skipSkyBlockCheck", false);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.skipSkyBlockCheck"));
        skipSkyBlockCheck = prop.getBoolean(false);
        prop = config.get(CATEGORY_DEBUG, "alwaysShowJerryIsland", true);
        prop.setLanguageKey(FancyWarpMenu.getFullLanguageKey("config.alwaysShowJerryIsland"));
        alwaysShowJerryIsland = prop.getBoolean(true);
        config.setCategoryRequiresWorldRestart(CATEGORY_DEBUG, false);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean isWarpMenuEnabled() {
        return warpMenuEnabled;
    }

    public static boolean shouldShowIslandLabels() {
        return showIslandLabels;
    }

    public static boolean shouldHideWarpLabelsUntilIslandHovered() {
        return hideWarpLabelsUntilIslandHovered;
    }

    public static boolean shouldHideWarpLabelForIslandsWithOneWarp() {
        return hideWarpLabelForIslandsWithOneWarp;
    }

    public static boolean shouldSuggestWarpMenuOnWarpCommand() {
        return suggestWarpMenuOnWarpCommand;
    }

    public static boolean shouldAddWarpCommandToChatHistory() {
        return addWarpCommandToChatHistory;
    }

    public static boolean shouldShowJerryIsland() {
        return showJerryIsland;
    }

    public static boolean shouldHideUnobtainableWarps() {
        return hideUnobtainableWarps;
    }

    public static boolean isUpdateNotificationEnabled() {
        return enableUpdateNotification;
    }

    public static boolean shouldShowRegularWarpMenuButton() {
        return showRegularWarpMenuButton;
    }

    public static boolean isDebugModeEnabled() {
        return debugModeEnabled;
    }

    public static boolean shouldShowDebugOverlay() {
        return showDebugOverlay;
    }

    public static boolean shouldDrawBorders() {
        return drawBorders;
    }

    public static boolean shouldSkipSkyBlockCheck() {
        return skipSkyBlockCheck;
    }

    public static boolean shouldAlwaysShowJerryIsland() {
        return alwaysShowJerryIsland;
    }

    public static void setShowDebugOverlay(boolean showDebugOverlay) {
        config.get(CATEGORY_DEBUG, "showDebugOverlay", true).set(showDebugOverlay);
        Settings.syncConfig(false);
    }

    public static void setDrawBorders(boolean drawBorders) {
        config.get(CATEGORY_DEBUG, "drawBorders", true).set(drawBorders);
        Settings.syncConfig(false);
    }

    public static void setWarpMenuEnabled(boolean warpMenuEnabled) {
        config.get(CATEGORY_GENERAL, "warpMenuEnabled", true).set(warpMenuEnabled);
        Settings.syncConfig(false);
    }
}

