/*
 * Decompiled with CFR 0.152.
 */
package ca.tirelesstraveler.fancywarpmenu;

import ca.tirelesstraveler.fancywarpmenu.EnvironmentDetails;
import ca.tirelesstraveler.fancywarpmenu.OpenConfigCommand;
import ca.tirelesstraveler.fancywarpmenu.data.Settings;
import ca.tirelesstraveler.fancywarpmenu.data.layout.Island;
import ca.tirelesstraveler.fancywarpmenu.data.layout.Layout;
import ca.tirelesstraveler.fancywarpmenu.data.skyblockconstants.SkyBlockConstants;
import ca.tirelesstraveler.fancywarpmenu.listeners.SkyBlockJoinListener;
import ca.tirelesstraveler.fancywarpmenu.listeners.WarpMenuListener;
import ca.tirelesstraveler.fancywarpmenu.resourceloaders.LayoutLoader;
import ca.tirelesstraveler.fancywarpmenu.resourceloaders.SkyBlockConstantsLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="fancywarpmenu", clientSideOnly=true, useMetadata=true, guiFactory="ca.tirelesstraveler.fancywarpmenu.gui.FancyWarpMenuGuiFactory", updateJSON="https://cdn.jsdelivr.net/gh/ILikePlayingGames/FancyWarpMenu@main/version/update.json")
public class FancyWarpMenu {
    @Mod.Instance(value="fancywarpmenu")
    private static FancyWarpMenu instance;
    private static ModContainer modContainer;
    private static String modId;
    static Logger logger;
    private static ForgeVersion.CheckResult updateCheckResult;
    private static Layout layout;
    private static SkyBlockConstants skyBlockConstants;
    private static SkyBlockJoinListener skyblockJoinListener;
    private static WarpMenuListener warpMenuListener;
    private static KeyBinding keyBindingOpenWarpMenu;

    public static FancyWarpMenu getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Pre-init", (int)4);
        EnvironmentDetails.deobfuscatedEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        modId = event.getModMetadata().modId;
        modContainer = Loader.instance().activeModContainer();
        bar.step("Initializing Listeners");
        warpMenuListener = new WarpMenuListener();
        MinecraftForge.EVENT_BUS.register((Object)warpMenuListener);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)warpMenuListener);
        skyblockJoinListener = new SkyBlockJoinListener();
        MinecraftForge.EVENT_BUS.register((Object)skyblockJoinListener);
        bar.step("Loading Settings");
        Settings.setConfig(new Configuration(event.getSuggestedConfigurationFile(), modContainer.getVersion()));
        Settings.setConfigPropertyOrder();
        Settings.syncConfig(true);
        logger = event.getModLog();
        event.getModMetadata().version = modContainer.getVersion();
        bar.step("Loading SkyBlock Constants");
        skyBlockConstants = SkyBlockConstantsLoader.loadSkyBlockConstants();
        bar.step("Loading Layout");
        layout = LayoutLoader.loadLayout();
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        updateCheckResult = ForgeVersion.getResult((ModContainer)modContainer);
        keyBindingOpenWarpMenu = new KeyBinding("fancywarpmenu.key.openMenu", 46, "fancywarpmenu.key.categories.fancyWarpMenu");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBindingOpenWarpMenu);
        ClientCommandHandler.instance.func_71560_a((ICommand)new OpenConfigCommand());
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Loading Textures", (int)(layout.getIslandList().size() + 1));
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        for (Island island : layout.getIslandList()) {
            bar.step(island.getName());
            textureManager.func_110577_a(island.getTextureLocation());
        }
        bar.step("Warp Icon");
        textureManager.func_110577_a(layout.getWarpIcon().getTextureLocation());
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"patcher")) {
            EnvironmentDetails.patcherInstalled = true;
        }
    }

    public ModContainer getModContainer() {
        return modContainer;
    }

    public String getModId() {
        return modId;
    }

    public static ForgeVersion.CheckResult getUpdateCheckResult() {
        return updateCheckResult;
    }

    public WarpMenuListener getWarpMenuListener() {
        return warpMenuListener;
    }

    public boolean isPlayerOnSkyBlock() {
        return skyblockJoinListener.isOnSkyBlock();
    }

    public void reloadResources() {
        Minecraft.func_71410_x().func_110436_a();
        this.reloadSkyBlockConstants();
        this.reloadLayout();
    }

    public void reloadSkyBlockConstants() {
        SkyBlockConstants loadedSkyBlockConstants = SkyBlockConstantsLoader.loadSkyBlockConstants();
        if (loadedSkyBlockConstants != null) {
            skyBlockConstants = loadedSkyBlockConstants;
        }
    }

    public void reloadLayout() {
        Layout loadedLayout = LayoutLoader.loadLayout();
        if (loadedLayout != null) {
            layout = loadedLayout;
        }
    }

    public static String getFullLanguageKey(String path) {
        return modId + "." + path;
    }

    public static KeyBinding getKeyBindingOpenWarpMenu() {
        return keyBindingOpenWarpMenu;
    }

    public static Layout getLayout() {
        return layout;
    }

    public static SkyBlockConstants getSkyBlockConstants() {
        return skyBlockConstants;
    }
}

