/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.overflowanimations.mixin;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import org.polyfrost.overflowanimations.config.OldAnimationsSettings;
import org.polyfrost.overflowanimations.hooks.TransformTypeHook;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderItem.class})
public class RenderItemMixin {
    @Unique
    public IBakedModel simplified$model;
    @Unique
    private EntityLivingBase simplified$entityLivingBase = null;

    @Inject(method={"renderModel(Lnet/minecraft/client/resources/model/IBakedModel;ILnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private void setModel(IBakedModel model, int color, ItemStack stack, CallbackInfo ci) {
        this.simplified$model = model;
    }

    @Inject(method={"renderItemModelForEntity"}, at={@At(value="HEAD")})
    public void getLastEntity(ItemStack stack, EntityLivingBase entityToRenderFor, ItemCameraTransforms.TransformType cameraTransformType, CallbackInfo ci) {
        this.simplified$entityLivingBase = entityToRenderFor;
    }

    @ModifyArg(method={"renderModel(Lnet/minecraft/client/resources/model/IBakedModel;ILnet/minecraft/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/RenderItem;renderQuads(Lnet/minecraft/client/renderer/WorldRenderer;Ljava/util/List;ILnet/minecraft/item/ItemStack;)V", ordinal=1), index=1)
    private List<BakedQuad> changeToSprite(List<BakedQuad> quads) {
        if (OldAnimationsSettings.itemSprites && OldAnimationsSettings.INSTANCE.enabled && !this.simplified$model.func_177556_c() && TransformTypeHook.shouldBeSprite()) {
            return quads.stream().filter(baked -> baked.func_178210_d() == EnumFacing.SOUTH).collect(Collectors.toList());
        }
        return quads;
    }

    @Redirect(method={"putQuadNormal"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;putNormal(FFF)V"))
    private void modifyNormalValue(WorldRenderer instance, float x, float y, float z, WorldRenderer renderer, BakedQuad quad) {
        if (OldAnimationsSettings.INSTANCE.enabled && !this.simplified$model.func_177556_c()) {
            if (OldAnimationsSettings.itemSprites && OldAnimationsSettings.itemSpritesColor && TransformTypeHook.shouldNotHaveGlint()) {
                instance.func_178975_e(x, z, y);
            } else if (OldAnimationsSettings.oldItemLighting) {
                instance.func_178975_e(-x, Minecraft.func_71410_x().field_71439_g.func_70632_aY() ? -y : y, z);
            }
        } else {
            instance.func_178975_e(x, y, z);
        }
    }

    @Inject(method={"renderEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void disableGlintOnSprite(IBakedModel model, CallbackInfo ci) {
        if (OldAnimationsSettings.itemSprites && OldAnimationsSettings.spritesGlint && OldAnimationsSettings.INSTANCE.enabled && TransformTypeHook.shouldNotHaveGlint()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/resources/model/IBakedModel;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/RenderItem;renderModel(Lnet/minecraft/client/resources/model/IBakedModel;Lnet/minecraft/item/ItemStack;)V")})
    private void translateSprite(ItemStack stack, IBakedModel model, CallbackInfo ci) {
        if (OldAnimationsSettings.itemSprites && OldAnimationsSettings.INSTANCE.enabled && !model.func_177556_c() && TransformTypeHook.shouldNotHaveGlint()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.0625f);
        }
    }

    @Inject(method={"renderItemModelTransform"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/RenderItem;renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/resources/model/IBakedModel;)V")})
    public void modifyModelPosition(ItemStack stack, IBakedModel model, ItemCameraTransforms.TransformType cameraTransformType, CallbackInfo ci) {
        if (OldAnimationsSettings.INSTANCE.enabled && !(stack.func_77973_b() instanceof ItemBanner)) {
            boolean isRod = stack.func_77973_b().func_77629_n_();
            boolean isBlock = stack.func_77973_b() instanceof ItemBlock;
            boolean isCarpet = false;
            if (isBlock) {
                Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
                boolean bl = isCarpet = block instanceof BlockCarpet || block instanceof BlockSnow;
            }
            if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON) {
                if (OldAnimationsSettings.fishingRodPosition && isRod) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                } else if (OldAnimationsSettings.firstTransformations && OldAnimationsSettings.firstPersonCarpetPosition && isCarpet) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.328125f, (float)0.0f);
                }
            } else if (OldAnimationsSettings.thirdTransformations && cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON && (this.simplified$entityLivingBase instanceof EntityPlayer || !OldAnimationsSettings.entityTransforms)) {
                if (isRod) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)110.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.002f, (float)0.037f, (float)-0.003f);
                } else if (OldAnimationsSettings.thirdPersonCarpetPosition && isCarpet) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                }
                if (isBlock) {
                    if (Block.func_149634_a((Item)stack.func_77973_b()).func_149645_b() != 2) {
                        GlStateManager.func_179109_b((float)-0.0285f, (float)-0.0375f, (float)0.0285f);
                        GlStateManager.func_179114_b((float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)-5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)-1.0f);
                }
            }
        }
    }

    @Inject(method={"renderItemAndEffectIntoGUI"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/RenderItem;renderItemIntoGUI(Lnet/minecraft/item/ItemStack;II)V")})
    public void fixGlint(ItemStack stack, int xPosition, int yPosition, CallbackInfo ci) {
        if (OldAnimationsSettings.INSTANCE.enabled) {
            GlStateManager.func_179126_j();
        }
    }
}

