/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.overflowanimations.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.polyfrost.overflowanimations.config.ItemPositionAdvancedSettings;
import org.polyfrost.overflowanimations.config.OldAnimationsSettings;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin_CustomPositions {
    @Shadow
    private ItemStack field_78453_b;
    @Shadow
    @Final
    private Minecraft field_78455_a;

    @Inject(method={"transformFirstPersonItem(FF)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void itemTransform(float equipProgress, float swingProgress, CallbackInfo ci) {
        OldAnimationsSettings settings = OldAnimationsSettings.INSTANCE;
        if (OldAnimationsSettings.globalPositions && settings.enabled) {
            GlStateManager.func_179109_b((float)(0.56f * (1.0f + settings.itemPositionX)), (float)(-0.52f * (1.0f - settings.itemPositionY)), (float)(-0.72f * (1.0f + settings.itemPositionZ)));
            GlStateManager.func_179109_b((float)0.0f, (float)(equipProgress * -0.6f), (float)0.0f);
            GlStateManager.func_179114_b((float)settings.itemRotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)settings.itemRotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)settings.itemRotationRoll, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float f = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
            GlStateManager.func_179114_b((float)(f * -20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            double scale = (double)0.4f * Math.exp(settings.itemScale);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            ci.cancel();
        }
    }

    @Inject(method={"doItemUsedTransformations"}, at={@At(value="HEAD")}, cancellable=true)
    public void swingTransformations(float swingProgress, CallbackInfo ci) {
        OldAnimationsSettings settings = OldAnimationsSettings.INSTANCE;
        ItemPositionAdvancedSettings advanced = OldAnimationsSettings.advancedSettings;
        if (OldAnimationsSettings.globalPositions && settings.enabled) {
            if (settings.swingSetting == 2) {
                ci.cancel();
            } else {
                float scale = 1.0f + (settings.swingSetting == 1 ? settings.itemScale : 0.0f);
                float f = -0.4f * (1.0f + advanced.itemSwingPositionX) * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI)) * scale;
                float f1 = 0.2f * (1.0f - advanced.itemSwingPositionY) * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI * 2.0f)) * scale;
                float f2 = -0.2f * (1.0f + advanced.itemSwingPositionZ) * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI)) * scale;
                GlStateManager.func_179109_b((float)f, (float)f1, (float)f2);
                ci.cancel();
            }
        }
    }

    @Inject(method={"doBlockTransformations"}, at={@At(value="HEAD")}, cancellable=true)
    public void blockedItemTransform(CallbackInfo ci) {
        OldAnimationsSettings settings = OldAnimationsSettings.INSTANCE;
        ItemPositionAdvancedSettings advanced = OldAnimationsSettings.advancedSettings;
        if (OldAnimationsSettings.globalPositions && settings.enabled) {
            GlStateManager.func_179109_b((float)(-0.5f * (1.0f + advanced.blockedPositionX)), (float)(0.2f * (1.0f + advanced.blockedPositionY)), (float)(0.0f + advanced.blockedPositionZ));
            GlStateManager.func_179114_b((float)advanced.blockedRotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)advanced.blockedRotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)advanced.blockedRotationRoll, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-80.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (OldAnimationsSettings.lunarBlockhit) {
                GlStateManager.func_179109_b((float)-0.55f, (float)0.2f, (float)0.1f);
                GlStateManager.func_179152_a((float)0.85f, (float)0.85f, (float)0.85f);
                GlStateManager.func_179114_b((float)1.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)1.0f, (float)0.25f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)2.0f, (float)0.0f, (float)2.0f, (float)0.0f);
            }
            double scale = 1.0 * Math.exp(advanced.blockedScale);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            ci.cancel();
        }
    }

    @ModifyArg(method={"renderItemInFirstPerson"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemRenderer;transformFirstPersonItem(FF)V", ordinal=2), index=0)
    private float modifyBlockEquip(float original) {
        return OldAnimationsSettings.lunarBlockhit && OldAnimationsSettings.INSTANCE.enabled ? 0.2f : original;
    }

    @Inject(method={"performDrinking"}, at={@At(value="HEAD")}, cancellable=true)
    public void drinkingItemTransform(AbstractClientPlayer clientPlayer, float partialTicks, CallbackInfo ci) {
        OldAnimationsSettings settings = OldAnimationsSettings.INSTANCE;
        ItemPositionAdvancedSettings advanced = OldAnimationsSettings.advancedSettings;
        if (OldAnimationsSettings.globalPositions && settings.enabled) {
            float f = (float)clientPlayer.func_71052_bv() - partialTicks + 1.0f;
            float f1 = f / (float)this.field_78453_b.func_77988_m();
            float f2 = MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
            if (f1 >= 0.8f) {
                f2 = 0.0f;
            }
            float posX = 0.56f * (1.0f + settings.itemPositionX);
            float posY = -0.52f * (1.0f - settings.itemPositionY);
            float posZ = -0.72f * (1.0f + settings.itemPositionZ);
            if (ItemPositionAdvancedSettings.shouldScaleEat) {
                GlStateManager.func_179109_b((float)-0.56f, (float)0.52f, (float)0.72f);
                GlStateManager.func_179109_b((float)posX, (float)posY, (float)posZ);
            }
            GlStateManager.func_179109_b((float)advanced.consumePositionX, (float)advanced.consumePositionY, (float)advanced.consumePositionZ);
            GlStateManager.func_179109_b((float)0.0f, (float)(f2 * (1.0f + advanced.consumeIntensity)), (float)0.0f);
            float f3 = 1.0f - (float)Math.pow(f1, 27.0f * (1.0f + advanced.consumeSpeed));
            GlStateManager.func_179109_b((float)(f3 * 0.6f), (float)(f3 * -0.5f), (float)(f3 * 0.0f));
            GlStateManager.func_179114_b((float)advanced.consumeRotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)advanced.consumeRotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)advanced.consumeRotationRoll, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(f3 * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f3 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f3 * 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            if (ItemPositionAdvancedSettings.shouldScaleEat) {
                GlStateManager.func_179109_b((float)0.56f, (float)-0.52f, (float)-0.72f);
                GlStateManager.func_179109_b((float)(-posX), (float)(-posY), (float)(-posZ));
            }
            ci.cancel();
        }
    }

    @Inject(method={"renderItemInFirstPerson"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemRenderer;transformFirstPersonItem(FF)V", ordinal=1, shift=At.Shift.AFTER)})
    public void drinkingItemScale(float partialTicks, CallbackInfo ci) {
        OldAnimationsSettings settings = OldAnimationsSettings.INSTANCE;
        if (OldAnimationsSettings.globalPositions && settings.enabled) {
            double scale = 1.0 * Math.exp(OldAnimationsSettings.advancedSettings.consumeScale);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        }
    }
}

