/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.overflowanimations.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import org.polyfrost.overflowanimations.config.OldAnimationsSettings;
import org.polyfrost.overflowanimations.hooks.DebugOverlayHook;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin {
    @Final
    private final Minecraft mc = Minecraft.func_71410_x();
    @Unique
    private float overflow$height;
    @Unique
    private float overflow$previousHeight;

    @Redirect(method={"orientCamera"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getEyeHeight()F"))
    public float modifyEyeHeight(Entity entity, float partialTicks) {
        return OldAnimationsSettings.smoothSneaking && OldAnimationsSettings.INSTANCE.enabled ? this.overflow$previousHeight + (this.overflow$height - this.overflow$previousHeight) * partialTicks : entity.func_70047_e();
    }

    @Redirect(method={"renderWorldDirections"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getEyeHeight()F"))
    public float syncCrossHair(Entity entity, float partialTicks) {
        return this.modifyEyeHeight(entity, partialTicks);
    }

    @Inject(method={"updateRenderer"}, at={@At(value="HEAD")})
    private void interpolateHeight(CallbackInfo ci) {
        Entity entity = this.mc.func_175606_aa();
        float eyeHeight = entity.func_70047_e();
        this.overflow$previousHeight = this.overflow$height;
        this.overflow$height = eyeHeight < this.overflow$height ? eyeHeight : (this.overflow$height += (eyeHeight - this.overflow$height) * 0.5f);
        DebugOverlayHook.setOverflowEyeHeight(this.overflow$height);
    }

    @Inject(method={"renderWorldDirections"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderCrosshair(float partialTicks, CallbackInfo ci) {
        if (OldAnimationsSettings.INSTANCE.debugCrosshairMode != 1 && OldAnimationsSettings.INSTANCE.enabled) {
            ci.cancel();
        }
    }

    @Inject(method={"hurtCameraEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelHurtCamera(float partialTicks, CallbackInfo ci) {
        if (OldAnimationsSettings.noHurtCam && OldAnimationsSettings.INSTANCE.enabled) {
            ci.cancel();
        }
    }
}

