/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.overflowanimations.gui;

import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;
import cc.polyfrost.oneconfig.utils.gui.OneUIScreen;
import org.polyfrost.overflowanimations.hooks.AnimationExportUtils;

public class PleaseMigrateDulkirModGui
extends OneUIScreen {
    private static final int GRAY_800 = ColorUtils.getColor((int)21, (int)22, (int)23, (int)255);
    private static final int WHITE_90 = ColorUtils.getColor((int)255, (int)255, (int)255, (int)229);
    private static final String TRANSFER = "Transfer";
    private static final String CANCEL = "Cancel";
    private final BasicButton transferButton = new BasicButton(-1, 40, "Transfer", 2, ColorPalette.PRIMARY);
    private final BasicButton cancelButton = new BasicButton(-1, 40, "Cancel", 2, ColorPalette.PRIMARY_DESTRUCTIVE);

    public void draw(long vg, float partialTicks, InputHandler inputHandler) {
        if (this.transferButton.getWidth() == -1) {
            this.transferButton.setWidth((int)(NanoVGHelper.INSTANCE.getTextWidth(vg, TRANSFER, 14.0f, Fonts.MEDIUM) + 40.0f));
            this.transferButton.setClickAction(AnimationExportUtils::transferDulkirConfig);
        }
        if (this.cancelButton.getWidth() == -1) {
            this.cancelButton.setWidth((int)(NanoVGHelper.INSTANCE.getTextWidth(vg, CANCEL, 14.0f, Fonts.MEDIUM) + 40.0f));
            this.cancelButton.setClickAction(() -> {
                this.cancelButton.setText("Confirm");
                this.cancelButton.setWidth((int)(NanoVGHelper.INSTANCE.getTextWidth(vg, "Confirm", 14.0f, Fonts.MEDIUM) + 40.0f));
                this.cancelButton.setClickAction(() -> {
                    this.cancelButton.setText(CANCEL);
                    this.cancelButton.setWidth((int)(NanoVGHelper.INSTANCE.getTextWidth(vg, CANCEL, 14.0f, Fonts.MEDIUM) + 40.0f));
                    GuiUtils.displayScreen(null);
                });
            });
        }
        float scale = OneConfigGui.getScaleFactor();
        int x = (int)(((float)UResolution.getWindowWidth() - 600.0f * scale) / 2.0f / scale);
        int y = (int)(((float)UResolution.getWindowHeight() - 240.0f * scale) / 2.0f / scale);
        NanoVGHelper.INSTANCE.scale(vg, scale, scale);
        inputHandler.scale((double)scale, (double)scale);
        NanoVGHelper.INSTANCE.drawRoundedRect(vg, (float)x, (float)y, 600.0f, 240.0f, GRAY_800, 20.0f);
        NanoVGHelper.INSTANCE.drawCenteredText(vg, "OverflowAnimations", (float)(x + 300), (float)(y + 40), WHITE_90, 28.0f, Fonts.MEDIUM);
        NanoVGHelper.INSTANCE.drawCenteredText(vg, "OverflowAnimations now replaces DulkirMod's animations feature.", (float)(x + 300), (float)(y + 100), WHITE_90, 16.0f, Fonts.REGULAR);
        NanoVGHelper.INSTANCE.drawCenteredText(vg, "Would you like to import your DulkirMod config?", (float)(x + 300), (float)(y + 120), WHITE_90, 16.0f, Fonts.REGULAR);
        NanoVGHelper.INSTANCE.drawCenteredText(vg, "(You can transfer your config later in the settings)", (float)(x + 300), (float)(y + 140), WHITE_90, 12.0f, Fonts.REGULAR);
        this.transferButton.draw(vg, (float)(x + 300 - this.transferButton.getWidth()), (float)(y + 180), inputHandler);
        this.cancelButton.draw(vg, (float)(x + 300 + 10), (float)(y + 180), inputHandler);
    }
}

