/*
 * Decompiled with CFR 0.152.
 */
package org.polyfrost.overflowanimations;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.MalformedJsonException;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;

public class ModDetectorPlugin
implements IFMLLoadingPlugin {
    public ModDetectorPlugin() {
        block50: {
            try {
                JFrame frame;
                File modsFolder = new File(Launch.minecraftHome, "mods");
                File[] modFolder = modsFolder.listFiles((dir, name) -> name.endsWith(".jar"));
                if (modFolder == null) break block50;
                JsonParser PARSER = new JsonParser();
                File oldFile = null;
                for (File file : modFolder) {
                    try (ZipFile mod2 = new ZipFile(file);){
                        ZipEntry entry = mod2.getEntry("mcmod.info");
                        if (entry == null) continue;
                        try (InputStream inputStream = mod2.getInputStream(entry);){
                            String modid;
                            byte[] availableBytes = new byte[inputStream.available()];
                            inputStream.read(availableBytes, 0, inputStream.available());
                            JsonObject modInfo = PARSER.parse(new String(availableBytes)).getAsJsonArray().get(0).getAsJsonObject();
                            if (!modInfo.has("modid") || !modInfo.has("version") || !(modid = modInfo.get("modid").getAsString()).equals("sk1er_old_animations")) continue;
                            oldFile = file;
                            break;
                        }
                    }
                    catch (MalformedJsonException | IllegalStateException mod2) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (oldFile == null) break block50;
                if (!oldFile.delete()) {
                    oldFile.deleteOnExit();
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    frame = new JFrame();
                    frame.setUndecorated(true);
                    frame.setAlwaysOnTop(true);
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                    JOptionPane.showMessageDialog(frame, "You have both Sk1er Old Animations and Overflow Animations installed.\nPlease remove Sk1er Old Animations from your mod folder, as OverflowAnimations replaces it.\nIt is in " + oldFile.getAbsolutePath(), "Sk1er Old Animations detected!", 0);
                    try {
                        Method exit = Class.forName("java.lang.Shutdown").getDeclaredMethod("exit", Integer.TYPE);
                        exit.setAccessible(true);
                        exit.invoke(null, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    break block50;
                }
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                frame = new JFrame();
                frame.setUndecorated(true);
                frame.setAlwaysOnTop(true);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                JOptionPane.showMessageDialog(frame, "You had both Sk1er Old Animations and Overflow Animations installed, so Overflow Animations removed Sk1er OAM.\nThis is because OverflowAnimations replaces it.\nClose this and restart your game.", "Sk1er Old Animations detected!", 0);
                try {
                    Method exit = Class.forName("java.lang.Shutdown").getDeclaredMethod("exit", Integer.TYPE);
                    exit.setAccessible(true);
                    exit.invoke(null, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> map) {
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

