/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0018\u00b2\u0006\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u008a\u0084\u0002"}, d2={"Lio/github/moulberry/notenoughupdates/util/MuseumUtil;", "", "()V", "findItemsByName", "", "", "displayName", "armor", "", "findMuseumArmorSetByName", "findMuseumItem", "Lio/github/moulberry/notenoughupdates/util/MuseumUtil$MuseumItem;", "stack", "Lnet/minecraft/item/ItemStack;", "isOnArmorPage", "findMuseumItemByName", "isMuseumInventory", "inventory", "Lnet/minecraft/inventory/IInventory;", "isValidSlot", "slot", "", "DonationState", "MuseumItem", "NotEnoughUpdates", "items"})
@SourceDebugExtension(value={"SMAP\nMuseumUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MuseumUtil.kt\nio/github/moulberry/notenoughupdates/util/MuseumUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1549#2:123\n1620#2,3:124\n1549#2:127\n1620#2,3:128\n*S KotlinDebug\n*F\n+ 1 MuseumUtil.kt\nio/github/moulberry/notenoughupdates/util/MuseumUtil\n*L\n103#1:123\n103#1:124,3\n107#1:127\n107#1:128,3\n*E\n"})
public final class MuseumUtil {
    @NotNull
    public static final MuseumUtil INSTANCE = new MuseumUtil();

    private MuseumUtil() {
    }

    @Nullable
    public final MuseumItem findMuseumItem(@NotNull ItemStack stack, boolean isOnArmorPage) {
        String skyblockId;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        Item item2 = item;
        Lazy items$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(stack, isOnArmorPage){
            final /* synthetic */ ItemStack $stack;
            final /* synthetic */ boolean $isOnArmorPage;
            {
                this.$stack = $stack;
                this.$isOnArmorPage = $isOnArmorPage;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                String string = this.$stack.func_82833_r();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stack.displayName");
                return MuseumUtil.INSTANCE.findItemsByName(string, this.$isOnArmorPage);
            }
        }));
        if (item2 instanceof ItemDye) {
            EnumDyeColor dyeColor = EnumDyeColor.func_176766_a((int)stack.func_77952_i());
            if (dyeColor == EnumDyeColor.LIME) {
                return new MuseumItem(MuseumUtil.findMuseumItem$lambda$0((Lazy<? extends List<String>>)items$delegate), DonationState.DONATED_VACANT);
            }
            if (dyeColor == EnumDyeColor.GRAY) {
                return new MuseumItem(MuseumUtil.findMuseumItem$lambda$0((Lazy<? extends List<String>>)items$delegate), DonationState.MISSING);
            }
        }
        if ((skyblockId = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withItemStack(stack).resolveInternalName()) != null) {
            return new MuseumItem(CollectionsKt.listOf((Object)skyblockId), isOnArmorPage ? DonationState.DONATED_PRESENT_PARTIAL : DonationState.DONATED_PRESENT);
        }
        return new MuseumItem(MuseumUtil.findMuseumItem$lambda$0((Lazy<? extends List<String>>)items$delegate), DonationState.DONATED_PRESENT);
    }

    @NotNull
    public final List<String> findItemsByName(@NotNull String displayName, boolean armor) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return CollectionsKt.filterNotNull((Iterable)(armor ? this.findMuseumArmorSetByName(displayName) : CollectionsKt.listOf((Object)this.findMuseumItemByName(displayName))));
    }

    private final String findMuseumItemByName(String displayName) {
        return ItemResolutionQuery.findInternalNameByDisplayName(displayName, true);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findMuseumArmorSetByName(String displayName) {
        JsonElement jsonElement;
        JsonElement jsonElement2;
        JsonElement jsonElement3;
        JsonElement jsonElement4;
        JsonElement pieces;
        String cleanedString = null;
        String string = StringUtils.cleanColour(displayName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanColour(displayName)");
        String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"'s", (String)"", (boolean)false, (int)4, null), (String)"- ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string3 = StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (CharSequence)" armor"), (CharSequence)" equipment"), (CharSequence)" set"), (String)" ", (String)"_", (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        cleanedString = string3;
        JsonObject museumJson = Constants.MUSEUM;
        JsonElement jsonElement5 = museumJson;
        if (jsonElement5 != null && (jsonElement5 = ((JsonObject)jsonElement5).get("set_exceptions")) != null && (jsonElement5 = jsonElement5.getAsJsonObject()) != null && (jsonElement5 = ((JsonObject)jsonElement5).get(cleanedString)) != null) {
            pieces = jsonElement5;
            boolean bl = false;
            String string4 = pieces.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pieces.asString");
            cleanedString = string4;
        }
        if (museumJson != null && (jsonElement4 = museumJson.get("sets_to_items")) != null && (jsonElement3 = jsonElement4.getAsJsonObject()) != null && (jsonElement2 = ((JsonObject)jsonElement3).get(cleanedString)) != null) {
            void $this$mapTo$iv$iv;
            pieces = jsonElement2;
            boolean bl = false;
            JsonArray jsonArray = pieces.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"pieces.asJsonArray");
            Iterable $this$map$iv = jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement6 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getAsString());
            }
            return (List)destination$iv$iv;
        }
        String withArmor = cleanedString + "_ARMOR";
        if (museumJson != null && (jsonElement3 = museumJson.get("sets_to_items")) != null && (jsonElement2 = jsonElement3.getAsJsonObject()) != null && (jsonElement = ((JsonObject)jsonElement2).get(withArmor)) != null) {
            void $this$mapTo$iv$iv;
            JsonElement pieces2 = jsonElement;
            boolean bl = false;
            JsonArray jsonArray = pieces2.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"pieces.asJsonArray");
            Iterable $this$map$iv = jsonArray;
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement7 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.getAsString());
            }
            return (List)destination$iv$iv2;
        }
        System.out.println((Object)("Could not find " + cleanedString + " in museum sets for name: \"" + displayName + '\"'));
        return CollectionsKt.emptyList();
    }

    public final boolean isMuseumInventory(@NotNull IInventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        String string = StringUtils.cleanColour(inventory.func_145748_c_().func_150260_c());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanColour(inventory.displayName.unformattedText)");
        return StringsKt.startsWith$default((String)string, (String)"Museum \u279c", (boolean)false, (int)2, null);
    }

    public final boolean isValidSlot(int slot) {
        int n = slot % 9;
        if (!(1 <= n ? n < 8 : false)) {
            return false;
        }
        return 9 <= slot ? slot < 45 : false;
    }

    private static final List<String> findMuseumItem$lambda$0(Lazy<? extends List<String>> $items$delegate) {
        Lazy<? extends List<String>> lazy = $items$delegate;
        return (List)lazy.getValue();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/moulberry/notenoughupdates/util/MuseumUtil$DonationState;", "", "(Ljava/lang/String;I)V", "DONATED_PRESENT_PARTIAL", "DONATED_PRESENT", "DONATED_VACANT", "MISSING", "NotEnoughUpdates"})
    public static final class DonationState
    extends Enum<DonationState> {
        public static final /* enum */ DonationState DONATED_PRESENT_PARTIAL = new DonationState();
        public static final /* enum */ DonationState DONATED_PRESENT = new DonationState();
        public static final /* enum */ DonationState DONATED_VACANT = new DonationState();
        public static final /* enum */ DonationState MISSING = new DonationState();
        private static final /* synthetic */ DonationState[] $VALUES;

        public static DonationState[] values() {
            return (DonationState[])$VALUES.clone();
        }

        public static DonationState valueOf(String value) {
            return Enum.valueOf(DonationState.class, value);
        }

        static {
            $VALUES = donationStateArray = new DonationState[]{DonationState.DONATED_PRESENT_PARTIAL, DonationState.DONATED_PRESENT, DonationState.DONATED_VACANT, DonationState.MISSING};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/github/moulberry/notenoughupdates/util/MuseumUtil$MuseumItem;", "", "skyblockItemIds", "", "", "state", "Lio/github/moulberry/notenoughupdates/util/MuseumUtil$DonationState;", "(Ljava/util/List;Lio/github/moulberry/notenoughupdates/util/MuseumUtil$DonationState;)V", "getSkyblockItemIds", "()Ljava/util/List;", "getState", "()Lio/github/moulberry/notenoughupdates/util/MuseumUtil$DonationState;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "NotEnoughUpdates"})
    public static final class MuseumItem {
        @NotNull
        private final List<String> skyblockItemIds;
        @NotNull
        private final DonationState state;

        public MuseumItem(@NotNull List<String> skyblockItemIds, @NotNull DonationState state) {
            Intrinsics.checkNotNullParameter(skyblockItemIds, (String)"skyblockItemIds");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.skyblockItemIds = skyblockItemIds;
            this.state = state;
        }

        @NotNull
        public final List<String> getSkyblockItemIds() {
            return this.skyblockItemIds;
        }

        @NotNull
        public final DonationState getState() {
            return this.state;
        }

        @NotNull
        public final List<String> component1() {
            return this.skyblockItemIds;
        }

        @NotNull
        public final DonationState component2() {
            return this.state;
        }

        @NotNull
        public final MuseumItem copy(@NotNull List<String> skyblockItemIds, @NotNull DonationState state) {
            Intrinsics.checkNotNullParameter(skyblockItemIds, (String)"skyblockItemIds");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new MuseumItem(skyblockItemIds, state);
        }

        public static /* synthetic */ MuseumItem copy$default(MuseumItem museumItem, List list, DonationState donationState, int n, Object object) {
            if ((n & 1) != 0) {
                list = museumItem.skyblockItemIds;
            }
            if ((n & 2) != 0) {
                donationState = museumItem.state;
            }
            return museumItem.copy(list, donationState);
        }

        @NotNull
        public String toString() {
            return "MuseumItem(skyblockItemIds=" + this.skyblockItemIds + ", state=" + (Object)((Object)this.state) + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.skyblockItemIds).hashCode();
            result2 = result2 * 31 + this.state.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MuseumItem)) {
                return false;
            }
            MuseumItem museumItem = (MuseumItem)other;
            if (!Intrinsics.areEqual(this.skyblockItemIds, museumItem.skyblockItemIds)) {
                return false;
            }
            return this.state == museumItem.state;
        }
    }
}

