/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.level.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.profileviewer.CrimsonIslePage;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.level.LevelPage;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.GuiTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class SlayingTaskLevel
extends GuiTaskLevel {
    private final int[] bossLow = new int[]{25, 50, 100, 150, 250, 1000};
    private final int[] thorn = new int[]{25, 50, 150, 250, 400, 1000};
    private final int[] bossHigh = new int[]{50, 100, 150, 250, 500, 750, 1000};

    public SlayingTaskLevel(LevelPage levelPage) {
        super(levelPage);
    }

    @Override
    public void drawTask(JsonObject object, int mouseX, int mouseY, int guiLeft, int guiTop) {
        int mythologicalKillsMax;
        JsonObject slayingTask = this.levelPage.getConstant().get("slaying_task").getAsJsonObject();
        JsonArray slayerLevelUpXp = slayingTask.get("slayer_level_up_xp").getAsJsonArray();
        SkyblockProfiles.SkyblockProfile selectedProfile = GuiProfileViewer.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        Map<String, ProfileViewer.Level> skyblockInfo = selectedProfile.getLevelingInfo();
        int sbXpGainedSlayer = 0;
        if (skyblockInfo != null) {
            for (String slayer : Weight.SLAYER_NAMES) {
                ProfileViewer.Level level = skyblockInfo.get(slayer);
                for (int i = 0; i < (int)level.level; ++i) {
                    int asInt = slayerLevelUpXp.get(i).getAsInt();
                    sbXpGainedSlayer += asInt;
                }
            }
        }
        JsonObject bossCollectionsXp = slayingTask.getAsJsonObject("boss_collections_xp");
        HashMap allComps = new HashMap();
        JsonElement normalCompletions = Utils.getElement(object, "dungeons.dungeon_types.catacombs.tier_completions");
        JsonElement masterCompletions = Utils.getElement(object, "dungeons.dungeon_types.master_catacombs.tier_completions");
        if (normalCompletions != null) {
            HashMap normalCompMap = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((JsonElement)normalCompletions.getAsJsonObject(), HashMap.class);
            normalCompMap.forEach((floor2, value) -> {
                if (allComps.containsKey(floor2)) {
                    allComps.put(floor2, (Double)allComps.get(floor2) + value);
                } else {
                    allComps.put(floor2, value);
                }
            });
        }
        if (masterCompletions != null) {
            HashMap masterCompMap = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((JsonElement)masterCompletions.getAsJsonObject(), HashMap.class);
            masterCompMap.forEach((floor2, value) -> {
                if (allComps.containsKey(floor2)) {
                    allComps.put(floor2, (Double)allComps.get(floor2) + value * 2.0);
                } else {
                    allComps.put(floor2, value);
                }
            });
        }
        int bossCollectionXp = 0;
        JsonArray dungeonCollectionXp = bossCollectionsXp.getAsJsonArray("dungeon_collection_xp");
        block7: for (int i = 1; i <= 7; ++i) {
            if (!allComps.containsKey(String.valueOf(i))) continue;
            double value2 = (Double)allComps.get(String.valueOf(i));
            switch (i) {
                case 1: 
                case 2: 
                case 3: {
                    bossCollectionXp += this.loopThroughCollection(this.bossLow, value2, dungeonCollectionXp);
                    continue block7;
                }
                case 4: {
                    bossCollectionXp += this.loopThroughCollection(this.thorn, value2, dungeonCollectionXp);
                    continue block7;
                }
                case 5: 
                case 6: 
                case 7: {
                    bossCollectionXp += this.loopThroughCollection(this.bossHigh, value2, dungeonCollectionXp);
                }
            }
        }
        JsonArray defeatKuudraXp = slayingTask.get("defeat_kuudra_xp").getAsJsonArray();
        int sbXpDefeatKuudra = 0;
        int kuudraBossCollection = 0;
        if (object.has("nether_island_player_data")) {
            JsonObject kuudraCompletedTiers = Utils.getElementOrDefault(selectedProfile.getProfileJson(), "nether_island_player_data.kuudra_completed_tiers", new JsonObject()).getAsJsonObject();
            for (Map.Entry<String, JsonElement> stringJsonElementEntry : kuudraCompletedTiers.entrySet()) {
                String key = stringJsonElementEntry.getKey();
                int value3 = stringJsonElementEntry.getValue().getAsInt();
                int i = 0;
                for (String kuudraTier : CrimsonIslePage.KUUDRA_TIERS) {
                    if (key.equals(kuudraTier)) {
                        sbXpDefeatKuudra += defeatKuudraXp.get(i).getAsInt();
                        kuudraBossCollection += (i + 1) * value3;
                    }
                    ++i;
                }
            }
            if (kuudraBossCollection >= 10) {
                bossCollectionXp += 10;
            }
            if (kuudraBossCollection >= 100) {
                bossCollectionXp += 15;
            }
            if (kuudraBossCollection >= 500) {
                bossCollectionXp += 20;
            }
            if (kuudraBossCollection >= 2000) {
                bossCollectionXp += 25;
            }
            if (kuudraBossCollection >= 5000) {
                bossCollectionXp += 30;
            }
        }
        int sbXpBestiary = GuiProfileViewer.getSelectedProfile().getBestiaryXp();
        int mythologicalKillsXp = Utils.getElementAsInt(Utils.getElement(selectedProfile.getProfileJson(), "player_stats.mythos.kills"), 0) / 100;
        if (mythologicalKillsXp > (mythologicalKillsMax = slayingTask.get("mythological_kills").getAsInt())) {
            mythologicalKillsXp = mythologicalKillsMax;
        }
        int sbXpFromDragonKills = 0;
        JsonObject slayDragonsXp = slayingTask.getAsJsonObject("slay_dragons_xp");
        for (Map.Entry<String, JsonElement> stringJsonElementEntry : slayDragonsXp.entrySet()) {
            sbXpFromDragonKills += stringJsonElementEntry.getValue().getAsInt();
        }
        int sbXpFromSlayerDefeat = 0;
        JsonArray defeatSlayersXp = slayingTask.get("defeat_slayers_xp").getAsJsonArray();
        JsonObject slayerToTier = Constants.LEVELING.getAsJsonObject("slayer_to_highest_tier");
        if (slayerToTier == null) {
            Utils.showOutdatedRepoNotification("slayer_to_highest_tier from leveling.json");
            return;
        }
        for (Map.Entry<String, JsonElement> entry : slayerToTier.entrySet()) {
            int maxLevel = entry.getValue().getAsInt();
            for (int i = 0; i < 5 && i < maxLevel; ++i) {
                float tier = Utils.getElementAsFloat(Utils.getElement(object, "slayer.slayer_bosses." + entry.getKey() + ".boss_kills_tier_" + i), 0.0f);
                if (tier == 0.0f) continue;
                int value4 = defeatSlayersXp.get(i).getAsInt();
                sbXpFromSlayerDefeat += value4;
            }
        }
        JsonArray defeatArachneXp = slayingTask.get("defeat_arachne_xp").getAsJsonArray();
        int sbXpGainedArachne = 0;
        for (JsonElement jsonElement : defeatArachneXp) {
            sbXpGainedArachne += jsonElement.getAsInt();
        }
        ArrayList<String> lore = new ArrayList<String>();
        int slayerLevelUpMax = slayingTask.get("slayer_level_up").getAsInt();
        int bossCollectionsMax = slayingTask.get("boss_collections").getAsInt();
        int bestiaryXpMax = slayingTask.get("bestiary_progress").getAsInt();
        int slayDragonsMax = slayingTask.get("slay_dragons").getAsInt();
        int defeatSlayersMax = slayingTask.get("defeat_slayers").getAsInt();
        int defeatKuudraMax = slayingTask.get("defeat_kuudra").getAsInt();
        int defeatArachneMax = slayingTask.get("defeat_arachne").getAsInt();
        lore.add(this.levelPage.buildLore("Slayer Level Up", sbXpGainedSlayer, slayerLevelUpMax, false));
        lore.add(this.levelPage.buildLore("Boss Collections", bossCollectionXp, bossCollectionsMax, false));
        lore.add(this.levelPage.buildLore("Bestiary Progress", sbXpBestiary, bestiaryXpMax, false));
        lore.add(this.levelPage.buildLore("Mythological Kills", mythologicalKillsXp, mythologicalKillsMax, false));
        lore.add(this.levelPage.buildLore("Slay Dragons", sbXpFromDragonKills, slayDragonsMax, false));
        lore.add(this.levelPage.buildLore("Defeat Slayers", sbXpFromSlayerDefeat, defeatSlayersMax, false));
        lore.add(this.levelPage.buildLore("Defeat Kuudra", sbXpDefeatKuudra, defeatKuudraMax, false));
        lore.add(this.levelPage.buildLore("Defeat Arachne", sbXpGainedArachne, defeatArachneMax, false));
        int slayingTaskMax = this.levelPage.getConstant().getAsJsonObject("category_xp").get("slaying_task").getAsInt();
        int totalXp = sbXpGainedSlayer + bossCollectionXp + mythologicalKillsXp + sbXpFromDragonKills + sbXpFromSlayerDefeat + sbXpDefeatKuudra + sbXpGainedArachne + sbXpBestiary;
        this.levelPage.renderLevelBar("Slaying Task", new ItemStack(Items.field_151010_B), guiLeft + 23, guiTop + 85, 110, 0.0, totalXp, slayingTaskMax, mouseX, mouseY, true, lore);
    }

    private int loopThroughCollection(int[] array, double value, JsonArray jsonArray) {
        int i = 0;
        int gain = 0;
        for (int bossReq : array) {
            if (value >= (double)bossReq) {
                int gained = jsonArray.get(i).getAsInt();
                gain += gained;
            }
            ++i;
        }
        return gain;
    }
}

