/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.level.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.profileviewer.level.LevelPage;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.GuiTaskLevel;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class SkillRelatedTaskLevel
extends GuiTaskLevel {
    public SkillRelatedTaskLevel(LevelPage levelPage) {
        super(levelPage);
    }

    @Override
    public void drawTask(JsonObject object, int mouseX, int mouseY, int guiLeft, int guiTop) {
        SkyblockProfiles.SkyblockProfile selectedProfile = GuiProfileViewer.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        APIDataJson data = selectedProfile.getAPIDataJson();
        if (data == null) {
            return;
        }
        Map<String, ProfileViewer.Level> levelingInfo = selectedProfile.getLevelingInfo();
        if (levelingInfo == null) {
            return;
        }
        JsonObject skillRelatedTask = this.levelPage.getConstant().getAsJsonObject("skill_related_task");
        JsonObject miningObj = skillRelatedTask.getAsJsonObject("mining");
        int hotmLevel = (int)levelingInfo.get((Object)"hotm").level;
        int hotmXP = 0;
        JsonArray hotmXpArray = miningObj.get("hotm_xp").getAsJsonArray();
        for (int i = 1; i <= hotmLevel; ++i) {
            hotmXP += hotmXpArray.get(i - 1).getAsInt();
        }
        float mithrilPowder = data.mining_core.powder_mithril;
        float gemstonePowder = data.mining_core.powder_gemstone;
        float glacitePowder = data.mining_core.powder_glacite;
        float mithril = data.mining_core.powder_spent_mithril + mithrilPowder;
        float gemstone = data.mining_core.powder_spent_gemstone + gemstonePowder;
        float glacite = data.mining_core.powder_spent_glacite + glacitePowder;
        double totalMithril = mithril + mithrilPowder;
        double totalGemstone = gemstone + gemstonePowder;
        double totalGlacite = glacite + glacitePowder;
        double mithrilUnder = Math.min(350000.0, totalMithril);
        double mithrilOver = Math.max(0.0, Math.min(totalMithril, 1.25E7) - 350000.0);
        double gemstoneUnder = Math.min(350000.0, totalGemstone);
        double gemstoneOver = Math.max(0.0, Math.min(totalGemstone, 2.0E7) - 350000.0);
        double glaciteUnder = Math.min(350000.0, totalGlacite);
        double glaciteOver = Math.max(0.0, Math.min(totalGlacite, 2.0E7) - 350000.0);
        double mithrilXP = Math.floor(mithrilUnder / 2400.0);
        double gemstoneXP = Math.floor(gemstoneUnder / 2500.0);
        double glaciteXP = Math.floor(glaciteUnder / 2500.0);
        double mithrilExcess = Math.floor(3.75 * (Math.sqrt(1.0 + 8.0 * Math.sqrt(0.14066136 * mithrilOver + 9.0)) - 3.0));
        double gemstoneExcess = Math.floor(4.25 * (Math.sqrt(1.0 + 8.0 * Math.sqrt(0.08791335 * gemstoneOver + 9.0)) - 3.0));
        double glaciteExcess = Math.floor(4.25 * (Math.sqrt(1.0 + 8.0 * Math.sqrt(0.08791335 * glaciteOver + 9.0)) - 3.0));
        double sbXpHotmTier = mithrilXP + mithrilExcess + (gemstoneXP + gemstoneExcess) + (glaciteXP + glaciteExcess) + (double)hotmXP;
        int sbXpPotmTier = 0;
        JsonArray potmXpArray = miningObj.get("potm_xp").getAsJsonArray();
        int potm = data.mining_core.nodes.getOrDefault("special_0", new JsonPrimitive(0)).getAsInt();
        for (int i = 1; i <= potm; ++i) {
            sbXpPotmTier += potmXpArray.get(i - 1).getAsInt();
        }
        int sbXpCommissionMilestone = 0;
        JsonArray tutorialArray = Utils.getElementOrDefault(selectedProfile.getProfileJson(), "objectives.tutorial", new JsonArray()).getAsJsonArray();
        JsonArray commissionMilestoneXpArray = miningObj.get("commission_milestone_xp").getAsJsonArray();
        for (JsonElement jsonElement : tutorialArray) {
            if (!jsonElement.getAsJsonPrimitive().isString() || !jsonElement.getAsString().startsWith("commission_milestone_reward_skyblock_xp_tier")) continue;
            for (int i = 1; i <= commissionMilestoneXpArray.size(); ++i) {
                int value = commissionMilestoneXpArray.get(i - 1).getAsInt();
                if (!jsonElement.getAsString().equals("commission_milestone_reward_skyblock_xp_tier_" + i)) continue;
                sbXpCommissionMilestone += value;
            }
        }
        int sbXpFossilResearch = data.glacite_player_data.fossils_donated.size() * miningObj.get("fossil_research_xp").getAsInt();
        float pet_milestone_ores_mined = data.player_stats.pets.milestone.ores_mined;
        int sbXpRockPet = 0;
        int rockMilestoneXp = miningObj.get("rock_milestone_xp").getAsInt();
        JsonArray rockMilestoneRequired = miningObj.get("rock_milestone_required").getAsJsonArray();
        for (JsonElement jsonElement : rockMilestoneRequired) {
            int value = jsonElement.getAsInt();
            if (!(pet_milestone_ores_mined >= (float)value)) continue;
            sbXpRockPet += rockMilestoneXp;
        }
        JsonObject farmingObj = skillRelatedTask.get("farming").getAsJsonObject();
        int anitaShopUpgradesXp = farmingObj.get("anita_shop_upgrades_xp").getAsInt();
        int doubleDrops = data.jacobs_contest.perks.double_drops;
        int farmingLevelCap = data.jacobs_contest.perks.farming_level_cap;
        int sbXpGainedByAnita = (doubleDrops + farmingLevelCap) * anitaShopUpgradesXp;
        int sbXpTrophyFish = 0;
        JsonObject fishingObj = skillRelatedTask.get("fishing").getAsJsonObject();
        JsonArray trophyFishXpArr = fishingObj.get("trophy_fish_xp").getAsJsonArray();
        if (object.has("trophy_fish")) {
            JsonObject trophyFish = object.get("trophy_fish").getAsJsonObject();
            for (Map.Entry<String, JsonElement> stringJsonElementEntry : trophyFish.entrySet()) {
                String key = stringJsonElementEntry.getKey();
                if (!stringJsonElementEntry.getValue().isJsonPrimitive()) continue;
                if (key.endsWith("_bronze")) {
                    sbXpTrophyFish += trophyFishXpArr.get(0).getAsInt();
                }
                if (key.endsWith("_silver")) {
                    sbXpTrophyFish += trophyFishXpArr.get(1).getAsInt();
                }
                if (key.endsWith("_gold")) {
                    sbXpTrophyFish += trophyFishXpArr.get(2).getAsInt();
                }
                if (!key.endsWith("_diamond")) continue;
                sbXpTrophyFish += trophyFishXpArr.get(3).getAsInt();
            }
        }
        float petMilestoneKilled = data.player_stats.pets.milestone.sea_creatures_killed;
        int sbXpDolphinPet = 0;
        int dolphinMilestoneXp = fishingObj.get("dolphin_milestone_xp").getAsInt();
        JsonArray dolphinMilestoneRequired = fishingObj.get("dolphin_milestone_required").getAsJsonArray();
        for (JsonElement jsonElement : dolphinMilestoneRequired) {
            int value = jsonElement.getAsInt();
            if (!(petMilestoneKilled >= (float)value)) continue;
            sbXpDolphinPet += dolphinMilestoneXp;
        }
        int sbXpNucleus = 0;
        int nucleusRuns = data.leveling.completions.NUCLEUS_RUNS;
        JsonElement nucleusXp = miningObj.get("crystal_nucleus_xp");
        if (nucleusXp == null) {
            Utils.showOutdatedRepoNotification("crystal_nucleus_xp from sblevels.json");
        } else {
            sbXpNucleus += nucleusRuns * nucleusXp.getAsInt();
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(this.levelPage.buildLore("Heart of the Mountain", sbXpHotmTier, miningObj.get("hotm").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Commission Milestones", sbXpCommissionMilestone, miningObj.get("commission_milestone").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Crystal Nucleus", sbXpNucleus, miningObj.get("crystal_nucleus").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Anita's Shop Upgrade", sbXpGainedByAnita, farmingObj.get("anita_shop_upgrades").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Peak of the Mountain", sbXpPotmTier, miningObj.get("potm").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Fossil Research", sbXpFossilResearch, miningObj.get("fossil_research").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Trophy Fish", sbXpTrophyFish, fishingObj.get("trophy_fish").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Rock Milestone", sbXpRockPet, miningObj.get("rock_milestone").getAsInt(), false));
        lore.add(this.levelPage.buildLore("Dolphin Milestone", sbXpDolphinPet, fishingObj.get("dolphin_milestone").getAsInt(), false));
        int totalXp = (int)(sbXpHotmTier + (double)sbXpCommissionMilestone + (double)sbXpGainedByAnita + (double)sbXpPotmTier + (double)sbXpTrophyFish + (double)sbXpRockPet + (double)sbXpDolphinPet + (double)sbXpNucleus + (double)sbXpFossilResearch);
        this.levelPage.renderLevelBar("Skill Related Task", new ItemStack(Items.field_151048_u), guiLeft + 23, guiTop + 115, 110, 0.0, totalXp, this.levelPage.getConstant().getAsJsonObject("category_xp").get("skill_related_task").getAsInt(), mouseX, mouseY, true, lore);
    }
}

