/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer.level.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.level.LevelPage;
import io.github.moulberry.notenoughupdates.profileviewer.level.task.GuiTaskLevel;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Map;

public class DungeonTaskLevel
extends GuiTaskLevel {
    public DungeonTaskLevel(LevelPage levelPage) {
        super(levelPage);
    }

    @Override
    public void drawTask(JsonObject object, int mouseX, int mouseY, int guiLeft, int guiTop) {
        JsonObject dungeonTask = this.levelPage.getConstant().get("dungeon_task").getAsJsonObject();
        SkyblockProfiles.SkyblockProfile selectedProfile = GuiProfileViewer.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        Map<String, ProfileViewer.Level> skyblockInfo = selectedProfile.getLevelingInfo();
        int sbLevelGainedFloor = 0;
        int sbXpGainedClass = 0;
        int sbXpGainedLvl = 0;
        int catacombsLvl = 0;
        if (skyblockInfo != null && skyblockInfo.containsKey("catacombs")) {
            ProfileViewer.Level catacombs = skyblockInfo.get("catacombs");
            catacombsLvl = (int)catacombs.level;
            int i = 1;
            while ((float)i <= catacombs.level) {
                sbXpGainedLvl = 40 > i ? (sbXpGainedLvl += 20) : (sbXpGainedLvl += 40);
                ++i;
            }
            for (String dungeonClass : Weight.DUNGEON_CLASS_NAMES) {
                ProfileViewer.Level level = skyblockInfo.get(dungeonClass);
                int i2 = 1;
                while ((float)i2 <= level.level) {
                    if (i2 <= 50) {
                        sbXpGainedClass += dungeonTask.get("class_xp").getAsInt();
                    }
                    ++i2;
                }
            }
            JsonArray completeCatacombs = dungeonTask.get("complete_catacombs").getAsJsonArray();
            int index = 0;
            for (JsonElement completeCatacomb : completeCatacombs) {
                int value = completeCatacomb.getAsInt();
                JsonElement normalCompletions = Utils.getElementOrDefault(object, "dungeons.dungeon_types.catacombs.tier_completions", null);
                if (normalCompletions != null && normalCompletions.getAsJsonObject().has("" + index)) {
                    sbLevelGainedFloor += value;
                }
                ++index;
            }
            int masterCatacombs = dungeonTask.get("complete_master_catacombs").getAsInt();
            for (int i3 = 0; i3 <= 7; ++i3) {
                JsonElement masterCompletions = Utils.getElementOrDefault(object, "dungeons.dungeon_types.master_catacombs.tier_completions", null);
                if (masterCompletions == null || !masterCompletions.getAsJsonObject().has("" + i3)) continue;
                sbLevelGainedFloor += masterCatacombs;
            }
        }
        int catacombsLevelUp = dungeonTask.get("catacombs_level_up").getAsInt();
        int classLevelUp = dungeonTask.get("class_level_up").getAsInt();
        int completeDungeon = dungeonTask.get("complete_dungeon").getAsInt();
        int totalGainful = catacombsLevelUp + classLevelUp + completeDungeon;
        double totalXp = sbXpGainedLvl + sbXpGainedClass + sbLevelGainedFloor;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(this.levelPage.buildLore("Catacombs Level Up", sbXpGainedLvl, catacombsLevelUp, false));
        lore.add(this.levelPage.buildLore("Class Level Up", sbXpGainedClass, classLevelUp, false));
        lore.add(this.levelPage.buildLore("Complete Dungeons", sbLevelGainedFloor, completeDungeon, false));
        this.levelPage.renderLevelBar("Dungeon Task", NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName("WITHER_RELIC").resolveToItemStack(), guiLeft + 23, guiTop + 55, 110, catacombsLvl, totalXp, totalGainful, mouseX, mouseY, true, lore);
    }
}

