/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.cosmetics.ShaderManager;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementTextField;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.GardenPage;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.bestiary.BestiaryPage;
import io.github.moulberry.notenoughupdates.profileviewer.BasicPage;
import io.github.moulberry.notenoughupdates.profileviewer.BingoPage;
import io.github.moulberry.notenoughupdates.profileviewer.CollectionsPage;
import io.github.moulberry.notenoughupdates.profileviewer.CrashRecoveryPage;
import io.github.moulberry.notenoughupdates.profileviewer.CrimsonIslePage;
import io.github.moulberry.notenoughupdates.profileviewer.DungeonPage;
import io.github.moulberry.notenoughupdates.profileviewer.ExtraPage;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.InventoriesPage;
import io.github.moulberry.notenoughupdates.profileviewer.MiningPage;
import io.github.moulberry.notenoughupdates.profileviewer.MuseumPage;
import io.github.moulberry.notenoughupdates.profileviewer.PetsPage;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.rift.RiftPage;
import io.github.moulberry.notenoughupdates.profileviewer.trophy.TrophyFishPage;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import io.github.moulberry.notenoughupdates.util.AsyncDependencyLoader;
import io.github.moulberry.notenoughupdates.util.PronounDB;
import io.github.moulberry.notenoughupdates.util.UrsaClient;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;

public class GuiProfileViewer
extends GuiScreen {
    public static final ResourceLocation pv_dropdown = new ResourceLocation("notenoughupdates:pv_dropdown.png");
    public static final ResourceLocation pv_bg = new ResourceLocation("notenoughupdates:pv_bg.png");
    public static final ResourceLocation pv_elements = new ResourceLocation("notenoughupdates:pv_elements.png");
    private static final Map<String, ResourceLocation> gamemodeToIcon = new HashMap<String, ResourceLocation>(){
        {
            this.put("ironman", new ResourceLocation("notenoughupdates:pv_ironman.png"));
            this.put("bingo", new ResourceLocation("notenoughupdates:pv_bingo.png"));
            this.put("island", new ResourceLocation("notenoughupdates:pv_stranded.png"));
        }
    };
    private static final ResourceLocation gamemodeIconUnknown = new ResourceLocation("notenoughupdates:pv_unknown.png");
    public static final ResourceLocation resource_packs = new ResourceLocation("minecraft:textures/gui/resource_packs.png");
    public static final ResourceLocation icons = new ResourceLocation("textures/gui/icons.png");
    public static final HashMap<String, HashMap<String, Float>> PET_STAT_BOOSTS = new HashMap<String, HashMap<String, Float>>(){
        {
            this.put("PET_ITEM_BIG_TEETH_COMMON", new HashMap<String, Float>(){
                {
                    this.put("CRIT_CHANCE", Float.valueOf(5.0f));
                }
            });
            this.put("PET_ITEM_HARDENED_SCALES_UNCOMMON", new HashMap<String, Float>(){
                {
                    this.put("DEFENCE", Float.valueOf(25.0f));
                }
            });
            this.put("PET_ITEM_LUCKY_CLOVER", new HashMap<String, Float>(){
                {
                    this.put("MAGIC_FIND", Float.valueOf(7.0f));
                }
            });
            this.put("PET_ITEM_SHARPENED_CLAWS_UNCOMMON", new HashMap<String, Float>(){
                {
                    this.put("CRIT_DAMAGE", Float.valueOf(15.0f));
                }
            });
        }
    };
    public static final HashMap<String, HashMap<String, Float>> PET_STAT_BOOSTS_MULT = new HashMap<String, HashMap<String, Float>>(){
        {
            this.put("PET_ITEM_IRON_CLAWS_COMMON", new HashMap<String, Float>(){
                {
                    this.put("CRIT_DAMAGE", Float.valueOf(1.4f));
                    this.put("CRIT_CHANCE", Float.valueOf(1.4f));
                }
            });
            this.put("PET_ITEM_TEXTBOOK", new HashMap<String, Float>(){
                {
                    this.put("INTELLIGENCE", Float.valueOf(2.0f));
                }
            });
        }
    };
    public static final HashMap<String, String> RARITY_TO_NUM = new HashMap<String, String>(){
        {
            this.put("COMMON", "0");
            this.put("UNCOMMON", "1");
            this.put("RARE", "2");
            this.put("EPIC", "3");
            this.put("LEGENDARY", "4");
            this.put("MYTHIC", "5");
        }
    };
    public static ProfileViewerPage currentPage = ProfileViewerPage.BASIC;
    private static int guiLeft;
    private static int guiTop;
    private static SkyblockProfiles profile;
    private static String profileName;
    public static AsyncDependencyLoader<Optional<PronounDB.PronounChoice>> pronouns;
    public final GuiElementTextField playerNameTextField;
    public final GuiElementTextField inventoryTextField = new GuiElementTextField("", 32);
    public final GuiElementTextField museumTextField = new GuiElementTextField("", 32);
    public final GuiElementTextField killDeathSearchTextField = new GuiElementTextField("", 32);
    private final Map<ProfileViewerPage, GuiProfileViewerPage> pages = new HashMap<ProfileViewerPage, GuiProfileViewerPage>();
    public int sizeX;
    public int sizeY;
    public float backgroundRotation = 0.0f;
    public long currentTime = 0L;
    public long lastTime = 0L;
    public long startTime = 0L;
    public List<String> tooltipToDisplay = null;
    private Shader blurShaderHorz = null;
    private Framebuffer blurOutputHorz = null;
    private Shader blurShaderVert = null;
    private Framebuffer blurOutputVert = null;
    private boolean profileDropdownSelected = false;
    private double lastBgBlurFactor = -1.0;
    private boolean showBingoPage;
    public static boolean onSecondPage;

    public GuiProfileViewer(SkyblockProfiles profile) {
        GuiProfileViewer.profile = profile;
        profileName = profile.getLatestProfileName();
        String displayname = GuiProfileViewer.getDisplayName();
        if (displayname.startsWith("\u00a7")) {
            displayname = "";
        }
        this.playerNameTextField = new GuiElementTextField(displayname, 32);
        this.playerNameTextField.setSize(100, 20);
        if (currentPage.isTransient()) {
            currentPage = ProfileViewerPage.BASIC;
            onSecondPage = false;
        }
        try {
            this.pages.put(ProfileViewerPage.BASIC, new BasicPage(this));
            this.pages.put(ProfileViewerPage.DUNGEON, new DungeonPage(this));
            this.pages.put(ProfileViewerPage.EXTRA, new ExtraPage(this));
            this.pages.put(ProfileViewerPage.INVENTORIES, new InventoriesPage(this));
            this.pages.put(ProfileViewerPage.COLLECTIONS, new CollectionsPage(this));
            this.pages.put(ProfileViewerPage.PETS, new PetsPage(this));
            this.pages.put(ProfileViewerPage.MINING, new MiningPage(this));
            this.pages.put(ProfileViewerPage.BINGO, new BingoPage(this));
            this.pages.put(ProfileViewerPage.TROPHY_FISH, new TrophyFishPage(this));
            this.pages.put(ProfileViewerPage.BESTIARY, new BestiaryPage(this));
            this.pages.put(ProfileViewerPage.CRIMSON_ISLE, new CrimsonIslePage(this));
            this.pages.put(ProfileViewerPage.MUSEUM, new MuseumPage(this));
            this.pages.put(ProfileViewerPage.RIFT, new RiftPage(this));
            this.pages.put(ProfileViewerPage.GARDEN, new GardenPage(this));
        }
        catch (Exception ex) {
            this.pages.put(ProfileViewerPage.CRASH_RECOVERY, new CrashRecoveryPage(this, ex, currentPage));
            currentPage = ProfileViewerPage.CRASH_RECOVERY;
        }
    }

    public static int getGuiLeft() {
        return guiLeft;
    }

    public static int getGuiTop() {
        return guiTop;
    }

    public static SkyblockProfiles getProfile() {
        return profile;
    }

    public static String getProfileName() {
        return profileName;
    }

    @Nullable
    public static SkyblockProfiles.SkyblockProfile getSelectedProfile() {
        return profile.getProfile(profileName);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        SkyblockProfiles.SkyblockProfile selectedProfile;
        ProfileViewerPage page;
        this.currentTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.currentTime;
        }
        if ((page = currentPage) != ProfileViewerPage.CRASH_RECOVERY) {
            if (profile == null) {
                page = ProfileViewerPage.INVALID_NAME;
            } else if (profile.getOrLoadSkyblockProfiles(null) == null) {
                page = ProfileViewerPage.LOADING;
            }
            if (profile != null && profile.getLatestProfileName() == null && !profile.getUpdatingSkyblockProfilesState().get()) {
                page = ProfileViewerPage.NO_SKYBLOCK;
            }
        }
        if (profile != null && profileName == null && profile.getLatestProfileName() != null) {
            profileName = profile.getLatestProfileName();
        }
        this.sizeX = 431;
        this.sizeY = 202;
        guiLeft = (this.field_146294_l - this.sizeX) / 2;
        guiTop = (this.field_146295_m - this.sizeY) / 2;
        SkyblockProfiles.SkyblockProfile skyblockProfile = selectedProfile = profile != null ? profile.getProfile(profileName) : null;
        if (NotEnoughUpdates.INSTANCE.config.profileViewer.alwaysShowBingoTab) {
            this.showBingoPage = true;
        } else {
            boolean bl = this.showBingoPage = selectedProfile != null && selectedProfile.getGamemode() != null && selectedProfile.getGamemode().equals("bingo");
        }
        if (!this.showBingoPage && currentPage == ProfileViewerPage.BINGO) {
            currentPage = ProfileViewerPage.BASIC;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_146276_q_();
        this.blurBackground();
        this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, guiLeft + 2, guiTop + 2, this.sizeX - 4, this.sizeY - 4);
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        this.renderTabs(true);
        this.renderRecentPlayers(true);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
        this.renderTabs(false);
        this.renderRecentPlayers(false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_bg);
        Utils.drawTexturedRect(guiLeft, guiTop, this.sizeX, this.sizeY, 9728);
        if (page != ProfileViewerPage.LOADING) {
            this.playerNameTextField.render(guiLeft + this.sizeX - 100, guiTop + this.sizeY + 5);
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            if (profile != null) {
                this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, guiLeft + 2, guiTop + this.sizeY + 3 + 2, 96, 16);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_dropdown);
                Utils.drawTexturedRect(guiLeft, guiTop + this.sizeY + 3, 100.0f, 20.0f, 0.0f, 0.5f, 0.0f, 0.10810811f, 9728);
                Utils.drawStringCenteredScaledMaxWidth(profileName, guiLeft + 50, guiTop + this.sizeY + 3 + 10, true, 90, new Color(63, 224, 208, 255).getRGB());
                if (selectedProfile != null && selectedProfile.getGamemode() != null) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ResourceLocation gamemodeIcon = gamemodeToIcon.getOrDefault(selectedProfile.getGamemode(), gamemodeIconUnknown);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(gamemodeIcon);
                    Utils.drawTexturedRect(guiLeft - 16 - 5, guiTop + this.sizeY + 5, 16.0f, 16.0f, 9728);
                }
                this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, guiLeft + 100 + 6 + 2, guiTop + this.sizeY + 3 + 2, 96, 16);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_dropdown);
                Utils.drawTexturedRect(guiLeft + 100 + 6, guiTop + this.sizeY + 3, 100.0f, 20.0f, 0.0f, 0.5f, 0.0f, 0.10810811f, 9728);
                Utils.drawStringCenteredScaledMaxWidth("Open in SkyCrypt", guiLeft + 50 + 100 + 6, guiTop + this.sizeY + 3 + 10, true, 90, new Color(63, 224, 208, 255).getRGB());
                if (this.profileDropdownSelected && !profile.getProfileNames().isEmpty() && scaledResolution.func_78325_e() < 4) {
                    int dropdownOptionSize = scaledResolution.func_78325_e() == 3 ? 10 : 20;
                    int sizeYDropdown = profile.getProfileNames().size() * dropdownOptionSize;
                    this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, guiLeft + 2, guiTop + this.sizeY + 23, 96, sizeYDropdown - 2);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_dropdown);
                    Utils.drawTexturedRect(guiLeft, guiTop + this.sizeY + 23 - 3, 100.0f, 3.0f, 0.5f, 1.0f, 0.0f, 0.016216217f, 9728);
                    Utils.drawTexturedRect(guiLeft, guiTop + this.sizeY + 23 + sizeYDropdown - 4, 100.0f, 4.0f, 0.5f, 1.0f, 0.97837836f, 1.0f, 9728);
                    Utils.drawTexturedRect(guiLeft, guiTop + this.sizeY + 23, 100.0f, sizeYDropdown - 4, 0.5f, 1.0f, (float)(181 - sizeYDropdown) / 185.0f, 0.97837836f, 9728);
                    for (int yIndex = 0; yIndex < profile.getProfileNames().size(); ++yIndex) {
                        String otherProfileName = profile.getProfileNames().get(yIndex);
                        selectedProfile = profile.getProfile(otherProfileName);
                        Utils.drawStringCenteredScaledMaxWidth(otherProfileName, guiLeft + 50, (float)(guiTop + this.sizeY + 23) + (float)dropdownOptionSize / 2.0f + (float)(dropdownOptionSize * yIndex), true, 90, new Color(33, 112, 104, 255).getRGB());
                        if (selectedProfile == null || selectedProfile.getGamemode() == null) continue;
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        ResourceLocation gamemodeIcon = gamemodeToIcon.getOrDefault(selectedProfile.getGamemode(), gamemodeIconUnknown);
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(gamemodeIcon);
                        Utils.drawTexturedRect(guiLeft - 16 - 5, guiTop + this.sizeY + 2 + 23 + dropdownOptionSize * yIndex, 16.0f, 16.0f, 9728);
                    }
                }
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.pages.containsKey((Object)page)) {
            try {
                this.pages.get((Object)page).drawPage(mouseX, mouseY, partialTicks);
            }
            catch (Exception ex) {
                if (page == ProfileViewerPage.CRASH_RECOVERY) {
                    throw ex;
                }
                this.pages.put(ProfileViewerPage.CRASH_RECOVERY, new CrashRecoveryPage(this, ex, currentPage));
                currentPage = ProfileViewerPage.CRASH_RECOVERY;
            }
        } else {
            switch (page) {
                case LOADING: {
                    String str = EnumChatFormatting.YELLOW + "Loading player profiles.";
                    long currentTimeMod = System.currentTimeMillis() % 1000L;
                    if (currentTimeMod > 333L) {
                        str = currentTimeMod < 666L ? str + "." : str + "..";
                    }
                    Utils.drawStringCentered(str, (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 101), true, 0);
                    long timeDiff = System.currentTimeMillis() - this.startTime;
                    UrsaClient.AuthenticationState authState = NotEnoughUpdates.INSTANCE.manager.ursaClient.getAuthenticationState();
                    if (NotEnoughUpdates.INSTANCE.manager.ursaClient.hasNonStandardUrsa()) {
                        Utils.drawStringCentered(EnumChatFormatting.RED + "Looks like you are using a non standard NEU server.", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 111), true, 0);
                        Utils.drawStringCentered("\u00a7cPlease change your ursa server to the default (empty value) in \u00a7a/neu ursa\u00a7c.", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 121), true, 0);
                        break;
                    }
                    if (authState == UrsaClient.AuthenticationState.FAILED_TO_JOINSERVER) {
                        Utils.drawStringCentered(EnumChatFormatting.RED + "Looks like we cannot authenticate with Mojang.", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 111), true, 0);
                        Utils.drawStringCentered(EnumChatFormatting.RED + "Is your game open for more than 24 hours?", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 121), true, 0);
                        break;
                    }
                    if (authState == UrsaClient.AuthenticationState.REJECTED) {
                        Utils.drawStringCentered(EnumChatFormatting.RED + "Looks like we cannot authenticate with Ursa.", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 111), true, 0);
                        Utils.drawStringCentered(EnumChatFormatting.RED + "Is your game open for more than 24 hours?", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 121), true, 0);
                        break;
                    }
                    if (timeDiff <= 20000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Its taking a while...", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 111), true, 0);
                    Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Might be hypixel's fault.", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 121), true, 0);
                    if (timeDiff <= 60000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Might be our fault :/.", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 131), true, 0);
                    if (timeDiff <= 180000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Wow you're still here?", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 141), true, 0);
                    if (timeDiff <= 360000L) break;
                    long second = timeDiff / 1000L % 60L;
                    long minute = timeDiff / 60000L % 60L;
                    long hour = timeDiff / 3600000L % 24L;
                    String time = String.format("%02d:%02d:%02d", hour, minute, second);
                    Utils.drawStringCentered(EnumChatFormatting.YELLOW + "You've wasted your time here for: " + time, (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 151), true, 0);
                    Utils.drawStringCentered(EnumChatFormatting.YELLOW + String.valueOf(EnumChatFormatting.BOLD) + "What are you doing with your life?", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 161), true, 0);
                    if (timeDiff <= 600000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.RED + String.valueOf(EnumChatFormatting.BOLD) + "Maniac", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 171), true, 0);
                    if (timeDiff <= 1200000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.RED + String.valueOf(EnumChatFormatting.BOLD) + "You're a menace to society", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 181), true, 0);
                    if (timeDiff <= 1800000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.RED + String.valueOf(EnumChatFormatting.BOLD) + "You don't know what's gonna happen to you", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 191), true, 0);
                    if (timeDiff <= 3000000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.RED + String.valueOf(EnumChatFormatting.BOLD) + "You really want this?", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 91), true, 0);
                    if (timeDiff <= 3300000L) break;
                    Utils.drawStringCentered(EnumChatFormatting.DARK_RED + String.valueOf(EnumChatFormatting.BOLD) + "OW LORD FORGIVE ME FOR THIS", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 71), true, 0);
                    if (timeDiff <= 3600000L) break;
                    throw new Error("Go do something productive"){

                        @Override
                        public void printStackTrace() {
                            throw new Error("Go do something productive");
                        }
                    };
                }
                case INVALID_NAME: {
                    Utils.drawStringCentered(EnumChatFormatting.RED + "Invalid name or API is down!", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 101), true, 0);
                    break;
                }
                case NO_SKYBLOCK: {
                    Utils.drawStringCentered(EnumChatFormatting.RED + "No SkyBlock data found!", (float)guiLeft + (float)this.sizeX / 2.0f, (float)(guiTop + 101), true, 0);
                }
            }
        }
        this.lastTime = this.currentTime;
        if (currentPage != ProfileViewerPage.LOADING && currentPage != ProfileViewerPage.INVALID_NAME) {
            int ignoredTabs = 0;
            List<Integer> configList = NotEnoughUpdates.INSTANCE.config.profileViewer.pageLayout;
            for (int i = 0; i < configList.size(); ++i) {
                ProfileViewerPage iPage = ProfileViewerPage.getById(configList.get(i));
                if (iPage == null) continue;
                if (iPage.stack == null || iPage == ProfileViewerPage.BINGO && !this.showBingoPage) {
                    ++ignoredTabs;
                    continue;
                }
                int i2 = i - ignoredTabs;
                int x = guiLeft + i2 * 28;
                int y = guiTop - 28;
                if (mouseX <= x || mouseX >= x + 28 || mouseY <= y || mouseY >= y + 32 || iPage.stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false).isEmpty()) continue;
                this.tooltipToDisplay = Collections.singletonList(iPage.stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false).get(0));
            }
        }
        int x = guiLeft + this.sizeX;
        int y = guiTop;
        ArrayList<String> previousProfileSearches = NotEnoughUpdates.INSTANCE.config.hidden.previousProfileSearches;
        if (mouseX > x && mouseX < x + 29 && mouseY > y && mouseY < y + 28) {
            this.tooltipToDisplay = new ArrayList<String>();
            this.tooltipToDisplay.add(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        }
        for (int i = 0; i < previousProfileSearches.size(); ++i) {
            if (mouseX <= x || mouseX >= x + 28 || mouseY <= y + 28 * (i + 1) || mouseY >= y + 28 * (i + 2)) continue;
            this.tooltipToDisplay = new ArrayList<String>();
            this.tooltipToDisplay.add((String)previousProfileSearches.get(i));
        }
        if (this.tooltipToDisplay != null) {
            ArrayList<String> grayTooltip = new ArrayList<String>(this.tooltipToDisplay.size());
            for (String line : this.tooltipToDisplay) {
                grayTooltip.add(EnumChatFormatting.GRAY + line);
            }
            Utils.drawHoveringText(grayTooltip, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
            this.tooltipToDisplay = null;
        }
    }

    private void renderTabs(boolean renderPressed) {
        int ignoredTabs = 0;
        List<Integer> configList = NotEnoughUpdates.INSTANCE.config.profileViewer.pageLayout;
        for (int i = 0; i < configList.size(); ++i) {
            boolean pressed;
            ProfileViewerPage page = ProfileViewerPage.getById(configList.get(i));
            if (page == null) continue;
            if (page.stack == null || page == ProfileViewerPage.BINGO && !this.showBingoPage) {
                ++ignoredTabs;
                continue;
            }
            boolean bl = pressed = page == currentPage;
            if (pressed != renderPressed) continue;
            this.renderTab(page.stack, i - ignoredTabs, pressed);
        }
    }

    private void renderTab(ItemStack stack, int xIndex, boolean pressed) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        int x = guiLeft + xIndex * 28;
        int y = guiTop - 28;
        float uMin = 0.0f;
        float uMax = 0.109375f;
        float vMin = 0.078125f;
        float vMax = 0.19921875f;
        if (pressed) {
            vMin = 0.203125f;
            vMax = 0.328125f;
            if (xIndex != 0) {
                uMin = 0.109375f;
                uMax = 0.21875f;
            }
            this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, x + 2, y + 2, 24, 24);
        } else {
            this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, x + 2, y + 4, 24, 24);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_elements);
        Utils.drawTexturedRect(x, y, 28.0f, pressed ? 32.0f : 31.0f, uMin, uMax, vMin, vMax, 9728);
        GlStateManager.func_179126_j();
        Utils.drawItemStack(stack, x + 6, y + 9);
    }

    public static String getDisplayName() {
        return Utils.getElementOrDefault(profile.getHypixelProfile(), "displayname", new JsonPrimitive(EnumChatFormatting.RED + "ERROR")).getAsString();
    }

    private void renderRecentPlayers(boolean renderCurrent) {
        String playerName = GuiProfileViewer.getDisplayName();
        boolean selected = Objects.equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), playerName);
        if (selected == renderCurrent) {
            this.renderRecentPlayer(Minecraft.func_71410_x().field_71439_g.func_70005_c_().toLowerCase(Locale.ROOT), 0, selected);
        }
        ArrayList<String> previousProfileSearches = NotEnoughUpdates.INSTANCE.config.hidden.previousProfileSearches;
        for (int i = 0; i < previousProfileSearches.size(); ++i) {
            selected = Objects.equals(previousProfileSearches.get(i), playerName.toLowerCase(Locale.ROOT));
            if (selected != renderCurrent) continue;
            this.renderRecentPlayer((String)previousProfileSearches.get(i), i + 1, selected);
        }
    }

    private void renderRecentPlayer(String name, int yIndex, boolean selected) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        int x = guiLeft + this.sizeX;
        int y = guiTop + yIndex * 28;
        float uMin = 0.8828125f;
        float uMax = 1.0f;
        float vMin = 0.5625f;
        float vMax = 0.671875f;
        if (yIndex != 0) {
            vMin = 0.671875f;
            vMax = 0.78125f;
        }
        if (selected) {
            uMin = 0.765625f;
            uMax = 0.8828125f;
            this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, x - 2, y + 2, 28, 24);
        } else {
            this.renderBlurredBackground(this.field_146294_l, this.field_146295_m, x, y + 2, 26, 24);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_elements);
        Utils.drawTexturedRect(x - 3, y, 32.0f, 28.0f, uMin, uMax, vMin, vMax, 9728);
        GlStateManager.func_179126_j();
        ItemStack playerHead = ProfileViewerUtils.getPlayerData(name);
        Utils.drawItemStack(playerHead, x + 3, y + 6);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (currentPage != ProfileViewerPage.LOADING && currentPage != ProfileViewerPage.INVALID_NAME) {
            int ignoredTabs = 0;
            List<Integer> configList = NotEnoughUpdates.INSTANCE.config.profileViewer.pageLayout;
            for (int i = 0; i < configList.size(); ++i) {
                ProfileViewerPage page = ProfileViewerPage.getById(configList.get(i));
                if (page == null) continue;
                if (page.stack == null || page == ProfileViewerPage.BINGO && !this.showBingoPage) {
                    ++ignoredTabs;
                    continue;
                }
                int i2 = i - ignoredTabs;
                int x = guiLeft + i2 * 28;
                int y = guiTop - 28;
                if (mouseX <= x || mouseX >= x + 28 || mouseY <= y || mouseY >= y + 32) continue;
                if (currentPage != page) {
                    Utils.playPressSound();
                }
                currentPage = page;
                onSecondPage = false;
                this.inventoryTextField.otherComponentClick();
                this.playerNameTextField.otherComponentClick();
                this.killDeathSearchTextField.otherComponentClick();
                this.museumTextField.otherComponentClick();
                return;
            }
        }
        if (this.pages.containsKey((Object)currentPage)) {
            try {
                if (this.pages.get((Object)currentPage).mouseClicked(mouseX, mouseY, mouseButton)) {
                    return;
                }
            }
            catch (Exception ex) {
                if (currentPage == ProfileViewerPage.CRASH_RECOVERY) {
                    throw ex;
                }
                this.pages.put(ProfileViewerPage.CRASH_RECOVERY, new CrashRecoveryPage(this, ex, currentPage));
                currentPage = ProfileViewerPage.CRASH_RECOVERY;
            }
        }
        String playerName = GuiProfileViewer.getDisplayName();
        int x = guiLeft + this.sizeX;
        int y = guiTop;
        ArrayList<String> previousProfileSearches = NotEnoughUpdates.INSTANCE.config.hidden.previousProfileSearches;
        if (mouseX > x && mouseX < x + 29 && mouseY > y && mouseY < y + 28 && !playerName.equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_().toLowerCase(Locale.ROOT))) {
            NotEnoughUpdates.profileViewer.loadPlayerByName(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), profile -> {
                profile.resetCache();
                NotEnoughUpdates.INSTANCE.openGui = new GuiProfileViewer((SkyblockProfiles)profile);
            });
        }
        previousProfileSearches.removeIf(Objects::isNull);
        for (int i = 0; i < previousProfileSearches.size(); ++i) {
            if (mouseX <= x || mouseX >= x + 28 || mouseY <= y + 28 * (i + 1) || mouseY >= y + 28 * (i + 2) || playerName.equals(previousProfileSearches.get(i))) continue;
            NotEnoughUpdates.profileViewer.loadPlayerByName((String)previousProfileSearches.get(i), profile -> {
                profile.resetCache();
                NotEnoughUpdates.INSTANCE.openGui = new GuiProfileViewer((SkyblockProfiles)profile);
            });
        }
        if (mouseX > guiLeft + this.sizeX - 100 && mouseX < guiLeft + this.sizeX && mouseY > guiTop + this.sizeY + 5 && mouseY < guiTop + this.sizeY + 25) {
            this.playerNameTextField.mouseClicked(mouseX, mouseY, mouseButton);
            this.inventoryTextField.otherComponentClick();
            this.killDeathSearchTextField.otherComponentClick();
            this.museumTextField.otherComponentClick();
            return;
        }
        if (mouseX > guiLeft + 106 && mouseX < guiLeft + 106 + 100 && GuiProfileViewer.profile != null && !GuiProfileViewer.profile.getProfileNames().isEmpty() && profileName != null && mouseY > guiTop + this.sizeY + 3 && mouseY < guiTop + this.sizeY + 23) {
            String url = "https://sky.shiiyu.moe/stats/" + GuiProfileViewer.getDisplayName() + "/" + profileName;
            Utils.openUrl(url);
            Utils.playPressSound();
            return;
        }
        if (mouseX > guiLeft && mouseX < guiLeft + 100 && GuiProfileViewer.profile != null && !GuiProfileViewer.profile.getProfileNames().isEmpty()) {
            int dropdownOptionSize;
            int extraY;
            int index;
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            if (mouseY > guiTop + this.sizeY + 3 && mouseY < guiTop + this.sizeY + 23) {
                if (scaledResolution.func_78325_e() >= 4) {
                    this.profileDropdownSelected = false;
                    int profileNum = 0;
                    for (int index2 = 0; index2 < GuiProfileViewer.profile.getProfileNames().size(); ++index2) {
                        if (!GuiProfileViewer.profile.getProfileNames().get(index2).equals(profileName)) continue;
                        profileNum = index2;
                        break;
                    }
                    profileNum = mouseButton == 0 ? ++profileNum : --profileNum;
                    if (profileNum >= GuiProfileViewer.profile.getProfileNames().size()) {
                        profileNum = 0;
                    }
                    if (profileNum < 0) {
                        profileNum = GuiProfileViewer.profile.getProfileNames().size() - 1;
                    }
                    String newProfileName = GuiProfileViewer.profile.getProfileNames().get(profileNum);
                    if (profileName != null && !profileName.equals(newProfileName)) {
                        this.resetCache();
                    }
                    profileName = newProfileName;
                } else {
                    this.profileDropdownSelected = !this.profileDropdownSelected;
                }
            } else if (scaledResolution.func_78325_e() < 4 && this.profileDropdownSelected && (index = (extraY = mouseY - (guiTop + this.sizeY + 23)) / (dropdownOptionSize = scaledResolution.func_78325_e() == 3 ? 10 : 20)) >= 0 && index < GuiProfileViewer.profile.getProfileNames().size()) {
                String newProfileName = GuiProfileViewer.profile.getProfileNames().get(index);
                if (profileName != null && !profileName.equals(newProfileName)) {
                    this.resetCache();
                }
                profileName = newProfileName;
            }
            this.playerNameTextField.otherComponentClick();
            this.inventoryTextField.otherComponentClick();
            this.killDeathSearchTextField.otherComponentClick();
            this.museumTextField.otherComponentClick();
            return;
        }
        this.profileDropdownSelected = false;
        this.playerNameTextField.otherComponentClick();
        this.inventoryTextField.otherComponentClick();
        this.killDeathSearchTextField.otherComponentClick();
        this.museumTextField.otherComponentClick();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.pages.containsKey((Object)currentPage)) {
            try {
                this.pages.get((Object)currentPage).keyTyped(typedChar, keyCode);
            }
            catch (Exception ex) {
                if (currentPage == ProfileViewerPage.CRASH_RECOVERY) {
                    throw ex;
                }
                this.pages.put(ProfileViewerPage.CRASH_RECOVERY, new CrashRecoveryPage(this, ex, currentPage));
                currentPage = ProfileViewerPage.CRASH_RECOVERY;
            }
        }
        if (this.playerNameTextField.getFocus()) {
            if (keyCode == 28) {
                String name = this.playerNameTextField.getText();
                currentPage = ProfileViewerPage.LOADING;
                NotEnoughUpdates.profileViewer.loadPlayerByName(this.playerNameTextField.getText(), profile -> {
                    if (profile != null) {
                        profile.resetCache();
                        ProfileViewerUtils.saveSearch(name);
                    }
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiProfileViewer((SkyblockProfiles)profile));
                });
            }
            this.playerNameTextField.keyTyped(typedChar, keyCode);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        if (this.pages.containsKey((Object)currentPage)) {
            this.pages.get((Object)currentPage).mouseReleased(mouseX, mouseY, mouseButton);
        }
    }

    public void renderXpBar(String skillName, ItemStack stack, int x, int y, int xSize, ProfileViewer.Level levelObj, int mouseX, int mouseY) {
        float level = levelObj.level;
        int levelFloored = (int)Math.floor(level);
        Utils.renderAlignedString(skillName, EnumChatFormatting.WHITE.toString() + levelFloored, x + 14, y - 4, xSize - 20);
        if (levelObj.maxed) {
            this.renderGoldBar(x, y + 6, xSize);
        } else if ((skillName.contains("Catacombs") || Weight.DUNGEON_CLASS_NAMES.stream().anyMatch(e2 -> skillName.toLowerCase(Locale.ROOT).contains((CharSequence)e2))) && levelObj.level >= 50.0f) {
            this.renderGoldBar(x, y + 6, xSize);
        } else {
            this.renderBar(x, y + 6, xSize, level % 1.0f);
        }
        if (mouseX > x && mouseX < x + 120 && mouseY > y - 4 && mouseY < y + 13) {
            String levelStr;
            String totalXpStr = null;
            if (skillName.contains("Catacombs")) {
                totalXpStr = EnumChatFormatting.GRAY + "Total XP: " + EnumChatFormatting.DARK_PURPLE + StringUtils.formatNumber(Float.valueOf(levelObj.totalXp)) + EnumChatFormatting.DARK_GRAY + " (" + StringUtils.formatToTenths(Float.valueOf(this.getPercentage(skillName.toLowerCase(Locale.ROOT), levelObj))) + "% to 50)";
            }
            if (levelObj.maxed) {
                levelStr = !skillName.contains("HOTM") ? EnumChatFormatting.GOLD + "MAXED!" + EnumChatFormatting.GRAY + " (Overflow level: " + String.format("%.2f", Float.valueOf(levelObj.level)) + ")" : EnumChatFormatting.GOLD + "MAXED!";
            } else if (skillName.contains("Class Average")) {
                levelStr = "Progress: " + EnumChatFormatting.DARK_PURPLE + String.format("%.1f", Float.valueOf(level % 1.0f * 100.0f)) + "%";
                totalXpStr = "Exact Class Average: " + EnumChatFormatting.WHITE + String.format("%.2f", Float.valueOf(levelObj.level));
            } else {
                int maxXp = (int)levelObj.maxXpForLevel;
                levelStr = EnumChatFormatting.DARK_PURPLE + StringUtils.shortNumberFormat(Math.round(level % 1.0f * (float)maxXp)) + "/" + StringUtils.shortNumberFormat(maxXp) + (skillName.contains("Catacombs") && levelObj.level >= 50.0f ? EnumChatFormatting.GRAY + " (Overflow level: " + String.format("%.2f", Float.valueOf(levelObj.level)) + ")" : "");
            }
            this.tooltipToDisplay = totalXpStr != null ? Utils.createList(levelStr, totalXpStr) : Utils.createList(levelStr);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound display = new NBTTagCompound();
        display.func_74778_a("Name", skillName);
        nbt.func_74782_a("display", (NBTBase)display);
        stack.func_77982_d(nbt);
        GL11.glTranslatef((float)x, (float)((float)y - 6.0f), (float)0.0f);
        GL11.glScalef((float)0.7f, (float)0.7f, (float)1.0f);
        Utils.drawItemStackLinear(stack, 0, 0);
        GL11.glScalef((float)1.4285715f, (float)1.4285715f, (float)1.0f);
        GL11.glTranslatef((float)(-x), (float)(-((float)y - 6.0f)), (float)0.0f);
    }

    public EntityOtherPlayerMP getEntityPlayer() {
        return ((BasicPage)this.pages.get((Object)((Object)ProfileViewerPage.BASIC))).entityPlayer;
    }

    public void renderGoldBar(float x, float y, float xSize) {
        if (!OpenGlHelper.func_153193_b()) {
            this.renderBar(x, y, xSize, 1.0f);
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icons);
        ShaderManager shaderManager = ShaderManager.getInstance();
        shaderManager.loadShader("make_gold");
        shaderManager.loadData("make_gold", "amount", Float.valueOf((float)(this.startTime - System.currentTimeMillis()) / 10000.0f));
        Utils.drawTexturedRect(x, y, xSize / 2.0f, 5.0f, 0.0f, xSize / 2.0f / 256.0f, 0.30859375f, 0.328125f, 9728);
        Utils.drawTexturedRect(x + xSize / 2.0f, y, xSize / 2.0f, 5.0f, (182.0f - xSize / 2.0f) / 256.0f, 0.7109375f, 0.30859375f, 0.328125f, 9728);
        GL20.glUseProgram((int)0);
    }

    public void renderBar(float x, float y, float xSize, float completed) {
        float width;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icons);
        completed = (float)Math.round(completed / 0.05f) * 0.05f;
        float notCompleted = 1.0f - completed;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (completed < 0.5f) {
            width = (0.5f - completed) * xSize;
            Utils.drawTexturedRect(x + xSize * completed, y, width, 5.0f, xSize * completed / 256.0f, xSize / 2.0f / 256.0f, 0.2890625f, 0.30859375f, 9728);
        }
        if (completed < 1.0f) {
            width = Math.min(xSize * notCompleted, xSize / 2.0f);
            Utils.drawTexturedRect(x + xSize / 2.0f + Math.max(xSize * (completed - 0.5f), 0.0f), y, width, 5.0f, (182.0f - xSize / 2.0f + Math.max(xSize * (completed - 0.5f), 0.0f)) / 256.0f, 0.7109375f, 0.2890625f, 0.30859375f, 9728);
        }
        if (completed > 0.0f) {
            width = Math.min(xSize * completed, xSize / 2.0f);
            Utils.drawTexturedRect(x, y, width, 5.0f, 0.0f, width / 256.0f, 0.30859375f, 0.328125f, 9728);
        }
        if (completed > 0.5f) {
            width = Math.min(xSize * (completed - 0.5f), xSize / 2.0f);
            Utils.drawTexturedRect(x + xSize / 2.0f, y, width, 5.0f, (182.0f - xSize / 2.0f) / 256.0f, (182.0f - xSize / 2.0f + width) / 256.0f, 0.30859375f, 0.328125f, 9728);
        }
    }

    public void resetCache() {
        this.pages.values().forEach(GuiProfileViewerPage::resetCache);
    }

    private net.minecraft.util.Matrix4f createProjectionMatrix(int width, int height) {
        net.minecraft.util.Matrix4f projMatrix = new net.minecraft.util.Matrix4f();
        projMatrix.setIdentity();
        projMatrix.m00 = 2.0f / (float)width;
        projMatrix.m11 = 2.0f / (float)(-height);
        projMatrix.m22 = -0.0020001999f;
        projMatrix.m33 = 1.0f;
        projMatrix.m03 = -1.0f;
        projMatrix.m13 = 1.0f;
        projMatrix.m23 = -1.0001999f;
        return projMatrix;
    }

    private void blurBackground() {
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        if (this.blurOutputHorz == null) {
            this.blurOutputHorz = new Framebuffer(width, height, false);
            this.blurOutputHorz.func_147607_a(9728);
        }
        if (this.blurOutputVert == null) {
            this.blurOutputVert = new Framebuffer(width, height, false);
            this.blurOutputVert.func_147607_a(9728);
        }
        if (this.blurOutputHorz.field_147621_c != width || this.blurOutputHorz.field_147618_d != height) {
            this.blurOutputHorz.func_147613_a(width, height);
            this.blurShaderHorz.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (this.blurOutputVert.field_147621_c != width || this.blurOutputVert.field_147618_d != height) {
            this.blurOutputVert.func_147613_a(width, height);
            this.blurShaderVert.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (this.blurShaderHorz == null) {
            try {
                this.blurShaderHorz = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", Minecraft.func_71410_x().func_147110_a(), this.blurOutputHorz);
                this.blurShaderHorz.func_148043_c().func_147991_a("BlurDir").func_148087_a(1.0f, 0.0f);
                this.blurShaderHorz.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.blurShaderVert == null) {
            try {
                this.blurShaderVert = new Shader(Minecraft.func_71410_x().func_110442_L(), "blur", this.blurOutputHorz, this.blurOutputVert);
                this.blurShaderVert.func_148043_c().func_147991_a("BlurDir").func_148087_a(0.0f, 1.0f);
                this.blurShaderVert.func_148045_a((Matrix4f)this.createProjectionMatrix(width, height));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.blurShaderHorz != null && this.blurShaderVert != null) {
            if (15.0 != this.lastBgBlurFactor) {
                this.blurShaderHorz.func_148043_c().func_147991_a("Radius").func_148090_a(15.0f);
                this.blurShaderVert.func_148043_c().func_147991_a("Radius").func_148090_a(15.0f);
                this.lastBgBlurFactor = 15.0;
            }
            GL11.glPushMatrix();
            this.blurShaderHorz.func_148042_a(0.0f);
            this.blurShaderVert.func_148042_a(0.0f);
            GlStateManager.func_179126_j();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    }

    public float getPercentage(String skillName, ProfileViewer.Level level) {
        if (level.maxed) {
            return 100.0f;
        }
        if (skillName.contains("catacombs")) {
            return level.totalXp / 5.6980966E8f * 100.0f;
        }
        if (skillName.equalsIgnoreCase("vampire")) {
            return level.totalXp / 2400.0f * 100.0f;
        }
        if (Weight.SLAYER_NAMES.contains(skillName)) {
            return level.totalXp / 1000000.0f * 100.0f;
        }
        if (skillName.equalsIgnoreCase("social")) {
            return level.totalXp / 272800.0f * 100.0f;
        }
        if (skillName.equalsIgnoreCase("garden")) {
            return level.totalXp / 60120.0f * 100.0f;
        }
        if (level.maxLevel == 60) {
            return level.totalXp / 1.11672424E8f * 100.0f;
        }
        return level.totalXp / 5.5172424E7f * 100.0f;
    }

    public void renderBlurredBackground(int width, int height, int x, int y, int blurWidth, int blurHeight) {
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        float uMin = (float)x / (float)width;
        float uMax = (float)(x + blurWidth) / (float)width;
        float vMin = (float)(height - y) / (float)height;
        float vMax = (float)(height - y - blurHeight) / (float)height;
        this.blurOutputVert.func_147612_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(x, y, blurWidth, blurHeight, uMin, uMax, vMin, vMax);
        this.blurOutputVert.func_147606_d();
    }

    static {
        profileName = null;
        pronouns = AsyncDependencyLoader.withEqualsInvocation(() -> NotEnoughUpdates.INSTANCE.config.profileViewer.showPronounsInPv ? Optional.ofNullable(profile).map(it -> Utils.parseDashlessUUID(it.getUuid())) : Optional.empty(), uuid -> uuid.isPresent() ? PronounDB.getPronounsFor((UUID)uuid.get()) : CompletableFuture.completedFuture(Optional.empty()));
    }

    public static enum ProfileViewerPage {
        LOADING,
        INVALID_NAME,
        NO_SKYBLOCK,
        CRASH_RECOVERY,
        BASIC(0, Items.field_151121_aF, "\u00a79Skills"),
        DUNGEON(1, Item.func_150898_a((Block)Blocks.field_150330_I), "\u00a7eDungeoneering"),
        EXTRA(2, Items.field_151122_aG, "\u00a77Profile Stats"),
        INVENTORIES(3, Item.func_150898_a((Block)Blocks.field_150477_bB), "\u00a7bStorage"),
        COLLECTIONS(4, Items.field_151159_an, "\u00a76Collections"),
        PETS(5, Items.field_151103_aS, "\u00a7aPets"),
        MINING(6, Items.field_151035_b, "\u00a75Heart of the Mountain"),
        BINGO(7, (Item)Items.field_151098_aY, "\u00a7zBingo"),
        TROPHY_FISH(8, (Item)Items.field_151112_aM, "\u00a73Trophy Fish"),
        BESTIARY(9, Items.field_151040_l, "\u00a7cBestiary"),
        CRIMSON_ISLE(10, Item.func_150898_a((Block)Blocks.field_150424_aL), "\u00a74Crimson Isle"),
        MUSEUM(11, (Item)Items.field_151027_R, "\u00a76Museum"),
        RIFT(12, Items.field_151061_bv, "\u00a75Rift"),
        GARDEN(13, Item.func_150898_a((Block)Blocks.field_150349_c), "\u00a72Garden");

        public final ItemStack stack;
        public final int id;

        private ProfileViewerPage() {
            this(-1, null, null);
        }

        private ProfileViewerPage(int id, Item item, String name) {
            this.id = id;
            if (item == null) {
                this.stack = null;
            } else {
                this.stack = new ItemStack(item);
                NBTTagCompound nbt = new NBTTagCompound();
                NBTTagCompound display = new NBTTagCompound();
                display.func_74778_a("Name", name);
                nbt.func_74782_a("display", (NBTBase)display);
                this.stack.func_77982_d(nbt);
            }
        }

        public static ProfileViewerPage getById(int id) {
            for (ProfileViewerPage page : ProfileViewerPage.values()) {
                if (page.id != id) continue;
                return page;
            }
            return null;
        }

        public boolean isTransient() {
            return this == LOADING || this == NO_SKYBLOCK || this == INVALID_NAME || this == CRASH_RECOVERY;
        }

        public Optional<ItemStack> getItem() {
            return Optional.ofNullable(this.stack);
        }
    }
}

