/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementTextField;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;

public class DungeonPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_dung = new ResourceLocation("notenoughupdates:pv_dung.png");
    private static final ItemStack DEADBUSH = new ItemStack(Item.func_150898_a((Block)Blocks.field_150330_I));
    private static final ItemStack[] BOSS_HEADS = new ItemStack[7];
    private static final Map<String, ItemStack> classToIcon = new HashMap<String, ItemStack>(){
        {
            this.put("healer", new ItemStack((Item)Items.field_151068_bn, 1, 16389));
            this.put("mage", new ItemStack(Items.field_151072_bj));
            this.put("berserk", new ItemStack(Items.field_151040_l));
            this.put("archer", new ItemStack((Item)Items.field_151031_f));
            this.put("tank", new ItemStack((Item)Items.field_151027_R));
        }
    };
    private static final String[] bossFloorArr = new String[]{"Bonzo", "Scarf", "Professor", "Thorn", "Livid", "Sadan", "Necron"};
    private static final String[] bossFloorHeads = new String[]{"12716ecbf5b8da00b05f316ec6af61e8bd02805b21eb8e440151468dc656549c", "7de7bbbdf22bfe17980d4e20687e386f11d59ee1db6f8b4762391b79a5ac532d", "9971cee8b833a62fc2a612f3503437fdf93cad692d216b8cf90bbb0538c47dd8", "8b6a72138d69fbbd2fea3fa251cabd87152e4f1c97e5f986bf685571db3cc0", "c1007c5b7114abec734206d4fc613da4f3a0e99f71ff949cedadc99079135a0b", "fa06cb0c471c1c9bc169af270cd466ea701946776056e472ecdaeb49f0f4a4dc", "a435164c05cea299a3f016bbbed05706ebb720dac912ce4351c2296626aecd9a"};
    private static final LinkedHashMap<String, ItemStack> pageModeIcon = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("catacombs", Utils.editItemStackInfo(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("DUNGEON_STONE")), EnumChatFormatting.GRAY + "Normal Mode", true, new String[0]));
            this.put("master_catacombs", Utils.editItemStackInfo(NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("MASTER_SKULL_TIER_7")), EnumChatFormatting.GRAY + "Master Mode", true, new String[0]));
        }
    };
    private static int floorTime = 7;
    private final GuiElementTextField dungeonLevelTextField = new GuiElementTextField("", 32);
    private int floorLevelTo = -1;
    private long floorLevelToXP = -1L;

    public DungeonPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_dung);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        JsonObject leveling = Constants.LEVELING;
        if (leveling == null) {
            return;
        }
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        Map<String, ProfileViewer.Level> levelingInfo = selectedProfile.getLevelingInfo();
        if (levelingInfo == null) {
            return;
        }
        JsonObject profileInfo2 = selectedProfile.getProfileJson();
        JsonObject hypixelInfo = GuiProfileViewer.getProfile().getHypixelProfile();
        int sectionWidth = 110;
        boolean onMasterMode = GuiProfileViewer.onSecondPage;
        String dungeonString = onMasterMode ? "master_catacombs" : "catacombs";
        Utils.renderShadowedString(EnumChatFormatting.RED + (onMasterMode ? "Master Mode" : "Catacombs"), guiLeft + this.getInstance().sizeX / 2, guiTop + 5, sectionWidth);
        ProfileViewer.Level levelObjCata = levelingInfo.get("cosmetic_catacombs");
        String skillName = EnumChatFormatting.RED + "Catacombs";
        float level = levelObjCata.level;
        int levelFloored = (int)Math.floor(level);
        if (this.floorLevelTo == -1 && levelFloored >= 0) {
            this.dungeonLevelTextField.setText(String.valueOf(levelFloored + 1));
            this.calculateFloorLevelXP();
        }
        int x = guiLeft + 23;
        int y = guiTop + 25;
        this.getInstance().renderXpBar(skillName, DEADBUSH, x, y, sectionWidth, levelObjCata, mouseX, mouseY);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Until Cata " + this.floorLevelTo + ": ", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(this.floorLevelToXP), x, y + 16, sectionWidth);
        if (mouseX > x && mouseX < x + sectionWidth && mouseY > y + 16 && mouseY < y + 24 && !onMasterMode) {
            float F5 = Utils.getElementAsFloat(Utils.getElement(profileInfo2, "dungeons.dungeon_types.catacombs.tier_completions.5"), 0.0f);
            float F6 = Utils.getElementAsFloat(Utils.getElement(profileInfo2, "dungeons.dungeon_types.catacombs.tier_completions.6"), 0.0f);
            float F7 = Utils.getElementAsFloat(Utils.getElement(profileInfo2, "dungeons.dungeon_types.catacombs.tier_completions.7"), 0.0f);
            if (F5 > 150.0f) {
                F5 = 150.0f;
            }
            if (F6 > 100.0f) {
                F6 = 100.0f;
            }
            if (F7 > 50.0f) {
                F7 = 50.0f;
            }
            float xpF5 = 2400.0f * (F5 / 100.0f + 1.0f);
            float xpF6 = 4880.0f * (F6 / 100.0f + 1.0f);
            float xpF7 = 28000.0f * (F7 / 100.0f + 1.0f);
            if (!Keyboard.isKeyDown((int)42)) {
                xpF5 = (float)((double)xpF5 * 1.1);
                xpF6 = (float)((double)xpF6 * 1.1);
                xpF7 = (float)((double)xpF7 * 1.1);
            }
            long runsF5 = (int)Math.ceil((float)this.floorLevelToXP / xpF5);
            long runsF6 = (int)Math.ceil((float)this.floorLevelToXP / xpF6);
            long runsF7 = (int)Math.ceil((float)this.floorLevelToXP / xpF7);
            float timeF5 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.catacombs.fastest_time_s_plus.5");
            float timeF6 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.catacombs.fastest_time_s_plus.6");
            float timeF7 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.catacombs.fastest_time_s_plus.7");
            this.getInstance().tooltipToDisplay = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.YELLOW + "Remaining XP: " + EnumChatFormatting.GRAY + String.format("%,d", this.floorLevelToXP), String.format("# F5 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpF5), runsF5), String.format("# F6 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpF6), runsF6), String.format("# F7 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpF7), runsF7), ""});
            boolean hasTime = false;
            hasTime = this.isHasTime(timeF5, "Expected Time (F5) : %s", runsF5, hasTime);
            hasTime = this.isHasTime(timeF6, "Expected Time (F6) : %s", runsF6, hasTime);
            if (hasTime = this.isHasTime(timeF7, "Expected Time (F7) : %s", runsF7, hasTime)) {
                this.getInstance().tooltipToDisplay.add("");
            }
            if (!Keyboard.isKeyDown((int)42)) {
                this.getInstance().tooltipToDisplay.add("[Hold " + EnumChatFormatting.YELLOW + "SHIFT" + EnumChatFormatting.GRAY + " to show without Expert Ring]");
            }
            if (Keyboard.isKeyDown((int)29)) {
                if (!Keyboard.isKeyDown((int)42)) {
                    this.getInstance().tooltipToDisplay.add("");
                }
                this.getInstance().tooltipToDisplay.add("Number of runs is calculated as [Remaining XP]/[XP per Run].");
                this.getInstance().tooltipToDisplay.add("The [XP per Run] is the average xp gained from an S+ run");
                this.getInstance().tooltipToDisplay.add("The " + EnumChatFormatting.DARK_PURPLE + "Catacombs Expert Ring" + EnumChatFormatting.GRAY + " is assumed to be used, unless " + EnumChatFormatting.YELLOW + "SHIFT" + EnumChatFormatting.GRAY + " is held.");
                this.getInstance().tooltipToDisplay.add("[Time per run] is calculated using Fastest S+ x 120%");
            } else {
                this.getInstance().tooltipToDisplay.add("[Hold " + EnumChatFormatting.YELLOW + "CTRL" + EnumChatFormatting.GRAY + " to see details]");
            }
        }
        if (mouseX > x && mouseX < x + sectionWidth && mouseY > y + 16 && mouseY < y + 24 && onMasterMode) {
            float M3 = Math.min(DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.tier_completions.3"), 50.0f);
            float M4 = Math.min(DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.tier_completions.4"), 50.0f);
            float M5 = Math.min(DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.tier_completions.5"), 50.0f);
            float M6 = Math.min(DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.tier_completions.6"), 50.0f);
            float M7 = Math.min(DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.tier_completions.7"), 50.0f);
            float xpM3 = 35000.0f * (M3 / 100.0f + 1.0f);
            float xpM4 = 55000.0f * (M4 / 100.0f + 1.0f);
            float xpM5 = 70000.0f * (M5 / 100.0f + 1.0f);
            float xpM6 = 100000.0f * (M6 / 100.0f + 1.0f);
            float xpM7 = 300000.0f * (M7 / 100.0f + 1.0f);
            if (!Keyboard.isKeyDown((int)42)) {
                xpM3 = (float)((double)xpM3 * 1.1);
                xpM4 = (float)((double)xpM4 * 1.1);
                xpM5 = (float)((double)xpM5 * 1.1);
                xpM6 = (float)((double)xpM6 * 1.1);
                xpM7 = (float)((double)xpM7 * 1.1);
            }
            long runsM3 = (int)Math.ceil((float)this.floorLevelToXP / xpM3);
            long runsM4 = (int)Math.ceil((float)this.floorLevelToXP / xpM4);
            long runsM5 = (int)Math.ceil((float)this.floorLevelToXP / xpM5);
            long runsM6 = (int)Math.ceil((float)this.floorLevelToXP / xpM6);
            long runsM7 = (int)Math.ceil((float)this.floorLevelToXP / xpM7);
            float timeM3 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.fastest_time_s_plus.3");
            float timeM4 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.fastest_time_s_plus.4");
            float timeM5 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.fastest_time_s_plus.5");
            float timeM6 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.fastest_time_s_plus.6");
            float timeM7 = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.fastest_time_s_plus.7");
            this.getInstance().tooltipToDisplay = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.YELLOW + "Remaining XP: " + EnumChatFormatting.GRAY + String.format("%,d", this.floorLevelToXP), String.format("# M3 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpM3), runsM3), String.format("# M4 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpM4), runsM4), String.format("# M5 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpM5), runsM5), String.format("# M6 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpM6), runsM6), String.format("# M7 Runs (%s xp) : %d", StringUtils.shortNumberFormat(xpM7), runsM7), ""});
            boolean hasTime = false;
            hasTime = this.isHasTime(timeM3, "Expected Time (M3) : %s", runsM3, hasTime);
            hasTime = this.isHasTime(timeM4, "Expected Time (M4) : %s", runsM4, hasTime);
            hasTime = this.isHasTime(timeM5, "Expected Time (M5) : %s", runsM5, hasTime);
            hasTime = this.isHasTime(timeM6, "Expected Time (M6) : %s", runsM6, hasTime);
            if (hasTime = this.isHasTime(timeM7, "Expected Time (M7) : %s", runsM7, hasTime)) {
                this.getInstance().tooltipToDisplay.add("");
            }
            if (!Keyboard.isKeyDown((int)42)) {
                this.getInstance().tooltipToDisplay.add("[Hold " + EnumChatFormatting.YELLOW + "SHIFT" + EnumChatFormatting.GRAY + " to show without Expert Ring]");
            }
            if (Keyboard.isKeyDown((int)29)) {
                if (!Keyboard.isKeyDown((int)42)) {
                    this.getInstance().tooltipToDisplay.add("");
                }
                this.getInstance().tooltipToDisplay.add("Number of runs is calculated as [Remaining XP]/[XP per Run].");
                this.getInstance().tooltipToDisplay.add("The [XP per Run] is the average xp gained from an S+ run");
                this.getInstance().tooltipToDisplay.add("The " + EnumChatFormatting.DARK_PURPLE + "Catacombs Expert Ring" + EnumChatFormatting.GRAY + " is assumed to be used, unless " + EnumChatFormatting.YELLOW + "SHIFT" + EnumChatFormatting.GRAY + " is held.");
                this.getInstance().tooltipToDisplay.add("[Time per run] is calculated using Fastest S+ x 120%");
            } else {
                this.getInstance().tooltipToDisplay.add("[Hold " + EnumChatFormatting.YELLOW + "CTRL" + EnumChatFormatting.GRAY + " to see details]");
            }
        }
        this.dungeonLevelTextField.setSize(20, 10);
        this.dungeonLevelTextField.render(x + 22, y + 29);
        int calcLen = fontRendererObj.func_78256_a("Calculate");
        Utils.renderShadowedString(EnumChatFormatting.WHITE + "Calculate", (float)(x + sectionWidth - 17) - (float)calcLen / 2.0f, (float)(y + 30), 100);
        float secrets = -1.0f;
        if (hypixelInfo != null) {
            secrets = Utils.getElementAsFloat(Utils.getElement(profileInfo2, "dungeons.secrets"), 0.0f);
        }
        float totalRunsF = 0.0f;
        float totalRunsF5 = 0.0f;
        for (int i = 1; i <= 7; ++i) {
            float runs = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.catacombs.tier_completions." + i);
            totalRunsF += runs;
            if (i < 5) continue;
            totalRunsF5 += runs;
        }
        float totalRunsM = 0.0f;
        float totalRunsM5 = 0.0f;
        for (int i = 1; i <= 7; ++i) {
            float runs = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.tier_completions." + i);
            totalRunsM += runs;
            if (i < 5) continue;
            totalRunsM5 += runs;
        }
        float totalRuns = totalRunsF + totalRunsM;
        float mobKillsF = 0.0f;
        for (int i = 1; i <= 7; ++i) {
            float kills = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.catacombs.mobs_killed." + i);
            mobKillsF += kills;
        }
        float mobKillsM = 0.0f;
        for (int i = 1; i <= 7; ++i) {
            float kills = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types.master_catacombs.mobs_killed." + i);
            mobKillsM += kills;
        }
        float mobKills = mobKillsF + mobKillsM;
        int miscTopY = y + 55;
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Total Runs " + (onMasterMode ? "M" : "F"), EnumChatFormatting.WHITE.toString() + (int)(onMasterMode ? totalRunsM : totalRunsF), x, miscTopY, sectionWidth);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Total Runs (" + (onMasterMode ? "M" : "F") + "5-7)  ", EnumChatFormatting.WHITE.toString() + (int)(onMasterMode ? totalRunsM5 : totalRunsF5), x, miscTopY + 10, sectionWidth);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Secrets (Total)  ", EnumChatFormatting.WHITE + (secrets == -1.0f ? "?" : StringUtils.shortNumberFormat(secrets)), x, miscTopY + 20, sectionWidth);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Secrets (/Run)  ", EnumChatFormatting.WHITE.toString() + (secrets == -1.0f ? "?" : Float.valueOf((float)Math.round(secrets / Math.max(1.0f, totalRuns) * 100.0f) / 100.0f)), x, miscTopY + 30, sectionWidth);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Mob Kills (Total)  ", EnumChatFormatting.WHITE + StringUtils.shortNumberFormat(mobKills), x, miscTopY + 40, sectionWidth);
        int y3 = y + 117;
        for (int i = 1; i <= 7; ++i) {
            int w = fontRendererObj.func_78256_a(String.valueOf(i));
            int bx = x + sectionWidth * i / 8 - w / 2;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.renderShadowedString(EnumChatFormatting.WHITE.toString() + i, bx + w / 2, y3, 10);
        }
        float timeNorm = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types." + dungeonString + ".fastest_time." + floorTime);
        float timeS = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types." + dungeonString + ".fastest_time_s." + floorTime);
        float timeSPLUS = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types." + dungeonString + ".fastest_time_s_plus." + floorTime);
        String timeNormStr = timeNorm <= 0.0f ? "N/A" : Utils.prettyTime((long)timeNorm);
        String timeSStr = timeS <= 0.0f ? "N/A" : Utils.prettyTime((long)timeS);
        String timeSPlusStr = timeSPLUS <= 0.0f ? "N/A" : Utils.prettyTime((long)timeSPLUS);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Floor " + floorTime + " ", EnumChatFormatting.WHITE + timeNormStr, x, y3 + 10, sectionWidth);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Floor " + floorTime + " S", EnumChatFormatting.WHITE + timeSStr, x, y3 + 20, sectionWidth);
        Utils.renderAlignedString(EnumChatFormatting.YELLOW + "Floor " + floorTime + " S+", EnumChatFormatting.WHITE + timeSPlusStr, x, y3 + 30, sectionWidth);
        int x2 = guiLeft + 161;
        int y2 = guiTop + 27;
        Utils.renderShadowedString(EnumChatFormatting.RED + "Boss Collections", x2 + sectionWidth / 2, y2, sectionWidth);
        for (int i = 1; i <= 7; ++i) {
            float compl = DungeonPage.getElementAsFloat(profileInfo2, "dungeons.dungeon_types." + dungeonString + ".tier_completions." + i);
            if (BOSS_HEADS[i - 1] == null) {
                String textureLink = bossFloorHeads[i - 1];
                String b64Decoded = "{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + textureLink + "\"}}}";
                String b64Encoded = new String(Base64.getEncoder().encode(b64Decoded.getBytes()));
                ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
                NBTTagCompound nbt = new NBTTagCompound();
                NBTTagCompound skullOwner = new NBTTagCompound();
                NBTTagCompound properties = new NBTTagCompound();
                NBTTagList textures = new NBTTagList();
                NBTTagCompound textures_0 = new NBTTagCompound();
                String uuid = UUID.nameUUIDFromBytes(b64Encoded.getBytes()).toString();
                skullOwner.func_74778_a("Id", uuid);
                skullOwner.func_74778_a("Name", uuid);
                textures_0.func_74778_a("Value", b64Encoded);
                textures.func_74742_a((NBTBase)textures_0);
                properties.func_74782_a("textures", (NBTBase)textures);
                skullOwner.func_74782_a("Properties", (NBTBase)properties);
                nbt.func_74782_a("SkullOwner", (NBTBase)skullOwner);
                stack.func_77982_d(nbt);
                DungeonPage.BOSS_HEADS[i - 1] = stack;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x2 - 4), (float)(y2 + 10 + 20 * (i - 1)), (float)0.0f);
            GlStateManager.func_179152_a((float)1.3f, (float)1.3f, (float)1.0f);
            Utils.drawItemStack(BOSS_HEADS[i - 1], 0, 0);
            GlStateManager.func_179121_F();
            Utils.renderAlignedString(String.format(EnumChatFormatting.YELLOW + "%s (" + (onMasterMode ? "M" : "F") + "%d) ", bossFloorArr[i - 1], i), EnumChatFormatting.WHITE.toString() + (int)compl, x2 + 16, y2 + 18 + 20 * (i - 1), sectionWidth - 15);
        }
        x2 = guiLeft + 298;
        y2 = guiTop + 27;
        Utils.renderShadowedString(EnumChatFormatting.DARK_PURPLE + "Class Levels", x2 + sectionWidth / 2, y2, sectionWidth);
        JsonElement activeClassElement = Utils.getElement(profileInfo2, "dungeons.selected_dungeon_class");
        String activeClass = null;
        if (activeClassElement instanceof JsonPrimitive && ((JsonPrimitive)activeClassElement).isString()) {
            activeClass = activeClassElement.getAsString();
        }
        float classLevelSum = 0.0f;
        float classLevelSumOverflow = 0.0f;
        int numMaxed = 0;
        for (int i = 0; i < Weight.DUNGEON_CLASS_NAMES.size(); ++i) {
            String className = Weight.DUNGEON_CLASS_NAMES.get(i);
            String colour = className.equalsIgnoreCase(activeClass) ? EnumChatFormatting.GREEN.toString() : EnumChatFormatting.WHITE.toString();
            ProfileViewer.Level levelObj = levelingInfo.get("cosmetic_" + className);
            if (levelObj.level >= 50.0f) {
                levelObj.maxed = true;
                ++numMaxed;
                classLevelSum += 50.0f;
                classLevelSumOverflow += levelObj.level;
            } else {
                classLevelSum += levelObj.level;
            }
            this.getInstance().renderXpBar(colour + WordUtils.capitalizeFully((String)className), classToIcon.get(className), x2, y2 + 20 + 24 * i, sectionWidth, levelObj, mouseX, mouseY);
        }
        ProfileViewer.Level classAverage = new ProfileViewer.Level();
        if (numMaxed == Weight.DUNGEON_CLASS_NAMES.size()) {
            classAverage.maxed = true;
            classAverage.level = classLevelSumOverflow / (float)Weight.DUNGEON_CLASS_NAMES.size();
        } else {
            classAverage.level = classLevelSum / (float)Weight.DUNGEON_CLASS_NAMES.size();
        }
        this.getInstance().renderXpBar(EnumChatFormatting.WHITE + "Class Average", new ItemStack(Items.field_151156_bN), x2, y2 + 20 + 120, sectionWidth, classAverage, mouseX, mouseY);
        this.drawSideButtons(mouseX, mouseY);
    }

    private boolean isHasTime(float fastestTime, String format2, long runsAmount, boolean hasTime) {
        if (fastestTime > 1000.0f) {
            this.getInstance().tooltipToDisplay.add(String.format(format2, Utils.prettyTime(runsAmount * (long)((double)fastestTime * 1.2))));
            hasTime = true;
        }
        return hasTime;
    }

    private static float getElementAsFloat(JsonObject profileInfo2, String path) {
        return Utils.getElementAsFloat(Utils.getElement(profileInfo2, path), 0.0f);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        int y;
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        if (mouseX >= guiLeft + 45 && mouseX <= guiLeft + 65 && mouseY >= guiTop + 54 && mouseY <= guiTop + 64) {
            this.dungeonLevelTextField.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.dungeonLevelTextField.otherComponentClick();
        }
        int cW = fontRendererObj.func_78256_a("Calculate");
        if (mouseX >= guiLeft + 23 + 110 - 17 - cW && mouseX <= guiLeft + 23 + 110 - 17 && mouseY >= guiTop + 55 && mouseY <= guiTop + 65) {
            this.calculateFloorLevelXP();
        }
        if (mouseY >= (y = guiTop + 142) - 2 && mouseY <= y + 9) {
            for (int i = 1; i <= 7; ++i) {
                int w = fontRendererObj.func_78256_a(String.valueOf(i));
                int x = guiLeft + 23 + 110 * i / 8 - w / 2;
                if (mouseX < x - 2 || mouseX > x + 7) continue;
                floorTime = i;
                return false;
            }
        }
        if (mouseX >= guiLeft - 29 && mouseX <= guiLeft) {
            if (mouseY >= guiTop && mouseY <= guiTop + 28) {
                GuiProfileViewer.onSecondPage = false;
            } else if (mouseY + 28 >= guiTop && mouseY <= guiTop + 56) {
                GuiProfileViewer.onSecondPage = true;
            }
        }
        return false;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        this.dungeonLevelTextField.keyTyped(typedChar, keyCode);
    }

    private void drawSideButtons(int mouseX, int mouseY) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        if (GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("master_catacombs"), true, this.getInstance(), mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("catacombs"), true, this.getInstance(), mouseX, mouseY);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
        if (!GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("master_catacombs"), false, this.getInstance(), mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("catacombs"), false, this.getInstance(), mouseX, mouseY);
        }
        GlStateManager.func_179097_i();
    }

    private void calculateFloorLevelXP() {
        JsonObject leveling = Constants.LEVELING;
        if (leveling == null) {
            return;
        }
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        ProfileViewer.Level levelObjCata = selectedProfile.getLevelingInfo().get("cosmetic_catacombs");
        try {
            this.dungeonLevelTextField.setCustomBorderColour(-1);
            this.floorLevelTo = Integer.parseInt(this.dungeonLevelTextField.getText());
            JsonArray levelingArray = leveling.getAsJsonArray("catacombs");
            float remaining = -(levelObjCata.level % 1.0f * levelObjCata.maxXpForLevel);
            for (int level = 0; level < Math.min(this.floorLevelTo, levelingArray.size()); ++level) {
                if ((double)level < Math.floor(levelObjCata.level)) continue;
                remaining += levelingArray.get(level).getAsFloat();
            }
            if (remaining < 0.0f) {
                remaining = 0.0f;
            }
            this.floorLevelToXP = (long)remaining;
        }
        catch (Exception e2) {
            this.dungeonLevelTextField.setCustomBorderColour(-65536);
        }
    }
}

