/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.GuiPositionEditor;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.util.Calculator;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL14;

public class FuelBar {
    public static final ResourceLocation FUEL_BAR = new ResourceLocation("notenoughupdates:fuel_bar.png");
    private static final Pattern FUEL_PATTERN = Pattern.compile("\u00a77\u00a77Fuel: .*/([0-9km]+)");
    private int currentFuel = -1;
    private int maxFuel = -1;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        String[] lore;
        this.currentFuel = -1;
        if (SBInfo.getInstance().getLocation() == null) {
            return;
        }
        if (!(SBInfo.getInstance().getLocation().startsWith("mining_") || SBInfo.getInstance().getLocation().equals("crystal_hollows") || SBInfo.getInstance().getLocation().equals("mineshaft"))) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.mining.drillFuelBar) {
            return;
        }
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (held == null) {
            return;
        }
        String internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held);
        if (internalname == null || !internalname.contains("_DRILL_") && !internalname.equals("DIVAN_DRILL")) {
            return;
        }
        NBTTagCompound extraAttributes = ItemUtils.getExtraAttributes(held);
        this.currentFuel = extraAttributes.func_74762_e("drill_fuel");
        for (String line : lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(held.func_77978_p())) {
            try {
                Matcher matcher = FUEL_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                this.maxFuel = Calculator.calculate(matcher.group(1)).intValue();
                if (this.maxFuel >= this.currentFuel) continue;
                this.maxFuel = this.currentFuel;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onRenderScreen(RenderGameOverlayEvent.Post event) {
        if (!GuiPositionEditor.renderDrill) {
            if (this.currentFuel < 0) {
                return;
            }
            if (!NotEnoughUpdates.INSTANCE.config.mining.drillFuelBar) {
                return;
            }
        } else {
            this.currentFuel = 300;
        }
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            GlStateManager.func_179094_E();
            ScaledResolution scaledResolution = Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.locationedit.guiScale);
            Position position = NotEnoughUpdates.INSTANCE.config.mining.drillFuelBarPosition;
            int x = position.getAbsX(scaledResolution, NotEnoughUpdates.INSTANCE.config.mining.drillFuelBarWidth + 2);
            int y = position.getAbsY(scaledResolution, 5);
            float fuelPercentage = (float)this.currentFuel / (float)this.maxFuel;
            this.renderBar(x -= NotEnoughUpdates.INSTANCE.config.mining.drillFuelBarWidth / 2 - 1, y + 6, NotEnoughUpdates.INSTANCE.config.mining.drillFuelBarWidth + 2, fuelPercentage);
            String str = String.format("\u00a72%d\u00a77/\u00a72%d \u00a76(%d%%)", this.currentFuel, this.maxFuel, (int)(fuelPercentage * 100.0f));
            GlStateManager.func_179147_l();
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            String clean = Utils.cleanColourNotModifiers(str);
            for (int xO = -2; xO <= 2; ++xO) {
                for (int yO = -2; yO <= 2; ++yO) {
                    if (Math.abs(xO) == Math.abs(yO)) continue;
                    Minecraft.func_71410_x().field_71466_p.func_175065_a(clean, (float)(x + 2) + (float)xO / 2.0f, (float)y + (float)yO / 2.0f, new Color(0, 0, 0, 200 / Math.max(Math.abs(xO), Math.abs(yO))).getRGB(), false);
                }
            }
            Minecraft.func_71410_x().field_71466_p.func_175065_a(str, (float)(x + 2), (float)y, 0xFFFFFF, false);
            Utils.pushGuiScale(0);
            GlStateManager.func_179121_F();
        }
    }

    private void renderBar(float x, float y, float xSize, float completed) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FUEL_BAR);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        Color c = Color.getHSBColor(0.41111112f * completed - 0.055555556f, 0.9f, 1.0f - 0.5f * completed);
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
        Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.locationedit.guiScale);
        int w = (int)xSize;
        int w_2 = w / 2;
        int k = (int)Math.min((double)w, Math.ceil(completed * (float)w));
        Utils.drawTexturedRect(x, y, w_2, 5.0f, 0.0f, (float)w_2 / 181.0f, 0.0f, 0.5f, 9728);
        Utils.drawTexturedRect(x + (float)w_2, y, w_2, 5.0f, 1.0f - (float)w_2 / 181.0f, 1.0f, 0.0f, 0.5f, 9728);
        if (k > 0) {
            Utils.drawTexturedRect(x, y, Math.min(w_2, k), 5.0f, 0.0f, (float)Math.min(w_2, k) / 181.0f, 0.5f, 1.0f, 9728);
            if (completed > 0.5f) {
                Utils.drawTexturedRect(x + (float)w_2, y, k - w_2, 5.0f, 1.0f - (float)w_2 / 181.0f, 1.0f + (float)(k - w) / 181.0f, 0.5f, 1.0f, 9728);
            }
        }
        GlStateManager.func_179121_F();
    }
}

