/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.StorageManager;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.util.vector.Vector2f;

public class CrystalHollowOverlay
extends TextOverlay {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final StorageManager storageManager = StorageManager.getInstance();
    private final Pattern notFoundPattern = Pattern.compile("\\[NPC] Keeper of \\w+: Talk to me when you have found a (?<item>[a-z-A-Z ]+)!");
    private final Pattern foundPattern = Pattern.compile("\\[NPC] Keeper of \\w+: Excellent! You have returned the (?<item>[a-z-A-Z ]+) to its rightful place!");
    private final Pattern resetPattern = Pattern.compile("\\[NPC] Keeper of \\w+: (You found all of the items! Behold\\.\\.\\. the Jade Crystal!)");
    private final Pattern alreadyFoundPattern = Pattern.compile("\\[NPC] Keeper of \\w+: You have already restored this Dwarf's (?<item>[a-z-A-Z ]+)!");
    private final Pattern givePattern = Pattern.compile("\\[NPC] Professor Robot: Thanks for bringing me the (?<part>[a-zA-Z0-9 ]+)! Bring me (\\d+|one) more components? to fix the giant!");
    private final Pattern notFinalPattern = Pattern.compile("\\[NPC] Professor Robot: That's not the final component! Bring me a (?<part>[a-zA-Z0-9 ]+) to gain access to Automaton Prime's storage container!");
    private final Pattern obtainCrystalPattern = Pattern.compile(" +(?<crystal>[a-zA-Z]+) Crystal");
    private final Pattern crystalNotPlacedPattern = Pattern.compile(".*: You haven't placed the (?<crystal>[a-zA-Z]+) Crystal yet!");
    private final Pattern crystalPlacedPattern = Pattern.compile(".*: You have already placed the (?<crystal>[a-zA-Z]+) Crystal!");
    private final Pattern crystalPlacePattern = Pattern.compile("\u2726 You placed the (?<crystal>[a-zA-Z]+) Crystal!");
    private final Pattern crystalReclaimPattern = Pattern.compile("\u2726 You reclaimed the (?<crystal>[a-zA-Z]+) Crystal!");
    private final Pattern hotmCrystalNotFoundPattern = Pattern.compile("(?<crystal>[a-zA-Z]+) \\u2716 Not Found");
    private final Pattern hotmCrystalNotPlacedPattern = Pattern.compile("(?<crystal>[a-zA-Z]+) \\u2716 Not Placed");
    private final Pattern hotmCrystalPlacedPattern = Pattern.compile("(?<crystal>[a-zA-Z]+) \\u2714 Placed");
    private static Map<String, ItemStack> crystallHollowsIcons;

    public CrystalHollowOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    private void updateHotmCrystalState(IInventory lower2) {
        String[] lore;
        NEUConfig.HiddenProfileSpecific perProfileConfig = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (perProfileConfig == null) {
            return;
        }
        ItemStack crystalStateStack = lower2.func_70301_a(50);
        if (crystalStateStack == null || !crystalStateStack.func_77942_o()) {
            return;
        }
        String name = Utils.cleanColour(crystalStateStack.func_82833_r()).trim();
        if (!name.equals("Crystal Hollows Crystals")) {
            return;
        }
        for (String line : lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(crystalStateStack.func_77978_p())) {
            if (line == null) continue;
            String cleanLine = Utils.cleanColour(line).trim();
            Matcher hotmCrystalNotPlacedMatcher = this.hotmCrystalNotPlacedPattern.matcher(cleanLine);
            Matcher hotmCrystalNotFoundMatcher = this.hotmCrystalNotFoundPattern.matcher(cleanLine);
            Matcher hotmCrystalPlacedMatcher = this.hotmCrystalPlacedPattern.matcher(cleanLine);
            if (hotmCrystalNotFoundMatcher.matches() && perProfileConfig.crystals.containsKey(hotmCrystalNotFoundMatcher.group("crystal"))) {
                perProfileConfig.crystals.put(hotmCrystalNotFoundMatcher.group("crystal"), 0);
                continue;
            }
            if (hotmCrystalNotPlacedMatcher.matches() && perProfileConfig.crystals.containsKey(hotmCrystalNotPlacedMatcher.group("crystal"))) {
                perProfileConfig.crystals.put(hotmCrystalNotPlacedMatcher.group("crystal"), 1);
                continue;
            }
            if (!hotmCrystalPlacedMatcher.matches() || !perProfileConfig.crystals.containsKey(hotmCrystalPlacedMatcher.group("crystal"))) continue;
            perProfileConfig.crystals.put(hotmCrystalPlacedMatcher.group("crystal"), 2);
        }
    }

    @Override
    public void updateFrequent() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            String containerName = lower2.func_145748_c_().func_150260_c();
            if (containerName.equals("Heart of the Mountain") && lower2.func_70302_i_() >= 54) {
                this.updateHotmCrystalState(lower2);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.mining.crystalHollowOverlay;
    }

    @Override
    public void update() {
        this.overlayStrings = null;
        if (!this.isEnabled() || SBInfo.getInstance().getLocation() == null || !SBInfo.getInstance().getLocation().equals("crystal_hollows")) {
            return;
        }
        NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hidden == null) {
            return;
        }
        this.overlayStrings = new ArrayList();
        HashMap<String, Integer> inventoryData = new HashMap<String, Integer>();
        for (String key : hidden.automatonParts.keySet()) {
            inventoryData.put(key, 0);
        }
        for (String key : hidden.divanMinesParts.keySet()) {
            inventoryData.put(key, 0);
        }
        HashMap<String, Integer> storageData = new HashMap<String, Integer>(inventoryData);
        for (ItemStack item : CrystalHollowOverlay.mc.field_71439_g.field_71071_by.field_70462_a) {
            String name;
            if (item == null || !inventoryData.containsKey(name = Utils.cleanColour(item.func_82833_r()))) continue;
            inventoryData.put(name, (Integer)inventoryData.get(name) + item.field_77994_a);
        }
        for (Map.Entry entry : this.storageManager.storageConfig.displayToStorageIdMap.entrySet()) {
            int storageId = (Integer)entry.getValue();
            StorageManager.StoragePage page = this.storageManager.getPage(storageId, false);
            if (page == null || page.rows <= 0) continue;
            for (ItemStack item : page.items) {
                String name;
                if (item == null || !storageData.containsKey(name = Utils.cleanColour(item.func_82833_r()))) continue;
                storageData.put(name, storageData.get(name) + item.field_77994_a);
            }
        }
        Iterator<Integer> iterator = NotEnoughUpdates.INSTANCE.config.mining.crystalHollowText.iterator();
        block23: while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            switch (n) {
                case 0: {
                    if (!this.crystalCheck()) break;
                    for (String part : hidden.crystals.keySet()) {
                        switch (hidden.crystals.get(part)) {
                            case 2: {
                                if (NotEnoughUpdates.INSTANCE.config.mining.crystalHollowHideDone) break;
                                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPlacedColor] + "Placed");
                                break;
                            }
                            case 1: {
                                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowCollectedColor] + "Collected");
                                break;
                            }
                            case 0: {
                                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowMissingColor] + "Missing");
                            }
                        }
                    }
                    continue block23;
                }
                case 1: {
                    if (!this.crystalCheck()) break;
                    int count = this.getCountCrystal(hidden.crystals);
                    float percent = (float)count / (float)hidden.crystals.size() * 100.0f;
                    this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + "Crystals: " + this.getColor(percent) + count + "/" + hidden.crystals.size());
                    break;
                }
                case 2: {
                    if (!this.crystalCheck()) break;
                    int count = this.getCountCrystal(hidden.crystals);
                    float percent = (float)count / (float)hidden.crystals.size() * 100.0f;
                    this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + "Crystals: " + this.getColor(percent) + StringUtils.formatToTenths(Float.valueOf(percent)) + "%");
                    break;
                }
                case 3: {
                    if (!this.automatonCheck()) break;
                    this.renderParts(hidden.automatonParts, inventoryData, storageData);
                    break;
                }
                case 4: {
                    if (!this.automatonCheck()) break;
                    this.renderPartsNumbers(hidden.automatonParts, inventoryData, storageData);
                    break;
                }
                case 5: {
                    if (!this.automatonCheck()) break;
                    this.renderCount("Automaton parts", hidden.automatonParts, inventoryData, storageData);
                    break;
                }
                case 6: {
                    if (!this.automatonCheck()) break;
                    this.renderPercent("Automaton parts", hidden.automatonParts, inventoryData, storageData);
                    break;
                }
                case 7: {
                    if (!this.divanCheck()) break;
                    this.renderParts(hidden.divanMinesParts, inventoryData, storageData);
                    break;
                }
                case 8: {
                    if (!this.divanCheck()) break;
                    this.renderPartsNumbers(hidden.divanMinesParts, inventoryData, storageData);
                    break;
                }
                case 9: {
                    if (!this.divanCheck()) break;
                    this.renderCount("Mines of Divan parts", hidden.divanMinesParts, inventoryData, storageData);
                    break;
                }
                case 10: {
                    if (!this.divanCheck()) break;
                    this.renderPercent("Mines of Divan parts", hidden.divanMinesParts, inventoryData, storageData);
                }
            }
        }
    }

    private void renderParts(HashMap<String, Boolean> parts, HashMap<String, Integer> inventoryData, HashMap<String, Integer> storageData) {
        for (String part : parts.keySet()) {
            if (parts.get(part).booleanValue() && !NotEnoughUpdates.INSTANCE.config.mining.crystalHollowHideDone) {
                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowDoneColor] + "Done");
                continue;
            }
            if (inventoryData.get(part) >= 1) {
                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowInventoryColor] + "In Inventory");
                continue;
            }
            if (storageData.get(part) >= 1) {
                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowStorageColor] + "In Storage");
                continue;
            }
            this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowMissingColor] + "Missing");
        }
    }

    private void renderPartsNumbers(HashMap<String, Boolean> parts, HashMap<String, Integer> inventoryData, HashMap<String, Integer> storageData) {
        for (String part : parts.keySet()) {
            if (parts.get(part).booleanValue()) {
                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowDoneColor] + (inventoryData.get(part) + storageData.get(part)));
                continue;
            }
            if (inventoryData.get(part) >= 1) {
                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowInventoryColor] + (inventoryData.get(part) + storageData.get(part)));
                continue;
            }
            if (storageData.get(part) >= 1) {
                this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowStorageColor] + (inventoryData.get(part) + storageData.get(part)));
                continue;
            }
            this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + part + ": " + EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowMissingColor] + (inventoryData.get(part) + storageData.get(part)));
        }
    }

    private void renderCount(String text, HashMap<String, Boolean> parts, HashMap<String, Integer> inventoryData, HashMap<String, Integer> storageData) {
        int count = this.getCount(parts, inventoryData, storageData);
        float percent = (float)count / (float)parts.size() * 100.0f;
        this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + text + ": " + this.getColor(percent) + count + "/" + parts.size());
    }

    private void renderPercent(String text, HashMap<String, Boolean> parts, HashMap<String, Integer> inventoryData, HashMap<String, Integer> storageData) {
        int count = this.getCount(parts, inventoryData, storageData);
        float percent = (float)count / (float)parts.size() * 100.0f;
        this.overlayStrings.add(EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowPartColor] + text + ": " + this.getColor(percent) + StringUtils.formatToTenths(Float.valueOf(percent)) + "%");
    }

    private EnumChatFormatting getColor(float percent) {
        if (percent >= 66.0f) {
            return EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowAllColor];
        }
        if (percent >= 33.0f) {
            return EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowMiddleColor];
        }
        return EnumChatFormatting.values()[NotEnoughUpdates.INSTANCE.config.mining.crystalHollowNoneColor];
    }

    private int getCount(HashMap<String, Boolean> parts, HashMap<String, Integer> inventoryData, HashMap<String, Integer> storageData) {
        int count = 0;
        for (String part : parts.keySet()) {
            if (!parts.get(part).booleanValue() && inventoryData.get(part) <= 0 && storageData.get(part) <= 0) continue;
            ++count;
        }
        return count;
    }

    private int getCountCrystal(HashMap<String, Integer> parts) {
        int count = 0;
        for (String part : parts.keySet()) {
            if (parts.get(part) <= 0) continue;
            ++count;
        }
        return count;
    }

    private boolean automatonCheck() {
        return NotEnoughUpdates.INSTANCE.config.mining.crystalHollowAutomatonLocation == 0 || NotEnoughUpdates.INSTANCE.config.mining.crystalHollowAutomatonLocation == 1 && SBInfo.getInstance().getScoreboardLocation().equals("Precursor Remnants") || NotEnoughUpdates.INSTANCE.config.mining.crystalHollowAutomatonLocation >= 1 && SBInfo.getInstance().getScoreboardLocation().equals("Lost Precursor City");
    }

    private boolean divanCheck() {
        return NotEnoughUpdates.INSTANCE.config.mining.crystalHollowDivanLocation == 0 || NotEnoughUpdates.INSTANCE.config.mining.crystalHollowDivanLocation == 1 && SBInfo.getInstance().getScoreboardLocation().equals("Mithril Deposits") || NotEnoughUpdates.INSTANCE.config.mining.crystalHollowDivanLocation >= 1 && SBInfo.getInstance().getScoreboardLocation().equals("Mines of Divan");
    }

    private boolean crystalCheck() {
        return NotEnoughUpdates.INSTANCE.config.mining.crystalHollowCrystalLocation == 0 || !this.divanCheck() && !this.automatonCheck();
    }

    public void message(String message) {
        NEUConfig.HiddenProfileSpecific hidden = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (hidden == null) {
            return;
        }
        Matcher crystalNotPlacedMatcher = this.crystalNotPlacedPattern.matcher(message);
        Matcher crystalPlacedMatcher = this.crystalPlacedPattern.matcher(message);
        Matcher crystalPlaceMatcher = this.crystalPlacePattern.matcher(message);
        Matcher crystalReclaimMatcher = this.crystalReclaimPattern.matcher(message);
        if (message.startsWith("  CRYSTAL NUCLEUS LOOT BUNDLE")) {
            hidden.crystals.replaceAll((k, v) -> 0);
        }
        if (crystalNotPlacedMatcher.matches() && hidden.crystals.containsKey(crystalNotPlacedMatcher.group("crystal"))) {
            hidden.crystals.put(crystalNotPlacedMatcher.group("crystal"), 1);
            this.resetCrystal(hidden, crystalNotPlacedMatcher.group("crystal"));
        } else if (crystalPlacedMatcher.matches() && hidden.crystals.containsKey(crystalPlacedMatcher.group("crystal"))) {
            hidden.crystals.put(crystalPlacedMatcher.group("crystal"), 2);
            this.resetCrystal(hidden, crystalPlacedMatcher.group("crystal"));
        } else if (crystalPlaceMatcher.matches() && hidden.crystals.containsKey(crystalPlaceMatcher.group("crystal"))) {
            hidden.crystals.put(crystalPlaceMatcher.group("crystal"), 2);
        } else if (crystalReclaimMatcher.matches() && hidden.crystals.containsKey(crystalReclaimMatcher.group("crystal"))) {
            hidden.crystals.put(crystalReclaimMatcher.group("crystal"), 1);
        } else if (message.startsWith("[NPC] Keeper of ")) {
            Matcher foundMatcher = this.foundPattern.matcher(message);
            Matcher alreadyFoundMatcher = this.alreadyFoundPattern.matcher(message);
            Matcher notFoundMatcher = this.notFoundPattern.matcher(message);
            Matcher resetMatcher = this.resetPattern.matcher(message);
            if (foundMatcher.matches() && hidden.divanMinesParts.containsKey(foundMatcher.group("item"))) {
                hidden.divanMinesParts.put(foundMatcher.group("item"), true);
            } else if (notFoundMatcher.matches() && hidden.divanMinesParts.containsKey(notFoundMatcher.group("item"))) {
                hidden.divanMinesParts.put(notFoundMatcher.group("item"), false);
            } else if (resetMatcher.matches()) {
                hidden.divanMinesParts.replaceAll((k, v) -> false);
            } else if (alreadyFoundMatcher.matches() && hidden.divanMinesParts.containsKey(alreadyFoundMatcher.group("item"))) {
                hidden.divanMinesParts.put(alreadyFoundMatcher.group("item"), true);
            }
        } else if (message.startsWith("  ")) {
            Matcher crystalMatcher = this.obtainCrystalPattern.matcher(message);
            if (crystalMatcher.matches() && hidden.crystals.containsKey(crystalMatcher.group("crystal"))) {
                hidden.crystals.put(crystalMatcher.group("crystal"), 1);
            } else {
                String item = message.replace("  ", "");
                if (hidden.automatonParts.containsKey(item)) {
                    hidden.automatonParts.put(item, false);
                }
            }
        } else if (message.startsWith("[NPC] Professor Robot: ")) {
            if (message.equals("[NPC] Professor Robot: That's not one of the components I need! Bring me one of the missing components:")) {
                hidden.automatonParts.replaceAll((k, v) -> true);
            } else if (message.startsWith("[NPC] Professor Robot: You've brought me all of the components")) {
                hidden.automatonParts.replaceAll((k, v) -> false);
            } else {
                String item;
                Matcher giveMatcher = this.givePattern.matcher(message);
                Matcher notFinalMatcher = this.notFinalPattern.matcher(message);
                if (giveMatcher.matches()) {
                    String item2 = giveMatcher.group("part");
                    if (hidden.automatonParts.containsKey(item2)) {
                        hidden.automatonParts.put(item2, true);
                    }
                } else if (notFinalMatcher.matches() && hidden.automatonParts.containsKey(item = notFinalMatcher.group("part"))) {
                    hidden.automatonParts.replaceAll((k, v) -> true);
                    hidden.automatonParts.put(item, false);
                }
            }
        }
    }

    private void resetCrystal(NEUConfig.HiddenProfileSpecific hidden, String crystal) {
        switch (crystal) {
            case "Sapphire": {
                hidden.automatonParts.replaceAll((k, v) -> false);
                break;
            }
            case "Jade": {
                hidden.divanMinesParts.replaceAll((k, v) -> false);
            }
        }
    }

    @Override
    protected void renderLine(String line, Vector2f position, boolean dummy) {
        if (!NotEnoughUpdates.INSTANCE.config.mining.crystalHollowIcons) {
            return;
        }
        GlStateManager.func_179126_j();
        ItemStack icon = null;
        String cleaned = Utils.cleanColour(line);
        String beforeColon = cleaned.split(":")[0];
        if (crystallHollowsIcons == null) {
            CrystalHollowOverlay.setupCrystallHollowsIcons();
        }
        if (crystallHollowsIcons.containsKey(beforeColon)) {
            icon = crystallHollowsIcons.get(beforeColon);
        }
        if (icon != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)position.x, (float)position.y, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            Utils.drawItemStack(icon, 0, 0);
            GlStateManager.func_179121_F();
            position.x += 12.0f;
        }
        super.renderLine(line, position, dummy);
    }

    private static void setupCrystallHollowsIcons() {
        crystallHollowsIcons = new HashMap<String, ItemStack>(){
            {
                this.addItem("Scavenged Lapis Sword", "DWARVEN_LAPIS_SWORD");
                this.addItem("Scavenged Golden Hammer", "DWARVEN_GOLD_HAMMER");
                this.addItem("Scavenged Diamond Axe", "DWARVEN_DIAMOND_AXE");
                this.addItem("Scavenged Emerald Hammer", "DWARVEN_EMERALD_HAMMER");
                this.addItem("Electron Transmitter", "ELECTRON_TRANSMITTER");
                this.addItem("FTX 3070", "FTX_3070");
                this.addItem("Robotron Reflector", "ROBOTRON_REFLECTOR");
                this.addItem("Superlite Motor", "SUPERLITE_MOTOR");
                this.addItem("Control Switch", "CONTROL_SWITCH");
                this.addItem("Synthetic Heart", "SYNTHETIC_HEART");
                this.addItem("Amber", "PERFECT_AMBER_GEM");
                this.addItem("Sapphire", "PERFECT_SAPPHIRE_GEM");
                this.addItem("Jade", "PERFECT_JADE_GEM");
                this.addItem("Amethyst", "PERFECT_AMETHYST_GEM");
                this.addItem("Topaz", "PERFECT_TOPAZ_GEM");
            }

            private void addItem(String eventName, String internalName) {
                ItemStack itemStack = new ItemResolutionQuery(NotEnoughUpdates.INSTANCE.manager).withKnownInternalName(internalName).resolveToItemStack();
                if (itemStack == null) {
                    Utils.showOutdatedRepoNotification(internalName);
                    return;
                }
                this.put(eventName, itemStack.func_77946_l());
            }
        };
    }

    @Override
    protected Vector2f getSize(List<String> strings) {
        if (NotEnoughUpdates.INSTANCE.config.mining.crystalHollowIcons) {
            return super.getSize(strings).translate(12.0f, 0.0f);
        }
        return super.getSize(strings);
    }
}

