/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.mixins;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.TooltipTextScrolling;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiUtils.class}, remap=false)
public class MixinGuiUtils {
    @Inject(method={"drawHoveringText"}, at={@At(value="HEAD")}, cancellable=true)
    private static void drawHoveringText_head(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, CallbackInfo ci) {
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.customTooltips) {
            Utils.drawHoveringText(textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
            ci.cancel();
        } else if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale != 0) {
            Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale);
        }
    }

    @ModifyVariable(method={"drawHoveringText"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private static int drawHoveringText_modifyMouseX(int mouseX) {
        return Mouse.getX() * Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale).func_78326_a() / Minecraft.func_71410_x().field_71443_c;
    }

    @ModifyVariable(method={"drawHoveringText"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private static int drawHoveringText_modifyMouseY(int mouseY) {
        return Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale).func_78328_b() - Mouse.getY() * Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale).func_78328_b() / Minecraft.func_71410_x().field_71440_d;
    }

    @ModifyVariable(method={"drawHoveringText"}, at=@At(value="HEAD"), ordinal=2, argsOnly=true)
    private static int drawHoveringText_modifyWidth(int width) {
        return Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale).func_78326_a();
    }

    @ModifyVariable(method={"drawHoveringText"}, at=@At(value="HEAD"), ordinal=3, argsOnly=true)
    private static int drawHoveringText_modifyHeight(int height) {
        return Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.guiScale).func_78328_b();
    }

    @Inject(method={"drawHoveringText"}, at={@At(value="TAIL")})
    private static void drawHoveringText_tail(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, CallbackInfo ci) {
        Utils.resetGuiScale();
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"drawHoveringText"})
    private static List<String> onDrawHoveringText(List<String> textLines) {
        return TooltipTextScrolling.handleTextLineRendering(textLines);
    }
}

