/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.util;

import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.miscgui.util.ExperienceOrb;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class OrbDisplay {
    private static final ResourceLocation TEXTURE = new ResourceLocation("notenoughupdates:custom_enchant_gui.png");
    private static final int DEFAULT_COUNT = 30;
    private final List<ExperienceOrb> experienceOrbList = new ArrayList<ExperienceOrb>();

    public ExperienceOrb spawnExperienceOrb(Random random2, Vector2f start, Vector2f target, int baseType) {
        ExperienceOrb orb = new ExperienceOrb();
        orb.position = new Vector2f((ReadableVector2f)start);
        orb.positionLast = new Vector2f((ReadableVector2f)orb.position);
        orb.velocity = new Vector2f(random2.nextFloat() * 20.0f - 10.0f, random2.nextFloat() * 20.0f - 10.0f);
        orb.target = new Vector2f((ReadableVector2f)target);
        orb.type = baseType;
        orb.rotationDeg = random2.nextInt(4) * 90;
        float v = random2.nextFloat();
        if ((double)v > 0.6) {
            ++orb.type;
        }
        if ((double)v > 0.9) {
            ++orb.type;
        }
        this.experienceOrbList.add(orb);
        return orb;
    }

    public void spawnExperienceOrbs(int startX, int startY, int targetX, int targetY, int baseType) {
        this.spawnExperienceOrbs(new Random(), new Vector2f((float)startX, (float)startY), new Vector2f((float)targetX, (float)targetY), baseType, 30);
    }

    public void spawnExperienceOrbs(Random random2, Vector2f start, Vector2f target, int baseType, int count) {
        for (int i = 0; i < count; ++i) {
            this.spawnExperienceOrb(random2, start, target, baseType);
        }
    }

    public void physicsTickOrbs() {
        ListIterator<ExperienceOrb> it = this.experienceOrbList.listIterator();
        while (it.hasNext()) {
            ExperienceOrb orb = it.next();
            Vector2f delta = Vector2f.sub((Vector2f)orb.target, (Vector2f)orb.position, null);
            float length = delta.length();
            if (length < 8.0f && orb.velocity.lengthSquared() < 20.0f) {
                it.remove();
                continue;
            }
            Vector2f.add((Vector2f)orb.velocity, (Vector2f)((Vector2f)delta.scale(2.0f / length)), (Vector2f)orb.velocity);
            orb.velocity.scale(0.9f);
            orb.positionLast.set((ReadableVector2f)orb.position);
            Vector2f.add((Vector2f)orb.position, (Vector2f)orb.velocity, (Vector2f)orb.position);
        }
    }

    public void renderOrbs(float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179097_i();
        for (ExperienceOrb orb : this.experienceOrbList) {
            int orbX = Math.round(LerpUtils.lerp(orb.position.x, orb.positionLast.x, partialTicks));
            int orbY = Math.round(LerpUtils.lerp(orb.position.y, orb.positionLast.y, partialTicks));
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)orbX, (float)orbY, (float)0.0f);
            GlStateManager.func_179114_b((float)orb.rotationDeg, (float)0.0f, (float)0.0f, (float)1.0f);
            Vector2f delta = Vector2f.sub((Vector2f)orb.position, (Vector2f)orb.target, null);
            float length = delta.length();
            float velocitySquared = orb.velocity.lengthSquared();
            float opacity = (float)Math.sqrt(Math.min(1.0f, Math.min(2.0f, Math.max(0.5f, length / 16.0f)) * Math.min(2.0f, Math.max(0.5f, velocitySquared / 40.0f))));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            int orbU = orb.type % 3 * 16;
            int orbV = orb.type / 3 * 16 + 217;
            Utils.drawTexturedRect(-8.0f, -8.0f, 16.0f, 16.0f, (float)orbU / 512.0f, (float)(orbU + 16) / 512.0f, (float)orbV / 512.0f, (float)(orbV + 16) / 512.0f, 9728);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179126_j();
    }
}

