/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.common.collect.ImmutableList;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.TooltipTextScrolling;
import io.github.moulberry.notenoughupdates.core.util.ArrowPagesUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.AhBzKeybind;
import io.github.moulberry.notenoughupdates.recipes.CraftingRecipe;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeHistory;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiItemRecipe
extends GuiScreen {
    public static final ResourceLocation tabsTexture = new ResourceLocation("notenoughupdates", "textures/gui/tab.png");
    public static final int SLOT_SIZE = 16;
    public static final int SLOT_SPACING = 18;
    public static final int TITLE_X = 28;
    public static final int TITLE_Y = 6;
    public static final int HOTBAR_SLOT_X = 8;
    public static final int HOTBAR_SLOT_Y = 197;
    public static final int PLAYER_INVENTORY_X = 8;
    public static final int PLAYER_INVENTORY_Y = 140;
    public static final int TAB_POS_X = -26;
    public static final int TAB_POS_Y = 8;
    public static final int TAB_OFFSET_Y = 30;
    public static final int TAB_SIZE_X = 26;
    public static final int TAB_SIZE_Y = 30;
    public static final int TAB_TEXTURE_SIZE_X = 29;
    private int currentIndex = 0;
    private int currentTab = 0;
    private final Map<RecipeType, List<NeuRecipe>> craftingRecipes = new HashMap<RecipeType, List<NeuRecipe>>();
    private final List<RecipeType> tabs = new ArrayList<RecipeType>();
    private final NEUManager manager;
    public int guiLeft = 0;
    public int guiTop = 0;
    public int xSize = 176;
    public int ySize = 222;
    private static final ResourceLocation EDITOR = new ResourceLocation("notenoughupdates:invbuttons/editor.png");
    List<String> tooltipToDisplay = null;

    public GuiItemRecipe(List<NeuRecipe> unsortedRecipes, NEUManager manager) {
        this.manager = manager;
        for (NeuRecipe recipe : unsortedRecipes) {
            this.craftingRecipes.computeIfAbsent(recipe.getType(), ignored -> new ArrayList()).add(recipe);
            if (this.tabs.contains((Object)recipe.getType())) continue;
            this.tabs.add(recipe.getType());
        }
        this.tabs.sort(Comparator.naturalOrder());
        this.changeRecipe(0, 0);
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public NeuRecipe getCurrentRecipe() {
        List<NeuRecipe> currentRecipes = this.getCurrentRecipeList();
        this.currentIndex = MathHelper.func_76125_a((int)this.currentIndex, (int)0, (int)(currentRecipes.size() - 1));
        return currentRecipes.get(this.currentIndex);
    }

    public List<NeuRecipe> getCurrentRecipeList() {
        return this.craftingRecipes.get((Object)this.getCurrentTab());
    }

    public RecipeType getCurrentTab() {
        this.currentTab = MathHelper.func_76125_a((int)this.currentTab, (int)0, (int)(this.tabs.size() - 1));
        return this.tabs.get(this.currentTab);
    }

    public boolean isWithinRect(int x, int y, int topLeftX, int topLeftY, int width, int height) {
        return topLeftX <= x && x < topLeftX + width && topLeftY <= y && y < topLeftY + height;
    }

    private ImmutableList<RecipeSlot> getAllRenderedSlots() {
        return ImmutableList.builder().addAll(this.getPlayerInventory()).addAll(this.getCurrentRecipe().getSlots()).build();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String internalItemId;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NeuRecipe currentRecipe = this.getCurrentRecipe();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(currentRecipe.getBackground());
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.drawTabs();
        currentRecipe.drawExtraBackground(this, mouseX, mouseY);
        ImmutableList<RecipeSlot> slots = this.getAllRenderedSlots();
        for (Object slot : slots) {
            if (((RecipeSlot)slot).getStackSize() != -1.0) {
                ((RecipeSlot)slot).getItemStack().field_77994_a = 1;
            }
            Utils.drawItemStack(((RecipeSlot)slot).getItemStack(), ((RecipeSlot)slot).getX(this), ((RecipeSlot)slot).getY(this), true);
            if (((RecipeSlot)slot).getStackSize() == -1.0) continue;
            String stackSize = ((RecipeSlot)slot).getStackSize() > 10000.0 ? Utils.shortNumberFormat(((RecipeSlot)slot).getStackSize(), 0) : "" + (int)((RecipeSlot)slot).getStackSize();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            this.field_146289_q.func_175063_a(stackSize, (float)(((RecipeSlot)slot).getX(this) + 17 - this.field_146289_q.func_78256_a(stackSize)), (float)(((RecipeSlot)slot).getY(this) + 9), 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
        int[] topLeft = currentRecipe.getPageFlipPositionLeftTopCorner();
        ArrowPagesUtils.onDraw(this.guiLeft, this.guiTop, topLeft, this.currentIndex, this.getCurrentRecipeList().size());
        Utils.drawStringScaledMaxWidth(currentRecipe.getTitle(), this.guiLeft + 28, this.guiTop + 6, false, this.xSize - 38, 0x404040);
        currentRecipe.drawExtraInfo(this, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (RecipeSlot slot : slots) {
            if (!this.isWithinRect(mouseX, mouseY, slot.getX(this), slot.getY(this), 16, 16) || slot.getItemStack() == null) continue;
            this.tooltipToDisplay = slot.getItemStack().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (currentRecipe instanceof CraftingRecipe && !NotEnoughUpdates.INSTANCE.manager.auctionManager.isVanillaItem(internalItemId = ((CraftingRecipe)currentRecipe).getOutput().getInternalItemId())) {
            int x = this.guiLeft + 123;
            int y = this.guiTop + 105;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(x - 1, y - 1, 18.0f, 18.0f, 0.0f, 0.0703125f, 0.0f, 0.0703125f, 9728);
            Utils.drawItemStack(new ItemStack(Items.field_151005_D), x, y);
            if (this.isWithinRect(mouseX, mouseY, x, y, 16, 16)) {
                this.tooltipToDisplay = Collections.singletonList("\u00a7aClick for Supercraft");
            }
        }
        currentRecipe.drawHoverInformation(this, mouseX, mouseY);
        this.drawTabHoverInformation(mouseX, mouseY);
        if (this.tooltipToDisplay != null) {
            Utils.drawHoveringText(this.tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
            this.tooltipToDisplay = null;
        }
    }

    private void drawTabHoverInformation(int mouseX, int mouseY) {
        if (this.tabs.size() < 2) {
            return;
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.isWithinRect(mouseX - this.guiLeft, mouseY - this.guiTop, -26, 8 + 30 * i, 26, 30)) continue;
            RecipeType type2 = this.tabs.get(i);
            this.tooltipToDisplay = Arrays.asList("" + EnumChatFormatting.RESET + EnumChatFormatting.GREEN + type2.getLabel(), "" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + this.craftingRecipes.get((Object)type2).size() + " Recipes");
            return;
        }
    }

    private void drawTabs() {
        if (this.tabs.size() < 2) {
            return;
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            RecipeType recipeType = this.tabs.get(i);
            int tabPosX = this.guiLeft + -26;
            int tabPosY = this.guiTop + 30 * i + 8;
            int textureOffset = 0;
            if (this.currentTab == i) {
                textureOffset = 30;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(tabsTexture);
            this.func_73729_b(tabPosX, tabPosY, 0, textureOffset, 29, 30);
            Utils.drawItemStack(recipeType.getIcon(), tabPosX + 7, tabPosY + 7);
        }
    }

    public List<RecipeSlot> getPlayerInventory() {
        ArrayList<RecipeSlot> slots = new ArrayList<RecipeSlot>();
        ItemStack[] inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a;
        int hotbarSize = InventoryPlayer.func_70451_h();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.field_77994_a == 0) continue;
            int row = i / hotbarSize;
            int col = i % hotbarSize;
            if (row == 0) {
                slots.add(new RecipeSlot(8 + i * 18, 198, item));
                continue;
            }
            slots.add(new RecipeSlot(8 + col * 18, 140 + (row - 1) * 18, item));
        }
        return slots;
    }

    public void func_146282_l() throws IOException {
        int keyPressed;
        super.func_146282_l();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        int n = keyPressed = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        if (Keyboard.getEventKeyState()) {
            return;
        }
        for (RecipeSlot slot : this.getAllRenderedSlots()) {
            if (!this.isWithinRect(mouseX, mouseY, slot.getX(this), slot.getY(this), 16, 16)) continue;
            ItemStack itemStack = slot.getItemStack();
            if (keyPressed == this.manager.keybindViewRecipe.func_151463_i()) {
                this.manager.displayGuiItemRecipeKeybind(this.manager.getInternalNameForItem(itemStack));
                continue;
            }
            if (keyPressed == this.manager.keybindViewUsages.func_151463_i()) {
                this.manager.displayGuiItemUsagesKeybind(this.manager.getInternalNameForItem(itemStack));
                continue;
            }
            if (keyPressed != NotEnoughUpdates.INSTANCE.config.misc.openAHKeybind) continue;
            AhBzKeybind.onKeyPressed(itemStack);
        }
        if (keyPressed == this.manager.keybindPreviousRecipe.func_151463_i()) {
            NotEnoughUpdates.INSTANCE.openGui = RecipeHistory.getPrevious();
        } else if (keyPressed == this.manager.keybindNextRecipe.func_151463_i()) {
            NotEnoughUpdates.INSTANCE.openGui = RecipeHistory.getNext();
        }
    }

    public void changeRecipe(int tabIndex, int recipeIndex) {
        this.field_146292_n.removeAll(this.getCurrentRecipe().getExtraButtons(this));
        this.currentTab = tabIndex;
        this.currentIndex = recipeIndex;
        this.field_146292_n.addAll(this.getCurrentRecipe().getExtraButtons(this));
    }

    protected void func_146284_a(GuiButton p_actionPerformed_1_) {
        this.getCurrentRecipe().actionPerformed(p_actionPerformed_1_);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        String internalItemId;
        int y;
        int x;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        NeuRecipe currentRecipe = this.getCurrentRecipe();
        int[] topLeft = currentRecipe.getPageFlipPositionLeftTopCorner();
        if (mouseButton == 3) {
            NotEnoughUpdates.INSTANCE.openGui = RecipeHistory.getPrevious();
        } else if (mouseButton == 4) {
            NotEnoughUpdates.INSTANCE.openGui = RecipeHistory.getNext();
        }
        if (ArrowPagesUtils.onPageSwitchMouse(this.guiLeft, this.guiTop, topLeft, this.currentIndex, this.getCurrentRecipeList().size(), pageChange -> this.changeRecipe(this.currentTab, (int)pageChange))) {
            return;
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.isWithinRect(mouseX - this.guiLeft, mouseY - this.guiTop, -26, 8 + 30 * i, 26, 30)) continue;
            this.changeRecipe(i, 0);
            Utils.playPressSound();
            return;
        }
        for (RecipeSlot slot : this.getAllRenderedSlots()) {
            if (!this.isWithinRect(mouseX, mouseY, slot.getX(this), slot.getY(this), 16, 16)) continue;
            ItemStack itemStack = slot.getItemStack();
            if (mouseButton == 0) {
                this.manager.displayGuiItemRecipe(this.manager.getInternalNameForItem(itemStack));
                return;
            }
            if (mouseButton != 1) continue;
            this.manager.displayGuiItemUsages(this.manager.getInternalNameForItem(itemStack));
            return;
        }
        if (currentRecipe instanceof CraftingRecipe && this.isWithinRect(mouseX, mouseY, x = this.guiLeft + 123, y = this.guiTop + 105, 16, 16) && mouseButton == 0 && !NotEnoughUpdates.INSTANCE.manager.auctionManager.isVanillaItem(internalItemId = ((CraftingRecipe)currentRecipe).getOutput().getInternalItemId())) {
            NotEnoughUpdates.INSTANCE.sendChatMessage("/viewrecipe " + internalItemId);
            return;
        }
        currentRecipe.mouseClicked(this, mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        ScaledResolution scaledResolution = Utils.peekGuiScale();
        int mouseX = Mouse.getX() * scaledResolution.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledResolution.func_78328_b() - Mouse.getY() * scaledResolution.func_78328_b() / Minecraft.func_71410_x().field_71440_d - 1;
        this.getCurrentRecipe().genericMouseInput(mouseX, mouseY);
        if (TooltipTextScrolling.didRenderTooltip) {
            return;
        }
        if (Mouse.getEventDWheel() != 0) {
            ArrowPagesUtils.onPageSwitchScroll(this.currentIndex, this.getCurrentRecipeList().size(), pageChange -> this.changeRecipe(this.currentTab, (int)pageChange));
        }
    }

    public void arrowKeyboardInput() {
        ArrowPagesUtils.onPageSwitchKey(this.currentIndex, this.getCurrentRecipeList().size(), pageChange -> this.changeRecipe(this.currentTab, (int)pageChange));
    }
}

