/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GlScissorStack;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingFloat;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingInteger;
import io.github.moulberry.notenoughupdates.miscfeatures.SlotLocking;
import io.github.moulberry.notenoughupdates.miscgui.util.OrbDisplay;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C0EPacketClickWindow;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.glu.Project;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class GuiCustomEnchant
extends Gui {
    private static final GuiCustomEnchant INSTANCE = new GuiCustomEnchant();
    private static final ResourceLocation TEXTURE = new ResourceLocation("notenoughupdates:custom_enchant_gui.png");
    private static final ResourceLocation ENCHANTMENT_TABLE_BOOK_TEXTURE = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private static final ModelBook MODEL_BOOK = new ModelBook();
    private static final Pattern XP_COST_PATTERN = Pattern.compile("\\u00a73(\\d+) Exp Levels");
    private static final Pattern DISCOUNT_COST_PATTERN = Pattern.compile("\\u00a78\\u00a7m(\\d+)\\u00a73 (\\d+) Exp Levels");
    private static final Pattern ENCHANT_LEVEL_PATTERN = Pattern.compile("(.*)_(.*)");
    private static final Pattern ENCHANT_NAME_PATTERN = Pattern.compile("([^IVX]*) ([IVX]*)");
    public OrbDisplay orbDisplay = new OrbDisplay();
    private int guiLeft;
    private int guiTop;
    private boolean shouldOverrideFast = false;
    public float pageOpen;
    public float pageOpenLast;
    public float pageOpenRandom;
    public float pageOpenVelocity;
    public float bookOpen;
    public float bookOpenLast;
    private int currentPage;
    private int expectedMaxPage;
    private boolean isScrollingLeft = true;
    private ItemStack enchantingItem = null;
    private int removingEnchantPlayerLevel = -1;
    private final GuiElementTextField searchField = new GuiElementTextField("", 128);
    private final HashMap<String, Integer> playerEnchantIds = new HashMap();
    private boolean searchRemovedFromApplicable = false;
    private boolean searchRemovedFromRemovable = false;
    private final List<Enchantment> applicable = new ArrayList<Enchantment>();
    private final List<Enchantment> removable = new ArrayList<Enchantment>();
    private final HashMap<Integer, Enchantment> enchanterEnchLevels = new HashMap();
    private Enchantment enchanterCurrentEnch = null;
    public Random random = new Random();
    private EnchantState currentState = EnchantState.NO_ITEM;
    private EnchantState lastState = EnchantState.NO_ITEM;
    private final LerpingInteger leftScroll = new LerpingInteger(0, 150);
    private final LerpingInteger rightScroll = new LerpingInteger(0, 150);
    private final LerpingFloat arrowAmount = new LerpingFloat(0.0f, 100);
    private static final int X_SIZE = 364;
    private static final int Y_SIZE = 215;
    private int clickedScrollOffset = -1;
    private boolean isClickedScrollLeft = true;
    private boolean isChangingEnchLevel = false;
    private long cancelButtonAnimTime = 0L;
    private long confirmButtonAnimTime = 0L;
    private int tickCounter = 0;

    public static GuiCustomEnchant getInstance() {
        return INSTANCE;
    }

    public boolean shouldOverride(String containerName) {
        if (containerName == null) {
            this.shouldOverrideFast = false;
            return false;
        }
        boolean bl = this.shouldOverrideFast = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableTableGUI && containerName.length() >= 12 && Objects.equals("Enchant Item", containerName.substring(0, "Enchant Item".length())) && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard();
        if (!this.shouldOverrideFast) {
            this.currentState = EnchantState.NO_ITEM;
            this.applicable.clear();
            this.removable.clear();
            this.expectedMaxPage = 1;
        }
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        ItemStack hexStack = cc.func_85151_d().func_70301_a(50);
        if (hexStack != null && hexStack.func_77973_b() == Items.field_151062_by) {
            this.shouldOverrideFast = false;
            return false;
        }
        return this.shouldOverrideFast;
    }

    public void tick() {
        boolean updateItems;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        ItemStack stack = cc.func_85151_d().func_70301_a(23);
        ItemStack arrowStack = cc.func_85151_d().func_70301_a(45);
        ItemStack enchantingItemStack = cc.func_85151_d().func_70301_a(19);
        ItemStack hexStack = cc.func_85151_d().func_70301_a(50);
        int lastPage = this.currentPage;
        this.lastState = this.currentState;
        if (hexStack != null && hexStack.func_77973_b() == Items.field_151062_by) {
            return;
        }
        if (arrowStack != null && arrowStack.func_77973_b() == Items.field_151032_g && this.enchantingItem != null) {
            this.currentState = EnchantState.ADDING_ENCHANT;
        } else if (stack == null || enchantingItemStack == null) {
            this.currentState = this.currentState == EnchantState.SWITCHING_DONT_UPDATE || this.currentState == EnchantState.NO_ITEM ? EnchantState.NO_ITEM : EnchantState.SWITCHING_DONT_UPDATE;
        } else if (stack.func_77973_b() != Items.field_151100_aR) {
            ItemStack sanityCheckStack = cc.func_85151_d().func_70301_a(12);
            if (sanityCheckStack == null || sanityCheckStack.func_77973_b() == Items.field_151134_bR) {
                this.currentState = EnchantState.HAS_ITEM;
                this.enchantingItem = enchantingItemStack;
            } else {
                this.currentState = EnchantState.SWITCHING_DONT_UPDATE;
            }
        } else {
            this.currentState = stack.func_77952_i() == 1 ? EnchantState.INVALID_ITEM : EnchantState.NO_ITEM;
        }
        if (this.currentState == EnchantState.HAS_ITEM) {
            ItemStack pageUpStack = cc.func_85151_d().func_70301_a(17);
            ItemStack pageDownStack = cc.func_85151_d().func_70301_a(35);
            if (pageUpStack != null && pageDownStack != null) {
                this.currentPage = 0;
                boolean upIsGlass = pageUpStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                boolean downIsGlass = pageDownStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co);
                int page = -1;
                this.expectedMaxPage = 1;
                if (!downIsGlass) {
                    try {
                        page = Integer.parseInt(Utils.getRawTooltip(pageDownStack).get(1).substring(11)) - 1;
                        this.expectedMaxPage = page + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (page == -1 && !upIsGlass) {
                    try {
                        this.expectedMaxPage = page = Integer.parseInt(Utils.getRawTooltip(pageUpStack).get(1).substring(11)) + 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentPage = page == -1 ? 1 : page;
            }
        }
        this.orbDisplay.physicsTickOrbs();
        if (++this.tickCounter >= 20) {
            this.tickCounter = 0;
        }
        boolean bl = updateItems = this.tickCounter == 0;
        if (this.currentState == EnchantState.ADDING_ENCHANT) {
            if (this.arrowAmount.getTarget() != 1.0f) {
                this.arrowAmount.setTarget(1.0f);
                this.arrowAmount.resetTimer();
            }
        } else if (this.arrowAmount.getTarget() != 0.0f) {
            this.arrowAmount.setTarget(0.0f);
            this.arrowAmount.resetTimer();
        }
        if (this.lastState != this.currentState || lastPage != this.currentPage) {
            this.leftScroll.setValue(0);
            this.rightScroll.setValue(0);
            updateItems = true;
        }
        if (updateItems && this.currentState != EnchantState.SWITCHING_DONT_UPDATE) {
            this.enchanterEnchLevels.clear();
            if (this.enchantingItem != null) {
                NBTTagCompound enchantments;
                NBTTagCompound ea;
                this.playerEnchantIds.clear();
                NBTTagCompound tag = this.enchantingItem.func_77978_p();
                if (tag != null && (ea = tag.func_74775_l("ExtraAttributes")) != null && (enchantments = ea.func_74775_l("enchantments")) != null) {
                    for (String enchId : enchantments.func_150296_c()) {
                        this.playerEnchantIds.put(enchId, enchantments.func_74762_e(enchId));
                    }
                }
            }
            if (this.currentState == EnchantState.ADDING_ENCHANT) {
                this.removingEnchantPlayerLevel = -1;
                boolean updateLevel = this.enchanterCurrentEnch == null;
                for (int i = 0; i < 27; ++i) {
                    NBTTagCompound enchantments;
                    NBTTagCompound ea;
                    NBTTagCompound tagBook;
                    int slotIndex = 9 + i;
                    ItemStack book = cc.func_85151_d().func_70301_a(slotIndex);
                    if (book == null || book.func_77973_b() != Items.field_151134_bR || (tagBook = book.func_77978_p()) == null || (ea = tagBook.func_74775_l("ExtraAttributes")) == null || (enchantments = ea.func_74775_l("enchantments")) == null) continue;
                    String enchId = Utils.cleanColour(book.func_82833_r()).toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_").replaceAll("[^a-z_]", "");
                    String name = Utils.cleanColour(book.func_82833_r());
                    int enchLevel = -1;
                    if (name.equalsIgnoreCase("Bane of Arthropods")) {
                        name = "Bane of Arth.";
                    } else if (name.equalsIgnoreCase("Projectile Protection")) {
                        name = "Projectile Prot";
                    } else if (name.equalsIgnoreCase("Blast Protection")) {
                        name = "Blast Prot";
                    }
                    Matcher levelMatcher = ENCHANT_LEVEL_PATTERN.matcher(enchId);
                    if (levelMatcher.matches()) {
                        enchLevel = Utils.parseRomanNumeral(levelMatcher.group(2).toUpperCase(Locale.ROOT));
                        enchId = levelMatcher.group(1);
                    }
                    Enchantment enchantment = new Enchantment(slotIndex, name, enchId, Utils.getRawTooltip(book), enchLevel, false, true);
                    enchantment.displayLore.remove(0);
                    if (this.removingEnchantPlayerLevel == -1 && this.playerEnchantIds.containsKey(enchId)) {
                        this.removingEnchantPlayerLevel = this.playerEnchantIds.get(enchId);
                    }
                    if (this.removingEnchantPlayerLevel >= 0 && enchantment.level < this.removingEnchantPlayerLevel) continue;
                    if (this.enchanterCurrentEnch == null) {
                        this.enchanterCurrentEnch = enchantment;
                    } else if (updateLevel) {
                        if (this.removingEnchantPlayerLevel < 0 && enchantment.level > this.enchanterCurrentEnch.level) {
                            this.enchanterCurrentEnch = enchantment;
                        } else if (this.removingEnchantPlayerLevel >= 0 && enchantment.level < this.enchanterCurrentEnch.level) {
                            this.enchanterCurrentEnch = enchantment;
                        }
                    }
                    this.enchanterEnchLevels.put(enchantment.level, enchantment);
                }
                if (this.enchanterCurrentEnch != null && this.removingEnchantPlayerLevel >= 0) {
                    for (String line : this.enchanterCurrentEnch.displayLore) {
                        Matcher matcher = XP_COST_PATTERN.matcher(line);
                        Matcher discount_matcher = DISCOUNT_COST_PATTERN.matcher(line);
                        if (matcher.find()) {
                            this.enchanterCurrentEnch.xpCost = Integer.parseInt(matcher.group(1));
                            continue;
                        }
                        if (!discount_matcher.find()) continue;
                        this.enchanterCurrentEnch.xpCost = Integer.parseInt(discount_matcher.group(2));
                    }
                }
            } else {
                this.isChangingEnchLevel = false;
                this.enchanterCurrentEnch = null;
                this.searchRemovedFromRemovable = false;
                this.searchRemovedFromApplicable = false;
                this.applicable.clear();
                this.removable.clear();
                if (this.currentState == EnchantState.HAS_ITEM) {
                    for (int i = 0; i < 15; ++i) {
                        String enchId;
                        NBTTagCompound enchantments;
                        NBTTagCompound ea;
                        NBTTagCompound tagBook;
                        int slotIndex = 12 + i % 5 + i / 5 * 9;
                        ItemStack book = cc.func_85151_d().func_70301_a(slotIndex);
                        if (book == null || (tagBook = book.func_77978_p()) == null || (ea = tagBook.func_74775_l("ExtraAttributes")) == null || (enchantments = ea.func_74775_l("enchantments")) == null || (enchId = Utils.cleanColour(book.func_82833_r()).toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_").replaceAll("[^a-z_]", "")).equalsIgnoreCase("_")) continue;
                        enchId = ItemUtils.fixEnchantId(enchId, true);
                        String name = Utils.cleanColour(book.func_82833_r());
                        if (this.searchField.getText().trim().isEmpty() || name.toLowerCase(Locale.ROOT).contains(this.searchField.getText().trim().toLowerCase(Locale.ROOT))) {
                            Enchantment enchantment;
                            if (name.equalsIgnoreCase("Bane of Arthropods")) {
                                name = "Bane of Arth.";
                            } else if (name.equalsIgnoreCase("Projectile Protection")) {
                                name = "Projectile Prot";
                            } else if (name.equalsIgnoreCase("Blast Protection")) {
                                name = "Blast Prot";
                            } else if (name.equalsIgnoreCase("Luck of the Sea")) {
                                name = "Luck of Sea";
                            }
                            Matcher nameMatcher = ENCHANT_NAME_PATTERN.matcher(name);
                            if (nameMatcher.matches()) {
                                name = nameMatcher.group(1);
                            }
                            if (this.playerEnchantIds.containsKey(enchId)) {
                                enchantment = new Enchantment(slotIndex, name, enchId, Utils.getRawTooltip(book), this.playerEnchantIds.get(enchId), false, false);
                                if (enchantment.overMaxLevel) continue;
                                this.removable.add(enchantment);
                                continue;
                            }
                            enchantment = new Enchantment(slotIndex, name, enchId, Utils.getRawTooltip(book), 1, true, true);
                            this.applicable.add(enchantment);
                            continue;
                        }
                        if (this.playerEnchantIds.containsKey(enchId)) {
                            this.searchRemovedFromRemovable = true;
                            continue;
                        }
                        this.searchRemovedFromApplicable = true;
                    }
                    NEUConfig cfg = NotEnoughUpdates.INSTANCE.config;
                    int mult = cfg.enchantingSolvers.enchantOrdering == 0 ? 1 : -1;
                    Comparator<Enchantment> comparator = cfg.enchantingSolvers.enchantSorting == 0 ? Comparator.comparingInt(e2 -> mult * e2.xpCost) : (c1, c2) -> mult * c1.enchId.toLowerCase(Locale.ROOT).compareTo(c2.enchId.toLowerCase(Locale.ROOT));
                    this.removable.sort(comparator);
                    this.applicable.sort(comparator);
                }
            }
        }
        if (this.lastState != this.currentState) {
            do {
                this.pageOpenRandom += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (!(this.pageOpen > this.pageOpenRandom + 1.0f) && !(this.pageOpen < this.pageOpenRandom - 1.0f));
        }
        this.pageOpenLast = this.pageOpen;
        this.bookOpenLast = this.bookOpen;
        this.bookOpen = this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT ? (this.bookOpen += 0.2f) : (this.bookOpen -= 0.2f);
        this.bookOpen = MathHelper.func_76131_a((float)this.bookOpen, (float)0.0f, (float)1.0f);
        float f1 = (this.pageOpenRandom - this.pageOpen) * 0.4f;
        f1 = MathHelper.func_76131_a((float)f1, (float)-0.2f, (float)0.2f);
        this.pageOpenVelocity += (f1 - this.pageOpenVelocity) * 0.9f;
        this.pageOpen += this.pageOpenVelocity;
    }

    private List<String> createTooltip(String title, int selectedOption, String ... options) {
        String selPrefix = EnumChatFormatting.DARK_AQUA + " \u25b6 ";
        String unselPrefix = EnumChatFormatting.GRAY.toString();
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == selectedOption ? selPrefix + options[i] : unselPrefix + options[i];
        }
        ArrayList list = Lists.newArrayList((Object[])options);
        list.add(0, "");
        list.add(0, EnumChatFormatting.GREEN + title);
        return list;
    }

    public void render(float partialTicks) {
        int itemY;
        int vOffset;
        int top;
        Enchantment ench;
        int index;
        int i;
        int offset;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        int playerXpLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)chest.field_147002_h;
        this.leftScroll.tick();
        this.rightScroll.tick();
        this.arrowAmount.tick();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        this.guiLeft = (width - 364) / 2;
        this.guiTop = (height - 215) / 2;
        ArrayList tooltipToDisplay = null;
        boolean disallowClick = false;
        ItemStack stackOnMouse = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        int itemHoverX = -1;
        int itemHoverY = -1;
        boolean hoverLocked = false;
        this.func_73733_a(0, 0, width, height, -1072689136, -804253680);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, 364.0f, 215.0f, 0.0f, 0.7109375f, 0.0f, 0.41992188f, 9728);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a("Applicable", (float)(this.guiLeft + 7), (float)(this.guiTop + 7), 0x404040, false);
        fr.func_175065_a("Removable", (float)(this.guiLeft + 247), (float)(this.guiTop + 7), 0x404040, false);
        if (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT) {
            String pageStr = "Page: " + this.currentPage + "/" + this.expectedMaxPage;
            int pageStrLen = fr.func_78256_a(pageStr);
            Utils.drawStringCentered(pageStr, this.guiLeft + 182, this.guiTop + 14, false, 0x404040);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 182 - pageStrLen / 2 - 2 - 15, this.guiTop + 6, 15.0f, 15.0f, 0.0f, 0.029296875f, 0.7265625f, 0.7558594f, 9728);
            Utils.drawTexturedRect(this.guiLeft + 182 + pageStrLen / 2 + 2, this.guiTop + 6, 15.0f, 15.0f, 0.029296875f, 0.05859375f, 0.7265625f, 0.7558594f, 9728);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft + 295, this.guiTop + 147, 16.0f, 16.0f, 0.0f, 0.03125f, 0.7558594f, 0.7871094f, 9728);
        float sortingMinU = (float)(NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting * 16) / 512.0f;
        Utils.drawTexturedRect(this.guiLeft + 295, this.guiTop + 147 + 18, 16.0f, 16.0f, sortingMinU, sortingMinU + 0.03125f, 0.8183594f, 0.8496094f, 9728);
        float orderingMinU = (float)(NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering * 16) / 512.0f;
        Utils.drawTexturedRect(this.guiLeft + 295 + 18, this.guiTop + 147 + 18, 16.0f, 16.0f, orderingMinU, orderingMinU + 0.03125f, 0.8496094f, 0.8808594f, 9728);
        if (mouseX >= this.guiLeft + 294 && mouseX < this.guiLeft + 294 + 36 && mouseY >= this.guiTop + 146 && mouseY < this.guiTop + 146 + 36) {
            int index2 = (mouseX - (this.guiLeft + 295)) / 18 + (mouseY - (this.guiTop + 147)) / 18 * 2;
            switch (index2) {
                case 0: {
                    Gui.func_73734_a((int)(this.guiLeft + 295), (int)(this.guiTop + 147), (int)(this.guiLeft + 295 + 16), (int)(this.guiTop + 147 + 16), (int)-2130706433);
                    tooltipToDisplay = this.createTooltip("Enable GUI", 0, "On", "Off");
                    break;
                }
                case 2: {
                    Gui.func_73734_a((int)(this.guiLeft + 295), (int)(this.guiTop + 147 + 18), (int)(this.guiLeft + 295 + 16), (int)(this.guiTop + 147 + 16 + 18), (int)-2130706433);
                    tooltipToDisplay = this.createTooltip("Sort enchants...", NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting, "By Cost", "Alphabetically");
                    break;
                }
                case 3: {
                    Gui.func_73734_a((int)(this.guiLeft + 295 + 18), (int)(this.guiTop + 147 + 18), (int)(this.guiLeft + 295 + 16 + 18), (int)(this.guiTop + 147 + 16 + 18), (int)-2130706433);
                    tooltipToDisplay = this.createTooltip("Order enchants...", NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering, "Ascending", "Descending");
                }
            }
        }
        if (this.applicable.size() <= 6) {
            offset = 0;
        } else if (this.isScrollingLeft && this.clickedScrollOffset >= 0) {
            offset = mouseY - this.clickedScrollOffset;
            if (offset < 0) {
                offset = 0;
            }
            if (offset > 81) {
                offset = 81;
            }
        } else {
            offset = Math.round(81.0f * ((float)this.leftScroll.getValue() / (float)((this.applicable.size() - 6) * 16)));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft + 104, this.guiTop + 18 + offset, 12.0f, 15.0f, 0.0f, 0.0234375f, 0.6113281f, 0.640625f, 9728);
        if (this.removable.size() <= 6) {
            offset = 0;
        } else if (!this.isScrollingLeft && this.clickedScrollOffset >= 0) {
            offset = mouseY - this.clickedScrollOffset;
            if (offset < 0) {
                offset = 0;
            }
            if (offset > 81) {
                offset = 81;
            }
        } else {
            offset = Math.round(81.0f * ((float)this.rightScroll.getValue() / (float)((this.removable.size() - 6) * 16)));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft + 344, this.guiTop + 18 + offset, 12.0f, 15.0f, 0.0f, 0.0234375f, 0.6113281f, 0.640625f, 9728);
        this.renderEnchantBook(scaledResolution, partialTicks);
        if (this.currentState == EnchantState.INVALID_ITEM) {
            GlStateManager.func_179097_i();
            Utils.drawStringCentered("This item can't", this.guiLeft + 182, this.guiTop + 88, true, -43691);
            Utils.drawStringCentered("be enchanted", this.guiLeft + 182, this.guiTop + 98, true, -43691);
            GlStateManager.func_179126_j();
        }
        if (this.arrowAmount.getValue() > 0.0f) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float w = 22.0f * this.arrowAmount.getValue();
            if (this.removingEnchantPlayerLevel < 0) {
                Utils.drawTexturedRect(this.guiLeft + 134, this.guiTop + 58, w, 16.0f, 0.0f, w / 512.0f, 0.5800781f, 0.6113281f, 9728);
            } else {
                Utils.drawTexturedRect((float)(this.guiLeft + 230) - w, this.guiTop + 58, w, 16.0f, (44.0f - w) / 512.0f, 0.0859375f, 0.5800781f, 0.6113281f, 9728);
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT) {
            if (this.applicable.isEmpty() && this.removable.isEmpty() && this.searchRemovedFromApplicable) {
                Utils.drawStringCentered("Can't find that", this.guiLeft + 8 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchant, perhaps", this.guiLeft + 8 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("it is on", this.guiLeft + 8 + 48, this.guiTop + 48, true, -43691);
                Utils.drawStringCentered("another page?", this.guiLeft + 8 + 48, this.guiTop + 58, true, -43691);
            } else if (this.applicable.isEmpty() && !this.searchRemovedFromApplicable) {
                Utils.drawStringCentered("No applicable", this.guiLeft + 8 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchants on", this.guiLeft + 8 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("this page...", this.guiLeft + 8 + 48, this.guiTop + 48, true, -43691);
            }
            if (this.applicable.isEmpty() && this.removable.isEmpty() && this.searchRemovedFromRemovable) {
                Utils.drawStringCentered("Can't find that", this.guiLeft + 248 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchant, perhaps", this.guiLeft + 248 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("it is on", this.guiLeft + 248 + 48, this.guiTop + 48, true, -43691);
                Utils.drawStringCentered("another page?", this.guiLeft + 248 + 48, this.guiTop + 58, true, -43691);
            } else if (this.removable.isEmpty() && !this.searchRemovedFromRemovable) {
                Utils.drawStringCentered("No removable", this.guiLeft + 248 + 48, this.guiTop + 28, true, -43691);
                Utils.drawStringCentered("enchants on", this.guiLeft + 248 + 48, this.guiTop + 38, true, -43691);
                Utils.drawStringCentered("this page...", this.guiLeft + 248 + 48, this.guiTop + 48, true, -43691);
            }
        }
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.leftScroll.getValue() / 16;
            if (this.applicable.size() <= index) break;
            ench = this.applicable.get(index);
            top = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentEnch != null && this.enchanterCurrentEnch.enchId.equals(ench.enchId) ? 16 : 0;
            int uOffset = ench.conflicts ? 112 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 8, top, 96.0f, 16.0f, (float)uOffset / 512.0f, (float)(96 + uOffset) / 512.0f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 8 && mouseX <= this.guiLeft + 8 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (ench.displayLore != null) {
                    tooltipToDisplay = ench.displayLore;
                }
            }
            String levelStr = "" + ench.xpCost;
            int colour = 0xC8FF8F;
            if (ench.xpCost > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 16 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(ench.enchantName, (float)(this.guiLeft + 8 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        GlScissorStack.push(0, this.guiTop + 18, width, this.guiTop + 18 + 96, scaledResolution);
        for (i = 0; i < 7; ++i) {
            index = i + this.rightScroll.getValue() / 16;
            if (this.removable.size() <= index) break;
            ench = this.removable.get(index);
            top = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i;
            vOffset = this.enchanterCurrentEnch != null && this.enchanterCurrentEnch.enchId.equals(ench.enchId) ? 16 : 0;
            int textOffset = vOffset / 16;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft + 248, top, 96.0f, 16.0f, 0.0f, 0.1875f, (float)(249 + vOffset) / 512.0f, (float)(265 + vOffset) / 512.0f, 9728);
            if (mouseX > this.guiLeft + 248 && mouseX <= this.guiLeft + 248 + 96 && mouseY > top && mouseY <= top + 16) {
                disallowClick = true;
                if (ench.displayLore != null) {
                    tooltipToDisplay = ench.displayLore;
                }
            }
            String levelStr = "" + ench.xpCost;
            if (ench.xpCost < 0) {
                levelStr = "?";
            }
            int colour = 0xC8FF8F;
            if (ench.xpCost > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 - 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2 + 1), (float)(top + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(this.guiLeft + 256 - levelWidth / 2), (float)(top + 4), colour, false);
            fr.func_175065_a(ench.enchantName, (float)(this.guiLeft + 248 + 16 + 2 + textOffset), (float)(top + 4 + textOffset), -35, true);
        }
        GlScissorStack.pop(scaledResolution);
        fr.func_78276_b(Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150260_c(), this.guiLeft + 102, this.guiTop + 215 - 96 + 2, 0x404040);
        int inventoryStartIndex = cc.func_85151_d().func_70302_i_();
        GlStateManager.func_179126_j();
        for (int i2 = 0; i2 < 36; ++i2) {
            int itemX = this.guiLeft + 102 + 18 * (i2 % 9);
            itemY = this.guiTop + 133 + 18 * (i2 / 9);
            if (i2 >= 27) {
                itemY += 4;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 102 - 8), (float)(this.guiTop + 191 - (inventoryStartIndex / 9 * 18 + 89)), (float)0.0f);
            Slot slot = cc.func_75139_a(inventoryStartIndex + i2);
            ((AccessorGuiContainer)chest).doDrawSlot(slot);
            GlStateManager.func_179121_F();
            if (mouseX < itemX || mouseX >= itemX + 18 || mouseY < itemY || mouseY >= itemY + 18) continue;
            itemHoverX = itemX;
            itemHoverY = itemY;
            hoverLocked = SlotLocking.getInstance().isSlotLocked(slot);
            if (!slot.func_75216_d()) continue;
            tooltipToDisplay = slot.func_75211_c().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        if (this.currentState == EnchantState.HAS_ITEM) {
            if (this.searchField.getText().isEmpty() && !this.searchField.getFocus()) {
                this.searchField.setSize(90, 14);
                this.searchField.setPrependText("\u00a77Search...");
            } else {
                if (this.searchField.getFocus()) {
                    int len2 = fr.func_78256_a(this.searchField.getTextDisplay()) + 10;
                    this.searchField.setSize(Math.max(90, len2), 14);
                } else {
                    this.searchField.setSize(90, 14);
                }
                this.searchField.setPrependText("");
            }
            this.searchField.render(this.guiLeft + 182 - this.searchField.getWidth() / 2, this.guiTop + 83);
        } else if (this.currentState == EnchantState.ADDING_ENCHANT && this.enchanterCurrentEnch != null && !this.enchanterEnchLevels.isEmpty()) {
            int left = this.guiLeft + 182 - 56;
            int top2 = this.guiTop + 83;
            int uOffset = this.enchanterCurrentEnch.conflicts ? 112 : 0;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(left, top2, 112.0f, 16.0f, (float)uOffset / 512.0f, (float)(112 + uOffset) / 512.0f, 0.48632812f, 0.5175781f, 9728);
            if (mouseX > left + 16 && mouseX <= left + 96 && mouseY > top2 && mouseY <= top2 + 16) {
                disallowClick = true;
                if (this.enchanterCurrentEnch.displayLore != null) {
                    tooltipToDisplay = this.enchanterCurrentEnch.displayLore;
                }
            }
            String levelStr = "" + this.enchanterCurrentEnch.xpCost;
            if (this.enchanterCurrentEnch.xpCost < 0) {
                levelStr = "?";
            }
            int colour = 0xC8FF8F;
            if (this.enchanterCurrentEnch.xpCost > playerXpLevel) {
                colour = 0xFF5555;
            }
            int levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2 - 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2 + 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top2 + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top2 + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 8 - levelWidth / 2), (float)(top2 + 4), colour, false);
            String name = WordUtils.capitalizeFully((String)ItemUtils.fixEnchantId(this.enchanterCurrentEnch.enchId, false).replace("_", " "));
            if (name.equalsIgnoreCase("Bane of Arthropods")) {
                name = "Bane of Arth.";
            } else if (name.equalsIgnoreCase("Projectile Protection")) {
                name = "Projectile Prot";
            } else if (name.equalsIgnoreCase("Blast Protection")) {
                name = "Blast Prot";
            } else if (name.equalsIgnoreCase("Luck of the Sea")) {
                name = "Luck of Sea";
            }
            Utils.drawStringCentered(name, this.guiLeft + 182, top2 + 8, true, -35);
            if (this.isChangingEnchLevel) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(left + 96, top2, 16.0f, 16.0f, 0.1875f, 0.21875f, 0.5175781f, 0.5488281f, 9728);
            }
            levelStr = "" + this.enchanterCurrentEnch.level;
            if (this.enchanterCurrentEnch.xpCost < 0) {
                levelStr = "?";
            }
            levelWidth = fr.func_78256_a(levelStr);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 - 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 + 1), (float)(top2 + 4), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 4 - 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 4 + 1), 2957570, false);
            fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 4), 15368959, false);
            String confirmText = "Apply";
            if (this.removingEnchantPlayerLevel >= 0) {
                confirmText = this.removingEnchantPlayerLevel == this.enchanterCurrentEnch.level ? "Remove" : (this.enchanterCurrentEnch.level > this.removingEnchantPlayerLevel ? "Upgrade" : "Bad Level");
            }
            if (System.currentTimeMillis() - this.confirmButtonAnimTime < 500L && playerXpLevel >= this.enchanterCurrentEnch.xpCost) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 23, top2 + 18 + 9, false, 0x408040);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawStringCentered(confirmText, this.guiLeft + 182 - 1 - 24, top2 + 18 + 8, false, 0x408040);
                if (playerXpLevel < this.enchanterCurrentEnch.xpCost) {
                    Gui.func_73734_a((int)(this.guiLeft + 182 - 1 - 48), (int)(top2 + 18), (int)(this.guiLeft + 182 - 1), (int)(top2 + 18 + 14), (int)Integer.MIN_VALUE);
                }
            }
            if (System.currentTimeMillis() - this.cancelButtonAnimTime < 500L) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.66796875f, 0.6953125f, 9728);
                Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 25, top2 + 18 + 9, false, 0xA04040);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.guiLeft + 182 + 1, top2 + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
                Utils.drawStringCentered("Cancel", this.guiLeft + 182 + 1 + 24, top2 + 18 + 8, false, 0xA04040);
            }
            if (mouseY > top2 + 18 && mouseY <= top2 + 18 + 16) {
                if (mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1) {
                    disallowClick = true;
                    if (this.enchanterCurrentEnch.displayLore != null) {
                        tooltipToDisplay = this.enchanterCurrentEnch.displayLore;
                    }
                } else if (mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48) {
                    disallowClick = true;
                    tooltipToDisplay = Lists.newArrayList((Object[])new String[]{"\u00a7cCancel"});
                }
            }
            if (this.isChangingEnchLevel) {
                tooltipToDisplay = null;
                ArrayList<Enchantment> before = new ArrayList<Enchantment>();
                ArrayList<Enchantment> after = new ArrayList<Enchantment>();
                for (Enchantment ench2 : this.enchanterEnchLevels.values()) {
                    if (ench2.level < this.enchanterCurrentEnch.level) {
                        before.add(ench2);
                        continue;
                    }
                    if (ench2.level <= this.enchanterCurrentEnch.level) continue;
                    after.add(ench2);
                }
                before.sort(Comparator.comparingInt(o -> -o.level));
                after.sort(Comparator.comparingInt(o -> o.level));
                int bSize = before.size();
                int aSize = after.size();
                GlStateManager.func_179097_i();
                for (int i3 = 0; i3 < bSize + aSize; ++i3) {
                    int yIndex;
                    Enchantment ench3;
                    if (i3 < bSize) {
                        ench3 = (Enchantment)before.get(i3);
                        yIndex = -i3 - 1;
                    } else {
                        ench3 = (Enchantment)after.get(i3 - bSize);
                        yIndex = i3 - bSize + 1;
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int type2 = 0;
                    if (i3 == bSize) {
                        type2 = 2;
                    } else if (i3 == 0) {
                        type2 = 1;
                    }
                    if (mouseX > left + 96 && mouseX <= left + 96 + 16 && mouseY > top2 + 16 * yIndex && mouseY <= top2 + 16 * yIndex + 16) {
                        tooltipToDisplay = new ArrayList(ench3.displayLore);
                        if (tooltipToDisplay.size() > 2) {
                            tooltipToDisplay.remove(tooltipToDisplay.size() - 1);
                            tooltipToDisplay.remove(tooltipToDisplay.size() - 1);
                        }
                        itemHoverX = -1;
                        itemHoverY = -1;
                    }
                    Utils.drawTexturedRect(left + 96, top2 + 16 * yIndex, 16.0f, 16.0f, (float)(16 * type2) / 512.0f, (float)(16 + 16 * type2) / 512.0f, 0.6953125f, 0.7265625f, 9728);
                    levelStr = "" + ench3.level;
                    levelWidth = fr.func_78256_a(levelStr);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 - 1), (float)(top2 + 16 * yIndex + 4), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2 + 1), (float)(top2 + 16 * yIndex + 4), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 16 * yIndex + 4 - 1), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 16 * yIndex + 4 + 1), 2957570, false);
                    fr.func_175065_a(levelStr, (float)(left + 96 + 8 - levelWidth / 2), (float)(top2 + 16 * yIndex + 4), 15368959, false);
                }
                GlStateManager.func_179126_j();
            }
            if (mouseX > left + 96 && mouseX <= left + 96 + 16 && mouseY > top2 && mouseY <= top2 + 16) {
                tooltipToDisplay = this.isChangingEnchLevel ? Lists.newArrayList((Object[])new String[]{"\u00a7cCancel level change"}) : Lists.newArrayList((Object[])new String[]{"\u00a7aChange enchant level"});
            }
        }
        ItemStack itemEnchantInput = cc.func_75139_a(19).func_75211_c();
        if (itemEnchantInput != null && itemEnchantInput.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
            itemEnchantInput = this.enchantingItem;
        }
        int itemX = this.guiLeft + 174;
        itemY = this.guiTop + 58;
        if (itemEnchantInput == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(itemX, itemY, 16.0f, 16.0f, 0.0f, 0.03125f, 0.5488281f, 0.5800781f, 9728);
        } else {
            Utils.drawItemStack(itemEnchantInput, itemX, itemY);
        }
        if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
            itemHoverX = itemX;
            itemHoverY = itemY;
            if (itemEnchantInput != null) {
                tooltipToDisplay = itemEnchantInput.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
            }
        }
        if (!this.isChangingEnchLevel && itemHoverX >= 0 && itemHoverY >= 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)itemHoverX, (int)itemHoverY, (int)(itemHoverX + 16), (int)(itemHoverY + 16), (int)(hoverLocked ? -2130739072 : -2130706433));
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.orbDisplay.renderOrbs(partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        if (stackOnMouse != null) {
            if (disallowClick) {
                Utils.drawItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_180401_cv)), mouseX - 8, mouseY - 8);
            } else {
                Utils.drawItemStack(stackOnMouse, mouseX - 8, mouseY - 8);
            }
        } else if (tooltipToDisplay != null) {
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    private void renderEnchantBook(ScaledResolution scaledresolution, float partialTicks) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179083_b((int)((scaledresolution.func_78326_a() - 320) / 2 * scaledresolution.func_78325_e()), (int)((scaledresolution.func_78328_b() - 240) / 2 * scaledresolution.func_78325_e()), (int)(320 * scaledresolution.func_78325_e()), (int)(240 * scaledresolution.func_78325_e()));
        GlStateManager.func_179109_b((float)0.0f, (float)0.33f, (float)0.0f);
        Project.gluPerspective((float)90.0f, (float)1.3333334f, (float)9.0f, (float)80.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        RenderHelper.func_74519_b();
        GlStateManager.func_179109_b((float)0.0f, (float)3.3f, (float)-16.0f);
        GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)5.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ENCHANTMENT_TABLE_BOOK_TEXTURE);
        GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float bookOpenAngle = this.bookOpenLast + (this.bookOpen - this.bookOpenLast) * partialTicks;
        GlStateManager.func_179109_b((float)((1.0f - bookOpenAngle) * 0.2f), (float)((1.0f - bookOpenAngle) * 0.1f), (float)((1.0f - bookOpenAngle) * 0.25f));
        GlStateManager.func_179114_b((float)(-(1.0f - bookOpenAngle) * 90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float pageAngle1 = this.pageOpenLast + (this.pageOpen - this.pageOpenLast) * partialTicks + 0.25f;
        float pageAngle2 = this.pageOpenLast + (this.pageOpen - this.pageOpenLast) * partialTicks + 0.75f;
        pageAngle1 = (pageAngle1 - (float)MathHelper.func_76140_b((double)pageAngle1)) * 1.6f - 0.3f;
        pageAngle2 = (pageAngle2 - (float)MathHelper.func_76140_b((double)pageAngle2)) * 1.6f - 0.3f;
        if (pageAngle1 < 0.0f) {
            pageAngle1 = 0.0f;
        }
        if (pageAngle1 > 1.0f) {
            pageAngle1 = 1.0f;
        }
        if (pageAngle2 < 0.0f) {
            pageAngle2 = 0.0f;
        }
        if (pageAngle2 > 1.0f) {
            pageAngle2 = 1.0f;
        }
        GlStateManager.func_179091_B();
        MODEL_BOOK.func_78088_a(null, 0.0f, pageAngle1, pageAngle2, bookOpenAngle, 0.0f, 0.0625f);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
    }

    public void overrideIsMouseOverSlot(Slot slot, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (this.shouldOverrideFast && this.currentState != EnchantState.ADDING_ENCHANT) {
            boolean playerInv = slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by;
            int slotId = slot.getSlotIndex();
            if (playerInv && slotId < 36) {
                if ((slotId -= 9) < 0) {
                    slotId += 36;
                }
                int itemX = this.guiLeft + 102 + 18 * (slotId % 9);
                int itemY = this.guiTop + 133 + 18 * (slotId / 9);
                if (slotId >= 27) {
                    itemY += 4;
                }
                if (mouseX >= itemX && mouseX < itemX + 18 && mouseY >= itemY && mouseY < itemY + 18) {
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
            } else if (slotId == 19) {
                cir.setReturnValue((Object)(mouseX >= this.guiLeft + 173 && mouseX < this.guiLeft + 173 + 18 && mouseY >= this.guiTop + 57 && mouseY < this.guiTop + 57 + 18 ? 1 : 0));
            }
        }
    }

    public boolean mouseInput(int mouseX, int mouseY) {
        if (Mouse.getEventButtonState() && (this.currentState == EnchantState.HAS_ITEM || this.currentState == EnchantState.ADDING_ENCHANT) && mouseY > this.guiTop + 6 && mouseY < this.guiTop + 6 + 15) {
            String pageStr = "Page: " + this.currentPage + "/" + this.expectedMaxPage;
            int pageStrLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(pageStr);
            int click = -1;
            if (mouseX > this.guiLeft + 182 - pageStrLen / 2 - 2 - 15 && mouseX <= this.guiLeft + 182 - pageStrLen / 2 - 2) {
                click = 17;
            } else if (mouseX > this.guiLeft + 182 + pageStrLen / 2 + 2 && mouseX <= this.guiLeft + 182 + pageStrLen / 2 + 2 + 15) {
                click = 35;
            }
            if (click >= 0) {
                if (this.currentState == EnchantState.ADDING_ENCHANT) {
                    if (Mouse.getEventButtonState()) {
                        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                            return true;
                        }
                        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                        EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                        short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                        ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                        Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                        this.cancelButtonAnimTime = System.currentTimeMillis();
                    }
                } else {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                    short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(click);
                    Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, click, 0, 0, stack, transactionID));
                }
                return true;
            }
        }
        if (this.currentState == EnchantState.HAS_ITEM) {
            if (Mouse.getEventButtonState()) {
                if (mouseX > this.guiLeft + 182 - this.searchField.getWidth() / 2 && mouseX < this.guiLeft + 182 + this.searchField.getWidth() / 2 && mouseY > this.guiTop + 80 && mouseY < this.guiTop + 96) {
                    this.searchField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                } else {
                    this.searchField.setFocus(false);
                }
            } else if (Mouse.getEventButton() < 0 && this.searchField.getFocus() && Mouse.isButtonDown((int)0)) {
                this.searchField.mouseClickMove(mouseX, mouseY, 0, 0L);
            }
        } else if (this.currentState == EnchantState.ADDING_ENCHANT && !this.enchanterEnchLevels.isEmpty() && Mouse.getEventButtonState()) {
            short transactionID;
            EntityPlayerSP playerIn;
            int left = this.guiLeft + 182 - 56;
            int top = this.guiTop + 83;
            Utils.drawTexturedRect(this.guiLeft + 182 - 1 - 48, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
            Utils.drawTexturedRect(this.guiLeft + 182 + 1, top + 18, 48.0f, 14.0f, 0.0f, 0.09375f, 0.640625f, 0.66796875f, 9728);
            if (!this.isChangingEnchLevel && mouseX > this.guiLeft + 182 + 1 && mouseX <= this.guiLeft + 182 + 1 + 48 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                    return true;
                }
                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                playerIn = Minecraft.func_71410_x().field_71439_g;
                transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                this.cancelButtonAnimTime = System.currentTimeMillis();
            } else if (!this.isChangingEnchLevel && this.enchanterCurrentEnch != null && mouseX > left + 16 && mouseX <= left + 96 && mouseY > top && mouseY <= top + 16 || mouseX > this.guiLeft + 182 - 1 - 48 && mouseX <= this.guiLeft + 182 - 1 && mouseY > top + 18 && mouseY <= top + 18 + 14) {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                    return true;
                }
                GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                playerIn = Minecraft.func_71410_x().field_71439_g;
                transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(this.enchanterCurrentEnch.slotIndex);
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, this.enchanterCurrentEnch.slotIndex, 0, 0, stack, transactionID));
                int playerXpLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
                if (playerXpLevel >= this.enchanterCurrentEnch.xpCost) {
                    if (this.removingEnchantPlayerLevel >= 0 && this.enchanterCurrentEnch.level == this.removingEnchantPlayerLevel) {
                        this.orbDisplay.spawnExperienceOrbs(182, 66, 182, 36, 3);
                    } else {
                        this.orbDisplay.spawnExperienceOrbs(mouseX - this.guiLeft, mouseY - this.guiTop, 182, 66, 0);
                    }
                }
                this.confirmButtonAnimTime = System.currentTimeMillis();
            } else if (mouseX > left + 96 && mouseX <= left + 96 + 16) {
                if (!this.isChangingEnchLevel) {
                    if (mouseY > top && mouseY < top + 16) {
                        this.isChangingEnchLevel = true;
                        return true;
                    }
                } else {
                    ArrayList<Enchantment> before = new ArrayList<Enchantment>();
                    ArrayList<Enchantment> after = new ArrayList<Enchantment>();
                    for (Enchantment ench : this.enchanterEnchLevels.values()) {
                        if (ench.level < this.enchanterCurrentEnch.level) {
                            before.add(ench);
                            continue;
                        }
                        if (ench.level <= this.enchanterCurrentEnch.level) continue;
                        after.add(ench);
                    }
                    before.sort(Comparator.comparingInt(o -> -o.level));
                    after.sort(Comparator.comparingInt(o -> o.level));
                    int bSize = before.size();
                    int aSize = after.size();
                    for (int i = 0; i < bSize + aSize; ++i) {
                        Enchantment ench;
                        int yIndex;
                        if (i < bSize) {
                            yIndex = -i - 1;
                            ench = (Enchantment)before.get(i);
                        } else {
                            yIndex = i - bSize + 1;
                            ench = (Enchantment)after.get(i - bSize);
                        }
                        if (mouseY <= top + 16 * yIndex || mouseY > top + 16 * yIndex + 16) continue;
                        this.enchanterCurrentEnch = ench;
                        this.isChangingEnchLevel = false;
                        return true;
                    }
                }
            }
            if (this.isChangingEnchLevel) {
                this.isChangingEnchLevel = false;
                return true;
            }
        }
        if (!Mouse.getEventButtonState() && Mouse.getEventButton() < 0 && this.clickedScrollOffset != -1) {
            List<Enchantment> enchantsList;
            LerpingInteger lerpingInteger = this.isClickedScrollLeft ? this.leftScroll : this.rightScroll;
            List<Enchantment> list = enchantsList = this.isClickedScrollLeft ? this.applicable : this.removable;
            if (enchantsList.size() > 6) {
                int max2;
                int newOffset = mouseY - this.clickedScrollOffset;
                int newScroll = Math.round((float)newOffset * (float)((enchantsList.size() - 6) * 16) / 81.0f);
                if (newScroll > (max2 = (enchantsList.size() - 6) * 16)) {
                    newScroll = max2;
                }
                if (newScroll < 0) {
                    newScroll = 0;
                }
                lerpingInteger.setValue(newScroll);
            }
        }
        if (Mouse.getEventButtonState() && mouseX >= this.guiLeft + 294 && mouseX < this.guiLeft + 294 + 36 && mouseY >= this.guiTop + 146 && mouseY < this.guiTop + 146 + 36) {
            int index = (mouseX - (this.guiLeft + 295)) / 18 + (mouseY - (this.guiTop + 147)) / 18 * 2;
            int direction = Mouse.getEventButton() == 0 ? 1 : -1;
            switch (index) {
                case 0: {
                    NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableTableGUI = false;
                    break;
                }
                case 2: {
                    int val = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting;
                    if ((val += direction) < 0) {
                        val = 1;
                    }
                    if (val > 1) {
                        val = 0;
                    }
                    NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantSorting = val;
                    break;
                }
                case 3: {
                    int val = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering;
                    if ((val += direction) < 0) {
                        val = 1;
                    }
                    if (val > 1) {
                        val = 0;
                    }
                    NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enchantOrdering = val;
                    break;
                }
            }
        }
        if (Mouse.getEventButton() == 0) {
            if (Mouse.getEventButtonState()) {
                int offset;
                if (mouseX > this.guiLeft + 104 && mouseX < this.guiLeft + 104 + 12) {
                    int offset2 = this.applicable.size() <= 6 ? 0 : Math.round(81.0f * ((float)this.leftScroll.getValue() / (float)((this.applicable.size() - 6) * 16)));
                    if (mouseY >= this.guiTop + 18 + offset2 && mouseY < this.guiTop + 18 + offset2 + 15) {
                        this.isClickedScrollLeft = true;
                        this.clickedScrollOffset = mouseY - offset2;
                    }
                } else if (mouseX > this.guiLeft + 344 && mouseX < this.guiLeft + 344 + 12 && mouseY >= this.guiTop + 18 + (offset = this.removable.size() <= 6 ? 0 : Math.round(81.0f * ((float)this.rightScroll.getValue() / (float)((this.removable.size() - 6) * 16)))) && mouseY < this.guiTop + 18 + offset + 15) {
                    this.isClickedScrollLeft = false;
                    this.clickedScrollOffset = mouseY - offset;
                }
            } else {
                this.clickedScrollOffset = -1;
            }
        }
        if (mouseY > this.guiTop + 18 && mouseY < this.guiTop + 18 + 96) {
            ItemStack stack;
            short transactionID;
            if (mouseX > this.guiLeft + 8 && mouseX < this.guiLeft + 8 + 96) {
                if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null) {
                    for (int i = 0; i < 7; ++i) {
                        int index = i + this.leftScroll.getValue() / 16;
                        if (this.applicable.size() <= index) break;
                        int top = this.guiTop - this.leftScroll.getValue() % 16 + 18 + 16 * i;
                        if (mouseX <= this.guiLeft + 8 || mouseX > this.guiLeft + 8 + 96 || mouseY <= top || mouseY > top + 16) continue;
                        Enchantment ench = this.applicable.get(index);
                        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                            return true;
                        }
                        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                        if (this.currentState == EnchantState.HAS_ITEM) {
                            EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                            transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                            stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(ench.slotIndex);
                            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, ench.slotIndex, 0, 0, stack, transactionID));
                        } else if (this.currentState == EnchantState.ADDING_ENCHANT) {
                            EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                            transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                            stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                            this.cancelButtonAnimTime = System.currentTimeMillis();
                        }
                        return true;
                    }
                }
                this.isScrollingLeft = true;
            } else if (mouseX > this.guiLeft + 248 && mouseX < this.guiLeft + 248 + 96) {
                if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() == null) {
                    for (int i = 0; i < 7; ++i) {
                        int index = i + this.rightScroll.getValue() / 16;
                        if (this.removable.size() <= index) break;
                        int top = this.guiTop - this.rightScroll.getValue() % 16 + 18 + 16 * i;
                        if (mouseX <= this.guiLeft + 248 || mouseX > this.guiLeft + 248 + 96 || mouseY <= top || mouseY > top + 16) continue;
                        Enchantment ench = this.removable.get(index);
                        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                            return true;
                        }
                        GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                        if (this.currentState == EnchantState.HAS_ITEM) {
                            EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                            transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                            stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(ench.slotIndex);
                            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, ench.slotIndex, 0, 0, stack, transactionID));
                        } else if (this.currentState == EnchantState.ADDING_ENCHANT) {
                            EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                            transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                            stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                            this.cancelButtonAnimTime = System.currentTimeMillis();
                        }
                        return true;
                    }
                }
                this.isScrollingLeft = false;
            }
        }
        if (Mouse.getEventDWheel() != 0) {
            int scroll = Mouse.getEventDWheel();
            scroll = scroll > 0 ? -16 : 16;
            LerpingInteger lerpingInteger = this.isScrollingLeft ? this.leftScroll : this.rightScroll;
            int elementsCount = this.isScrollingLeft ? this.applicable.size() : this.removable.size();
            int max3 = (elementsCount - 6) * 16;
            int newTarget = lerpingInteger.getTarget() + scroll;
            if (newTarget > max3) {
                newTarget = max3;
            }
            if (newTarget < 0) {
                newTarget = 0;
            }
            if (newTarget != lerpingInteger.getTarget()) {
                lerpingInteger.resetTimer();
                lerpingInteger.setTarget(newTarget);
            }
        }
        if (mouseX > this.guiLeft + 102 && mouseX < this.guiLeft + 102 + 160 && (mouseY > this.guiTop + 133 && mouseY < this.guiTop + 133 + 54 || mouseY > this.guiTop + 133 + 54 + 4 && mouseY < this.guiTop + 133 + 54 + 4 + 18)) {
            if (this.currentState == EnchantState.ADDING_ENCHANT) {
                if (Mouse.getEventButtonState()) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                    short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                    Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                }
                return true;
            }
            return false;
        }
        if (mouseX >= this.guiLeft + 173 && mouseX < this.guiLeft + 173 + 18 && mouseY >= this.guiTop + 57 && mouseY < this.guiTop + 57 + 18) {
            if (this.currentState == EnchantState.ADDING_ENCHANT) {
                if (Mouse.getEventButtonState()) {
                    if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer)) {
                        return true;
                    }
                    GuiContainer chest = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
                    EntityPlayerSP playerIn = Minecraft.func_71410_x().field_71439_g;
                    short transactionID = playerIn.field_71070_bA.func_75136_a(playerIn.field_71071_by);
                    ItemStack stack = ((ContainerChest)chest.field_147002_h).func_85151_d().func_70301_a(45);
                    Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C0EPacketClickWindow(chest.field_147002_h.field_75152_c, 45, 0, 0, stack, transactionID));
                    this.cancelButtonAnimTime = System.currentTimeMillis();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean keyboardInput() {
        if (this.currentState == EnchantState.HAS_ITEM && this.searchField.getFocus()) {
            if (Keyboard.getEventKeyState()) {
                this.searchField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            }
            return true;
        }
        if (Keyboard.getEventKey() == Minecraft.func_71410_x().field_71474_y.field_151447_Z.func_151463_i()) {
            return false;
        }
        return Keyboard.getEventKey() != 1 && Keyboard.getEventKey() != Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i() && (!NotEnoughUpdates.INSTANCE.config.slotLocking.enableSlotLocking || Keyboard.getEventKey() != NotEnoughUpdates.INSTANCE.config.slotLocking.slotLockKey);
    }

    private class Enchantment {
        public int slotIndex;
        public String enchantName;
        public String enchId;
        public List<String> displayLore;
        public int level;
        public int xpCost = -1;
        public boolean overMaxLevel = false;
        public boolean conflicts = false;

        public Enchantment(int slotIndex, String enchantName, String enchId, List<String> displayLore, int level, boolean useMaxLevelForCost, boolean checkConflicts) {
            this.slotIndex = slotIndex;
            this.enchantName = enchantName;
            this.enchId = enchId;
            this.displayLore = displayLore;
            this.level = level;
            this.enchId = ItemUtils.fixEnchantId(enchId, true);
            if (Constants.ENCHANTS != null) {
                if (checkConflicts && Constants.ENCHANTS.has("enchant_pools")) {
                    JsonArray pools = Constants.ENCHANTS.getAsJsonArray("enchant_pools");
                    block0: for (int i = 0; i < pools.size(); ++i) {
                        JsonArray pool = pools.get(i).getAsJsonArray();
                        boolean hasThis = false;
                        boolean hasApplied = false;
                        for (int j = 0; j < pool.size(); ++j) {
                            String enchIdPoolElement = pool.get(j).getAsString();
                            if (enchId.equalsIgnoreCase(enchIdPoolElement)) {
                                hasThis = true;
                            } else if (GuiCustomEnchant.this.playerEnchantIds.containsKey(enchIdPoolElement)) {
                                hasApplied = true;
                            }
                            if (!hasThis || !hasApplied) continue;
                            this.conflicts = true;
                            break block0;
                        }
                    }
                }
                if (level >= 1 && Constants.ENCHANTS.has("enchants_xp_cost")) {
                    JsonArray costs;
                    JsonObject allCosts = Constants.ENCHANTS.getAsJsonObject("enchants_xp_cost");
                    JsonObject maxLevel = null;
                    if (Constants.ENCHANTS.has("max_xp_table_levels")) {
                        maxLevel = Constants.ENCHANTS.getAsJsonObject("max_xp_table_levels");
                    }
                    if (allCosts.has(this.enchId) && (costs = allCosts.getAsJsonArray(this.enchId)).size() >= 1) {
                        if (useMaxLevelForCost) {
                            int cost = maxLevel != null && maxLevel.has(this.enchId) ? maxLevel.get(this.enchId).getAsInt() : costs.size();
                            this.xpCost = costs.get(cost - 1).getAsInt();
                        } else if (level - 1 < costs.size()) {
                            this.xpCost = costs.get(level - 1).getAsInt();
                        } else {
                            this.overMaxLevel = true;
                        }
                    }
                }
            }
            for (String line : this.displayLore) {
                Matcher matcher = XP_COST_PATTERN.matcher(line);
                Matcher discount_matcher = DISCOUNT_COST_PATTERN.matcher(line);
                if (matcher.find()) {
                    this.xpCost = Integer.parseInt(matcher.group(1));
                    continue;
                }
                if (!discount_matcher.find()) continue;
                this.xpCost = Integer.parseInt(discount_matcher.group(2));
            }
        }
    }

    private static enum EnchantState {
        NO_ITEM,
        ADDING_ENCHANT,
        SWITCHING_DONT_UPDATE,
        INVALID_ITEM,
        HAS_ITEM;

    }
}

