/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.world;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SpawnParticleEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.world.GenericBlockHighlighter;
import io.github.moulberry.notenoughupdates.util.MathUtil;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnderNodeHighlighter
extends GenericBlockHighlighter {
    private static final EnderNodeHighlighter INSTANCE = new EnderNodeHighlighter();

    public static EnderNodeHighlighter getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onParticleSpawn(SpawnParticleEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getParticleTypes() == EnumParticleTypes.PORTAL) {
            double x = event.getXCoord();
            double y = event.getYCoord();
            double z = event.getZCoord();
            boolean xZero = MathUtil.basicallyEqual((x - 0.5) % 1.0, 0.0, 0.2);
            boolean yZero = MathUtil.basicallyEqual((y - 0.5) % 1.0, 0.0, 0.2);
            boolean zZero = MathUtil.basicallyEqual((z - 0.5) % 1.0, 0.0, 0.2);
            if (Math.abs(y % 1.0) == 0.25 && xZero && zZero && this.tryRegisterInterest(x, y - 1.0, z)) {
                return;
            }
            if (Math.abs(y % 1.0) == 0.75 && xZero && zZero && this.tryRegisterInterest(x, y + 1.0, z)) {
                return;
            }
            if (Math.abs(x % 1.0) == 0.25 && yZero && zZero && this.tryRegisterInterest(x + 1.0, y, z)) {
                return;
            }
            if (Math.abs(x % 1.0) == 0.75 && yZero && zZero && this.tryRegisterInterest(x - 1.0, y, z)) {
                return;
            }
            if (Math.abs(z % 1.0) == 0.25 && yZero && xZero && this.tryRegisterInterest(x, y, z + 1.0)) {
                return;
            }
            if (Math.abs(z % 1.0) == 0.75 && yZero && xZero) {
                this.tryRegisterInterest(x, y, z - 1.0);
            }
        }
    }

    @Override
    protected boolean isEnabled() {
        return "combat_3".equals(SBInfo.getInstance().getLocation()) && NotEnoughUpdates.INSTANCE.config.world.highlightEnderNodes;
    }

    @Override
    protected boolean isValidHighlightSpot(BlockPos key) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return false;
        }
        Block b = w.func_180495_p(key).func_177230_c();
        return b == Blocks.field_150377_bs || b == Blocks.field_150343_Z || b == Blocks.field_150406_ce;
    }

    @Override
    protected int getColor(BlockPos blockPos) {
        return SpecialColour.specialToChromaRGB(NotEnoughUpdates.INSTANCE.config.world.enderNodeColor2);
    }
}

