/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.updater;

import io.github.moulberry.notenoughupdates.util.JarUtil;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/updater/SigningPool;", "", "()V", "keyPool", "", "", "Lio/github/moulberry/notenoughupdates/miscfeatures/updater/SigningPool$PK;", "getKeyPool", "()Ljava/util/Map;", "load", "", "loadPK", "name", "inputStream", "Ljava/io/InputStream;", "verifySignature", "", "signatureBytes", "", "PK", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nSigningPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SigningPool.kt\nio/github/moulberry/notenoughupdates/miscfeatures/updater/SigningPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n766#2:70\n857#2,2:71\n1549#2:73\n1620#2,3:74\n1194#2,2:77\n1222#2,4:79\n*S KotlinDebug\n*F\n+ 1 SigningPool.kt\nio/github/moulberry/notenoughupdates/miscfeatures/updater/SigningPool\n*L\n39#1:70\n39#1:71,2\n40#1:73\n40#1:74,3\n54#1:77,2\n54#1:79,4\n*E\n"})
public final class SigningPool {
    @NotNull
    public static final SigningPool INSTANCE;
    @NotNull
    private static final Map<String, PK> keyPool;

    private SigningPool() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PK> load() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        List<String> l = JarUtil.INSTANCE.getAccess().listFiles("trusted_team_members");
        Iterable $this$filter$iv = l;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, (String)".key", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.loadPK(StringsKt.substringBeforeLast$default((String)it, (char)'.', null, (int)2, null), JarUtil.INSTANCE.getAccess().read("trusted_team_members/" + it)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PK loadPK(@NotNull String name, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte[] publicKeyBytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(x509EncodedKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getInstance(\"RSA\").gener\u2026ublic(x509EncodedKeySpec)");
        return new PK(name, publicKey);
    }

    @NotNull
    public final Map<String, PK> getKeyPool() {
        return keyPool;
    }

    public final boolean verifySignature(@NotNull String name, @NotNull InputStream inputStream, @NotNull byte[] signatureBytes) {
        int read;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)signatureBytes, (String)"signatureBytes");
        Signature signature = Signature.getInstance("SHA256withRSA");
        Object object = keyPool.get(name);
        if (object == null || (object = ((PK)object).getPublicKey()) == null) {
            return false;
        }
        signature.initVerify((PublicKey)object);
        byte[] b = new byte[4096];
        while ((read = inputStream.read(b)) >= 0) {
            signature.update(b, 0, read);
        }
        return signature.verify(signatureBytes);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        INSTANCE = new SigningPool();
        Iterable $this$associateBy$iv = INSTANCE.load();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PK pK = (PK)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getName(), element$iv$iv);
        }
        keyPool = destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/updater/SigningPool$PK;", "", "name", "", "publicKey", "Ljava/security/PublicKey;", "(Ljava/lang/String;Ljava/security/PublicKey;)V", "getName", "()Ljava/lang/String;", "getPublicKey", "()Ljava/security/PublicKey;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "NotEnoughUpdates"})
    public static final class PK {
        @NotNull
        private final String name;
        @NotNull
        private final PublicKey publicKey;

        public PK(@NotNull String name, @NotNull PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            this.name = name;
            this.publicKey = publicKey;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final PublicKey getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final PublicKey component2() {
            return this.publicKey;
        }

        @NotNull
        public final PK copy(@NotNull String name, @NotNull PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            return new PK(name, publicKey);
        }

        public static /* synthetic */ PK copy$default(PK pK, String string, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                string = pK.name;
            }
            if ((n & 2) != 0) {
                publicKey = pK.publicKey;
            }
            return pK.copy(string, publicKey);
        }

        @NotNull
        public String toString() {
            return "PK(name=" + this.name + ", publicKey=" + this.publicKey + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.publicKey.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PK)) {
                return false;
            }
            PK pK = (PK)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pK.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.publicKey, (Object)pK.publicKey);
        }
    }
}

