/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.profileviewer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.APIComposterUpgrades;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.BarnSkin;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.ComposterData;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.ComposterUpgrade;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.CropType;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.EliteWeightJson;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.GardenData;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.GardenDataJson;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.GardenPage;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.GardenRepoJson;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.PlotData;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.VisitorCommissions;
import io.github.moulberry.notenoughupdates.miscfeatures.profileviewer.VisitorRarity;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.UrsaClient;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.kotlin.Coroutines;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 H2\u00020\u0001:\u0001HB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00152\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-H\u0002J \u0010.\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020%H\u0002J%\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00150-2\b\u00105\u001a\u0004\u0018\u000106H\u0002\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020%H\u0002J\u001e\u00109\u001a\u0004\u0018\u00010\u00112\b\u0010:\u001a\u0004\u0018\u00010'2\b\u0010;\u001a\u0004\u0018\u00010'H\u0002J\u0014\u0010<\u001a\u0004\u0018\u00010\u00132\b\u0010;\u001a\u0004\u0018\u00010'H\u0002J \u0010=\u001a\u00020>2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010?\u001a\u00020\u0015H\u0016J\b\u0010@\u001a\u00020%H\u0002J\b\u0010A\u001a\u00020%H\u0002J\b\u0010B\u001a\u00020%H\u0002J\b\u0010C\u001a\u00020%H\u0002J\b\u0010D\u001a\u00020%H\u0002J\b\u0010E\u001a\u00020%H\u0002J\b\u0010F\u001a\u00020%H\u0002J\b\u0010G\u001a\u00020%H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00150!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00150!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenPage;", "Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewerPage;", "pvInstance", "Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewer;", "(Lio/github/moulberry/notenoughupdates/profileviewer/GuiProfileViewer;)V", "apiData", "Lio/github/moulberry/notenoughupdates/profileviewer/data/APIDataJson;", "background", "Lnet/minecraft/util/ResourceLocation;", "getBackground", "()Lnet/minecraft/util/ResourceLocation;", "currentProfile", "Lio/github/moulberry/notenoughupdates/profileviewer/SkyblockProfiles$SkyblockProfile;", "Lio/github/moulberry/notenoughupdates/profileviewer/SkyblockProfiles;", "currentlyFetching", "Ljava/util/concurrent/atomic/AtomicBoolean;", "eliteData", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/EliteWeightJson;", "gardenData", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenData;", "guiLeft", "", "guiTop", "manager", "Lio/github/moulberry/notenoughupdates/NEUManager;", "kotlin.jvm.PlatformType", "getManager", "()Lio/github/moulberry/notenoughupdates/NEUManager;", "mouseX", "mouseY", "repoData", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenRepoJson;", "visitorRarityToCompleted", "", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/VisitorRarity;", "visitorRarityToVisits", "drawAlignedStringWithHover", "", "first", "", "second", "x", "y", "length", "hover", "", "drawPage", "partialTicks", "", "getData", "getLevel", "Lio/github/moulberry/notenoughupdates/profileviewer/ProfileViewer$Level;", "experienceList", "currentExp", "", "(Ljava/util/List;Ljava/lang/Long;)Lio/github/moulberry/notenoughupdates/profileviewer/ProfileViewer$Level;", "getVisitorData", "loadFarmingWeight", "uuid", "profileId", "loadGardenData", "mouseClicked", "", "mouseButton", "openWebsite", "renderCompost", "renderCropMilestones", "renderCropUpgrades", "renderFarmingWeight", "renderGardenLevel", "renderPlots", "renderVisitorStats", "Companion", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nGardenPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenPage.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenPage\n+ 2 mcaccessor.kt\nio/github/moulberry/notenoughupdates/util/McaccessorKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,609:1\n24#2:610\n1#3:611\n1855#4,2:612\n*S KotlinDebug\n*F\n+ 1 GardenPage.kt\nio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenPage\n*L\n118#1:610\n585#1:612,2\n*E\n"})
public final class GardenPage
extends GuiProfileViewerPage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int guiLeft;
    private int guiTop;
    @Nullable
    private SkyblockProfiles.SkyblockProfile currentProfile;
    @Nullable
    private GardenData gardenData;
    @Nullable
    private EliteWeightJson eliteData;
    @NotNull
    private AtomicBoolean currentlyFetching;
    private GardenRepoJson repoData;
    @Nullable
    private APIDataJson apiData;
    private int mouseX;
    private int mouseY;
    @NotNull
    private final Map<VisitorRarity, Integer> visitorRarityToVisits;
    @NotNull
    private final Map<VisitorRarity, Integer> visitorRarityToCompleted;
    @NotNull
    private final ResourceLocation background;
    @NotNull
    private static final Companion.cropTypeAdapter.1 cropTypeAdapter = new TypeAdapter<CropType>(){

        public void write(@NotNull JsonWriter writer, @NotNull CropType value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            writer.value(value.name());
        }

        @Nullable
        public CropType read(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            String string = reader.nextString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.nextString()");
            return CropType.Companion.fromApiName(string);
        }
    };
    @NotNull
    private static final Gson gson;

    public GardenPage(@NotNull GuiProfileViewer pvInstance) {
        Intrinsics.checkNotNullParameter((Object)((Object)pvInstance), (String)"pvInstance");
        super(pvInstance);
        this.guiLeft = GuiProfileViewer.getGuiLeft();
        this.guiTop = GuiProfileViewer.getGuiTop();
        this.currentlyFetching = new AtomicBoolean(false);
        this.visitorRarityToVisits = new LinkedHashMap();
        this.visitorRarityToCompleted = new LinkedHashMap();
        this.background = new ResourceLocation("notenoughupdates:profile_viewer/garden/background.png");
    }

    private final NEUManager getManager() {
        return NotEnoughUpdates.INSTANCE.manager;
    }

    @NotNull
    public final ResourceLocation getBackground() {
        return this.background;
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        block9: {
            block8: {
                this.guiLeft = GuiProfileViewer.getGuiLeft();
                this.guiTop = GuiProfileViewer.getGuiTop();
                this.mouseX = mouseX;
                this.mouseY = mouseY;
                if (this.currentlyFetching.get()) {
                    Utils.drawStringCentered("\u00a7eLoading Data", this.guiLeft + 220, this.guiTop + 101, true, 0);
                    return;
                }
                if (Constants.GARDEN == null) {
                    Utils.drawStringCentered("\u00a7cMissing Repo Data", this.guiLeft + 220, this.guiTop + 101, true, 0);
                    Utils.showOutdatedRepoNotification("garden.json");
                    return;
                }
                SkyblockProfiles.SkyblockProfile newProfile = this.getSelectedProfile();
                if (!Intrinsics.areEqual((Object)newProfile, (Object)this.currentProfile)) {
                    this.getData();
                    this.currentProfile = this.getSelectedProfile();
                    return;
                }
                if (this.gardenData == null) break block8;
                GardenData gardenData = this.gardenData;
                boolean bl = gardenData != null ? gardenData.getGardenExperience() == 0 : false;
                if (!bl) break block9;
            }
            Utils.drawStringCentered("\u00a7cMissing Profile Data", this.guiLeft + 220, this.guiTop + 101, true, 0);
            return;
        }
        SkyblockProfiles.SkyblockProfile skyblockProfile = GuiProfileViewer.getSelectedProfile();
        if (skyblockProfile == null) {
            return;
        }
        SkyblockProfiles.SkyblockProfile selectedProfile = skyblockProfile;
        APIDataJson aPIDataJson = selectedProfile.APIDataJson;
        if (aPIDataJson == null) {
            return;
        }
        this.apiData = aPIDataJson;
        boolean $i$f$getMC = false;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.background);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        this.renderPlots();
        this.renderGardenLevel();
        this.renderFarmingWeight();
        this.renderCropUpgrades();
        this.renderCropMilestones();
        this.renderVisitorStats();
        this.renderCompost();
    }

    private final void getData() {
        this.currentlyFetching.set(true);
        Object object = this.getSelectedProfile();
        String profileId = object != null && (object = ((SkyblockProfiles.SkyblockProfile)object).getOuterProfileJson()) != null && (object = ((JsonObject)object).get("profile_id")) != null && (object = ((JsonElement)object).getAsString()) != null ? StringsKt.replace$default((String)object, (String)"-", (String)"", (boolean)false, (int)4, null) : null;
        Coroutines.INSTANCE.launchCoroutine((Function1)new Function1<Continuation<? super Unit>, Object>(this, profileId, null){
            int label;
            final /* synthetic */ GardenPage this$0;
            final /* synthetic */ String $profileId;
            {
                this.this$0 = $receiver;
                this.$profileId = $profileId;
                super(1, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GardenPage.access$setGardenData$p(this.this$0, GardenPage.access$loadGardenData(this.this$0, this.$profileId));
                        GardenPage.access$getVisitorData(this.this$0);
                        SkyblockProfiles skyblockProfiles = GuiProfileViewer.getProfile();
                        GardenPage.access$setEliteData$p(this.this$0, GardenPage.access$loadFarmingWeight(this.this$0, skyblockProfiles != null ? skyblockProfiles.getUuid() : null, this.$profileId));
                        GardenPage.access$getCurrentlyFetching$p(this.this$0).set(false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final GardenData loadGardenData(String profileId) {
        if (profileId == null) {
            return null;
        }
        JsonObject data = this.getManager().ursaClient.get(UrsaClient.Companion.gardenForProfile(profileId)).get();
        GardenRepoJson gardenRepoJson = gson.fromJson((JsonElement)Constants.GARDEN, GardenRepoJson.class);
        Intrinsics.checkNotNullExpressionValue((Object)gardenRepoJson, (String)"gson.fromJson(Constants.\u2026rdenRepoJson::class.java)");
        this.repoData = gardenRepoJson;
        return gson.fromJson((JsonElement)data, GardenDataJson.class).getGarden();
    }

    private final void getVisitorData() {
        VisitorRarity rarity;
        int amount;
        String visitor;
        this.visitorRarityToVisits.clear();
        this.visitorRarityToCompleted.clear();
        Object object = this.gardenData;
        if (object == null || (object = ((GardenData)object).getCommissionData()) == null || (object = ((VisitorCommissions)object).getVisits()) == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : object.entrySet()) {
            visitor = entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            GardenRepoJson gardenRepoJson = this.repoData;
            if (gardenRepoJson == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                gardenRepoJson = null;
            }
            if ((rarity = gardenRepoJson.getVisitors().get(visitor)) == null) {
                System.out.println((Object)("Unknown visitor: " + visitor));
                continue;
            }
            this.visitorRarityToVisits.put(rarity, ((Number)this.visitorRarityToVisits.getOrDefault((Object)rarity, 0)).intValue() + amount);
            this.visitorRarityToVisits.put(VisitorRarity.TOTAL, ((Number)this.visitorRarityToVisits.getOrDefault((Object)VisitorRarity.TOTAL, 0)).intValue() + amount);
        }
        Object object2 = this.gardenData;
        if (object2 == null || (object2 = ((GardenData)object2).getCommissionData()) == null || (object2 = ((VisitorCommissions)object2).getCompleted()) == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : object2.entrySet()) {
            visitor = entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            GardenRepoJson gardenRepoJson = this.repoData;
            if (gardenRepoJson == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                gardenRepoJson = null;
            }
            if (gardenRepoJson.getVisitors().get(visitor) == null) continue;
            this.visitorRarityToCompleted.put(rarity, ((Number)this.visitorRarityToCompleted.getOrDefault((Object)rarity, 0)).intValue() + amount);
            this.visitorRarityToCompleted.put(VisitorRarity.TOTAL, ((Number)this.visitorRarityToCompleted.getOrDefault((Object)VisitorRarity.TOTAL, 0)).intValue() + amount);
        }
    }

    private final EliteWeightJson loadFarmingWeight(String uuid, String profileId) {
        if (uuid == null) {
            return null;
        }
        if (profileId == null) {
            return null;
        }
        JsonObject data = this.getManager().apiUtils.request().url("https://api.elitebot.dev/weight/" + uuid + '/' + profileId).requestJson().get();
        return gson.fromJson((JsonElement)data, EliteWeightJson.class);
    }

    private final void renderPlots() {
        int top = this.guiTop + 79;
        int left = this.guiLeft + 192;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GardenRepoJson gardenRepoJson = this.repoData;
        if (gardenRepoJson == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
            gardenRepoJson = null;
        }
        for (Map.Entry<String, PlotData> value : gardenRepoJson.getPlots().entrySet()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
            int x = left + value.getValue().getX() * 22;
            int y = top + value.getValue().getY() * 22;
            Utils.drawTexturedRect(x, y, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
            Object object = this.gardenData;
            if (!(object != null && (object = ((GardenData)object).getUnlockedPlotIds()) != null ? object.contains(value.getKey()) : false)) {
                Utils.drawItemStack(new ItemStack(Blocks.field_180401_cv), x + 2, y + 2);
                if (this.mouseX < x || this.mouseX > x + 20 || this.mouseY < y || this.mouseY > y + 20) continue;
                this.getInstance().tooltipToDisplay = CollectionsKt.listOf((Object)("\u00a7cLocked " + value.getValue().getName()));
                continue;
            }
            Utils.drawItemStack(new ItemStack((Block)Blocks.field_150349_c), x + 2, y + 2);
            if (this.mouseX < x || this.mouseX > x + 20 || this.mouseY < y || this.mouseY > y + 20) continue;
            this.getInstance().tooltipToDisplay = CollectionsKt.listOf((Object)value.getValue().getName());
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiProfileViewer.pv_elements);
        Utils.drawTexturedRect(left + 44, top + 44, 20.0f, 20.0f, 0.0f, 0.078125f, 0.0f, 0.078125f, 9728);
        int x = left + 44 + 2;
        int y = top + 44 + 2;
        boolean error2 = false;
        error2 = true;
        GardenRepoJson gardenRepoJson2 = this.repoData;
        if (gardenRepoJson2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
            gardenRepoJson2 = null;
        }
        Map<String, BarnSkin> map2 = gardenRepoJson2.getBarn();
        GardenData gardenData = this.gardenData;
        BarnSkin barnSkin = map2.get(gardenData != null ? gardenData.getSelectedBarnSkin() : null);
        if (barnSkin != null) {
            BarnSkin it = barnSkin;
            boolean bl = false;
            ItemStack itemStack = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(it.getItem()).resolveToItemStack();
            Utils.drawItemStack(itemStack, x, y);
            if (this.mouseX >= x && this.mouseX <= x + 20 && this.mouseY >= y && this.mouseY <= y + 20) {
                this.getInstance().tooltipToDisplay = CollectionsKt.listOf((Object)("\u00a77Barn Skin: " + it.getName()));
            }
            error2 = false;
        }
        if (error2) {
            Utils.drawItemStack(new ItemStack(Blocks.field_180401_cv), x, y);
            if (this.mouseX >= x && this.mouseX <= x + 20 && this.mouseY >= y && this.mouseY <= y + 20) {
                Object[] objectArray = new String[3];
                GardenData gardenData2 = this.gardenData;
                objectArray[0] = "\u00a7cUnknown barn Skin: " + (gardenData2 != null ? gardenData2.getSelectedBarnSkin() : null);
                objectArray[1] = "\u00a7cIf you expected it to be there please send a message in";
                objectArray[2] = "\u00a7c\u00a7l#neu-support \u00a7r\u00a7con \u00a7l" + Utils.getDiscordInvite();
                this.getInstance().tooltipToDisplay = CollectionsKt.listOf((Object[])objectArray);
            }
        }
    }

    private final void renderCropUpgrades() {
        int startHeight;
        int yPos = startHeight = this.guiTop + 105;
        int xPos = this.guiLeft + 26;
        Utils.renderShadowedString("\u00a7eCrop Upgrades", xPos + 70, yPos + 5, 105);
        int averageUpgrade = 0;
        CropType[] cropTypeArray = CropType.values();
        int n = cropTypeArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            CropType crop = cropTypeArray[i];
            if (index == 5) {
                yPos = startHeight;
                xPos += 70;
            }
            Object object = this.gardenData;
            int upgradeLevel = object != null && (object = ((GardenData)object).getCropUpgradeLevels()) != null && (object = (Integer)object.get((Object)crop)) != null ? (Integer)object : 0;
            averageUpgrade += upgradeLevel;
            ItemStack itemStack = this.getManager().createItem(crop.getItemId());
            Utils.drawItemStack(itemStack, xPos + 2, yPos += 14);
            Utils.renderAlignedString("\u00a7e" + crop.getDisplayName(), "\u00a7f" + upgradeLevel, xPos + 20, yPos + 5, 50);
            if (this.mouseX < xPos + 20 || this.mouseX > xPos + 70 || this.mouseY < yPos || this.mouseY > yPos + 20) continue;
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("\u00a7a" + crop.getDisplayName());
            tooltip.add("");
            GardenRepoJson gardenRepoJson = this.repoData;
            if (gardenRepoJson == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                gardenRepoJson = null;
            }
            if (gardenRepoJson.getCropUpgrades().size() == upgradeLevel) {
                StringBuilder stringBuilder = new StringBuilder().append("\u00a77Current Tier: \u00a7a").append(upgradeLevel).append("\u00a77/\u00a7a");
                GardenRepoJson gardenRepoJson2 = this.repoData;
                if (gardenRepoJson2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                    gardenRepoJson2 = null;
                }
                tooltip.add(stringBuilder.append(gardenRepoJson2.getCropUpgrades().size()).toString());
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("\u00a77Current Tier: \u00a7e").append(upgradeLevel).append("\u00a77/\u00a7a");
                GardenRepoJson gardenRepoJson3 = this.repoData;
                if (gardenRepoJson3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                    gardenRepoJson3 = null;
                }
                tooltip.add(stringBuilder.append(gardenRepoJson3.getCropUpgrades().size()).toString());
            }
            tooltip.add("\u00a77" + crop.getDisplayName() + " Fortune: \u00a76+" + upgradeLevel * 5 + '\u2618');
            tooltip.add("");
            GardenRepoJson gardenRepoJson4 = this.repoData;
            if (gardenRepoJson4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                gardenRepoJson4 = null;
            }
            if (gardenRepoJson4.getCropUpgrades().size() == upgradeLevel) {
                tooltip.add("\u00a76Maxed");
            } else {
                tooltip.add("\u00a77Cost:");
                StringBuilder stringBuilder = new StringBuilder().append("\u00a7c");
                GardenRepoJson gardenRepoJson5 = this.repoData;
                if (gardenRepoJson5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                    gardenRepoJson5 = null;
                }
                tooltip.add(stringBuilder.append(((Number)gardenRepoJson5.getCropUpgrades().get(upgradeLevel)).intValue()).append(" \u00a77Copper to Upgrade").toString());
                GardenRepoJson gardenRepoJson6 = this.repoData;
                if (gardenRepoJson6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                    gardenRepoJson6 = null;
                }
                int totalCopper = CollectionsKt.sumOfInt((Iterable)gardenRepoJson6.getCropUpgrades());
                GardenRepoJson gardenRepoJson7 = this.repoData;
                if (gardenRepoJson7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                    gardenRepoJson7 = null;
                }
                int sum = totalCopper - CollectionsKt.sumOfInt((Iterable)gardenRepoJson7.getCropUpgrades().subList(0, upgradeLevel));
                tooltip.add("\u00a7c" + sum + " \u00a77Copper to Max");
            }
            this.getInstance().tooltipToDisplay = tooltip;
        }
        int x = this.guiLeft + 70 + 26 - 42;
        int y = startHeight + 5;
        n = x + 80;
        int n2 = this.mouseX;
        boolean bl = x <= n2 ? n2 <= n : false;
        if (bl) {
            n = y + 13;
            n2 = this.mouseY;
            boolean bl2 = y <= n2 ? n2 <= n : false;
            if (bl2) {
                this.getInstance().tooltipToDisplay = CollectionsKt.listOf((Object)("\u00a7eAverage Upgrade " + averageUpgrade / 10));
            }
        }
    }

    private final void renderCropMilestones() {
        int startHeight;
        int yPos = startHeight = this.guiTop + 10;
        int xPos = this.guiLeft + 26;
        Utils.renderShadowedString("\u00a7eCrop Milestones", xPos + 70, yPos + 5, 105);
        int averageMilestone = 0;
        CropType[] cropTypeArray = CropType.values();
        int n = cropTypeArray.length;
        for (int i = 0; i < n; ++i) {
            List<Integer> levelsInfo;
            int index = i;
            CropType crop = cropTypeArray[i];
            if (index == 5) {
                yPos = startHeight;
                xPos += 70;
            }
            ItemStack itemStack = this.getManager().createItem(crop.getItemId());
            Utils.drawItemStack(itemStack, xPos + 2, yPos += 14);
            GardenRepoJson gardenRepoJson = this.repoData;
            if (gardenRepoJson == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                gardenRepoJson = null;
            }
            if (gardenRepoJson.getCropMilestones().get((Object)crop) == null) continue;
            Object object = this.gardenData;
            long currentCollection = object != null && (object = ((GardenData)object).getResourcesCollected()) != null && (object = (Long)object.get((Object)crop)) != null ? (Long)object : 0L;
            ProfileViewer.Level levelInfo = this.getLevel(levelsInfo, currentCollection);
            int collectionLevel = (int)levelInfo.level;
            String formattedAmount = StringUtils.formatNumber(currentCollection);
            int nextLevel = 0;
            String nextLevelString = "\u00a76MAXED";
            int maxLevel = 0;
            String maxLevelString = "";
            String formattedPercentage = "100.00";
            String formattedMaxLevelPercentage = "100.00";
            String aboveMaxMilestoneNumber = null;
            int lastCropMilestoneAmountRequired = 0;
            for (int i2 = 0; i2 < 46; ++i2) {
                maxLevel += ((Number)levelsInfo.get(i2)).intValue();
                if (i2 < collectionLevel + 1) {
                    nextLevel += ((Number)levelsInfo.get(i2)).intValue();
                }
                if (i2 != 45) continue;
                lastCropMilestoneAmountRequired = ((Number)levelsInfo.get(i2)).intValue();
            }
            if (!levelInfo.maxed) {
                String string = StringUtils.formatNumber(maxLevel);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatNumber(maxLevel)");
                maxLevelString = string;
                long remainingForNext = ((Number)levelsInfo.get(collectionLevel)).longValue() - ((long)nextLevel - currentCollection);
                String formattedRemainingForNext = StringUtils.formatNumber(remainingForNext);
                nextLevelString = "\u00a7e" + formattedRemainingForNext + "\u00a76/\u00a7e" + StringUtils.formatNumber(((Number)levelsInfo.get(collectionLevel)).intValue());
                double percentage = (double)remainingForNext / (double)((Number)levelsInfo.get(collectionLevel)).intValue() * (double)100;
                String string2 = "%.2f";
                Object object2 = new Object[]{percentage};
                String string3 = String.format(string2, Arrays.copyOf(object2, ((Object[])object2).length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                formattedPercentage = string3;
                float maxLevelPercentage = (float)currentCollection / (float)maxLevel * (float)100;
                object2 = "%.2f";
                Object[] objectArray = new Object[]{Float.valueOf(maxLevelPercentage)};
                String string4 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                formattedMaxLevelPercentage = string4;
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add("\u00a7a" + crop.getDisplayName() + ' ' + collectionLevel);
            tooltip.add("\u00a77Total: \u00a7a" + formattedAmount);
            tooltip.add("");
            if (!levelInfo.maxed) {
                tooltip.add("Progress to Tier " + ((int)levelInfo.level + 1) + ": \u00a7e" + formattedPercentage + '%');
                tooltip.add(nextLevelString);
                tooltip.add("");
                tooltip.add("Progress to Tier 46: \u00a7e" + formattedMaxLevelPercentage + '%');
                tooltip.add("\u00a7e" + formattedAmount + "\u00a76/\u00a7e" + maxLevelString);
            } else {
                double aboveMaxMilestone = (double)currentCollection - (double)maxLevel + (double)lastCropMilestoneAmountRequired;
                String string = StringUtils.formatNumber(aboveMaxMilestone);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatNumber(aboveMaxMilestone)");
                aboveMaxMilestoneNumber = string;
                tooltip.add("\u00a77Overflow: \u00a76" + aboveMaxMilestoneNumber);
                tooltip.add("");
                tooltip.add("\u00a76Max tier reached!");
            }
            this.drawAlignedStringWithHover("\u00a7e" + crop.getDisplayName(), "\u00a7f" + collectionLevel, xPos + 20, yPos + 5, 50, (List<String>)tooltip);
            averageMilestone += collectionLevel;
        }
        int x = this.guiLeft + 70 + 26 - 42;
        int y = startHeight + 5;
        n = x + 80;
        int n2 = this.mouseX;
        boolean bl = x <= n2 ? n2 <= n : false;
        if (bl) {
            n = y + 13;
            n2 = this.mouseY;
            boolean bl2 = y <= n2 ? n2 <= n : false;
            if (bl2) {
                this.getInstance().tooltipToDisplay = CollectionsKt.listOf((Object)("\u00a7eAverage Milestone " + averageMilestone / 10));
            }
        }
    }

    private final void renderVisitorStats() {
        Object object;
        int xPos = this.guiLeft + 322;
        int yPos = this.guiTop + 17;
        Utils.renderShadowedString("\u00a7eVisitors", xPos + 40, yPos - 2, 80);
        StringBuilder stringBuilder = new StringBuilder().append("\u00a7f").append((object = this.gardenData) != null && (object = ((GardenData)object).getCommissionData()) != null ? ((VisitorCommissions)object).getUniqueNpcsServed() : 0).append('/');
        GardenRepoJson gardenRepoJson = this.repoData;
        if (gardenRepoJson == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
            gardenRepoJson = null;
        }
        Utils.renderAlignedString("\u00a7eUnique Visitors", stringBuilder.append(gardenRepoJson.getVisitors().size()).toString(), xPos, yPos + 10, 80);
        yPos += 20;
        for (VisitorRarity rarity : VisitorRarity.values()) {
            String formattedVisits = StringUtils.formatNumber(this.visitorRarityToVisits.getOrDefault((Object)rarity, 0));
            String formattedCompleted = StringUtils.formatNumber(this.visitorRarityToCompleted.getOrDefault((Object)rarity, 0));
            Object[] objectArray = new String[]{"\u00a77Visits: \u00a7f" + formattedVisits, "\u00a77Completed: \u00a7f" + formattedCompleted};
            List tooltip = CollectionsKt.listOf((Object[])objectArray);
            String rarityStats = "\u00a7f" + formattedCompleted + '/' + formattedVisits;
            this.drawAlignedStringWithHover(rarity.getDisplayName(), rarityStats, xPos, yPos, 80, tooltip);
            yPos += 12;
        }
    }

    private final void renderGardenLevel() {
        int top = this.guiTop + 20;
        int left = this.guiLeft + 190;
        GardenRepoJson gardenRepoJson = this.repoData;
        if (gardenRepoJson == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
            gardenRepoJson = null;
        }
        GardenData gardenData = this.gardenData;
        ProfileViewer.Level level = this.getLevel(gardenRepoJson.getGardenExperience(), gardenData != null ? Long.valueOf(gardenData.getGardenExperience()) : null);
        if (level.maxed) {
            this.getInstance().renderGoldBar((float)left + (float)16, top + 10, 80.0f);
        } else {
            this.getInstance().renderBar((float)left + (float)16, top + 10, 80.0f, level.level % 1.0f);
        }
        int maxXp = (int)level.maxXpForLevel;
        String totalXpS = StringUtils.formatNumber((long)level.totalXp);
        ArrayList<String> gardenTooltip = new ArrayList<String>();
        gardenTooltip.add("\u00a72Garden");
        if (level.maxed) {
            gardenTooltip.add("\u00a77Progress: \u00a76MAXED!");
        } else {
            gardenTooltip.add("\u00a77Progress: \u00a75" + StringUtils.shortNumberFormat(Math.round(level.level % 1.0f * (float)maxXp)) + '/' + StringUtils.shortNumberFormat(maxXp));
        }
        gardenTooltip.add("\u00a77Total XP: \u00a75" + totalXpS + "\u00a78 (" + StringUtils.formatToTenths(Float.valueOf(this.getInstance().getPercentage("garden", level))) + "% to " + level.maxLevel + ')');
        this.drawAlignedStringWithHover("\u00a72Garden", "\u00a7f" + (int)level.level, left + 36, top, 60, (List<String>)gardenTooltip);
        Utils.drawItemStack(new ItemStack((Block)Blocks.field_150349_c), left + 16, top - 6);
        Object object = this.apiData;
        int copper = object != null && (object = ((APIDataJson)object).garden_player_data) != null ? ((APIDataJson.GardenPlayerData)object).copper : 0;
        Utils.renderAlignedString("\u00a7cCopper", "\u00a7f" + StringUtils.formatNumber(copper), left + 16, top + 20, 80);
    }

    private final void renderFarmingWeight() {
        List list;
        int top = this.guiTop + 51;
        int left = this.guiLeft + 190;
        if (this.eliteData == null) {
            Object[] objectArray = new String[]{"\u00a7eLoading...", "\u00a7eTry again soon!"};
            this.drawAlignedStringWithHover("\u00a7eFarming Weight", "\u00a7eLoading...", left + 16, top, 95, CollectionsKt.listOf((Object[])objectArray));
            return;
        }
        EliteWeightJson eliteWeightJson = this.eliteData;
        double totalWeight = eliteWeightJson != null ? eliteWeightJson.getTotalWeight() : 0.0;
        Object object = this.eliteData;
        double bonusWeight = object != null && (object = ((EliteWeightJson)object).getBonusWeight()) != null && (object = object.values()) != null ? CollectionsKt.sumOfDouble((Iterable)((Iterable)object)) : 0.0;
        List $this$renderFarmingWeight_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$renderFarmingWeight_u24lambda_u241.add("\u00a77Total Weight: \u00a7f" + StringUtils.formatNumber(totalWeight));
        $this$renderFarmingWeight_u24lambda_u241.add("\u00a77Bonus Weight: \u00a7f" + StringUtils.formatNumber(bonusWeight));
        for (CropType crop : CropType.values()) {
            Object object2 = this.eliteData;
            double cropWeight = object2 != null && (object2 = ((EliteWeightJson)object2).getCropWeight()) != null && (object2 = (Double)object2.get((Object)crop)) != null ? (Double)object2 : 0.0;
            $this$renderFarmingWeight_u24lambda_u241.add("\u00a77" + crop.getDisplayName() + ": \u00a7f" + StringUtils.formatNumber(cropWeight));
        }
        $this$renderFarmingWeight_u24lambda_u241.add("");
        $this$renderFarmingWeight_u24lambda_u241.add("Data provided by the Elitebot API.");
        $this$renderFarmingWeight_u24lambda_u241.add("\u00a7eClick to view on the Elitebot website.");
        List tooltip = CollectionsKt.build((List)list);
        this.drawAlignedStringWithHover("\u00a7eFarming Weight", "\u00a7f" + StringUtils.formatNumber((int)totalWeight), left + 11, top, 90, tooltip);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            int n = this.guiLeft + 190;
            boolean bl = mouseX <= this.guiLeft + 290 ? n <= mouseX : false;
            if (bl) {
                n = this.guiTop + 51;
                boolean bl2 = mouseY <= this.guiTop + 60 ? n <= mouseY : false;
                if (bl2) {
                    this.openWebsite();
                }
            }
        }
        return false;
    }

    private final void renderCompost() {
        int xPos = this.guiLeft + 322;
        int yPos = this.guiTop + 122;
        Utils.renderShadowedString("\u00a7eCompost Upgrades", xPos + 40, yPos - 2, 80);
        yPos += 12;
        Object object = this.gardenData;
        if (object == null || (object = ((GardenData)object).getComposterData()) == null || (object = ((ComposterData)object).getUpgrades()) == null) {
            return;
        }
        Object object2 = object;
        int speed = ((APIComposterUpgrades)object2).component1();
        int multiDrop = ((APIComposterUpgrades)object2).component2();
        int fuelCap = ((APIComposterUpgrades)object2).component3();
        int organicMatterCap = ((APIComposterUpgrades)object2).component4();
        int costReduction = ((APIComposterUpgrades)object2).component5();
        for (int i = 0; i < 5; ++i) {
            String it;
            String string;
            Object object3;
            Object object4;
            Object object5;
            int n;
            Object object6;
            switch (i) {
                case 0: {
                    object6 = "\u00a7aSpeed";
                    break;
                }
                case 1: {
                    object6 = "\u00a7aMulti Drop";
                    break;
                }
                case 2: {
                    object6 = "\u00a7aFuel Cap";
                    break;
                }
                case 3: {
                    object6 = "\u00a7aOrganic Matter Cap";
                    break;
                }
                case 4: {
                    object6 = "\u00a7aCost Reduction";
                    break;
                }
                default: {
                    object6 = 0;
                }
            }
            Object upgradeName = object6;
            switch (i) {
                case 0: {
                    n = speed;
                    break;
                }
                case 1: {
                    n = multiDrop;
                    break;
                }
                case 2: {
                    n = fuelCap;
                    break;
                }
                case 3: {
                    n = organicMatterCap;
                    break;
                }
                case 4: {
                    n = costReduction;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            int upgradeAmount = n;
            switch (i) {
                case 0: {
                    object5 = "speed";
                    break;
                }
                case 1: {
                    object5 = "multi_drop";
                    break;
                }
                case 2: {
                    object5 = "fuel_cap";
                    break;
                }
                case 3: {
                    object5 = "organic_matter_cap";
                    break;
                }
                case 4: {
                    object5 = "cost_reduction";
                    break;
                }
                default: {
                    object5 = 0;
                }
            }
            Object repoName = object5;
            ArrayList<String> tooltip = new ArrayList<String>();
            GardenRepoJson gardenRepoJson = this.repoData;
            if (gardenRepoJson == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                gardenRepoJson = null;
            }
            Map<Integer, ComposterUpgrade> map2 = gardenRepoJson.getComposterUpgrades().get(repoName);
            ComposterUpgrade upgradeValues = map2 != null ? map2.get(upgradeAmount + 1) : null;
            GardenRepoJson gardenRepoJson2 = this.repoData;
            if (gardenRepoJson2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                gardenRepoJson2 = null;
            }
            int upgradeValuesCurrent = (object4 = gardenRepoJson2.getComposterUpgrades().get(repoName)) != null && (object4 = object4.get(upgradeAmount)) != null ? ((ComposterUpgrade)object4).getUpgrade() : 0;
            String upgradeValuesCurrentSt = StringUtils.formatNumber(upgradeValuesCurrent);
            tooltip.add("" + upgradeName + ' ' + upgradeAmount);
            if (upgradeValues != null) {
                GardenRepoJson gardenRepoJson3 = this.repoData;
                if (gardenRepoJson3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                    gardenRepoJson3 = null;
                }
                if ((object3 = gardenRepoJson3.getComposterTooltips().get(repoName)) != null && (string = StringsKt.replace$default((String)object3, (String)"{}", (String)(upgradeValuesCurrentSt + " -> " + StringUtils.formatNumber(upgradeValues.getUpgrade())), (boolean)false, (int)4, null)) != null) {
                    it = string;
                    boolean bl = false;
                    tooltip.add(it);
                }
                tooltip.add("");
                tooltip.add("\u00a77Cost:");
                object3 = upgradeValues.getItems().entrySet().iterator();
                while (object3.hasNext()) {
                    Map.Entry item = (Map.Entry)object3.next();
                    NEUManager nEUManager = this.getManager();
                    String string2 = ((String)item.getKey()).toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                    ItemStack itemStack = nEUManager.createItem(string2);
                    if (itemStack == null) {
                        System.out.println((Object)("Item not found: " + (String)item.getKey()));
                        tooltip.add("\u00a7cUnknown Item: " + (String)item.getKey());
                        continue;
                    }
                    tooltip.add("\u00a77" + ((Number)item.getValue()).intValue() + "x " + itemStack.func_82833_r());
                }
                tooltip.add("\u00a77" + upgradeValues.getCopper() + " \u00a7cCopper");
            } else {
                GardenRepoJson gardenRepoJson4 = this.repoData;
                if (gardenRepoJson4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repoData");
                    gardenRepoJson4 = null;
                }
                if ((object3 = gardenRepoJson4.getComposterTooltips().get(repoName)) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)upgradeValuesCurrentSt, (String)"upgradeValuesCurrentSt");
                    string = StringsKt.replace$default((String)object3, (String)"{}", (String)upgradeValuesCurrentSt, (boolean)false, (int)4, null);
                    if (string != null) {
                        it = string;
                        boolean bl = false;
                        tooltip.add(it);
                    }
                }
                tooltip.add("\u00a76Maxed");
            }
            this.drawAlignedStringWithHover("\u00a7e" + upgradeName, "\u00a7f" + upgradeAmount, xPos, yPos, 80, (List<String>)tooltip);
            yPos += 12;
        }
    }

    private final ProfileViewer.Level getLevel(List<Integer> experienceList, Long currentExp) {
        JsonArray array = new JsonArray();
        Iterable $this$forEach$iv = experienceList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            array.add(gson.toJsonTree(it));
        }
        Long l = currentExp;
        ProfileViewer.Level level = ProfileViewerUtils.getLevel(array, l != null ? l : 0L, experienceList.size(), false);
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(array, (current\u2026perienceList.size, false)");
        return level;
    }

    private final void openWebsite() {
        if (this.eliteData == null) {
            return;
        }
        Utils.openUrl("https://elitebot.dev/@" + GuiProfileViewer.getDisplayName() + '/' + GuiProfileViewer.getProfileName());
        Utils.playPressSound();
    }

    private final void drawAlignedStringWithHover(String first, String second, int x, int y, int length, List<String> hover) {
        Utils.renderAlignedString(first, second, x, y, length);
        int n = x + length;
        int n2 = this.mouseX;
        boolean bl = x <= n2 ? n2 <= n : false;
        if (bl) {
            n = y + 13;
            n2 = this.mouseY;
            boolean bl2 = y <= n2 ? n2 <= n : false;
            if (bl2) {
                this.getInstance().tooltipToDisplay = hover;
            }
        }
    }

    public static final /* synthetic */ void access$setGardenData$p(GardenPage $this, GardenData gardenData) {
        $this.gardenData = gardenData;
    }

    public static final /* synthetic */ GardenData access$loadGardenData(GardenPage $this, String profileId) {
        return $this.loadGardenData(profileId);
    }

    public static final /* synthetic */ void access$getVisitorData(GardenPage $this) {
        $this.getVisitorData();
    }

    public static final /* synthetic */ void access$setEliteData$p(GardenPage $this, EliteWeightJson eliteWeightJson) {
        $this.eliteData = eliteWeightJson;
    }

    public static final /* synthetic */ EliteWeightJson access$loadFarmingWeight(GardenPage $this, String uuid, String profileId) {
        return $this.loadFarmingWeight(uuid, profileId);
    }

    public static final /* synthetic */ AtomicBoolean access$getCurrentlyFetching$p(GardenPage $this) {
        return $this.currentlyFetching;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)CropType.class), cropTypeAdapter.nullSafe()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().setPrettyP\u2026                .create()");
        GardenPage.gson = gson;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenPage$Companion;", "", "()V", "cropTypeAdapter", "io/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenPage$Companion$cropTypeAdapter$1", "Lio/github/moulberry/notenoughupdates/miscfeatures/profileviewer/GardenPage$Companion$cropTypeAdapter$1;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "NotEnoughUpdates"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

